/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.IAction;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.controller.IReportActionController;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.RAPLogger;
import com.cognos.rap.utility.XMLUtility;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.ibm.json.java.JSONObject;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class BaseAction
implements IAction {
    public static final String USE_MA_GET_PARENT_REQUEST = "useMAGetParentRequest";
    public static final String USE_MA_GET_CHILD_REQUEST = "useMAGetChildRequest";
    private ActionEnv _actionEnv = new ActionEnv();
    private static String authoringLocaleProperties = "<Properties><Property name=\"/@listSeparator\"/></Properties>";

    public boolean doQueryForListSeparator() {
        return true;
    }

    @Override
    public void setReportActionController(IReportActionController reportActionController) {
        this._actionEnv.setReportActionController(reportActionController);
    }

    public ActionEnv getEnv() {
        return this._actionEnv;
    }

    public RAPReport getRAPReport() {
        return this._actionEnv._rapReport;
    }

    public IReportActionController getReportActionController() {
        return this._actionEnv.getReportActionController();
    }

    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        RAPReport rapReport = this._actionEnv._rapReport;
        if (rapReport == null) {
            rapReport = new RAPReport(reportToModify);
        }
        this.setEnv(rapReport, actionArgs);
    }

    @Override
    public void apply(RAPReport rapReport, Element actionArgs) throws ActionException {
        this.setEnv(rapReport, actionArgs);
        this._actionEnv.setRAPTimer(rapReport.getRAPTimer());
        if (this.doQueryForListSeparator()) {
            this.getListSeparator();
        }
        this.apply(rapReport.getDOM(), actionArgs);
    }

    private void getListSeparator() throws CognosServiceRequestException {
        Element maResponse;
        RAPReport rapReport;
        block5: {
            rapReport = this._actionEnv._rapReport;
            if (V5SpecHelper.getListSeparator(rapReport.getDOM()) != null) {
                return;
            }
            String authoringLocalePropertiesRequest = "<metadataRequest connection=\"" + XMLUtility.encodeXMLAttribute(rapReport.getModelPath()) + "\">" + "<Functions authoringLocale=\"" + rapReport.getExpressionLocale() + "\">" + authoringLocaleProperties + "</Functions>" + "</metadataRequest>";
            maResponse = null;
            try {
                maResponse = this._actionEnv.getRapServiceRequestManager().executeMAQuery(authoringLocalePropertiesRequest, null);
            }
            catch (Exception e) {
                ICognosViewerActionResponse response;
                if (!(e instanceof CognosServiceRequestException) || !(((CognosServiceRequestException)e).getCustomValue() instanceof ICognosViewerActionResponse) || !"working".equals((response = (ICognosViewerActionResponse)((CognosServiceRequestException)e).getCustomValue()).getStatus()) && !"stillWorking".equals(response.getStatus())) break block5;
                throw (CognosServiceRequestException)e;
            }
        }
        String listSeparator = ",";
        if (maResponse != null && maResponse.element("listSeparator") != null) {
            Element listSeparatorElem = maResponse.element("listSeparator");
            listSeparator = listSeparatorElem.attributeValue("value");
        } else {
            RAPLogger.info("RAP_INT: MA request for listSeparator failed (defaulting to ,)", BaseAction.class);
        }
        V5SpecHelper.setXMLAttribute(rapReport.getDOM().getRootElement(), "listSeparator", listSeparator, "no");
    }

    public void setEnv(RAPReport rapReport, Element actionArgs) {
        this._actionEnv._rapReport = rapReport;
        this._actionEnv._actionArguments = new Arguments(actionArgs);
    }

    public String getLocale() {
        return this._actionEnv.getLocale();
    }

    @Override
    public Arguments getActionArguments() {
        return this._actionEnv._actionArguments;
    }

    @Override
    public RAPReport getReport() {
        return this._actionEnv._rapReport;
    }

    public void setRAPReport(RAPReport rapReport) {
        this._actionEnv._rapReport = rapReport;
    }

    public RapServiceRequestManager getRapServiceRequestManager() {
        String useMAChild = this.getActionArguments().getArgument(USE_MA_GET_CHILD_REQUEST);
        String useMAParent = this.getActionArguments().getArgument(USE_MA_GET_PARENT_REQUEST);
        JSONObject actionOptions = null;
        if (useMAChild != null || useMAParent != null) {
            actionOptions = new JSONObject();
            actionOptions.put((Object)USE_MA_GET_CHILD_REQUEST, (Object)useMAChild);
            actionOptions.put((Object)USE_MA_GET_PARENT_REQUEST, (Object)useMAParent);
        }
        return this._actionEnv.getRapServiceRequestManager(actionOptions);
    }
}

