/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import java.util.HashSet;

public class CCLDbTypesInfo {
    private static final int cclDTypeString = 1;
    private static final int cclDTypeDate = 13;
    private static final int cclDTypeYMInterval = 17;
    public static final int cclDTypeNumeric = 54;
    public static final int cclDTypeDateTime = 59;
    private static final int firstKnownDateType = 13;
    private static final int lastKnownDateType = 17;
    private static final String _dateTimeValuePattern = "^\\s*([0-9]*)-([0-9]*)-([0-9]*)T([0-9]*):([0-9]*):([0-9]*)\\.([0-9]*)$";
    private static final HashSet<String> numericTypes = new HashSet();
    private static final HashSet<String> dateTimeTypes;

    public static boolean isUnsupportedType(int dataType) {
        return dataType > 17 && dataType != 59;
    }

    public static boolean isDateTimeType(int dataType) {
        return dataType == 59;
    }

    public static boolean isDateTimeFormat(String value) {
        return value.matches(_dateTimeValuePattern);
    }

    public static boolean isKnownDateType(int dataType) {
        return dataType >= 13 && dataType <= 17;
    }

    public static boolean isKnownNumericType(int dataType) {
        boolean returnValue = dataType > 1 && dataType < 13 || dataType == 54;
        return returnValue;
    }

    public static boolean isStringType(int dataType) {
        return dataType == 1;
    }

    public static boolean isKnownNumericTypeString(String xsdTypeString) {
        return numericTypes.contains(xsdTypeString);
    }

    public static boolean isKnownDimensionalTypeString(String xsdTypeString) {
        return "hierarchyUniqueName".equals(xsdTypeString) || "memberUniqueName".equals(xsdTypeString);
    }

    public static boolean isKnownDateTypeString(String xsdTypeString) {
        return dateTimeTypes.contains(xsdTypeString);
    }

    static {
        numericTypes.add("xsdDecimal");
        numericTypes.add("xsdDouble");
        numericTypes.add("xsdFloat");
        numericTypes.add("xsdByte");
        numericTypes.add("xsdInt");
        numericTypes.add("xsdLong");
        numericTypes.add("xsdShort");
        numericTypes.add("xsdUnsignedInt");
        numericTypes.add("xsdUnsignedLong");
        numericTypes.add("xsdUnsignedShort");
        dateTimeTypes = new HashSet();
        dateTimeTypes.add("xsdDate");
        dateTimeTypes.add("xsdDateTime");
        dateTimeTypes.add("xsdDuration");
        dateTimeTypes.add("xsdTime");
    }
}

