/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.DrillabilityInfo;
import com.cognos.rap.actions.FilterInfo;
import com.cognos.rap.actions.ItemInfo;
import com.cognos.rap.actions.SlicerInfo;
import com.cognos.rap.actions.SortInfo;
import com.cognos.rap.utility.JSONUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DataContainerInfo {
    private String _layoutID = null;
    private ArrayList<FilterInfo> _filterInfoList = null;
    private ArrayList<SlicerInfo> _slicerInfoList = null;
    private ArrayList<ItemInfo> _itemInfoList = null;
    private ArrayList<DrillabilityInfo> _drillabilityInfoList = null;
    private HashMap<String, SortInfo> _sortInfoMap = null;
    private boolean _promptWidget = false;
    private String _displayTypeId = null;
    private Set<String> _possibleDisplayTypeIds = null;
    private String _recommendedDisplayTypes = null;
    private String _recommendedDisplayVariations = null;
    private boolean _recommendedDisplayTypesEnabled = false;
    private String _parentContainerName = null;
    private String _lockedFilterInfo = null;
    private List<String> _dynamicDataFilterDescriptors = null;

    public DataContainerInfo(String layoutID) {
        this._layoutID = layoutID;
    }

    public void addFilterInfo(FilterInfo fi) {
        if (this._filterInfoList == null) {
            this._filterInfoList = new ArrayList();
        }
        this._filterInfoList.add(fi);
    }

    public void addSlicerInfo(SlicerInfo si) {
        if (this._slicerInfoList == null) {
            this._slicerInfoList = new ArrayList();
        }
        this._slicerInfoList.add(si);
    }

    public void addDrillabilityInfo(DrillabilityInfo di) {
        if (this._drillabilityInfoList == null) {
            this._drillabilityInfoList = new ArrayList();
        }
        this._drillabilityInfoList.add(di);
    }

    public void addItemInfo(ItemInfo ii) {
        if (this._itemInfoList == null) {
            this._itemInfoList = new ArrayList();
        }
        this._itemInfoList.add(ii);
    }

    public void setPromptWidget(boolean value) {
        this._promptWidget = value;
    }

    public SortInfo addSortInfo(SortInfo si) {
        if (this._sortInfoMap == null) {
            this._sortInfoMap = new HashMap();
        }
        if (si._setSorting && si._sortReferences != null) {
            this._sortInfoMap.put(si._sortReferences.get((int)0)._referenceItem, si);
        } else {
            this._sortInfoMap.put(si._sortItem, si);
        }
        return si;
    }

    public int getSortInfoCount() {
        if (this._sortInfoMap != null) {
            return this._sortInfoMap.size();
        }
        return 0;
    }

    public void setLockedFilterInfo(String lockedFilterSpecAsJSON) {
        this._lockedFilterInfo = lockedFilterSpecAsJSON;
    }

    public void setParentContainerName(String parentContainerName) {
        this._parentContainerName = parentContainerName;
    }

    public void setDynamicDataFilterDescriptors(List<String> dynamicDataFilterDescriptors) {
        if (this._dynamicDataFilterDescriptors != null) {
            this._dynamicDataFilterDescriptors.addAll(dynamicDataFilterDescriptors);
        } else {
            this._dynamicDataFilterDescriptors = dynamicDataFilterDescriptors;
        }
    }

    public String toJSON() throws IOException {
        StringBuilder JSON = new StringBuilder();
        JSON.append("{\"container\": \"");
        JSON.append(JSONUtility.javascriptencode(this._layoutID));
        JSON.append("\"");
        if (this._parentContainerName != null) {
            JSON.append(", \"parentContainer\": \"");
            JSON.append(JSONUtility.javascriptencode(this._parentContainerName));
            JSON.append("\"");
        }
        if (this._sortInfoMap != null) {
            Collection<SortInfo> sortInfoList = this._sortInfoMap.values();
            JSON.append(", \"sort\": [");
            boolean first = true;
            for (SortInfo sortInfo : sortInfoList) {
                if (!first) {
                    JSON.append(",");
                }
                first = false;
                JSON.append(sortInfo.createJSON().toString());
            }
            JSON.append("]");
        }
        if (this._filterInfoList != null || this._slicerInfoList != null) {
            JSONArray filterArray = new JSONArray();
            if (this._filterInfoList != null) {
                for (FilterInfo filterInfo : this._filterInfoList) {
                    JSONObject filterJSON = filterInfo.createJSON();
                    if (filterJSON == null) continue;
                    filterArray.add((Object)filterJSON);
                }
            }
            if (this._slicerInfoList != null) {
                for (SlicerInfo slicerInfo : this._slicerInfoList) {
                    JSONObject slicerJSON = slicerInfo.createJSON();
                    if (slicerJSON == null) continue;
                    filterArray.add((Object)slicerJSON);
                }
            }
            if (filterArray.size() > 0) {
                JSON.append(", \"filter\": ");
                JSON.append(filterArray.toString());
            }
        }
        if (this._lockedFilterInfo != null) {
            JSON.append(", ");
            JSON.append(this._lockedFilterInfo);
        }
        if (this._dynamicDataFilterDescriptors != null) {
            JSON.append(", \"sliders\": [");
            boolean first = true;
            for (String descriptor : this._dynamicDataFilterDescriptors) {
                if (!first) {
                    JSON.append(",");
                }
                first = false;
                JSON.append(descriptor);
            }
            JSON.append("]");
        }
        if (this._drillabilityInfoList != null) {
            JSON.append(", \"drillability\": [");
            boolean first = true;
            for (DrillabilityInfo drillabilityInfo : this._drillabilityInfoList) {
                if (!first) {
                    JSON.append(",");
                }
                first = false;
                drillabilityInfo.appendJSON(JSON);
            }
            JSON.append("]");
        }
        if (this._itemInfoList != null) {
            JSON.append(", \"itemInfo\": [");
            boolean first = true;
            for (ItemInfo itemInfo : this._itemInfoList) {
                if (!first) {
                    JSON.append(",");
                }
                first = false;
                itemInfo.appendJSON(JSON);
            }
            JSON.append("]");
        }
        if (this._promptWidget) {
            JSON.append(", \"promptWidget\": true");
        }
        if (this._possibleDisplayTypeIds != null) {
            JSON.append(", \"possibleDisplayTypes\": [");
            boolean first = true;
            for (String id : this._possibleDisplayTypeIds) {
                if (!first) {
                    JSON.append(",");
                }
                first = false;
                JSON.append("\"" + id + "\"");
            }
            JSON.append("]");
        }
        if (this._displayTypeId != null) {
            JSON.append(", \"displayTypeId\":\"" + this._displayTypeId + "\"");
        }
        if (this._recommendedDisplayTypesEnabled) {
            JSON.append(", \"suggestedDisplayTypesEnabled\":\"" + this._recommendedDisplayTypesEnabled + "\"");
        }
        if (this._recommendedDisplayVariations != null) {
            JSON.append(", \"variationGroups\":" + this._recommendedDisplayVariations);
        }
        if (this._recommendedDisplayTypes != null) {
            JSON.append(", \"suggestedDisplayTypes\":" + this._recommendedDisplayTypes);
        }
        JSON.append("}");
        return JSON.toString();
    }

    public void setDisplayTypeId(String id) {
        this._displayTypeId = id;
    }

    public String getDisplayTypeId() {
        return this._displayTypeId;
    }

    public void setPossibleDisplayTypeIds(Set<String> ids) {
        this._possibleDisplayTypeIds = ids;
    }

    public Set<String> getPossibleDisplayTypeIds() {
        return this._possibleDisplayTypeIds;
    }

    public void setRecommendedDisplayTypes(String RecommendedDisplayTypes) {
        this._recommendedDisplayTypes = RecommendedDisplayTypes;
    }

    public String getRecommendedDisplayTypes() {
        return this._recommendedDisplayTypes;
    }

    public void setRecommendedDisplayVariations(String recommendedDisplayVariations) {
        this._recommendedDisplayVariations = recommendedDisplayVariations;
    }

    public String getRecommendedDisplayVariations() {
        return this._recommendedDisplayVariations;
    }

    public void setRecommendedDisplayTypesEnabled(boolean recommendedDisplayTypesEnabled) {
        this._recommendedDisplayTypesEnabled = recommendedDisplayTypesEnabled;
    }

    public boolean getSuggestedDisplayTypesEnabled() {
        return this._recommendedDisplayTypesEnabled;
    }
}

