/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.WidgetContextManager;
import com.cognos.rap.actions.WidgetSelectValueControlContext;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SetExpandCollapse;
import com.cognos.rap.actions.v5spechelpers.V5SetFiltering;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.JSONUtility;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public abstract class DynamicDataFilter {
    public static final String v5Attr_postAutoAggregation = "postAutoAggregation";
    private String _filterClientId = null;
    protected String _filterName = null;
    protected int _currentPayloadItemIndex = 0;
    private boolean _hasNextPayloadItem = false;
    protected String _attributeName = null;
    protected boolean _discreteNumeric = false;
    protected String _filterCustomRDIName = null;
    protected String _customParamName = null;
    protected String _controlType = null;
    protected String _reportModelPath = null;
    protected boolean _isInitialized = false;
    protected String _hun = null;
    protected String _listSeparator = ",";
    protected boolean _multipleNamespaceReportItem = false;
    protected boolean _preAuthoredFilter = false;
    protected FilterOutputType _filterOutputType = FilterOutputType.detailFilter;
    private static final String simpleParameterRE = "(([Ii][Nn])|=|(->))\\s*\\(?\\?.*\\?";
    private static final String promptMacroRE = "((#prompt)|(#promptmany))\\s*\\(\\s*'.*'.*\\)#";
    private static final Pattern simpleParameterPattern = Pattern.compile("(([Ii][Nn])|=|(->))\\s*\\(?\\?.*\\?");
    private static final Pattern promptMacroPattern = Pattern.compile("((#prompt)|(#promptmany))\\s*\\(\\s*'.*'.*\\)#");
    public static final String RAP_DYNAMIC_DATA_FILTER_PARAM_PREFIX = "BusinessInsight.";
    public static final String RAP_DYNAMIC_DATA_FILTER_TAG = "RAP_DataFilterID";
    public static final String RAP_DYNAMIC_DATA_FILTER_CUSTOM_RDINAME = "RAP_DataFilterCustomRDIName";
    public static final String RAP_DYNAMIC_DATA_FILTER_PARAM_TAG = "RAP_DataFilterParam";
    public static final String RAP_DYNAMIC_DATA_FILTER_PROTECTED = "RAP_DataFilterProtected";
    public static final String RAP_DYNAMIC_DATA_FILTER_DESCRIPTOR = "RAP_DataFilterDescriptor";
    public static final String RAP_DYNAMIC_DATA_FILTER_ORIGINAL_EXPRESSION = "RAP_OriginalExpression";
    public static final String RAP_DYNAMIC_DATA_FILTER_INLINE = "RAP_DataFilterInline";
    DetailFilterOutput _detailFilterOutput = new DetailFilterOutput();

    public int getNextPayloadItemIndex() {
        if (this._hasNextPayloadItem) {
            return this._currentPayloadItemIndex + 1;
        }
        return 0;
    }

    public void setCurrentPayloadItemIndex(int i) {
        this._currentPayloadItemIndex = i;
    }

    public boolean isAdditionalPayloadItem() {
        return this._currentPayloadItemIndex > 0;
    }

    public void setPreAuthoredFilter() {
        this._preAuthoredFilter = true;
    }

    public boolean isResetter() {
        return false;
    }

    public void setFilterOutputType(FilterOutputType type) {
        this._filterOutputType = type;
    }

    public void setListSeparator(String listSeparator) {
        this._listSeparator = listSeparator;
    }

    public DynamicDataFilter(String clientId, String reportModelPath) {
        this._filterClientId = clientId;
        this._reportModelPath = reportModelPath;
        this._filterName = null;
        this._attributeName = null;
    }

    public String getId() {
        return this._filterClientId;
    }

    public String getControlType() {
        return this._controlType;
    }

    public boolean isFacet() {
        return "facet".equals(this._controlType);
    }

    public boolean isAttributeType() {
        return this._attributeName != null;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getQualifiedAttributeName(V5Query query) {
        String nameToReturn = "_ATTR_FILTER_" + this._filterName + "_" + this._attributeName;
        if (query.findItem(nameToReturn) != null) {
            return nameToReturn;
        }
        return this._filterName + "." + this._attributeName;
    }

    public static String getRefExplicitMemberName(String name) {
        if (name != null && name.startsWith("_NOROLLLUP_")) {
            name = name.replaceFirst("_NOROLLLUP_", "");
        }
        return "_MBER_FILTER_" + name;
    }

    public String getReportModelPath() {
        return this._reportModelPath;
    }

    public void initialize(JSONObject filterDefinition) {
        if (!this.initializeGenericContext(filterDefinition)) {
            this._filterName = (String)filterDefinition.get((Object)"name");
            this._attributeName = null;
            this._controlType = (String)filterDefinition.get((Object)"controlType");
            this._isInitialized = true;
        }
    }

    private boolean initializeGenericContext(JSONObject filterDefinition) {
        if (WidgetContextManager.isValid(filterDefinition)) {
            WidgetContextManager genericEventContext = new WidgetContextManager(filterDefinition);
            this._filterName = genericEventContext.getItemName(this._currentPayloadItemIndex);
            this._hasNextPayloadItem = genericEventContext.getItemName(this._currentPayloadItemIndex + 1) != null;
            WidgetSelectValueControlContext svc = genericEventContext.getSelectValueControlContext();
            if (svc != null) {
                this._controlType = svc.getControlType();
                if (svc.isAttributeType()) {
                    this._attributeName = this._filterName;
                    this._filterName = svc.getDimension();
                }
            }
            this._isInitialized = true;
            return true;
        }
        return false;
    }

    public Element getFacetBase(V5Query query) {
        Element facetBase = query.findItem("_FACETBASE_" + this._filterName + "_" + this._attributeName);
        if (facetBase == null) {
            facetBase = query.findItem(this._filterName);
        }
        return facetBase;
    }

    public void initializeFromXML(Element eFilterValue) {
        if (eFilterValue != null) {
            this._filterName = eFilterValue.elementText("name");
        }
        this._isInitialized = true;
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void setName(String name) {
        this._filterName = name;
    }

    public String getName() {
        return this._filterName;
    }

    public void setCustomRDIName(String name) {
        this._filterCustomRDIName = name;
    }

    public String getCustomRDIName() {
        return this._filterCustomRDIName;
    }

    public String getRDIName() {
        if (this.getCustomRDIName() != null) {
            return this.getCustomRDIName();
        }
        return this.getName();
    }

    public String getParamName() {
        if (this._customParamName != null) {
            return this._customParamName;
        }
        return RAP_DYNAMIC_DATA_FILTER_PARAM_PREFIX + this._filterName;
    }

    public void setCustomParamName(String customParamName) {
        this._customParamName = customParamName;
    }

    public boolean initializeFromPreauthoredFilter(Element rootElement) {
        String paramName = DynamicDataFilter.extractParamName(rootElement);
        if (paramName != null) {
            this.setCustomParamName(paramName);
            this.setPreAuthoredFilter();
            this.setFilterOutputType(FilterOutputType.dataItem);
            this.populateFilterOutput(true);
            return true;
        }
        return false;
    }

    public static String extractParamName(Element dataItem) {
        String expression = dataItem.elementText("expression");
        if (expression == null) {
            return null;
        }
        Matcher simpleParameterPatternMatcher = simpleParameterPattern.matcher(expression);
        if (simpleParameterPatternMatcher.find()) {
            int startOfSimpleParameterPattern = simpleParameterPatternMatcher.start();
            expression = expression.substring(startOfSimpleParameterPattern);
            if ((expression = expression.substring(expression.indexOf("?") + 1)).indexOf("?") > 0) {
                return expression.substring(0, expression.indexOf("?"));
            }
        } else {
            int startOfPromptMacroPattern;
            Matcher promptMacroPatternMatcher = promptMacroPattern.matcher(expression);
            if (promptMacroPatternMatcher.find() && (startOfPromptMacroPattern = promptMacroPatternMatcher.start()) >= 0 && (expression = expression.substring(startOfPromptMacroPattern)).indexOf("'") > 0 && (expression = expression.substring(expression.indexOf("'") + 1)).indexOf("'") > 0) {
                return expression.substring(0, expression.indexOf("'"));
            }
        }
        return null;
    }

    public String getClientId() {
        return this._filterClientId;
    }

    public abstract void generateV5DetailFilter(Element var1, boolean var2, boolean var3);

    public void generateV5AttributeFilter(String hun, JSONObject dimensionInfo, Element v5DetailFilterNode) {
    }

    public abstract void populateFilterOutput(boolean var1);

    public ArrayList<SelectedCell> getDiscreteValuesAsSelectedCells(String nodeType) {
        return new ArrayList<SelectedCell>();
    }

    protected void matchFacetValuesToReportNamespace(String reportNamespace) {
    }

    public abstract String generateV5FilterDescriptor();

    public abstract String getSelectChoices();

    protected String generateV5FilterTermRHS(String sValue, boolean valueIsString) {
        if (valueIsString) {
            return "'" + V5SpecHelper.getV5SafeFilterValue(sValue) + "'";
        }
        return sValue;
    }

    public void setHun(String hun) {
        this._hun = hun;
    }

    public void setMultipleNamespaceReportItem(boolean flag) {
        this._multipleNamespaceReportItem = flag;
    }

    public void addFilterTags(Element rootElement, String clientId, String detailFilterDescriptor, boolean filterProtected, boolean canInline) {
        this._detailFilterOutput.addFilterTags(rootElement, clientId, detailFilterDescriptor, filterProtected, canInline);
    }

    public static void removeFilterTags(Element dataFilterRoot) {
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_TAG);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_CUSTOM_RDINAME);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_PROTECTED);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_DESCRIPTOR);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_PARAM_TAG);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_INLINE);
        V5SpecHelper.removeXMLAttribute(dataFilterRoot, RAP_DYNAMIC_DATA_FILTER_ORIGINAL_EXPRESSION);
    }

    public static String getFilterDescriptorProperty(Element filterRoot, String propName) {
        String descriptor = V5SpecHelper.getXMLAttribute(filterRoot, RAP_DYNAMIC_DATA_FILTER_DESCRIPTOR);
        try {
            JSONObject descriptorJSON;
            if (descriptor != null && (descriptorJSON = JSONUtility.parse(descriptor)) != null && descriptorJSON.get((Object)propName) != null) {
                return descriptorJSON.get((Object)propName).toString();
            }
        }
        catch (ActionException actionException) {
            // empty catch block
        }
        return null;
    }

    public void setInlineValues(boolean flag) {
        if (flag) {
            this._detailFilterOutput._inlineValues = true;
        }
    }

    public void setDiscreteNumeric(boolean flag) {
        this._discreteNumeric = flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateV5SetFilter(V5Query v5Query, V5QueryItem queryItem) throws ActionException {
        this.populateFilterOutput(true);
        V5SetFiltering setFiltering = new V5SetFiltering();
        setFiltering.setFilterInitialSet(true);
        setFiltering.setListSeparator(this._listSeparator);
        this.matchFacetValuesToReportNamespace(V5QueryItem.getNameSpace(queryItem.getDOM()));
        ArrayList<SelectedCell> selectedCells = this.getDiscreteValuesAsSelectedCells("memberUniqueName");
        Element modifiedItem = queryItem.getDOM();
        Element itemToTag = queryItem.getDOM();
        Object dimensionLevels = null;
        JSONObject dimensionInfo = null;
        if (this.isAttributeType()) {
            dimensionInfo = v5Query.getDimensionInfo(this._reportModelPath, queryItem.getDOM(), V5QueryItem.getHun(queryItem.getDOM()));
            if (!v5Query.hasAttribute(dimensionInfo, this.getAttributeName())) return;
            itemToTag = setFiltering.addUpdateAttributeFilters(v5Query, selectedCells, this._attributeName, this.getQualifiedAttributeName(v5Query), dimensionInfo);
        } else {
            modifiedItem = setFiltering.addUpdateSetFilters(v5Query, selectedCells, true);
        }
        if (null == modifiedItem) {
            return;
        }
        this.setFilterOutputType(FilterOutputType.dataItem);
        this.addFilterTags(itemToTag, this.getClientId(), this.generateV5FilterDescriptor(), false, true);
        V5SetExpandCollapse expandCollapse = new V5SetExpandCollapse();
        expandCollapse.removeAllExpandedAndCollapsedNodes(modifiedItem);
        Element linkedSetItem = V5SpecHelper.getLinkedSetItem(v5Query, modifiedItem);
        if (linkedSetItem == null) return;
        if (this.isAttributeType()) {
            setFiltering.addUpdateLinkedSet_AttributeFilters(v5Query, linkedSetItem, this.getQualifiedAttributeName(v5Query), dimensionInfo);
        } else {
            selectedCells.get((int)0).nodeName = linkedSetItem.attributeValue("name");
            setFiltering.addUpdateSetFilters(v5Query, selectedCells, true);
        }
        expandCollapse.removeAllExpandedAndCollapsedNodes(linkedSetItem);
    }

    public static boolean isInline(Element dataFilter) {
        String inlineValues = V5SpecHelper.getXMLAttribute(dataFilter, RAP_DYNAMIC_DATA_FILTER_INLINE);
        return inlineValues == null;
    }

    protected class DetailFilterOutput {
        protected static final String _operatorIn = "in";
        protected static final String _operatorInRange = "in_range";
        protected static final String _operatorEquals = "=";
        protected static final String _setFunction = "set";
        private String _filterLHS = null;
        private String _filterOperator = null;
        private String _filterRHS = null;
        protected boolean _inlineValues = false;

        protected DetailFilterOutput() {
        }

        protected void setLHS(String LHS) {
            this._filterLHS = LHS;
        }

        protected void setRHS(String RHS) {
            this._filterRHS = RHS;
        }

        protected void setOperator(String op) {
            this._filterOperator = op;
        }

        protected Element create(String clientId, Element v5DetailFiltersNode, String sDetailFilterDescriptor, boolean postAutoAggregation, boolean isNumericValuesType) {
            Element detailFilter = v5DetailFiltersNode.addElement("detailFilter");
            detailFilter.addAttribute("use", "optional");
            this.addFilterTags(detailFilter, clientId, sDetailFilterDescriptor, false, true);
            Element detailFilterExpressionElement = detailFilter.addElement("filterExpression");
            if (postAutoAggregation && isNumericValuesType) {
                detailFilter.addAttribute(DynamicDataFilter.v5Attr_postAutoAggregation, "true");
            }
            detailFilterExpressionElement.setText(this.generateExpressionString());
            return detailFilter;
        }

        public void addFilterTags(Element dataFilterRoot, String clientId, String sDetailFilterDescriptor, boolean filterProtected, boolean canInline) {
            if (DynamicDataFilter.this._filterCustomRDIName != null) {
                V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_CUSTOM_RDINAME, DynamicDataFilter.this._filterCustomRDIName, "no");
            }
            V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_TAG, clientId, "no");
            V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_DESCRIPTOR, sDetailFilterDescriptor, "no");
            if (!this._inlineValues) {
                V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_PARAM_TAG, DynamicDataFilter.this.getParamName(), "no");
            }
            if (filterProtected) {
                V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_PROTECTED, "", "no");
            }
            if (!this._inlineValues && canInline) {
                String inlineVersion = null;
                inlineVersion = this._filterLHS != null ? this._filterLHS + " " + this._filterOperator + " " + this._filterRHS : this._filterOperator + this._filterRHS;
                V5SpecHelper.setXMLAttribute(dataFilterRoot, DynamicDataFilter.RAP_DYNAMIC_DATA_FILTER_INLINE, inlineVersion, "no");
            }
        }

        private String generateExpressionString() {
            if (this._inlineValues) {
                return this._filterLHS + " " + this._filterOperator + " " + this._filterRHS;
            }
            return this._filterLHS + " " + this._filterOperator + " ?" + DynamicDataFilter.this.getParamName() + "?";
        }
    }

    public static enum FilterOutputType {
        detailFilter,
        summaryFilter,
        dataItem;

    }
}

