/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.DiscreteValue;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.WidgetContextManager;
import com.cognos.rap.actions.WidgetInternalContext;
import com.cognos.rap.actions.WidgetSelectValueControlContext;
import com.cognos.rap.actions.v5spechelpers.V5ContextSlicer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DynamicDiscreteValuesFilter
extends DynamicDataFilter {
    private ModelAndValues _modelAndValues = null;
    private List<ParmValue> _selectChoicesParmValues = new ArrayList<ParmValue>();

    @Override
    public ArrayList<SelectedCell> getDiscreteValuesAsSelectedCells(String nodeType) {
        ArrayList<SelectedCell> selectedCells = new ArrayList<SelectedCell>();
        for (ParmValue value : this._selectChoicesParmValues) {
            SelectedCell cell = value.getAsSelectedCell();
            cell.nodeName = this.getRDIName();
            cell.nodeType = nodeType;
            selectedCells.add(cell);
        }
        return selectedCells;
    }

    private String stripNameSpace(String nsEntity) {
        int endNamespace;
        int n = endNamespace = nsEntity == null ? 0 : nsEntity.indexOf("].[");
        if (endNamespace > 0) {
            return nsEntity.substring(endNamespace + 1);
        }
        return nsEntity;
    }

    protected boolean hunsMatch(String hunOrMun) {
        if (hunOrMun == null || this._hun == null) {
            return false;
        }
        return hunOrMun.startsWith(this._hun) || this.isFacet() && this.stripNameSpace(hunOrMun).startsWith(this.stripNameSpace(this._hun));
    }

    @Override
    protected void matchFacetValuesToReportNamespace(String reportNamespace) {
        String delimitedNameSpace = "[" + reportNamespace + "]";
        if (this.isFacet()) {
            for (ParmValue value : this._selectChoicesParmValues) {
                String useValue = value.getUseValueAttribute();
                if (this.isAttributeType() || useValue.startsWith(delimitedNameSpace)) continue;
                value.setUseValue(delimitedNameSpace + this.stripNameSpace(useValue));
            }
        }
    }

    public DynamicDiscreteValuesFilter(String clientId, String reportModelPath) {
        super(clientId, reportModelPath);
    }

    @Override
    public void initialize(JSONObject filterJSON) {
        super.initialize(filterJSON);
        if (!this.initializeFromGenericWidgetContext(filterJSON)) {
            JSONArray inputModelValuesBlocks = (JSONArray)filterJSON.get((Object)"values");
            if (this.emptyValueSet(filterJSON, inputModelValuesBlocks)) {
                return;
            }
            List<JSONObject> bestInputModelValuesBlocks = this.selectBestModelValuesBlocks(inputModelValuesBlocks);
            if (bestInputModelValuesBlocks.size() == 0) {
                if (this._filterOutputType == DynamicDataFilter.FilterOutputType.detailFilter) {
                    this._modelAndValues = this.createModelAndValues(null);
                    this.addCaptionValuesFromAllBlocks(inputModelValuesBlocks);
                }
                return;
            }
            this._modelAndValues = this.createModelAndValues(bestInputModelValuesBlocks.get(0));
            if (this._modelAndValues == null) {
                this._isInitialized = false;
                return;
            }
            for (JSONObject bestInputModelValuesBlock : bestInputModelValuesBlocks) {
                this.addValuesFromInputBlock(bestInputModelValuesBlock);
            }
        }
    }

    private boolean valuesMatchModelPath() {
        if (this._reportModelPath != null && this._modelAndValues != null && this._modelAndValues.getModelPath() != null) {
            return this._reportModelPath.equals(this._modelAndValues.getModelPath()) || this._reportModelPath.equals(this._modelAndValues.getModelPath() + "model[name='model']") || this._reportModelPath.equals(this._modelAndValues.getModelPath() + "model[last()]");
        }
        return false;
    }

    public boolean initializeFilterOnMemberTypeColumn(V5QueryItem queryItem) throws ActionException {
        boolean isMemberTypeColumn = false;
        queryItem.setEvaluateSpecOnly(true);
        if (queryItem.confirmIsSetOrMember()) {
            isMemberTypeColumn = true;
            this.setHun(queryItem.getProperties()._hun);
        } else if (this.valuesMatchModelPath() && !this.filterHasMuns()) {
            isMemberTypeColumn = false;
        } else {
            queryItem.setEvaluateSpecOnly(false);
            if (queryItem.confirmIsSetOrMember()) {
                isMemberTypeColumn = true;
                this.setHun(queryItem.getProperties()._hun);
            }
        }
        return isMemberTypeColumn;
    }

    private boolean initializeFromGenericWidgetContext(JSONObject genericEventContextJSON) {
        if (!WidgetContextManager.isValid(genericEventContextJSON)) {
            return false;
        }
        WidgetContextManager eventContext = new WidgetContextManager(genericEventContextJSON);
        if (eventContext.isEmptyValuesSet()) {
            this._modelAndValues = new ModelAndValues(null, null, "string");
            return true;
        }
        WidgetSelectValueControlContext selectValueControlContext = eventContext.getSelectValueControlContext();
        if (selectValueControlContext != null) {
            List<WidgetInternalContext.ModelItemBlock> bestModelItemBlocks;
            if (selectValueControlContext.isAttributeType() && selectValueControlContext.getDimension() != null) {
                this._attributeName = eventContext.getItemName(this._currentPayloadItemIndex);
                this._filterName = selectValueControlContext.getDimension();
            }
            if ((bestModelItemBlocks = selectValueControlContext.selectBestModelItemBlocks(this._reportModelPath)).size() == 0) {
                if (this._filterOutputType == DynamicDataFilter.FilterOutputType.detailFilter) {
                    this._modelAndValues = this.createModelAndValues(null);
                    for (String value : selectValueControlContext.getAllInternalContextValues(this._filterName)) {
                        this._modelAndValues.addValue(value, null, null);
                    }
                    for (String value : eventContext.getGenericContextDiscreteValues(selectValueControlContext.isAttributeType() ? this._attributeName : this._filterName)) {
                        this._modelAndValues.addValue(value, null, null);
                    }
                }
                return true;
            }
            this._modelAndValues = this.createModelAndValuesFromWidgetContext(bestModelItemBlocks.get(0));
            if (this._modelAndValues == null) {
                this._isInitialized = false;
                return true;
            }
            for (int i = 0; i < bestModelItemBlocks.size(); ++i) {
                WidgetInternalContext.ModelItemBlock modelItemBlock = bestModelItemBlocks.get(i);
                this.addValuesFromInputBlock(this.isFacet() ? modelItemBlock.getFirstItem() : modelItemBlock.getItem(this._filterName));
            }
        }
        return true;
    }

    private boolean emptyValueSet(JSONObject filterJSON, JSONArray inputModelValuesBlocks) {
        if (inputModelValuesBlocks != null && inputModelValuesBlocks.size() == 0) {
            String valueTypeStr = (String)filterJSON.get((Object)"valuetype");
            this._modelAndValues = new ModelAndValues(null, null, valueTypeStr);
            return true;
        }
        return false;
    }

    private ModelAndValues createModelAndValues(JSONObject bestModelValuesBlock) {
        JSONObject bestModelInfo;
        String bestValueTypeStr = "string";
        if (bestModelValuesBlock != null && (bestModelInfo = (JSONObject)bestModelValuesBlock.get((Object)"modelInfo")) != null) {
            String keyCol = (String)bestModelInfo.get((Object)"keyCol");
            String bestModelPath = (String)bestModelInfo.get((Object)"path");
            bestValueTypeStr = (String)bestModelInfo.get((Object)"valuetype");
            return new ModelAndValues(bestModelPath, keyCol, bestValueTypeStr);
        }
        return new ModelAndValues(null, null, bestValueTypeStr);
    }

    private ModelAndValues createModelAndValuesFromWidgetContext(WidgetInternalContext.ModelItemBlock bestModel) {
        String bestValueTypeStr = "string";
        if (bestModel != null) {
            return new ModelAndValues(bestModel.getModelName(), bestModel.getKeyCol(this._filterName), "string");
        }
        return new ModelAndValues(null, null, bestValueTypeStr);
    }

    private List<JSONObject> selectBestModelValuesBlocks(JSONArray inputModelValuesBlocks) {
        ArrayList<JSONObject> bestInputBlocks = new ArrayList<JSONObject>();
        for (int i = 0; i < inputModelValuesBlocks.size(); ++i) {
            JSONObject inputModelValuesBlock = (JSONObject)inputModelValuesBlocks.get(i);
            JSONObject inputModelInfo = (JSONObject)inputModelValuesBlock.get((Object)"modelInfo");
            String inputValuesModelPath = null;
            if (inputModelInfo != null) {
                inputValuesModelPath = (String)inputModelInfo.get((Object)"path");
            }
            if (inputValuesModelPath != null && inputValuesModelPath.equals(this._reportModelPath)) {
                bestInputBlocks.add(inputModelValuesBlock);
                continue;
            }
            if (inputValuesModelPath != null) continue;
            bestInputBlocks.add(inputModelValuesBlock);
        }
        return bestInputBlocks;
    }

    private void addValuesFromInputBlock(JSONObject inputModelValuesBlock) {
        if (inputModelValuesBlock == null) {
            return;
        }
        JSONArray valuesEntryArray = (JSONArray)inputModelValuesBlock.get((Object)"values");
        for (int v = 0; v < valuesEntryArray.size(); ++v) {
            JSONObject jsonValuesEntry = (JSONObject)valuesEntryArray.get(v);
            String key = jsonValuesEntry.get((Object)"key") == null ? null : jsonValuesEntry.get((Object)"key").toString();
            this._modelAndValues.addValue((String)jsonValuesEntry.get((Object)"caption"), key, (String)jsonValuesEntry.get((Object)"mun"));
        }
    }

    private void addCaptionValuesFromAllBlocks(JSONArray inputModelValuesBlocks) {
        for (int i = 0; i < inputModelValuesBlocks.size(); ++i) {
            JSONObject inputModelValuesBlock = (JSONObject)inputModelValuesBlocks.get(i);
            JSONArray valuesEntryArray = (JSONArray)inputModelValuesBlock.get((Object)"values");
            for (int v = 0; v < valuesEntryArray.size(); ++v) {
                JSONObject jsonValuesEntry = (JSONObject)valuesEntryArray.get(v);
                this._modelAndValues.addValue((String)jsonValuesEntry.get((Object)"caption"), null, null);
            }
        }
    }

    @Override
    public void initializeFromXML(Element eFilterValue) {
        super.initializeFromXML(eFilterValue);
        if (eFilterValue != null) {
            this._modelAndValues = new ModelAndValues(null, null, eFilterValue.elementText("valuesType"));
            List eValues = XMLUtility.selectNodes(eFilterValue, "./*[local-name()='values']/*[local-name()='value']");
            ListIterator valuesIterator = eValues.listIterator();
            while (valuesIterator.hasNext()) {
                Element valueNode = (Element)valuesIterator.next();
                this._modelAndValues.addValue(valueNode.getText(), valueNode.attributeValue("key"), valueNode.attributeValue("mun"));
            }
        }
    }

    public ModelAndValues getModelAndValues() {
        return this._modelAndValues;
    }

    @Override
    public void generateV5DetailFilter(Element v5DetailFiltersNode, boolean isMemberTypeColumn, boolean postAutoAggregation) {
        if (this._modelAndValues == null) {
            return;
        }
        this.populateFilterOutput(isMemberTypeColumn);
        this._detailFilterOutput.create(this.getId(), v5DetailFiltersNode, this.generateV5FilterDescriptor(), postAutoAggregation, false);
    }

    @Override
    public void generateV5AttributeFilter(String hun, JSONObject dimensionInfo, Element v5DetailFilterNode) {
        this.setInlineValues(true);
        if (this._modelAndValues == null) {
            return;
        }
        this.populateFilterOutput(false);
        ArrayList<SelectedCell> selectedCells = this.getDiscreteValuesAsSelectedCells("memberUniqueName");
        v5DetailFilterNode.addAttribute("use", "optional");
        this.addFilterTags(v5DetailFilterNode, this.getId(), this.generateV5FilterDescriptor(), false, true);
        Element detailFilterExpressionElement = DocumentHelper.makeElement((Branch)v5DetailFilterNode, (String)"filterExpression");
        detailFilterExpressionElement.setText(this.createAttributeFilterExpression(hun, dimensionInfo, this._attributeName, selectedCells));
    }

    private String createAttributeFilterExpression(String hunOrlun, String attributeName, ArrayList<SelectedCell> selectedCells, boolean isString) {
        String attributeTerm = ".[" + attributeName + "]";
        String attributeMPUN = hunOrlun + attributeTerm;
        String expression = isString ? "lower(" + attributeMPUN + ")" : attributeMPUN;
        expression = expression + " in (";
        for (int i = 0; i < selectedCells.size(); ++i) {
            SelectedCell cell = selectedCells.get(i);
            expression = expression + (i == 0 ? "" : this._listSeparator);
            expression = expression + (isString ? "lower('" : "'");
            expression = expression + V5SpecHelper.getV5SafeFilterValue(cell.nodeUse);
            expression = expression + (isString ? "')" : "'");
        }
        expression = expression + ")";
        return expression;
    }

    protected String createAttributeFilterExpression(String hun, JSONObject dimensionInfo, String attributeName, ArrayList<SelectedCell> selectedCells) {
        JSONArray levels = V5Query.getLevels(dimensionInfo);
        boolean isString = V5Query.isString(dimensionInfo, attributeName);
        if (levels == null || levels.size() == 0) {
            return this.createAttributeFilterExpression(hun, attributeName, selectedCells, isString);
        }
        if (levels.size() == 1) {
            JSONObject level0 = (JSONObject)levels.get(0);
            return this.createAttributeFilterExpression((String)level0.get((Object)"_ref"), attributeName, selectedCells, isString);
        }
        String expression = "";
        for (int lvl = 0; lvl < levels.size(); ++lvl) {
            String joiner = lvl == 0 ? "" : " or ";
            JSONObject levelN = (JSONObject)levels.get(lvl);
            expression = expression + joiner + this.createAttributeFilterExpression((String)levelN.get((Object)"_ref"), attributeName, selectedCells, isString);
        }
        return expression;
    }

    public void generateV5Slicer(Element contextSlicer) {
        if (this._modelAndValues == null) {
            return;
        }
        this._modelAndValues.setIsSlicerType();
        this.populateFilterOutput(true);
        if (this.getModelAndValues().canUseMunValues()) {
            if (this.isFacet()) {
                this.matchFacetValuesToReportNamespace(V5QueryItem.getNameSpace(contextSlicer));
            }
            V5ContextSlicer.updateDynamicContextSlicer(contextSlicer, this._controlType, this.getClientId(), this._selectChoicesParmValues);
        }
    }

    @Override
    public String generateV5FilterDescriptor() {
        String clientId;
        JSONObject descriptor = new JSONObject();
        descriptor.put((Object)"name", (Object)this._filterName);
        descriptor.put((Object)"attributeName", (Object)this._attributeName);
        if (this._controlType != null) {
            descriptor.put((Object)"controlType", (Object)this._controlType);
        }
        if ((clientId = this.getClientId()) != null) {
            descriptor.put((Object)"clientId", (Object)clientId);
        }
        JSONArray valueArray = new JSONArray();
        descriptor.put((Object)"values", (Object)valueArray);
        if (this._modelAndValues != null) {
            if (this._modelAndValues._keyColumnName != null) {
                descriptor.put((Object)"keyColumnName", (Object)this._modelAndValues._keyColumnName);
            }
            for (DiscreteValue valueEntry : this._modelAndValues.getValues()) {
                valueArray.add((Object)valueEntry.getCaption());
            }
        }
        return descriptor.toString();
    }

    public boolean filterHasMuns() {
        return this._modelAndValues != null && this._modelAndValues.filterHasMuns();
    }

    @Override
    public void populateFilterOutput(boolean isMemberTypeColumn) {
        if (this._modelAndValues == null) {
            return;
        }
        this._modelAndValues.applyRulesForUsingMunsOrKeys();
        this._selectChoicesParmValues.clear();
        if (this._modelAndValues.getValues().size() == 0) {
            this._detailFilterOutput.setRHS("('')");
            this._selectChoicesParmValues.add(new ParmValue(null, null));
            this.populateFilterOutputLHS(isMemberTypeColumn, false, 0);
            return;
        }
        boolean valuesContainDigits = false;
        int longestValue = 0;
        StringBuilder expressionRHS = new StringBuilder("(");
        boolean firstTime = true;
        for (DiscreteValue valueEntry : this._modelAndValues.getValues()) {
            if (!firstTime) {
                expressionRHS.append(this._listSeparator);
            }
            firstTime = false;
            String rootRHSValue = null;
            if (this._modelAndValues.getIsSlicerType() && valueEntry.getMun() == null) continue;
            if (isMemberTypeColumn && this._modelAndValues.canUseMunValues()) {
                rootRHSValue = valueEntry.getMun();
                expressionRHS.append(V5SpecHelper.getV5SafeFilterValue(rootRHSValue));
            } else if (this._modelAndValues.canUseKeyValues()) {
                rootRHSValue = valueEntry.getKey();
                expressionRHS.append("'" + rootRHSValue.replace("'", "''") + "'");
            } else {
                rootRHSValue = valueEntry.getCaption();
                if (this._discreteNumeric) {
                    expressionRHS.append(rootRHSValue);
                } else {
                    expressionRHS.append("'" + rootRHSValue.replace("'", "''") + "'");
                }
            }
            if (rootRHSValue.length() > longestValue) {
                longestValue = rootRHSValue.length();
            }
            if (!valuesContainDigits) {
                valuesContainDigits = rootRHSValue.matches(".*[0-9].*");
            }
            this._selectChoicesParmValues.add(new ParmValue(rootRHSValue, valueEntry.getCaption()));
        }
        expressionRHS.append(")");
        this._detailFilterOutput.setRHS(expressionRHS.toString());
        this.populateFilterOutputLHS(isMemberTypeColumn, valuesContainDigits, longestValue);
    }

    private void populateFilterOutputLHS(boolean isMemberTypeColumn, boolean valuesContainDigits, int longestValue) {
        if (this._filterOutputType == DynamicDataFilter.FilterOutputType.dataItem && this._modelAndValues.canUseMunValues()) {
            this._detailFilterOutput.setLHS(null);
            this._detailFilterOutput.setOperator("set");
        } else {
            this._detailFilterOutput.setLHS(this.generateV5FilterTermLHS(isMemberTypeColumn, valuesContainDigits, longestValue, this._detailFilterOutput._inlineValues));
            this._detailFilterOutput.setOperator("in");
        }
    }

    private String generateV5FilterTermLHS(boolean isMemberType, boolean valuesContainDigits, int longestValue, boolean inlineValues) {
        if (this._modelAndValues.canUseMunValues()) {
            return this._hun == null ? "[" + this.getRDIName() + "]" : this._hun;
        }
        if (isMemberType) {
            String nameOrHun;
            String string = nameOrHun = this._hun == null ? "[" + this.getRDIName() + "]" : this._hun;
            if (this._modelAndValues.canUseKeyValues()) {
                return "roleValue('_businessKey', " + nameOrHun + ")";
            }
            return this._hun == null ? "caption(" + nameOrHun + ")" : "caption(members(" + nameOrHun + "))";
        }
        if (this._modelAndValues.getKeyColumnName() != null) {
            if (!this._modelAndValues.getKeyColumnName().startsWith("[")) {
                return "[" + this._modelAndValues.getKeyColumnName() + "]";
            }
            return this._modelAndValues.getKeyColumnName();
        }
        if (inlineValues && valuesContainDigits && !this._discreteNumeric) {
            return "cast([" + this.getRDIName() + "]" + this._listSeparator + " varchar (" + Integer.toString(longestValue + 2) + "))";
        }
        return "[" + this.getRDIName() + "]";
    }

    @Override
    public String getSelectChoices() {
        StringBuilder selectChoices = new StringBuilder();
        selectChoices.append("<selectChoices>");
        for (ParmValue choice : this._selectChoicesParmValues) {
            selectChoices.append("<selectOption useValue=\"" + choice.getEncodedUseValueAttribute() + "\"");
            if (choice.getEncodedDisplayValueAttribute() != null && !choice.useAndDisplayValuesAreEqual()) {
                selectChoices.append(" displayValue=\"" + choice.getEncodedDisplayValueAttribute() + "\"");
            }
            selectChoices.append("/>");
        }
        selectChoices.append("</selectChoices>");
        return selectChoices.toString();
    }

    public void addSelectChoicesParmValue(ParmValue pv) {
        this._selectChoicesParmValues.add(pv);
    }

    public class ModelAndValues {
        protected String _keyColumnName = null;
        private String _modelPath = null;
        private String _valuesType = null;
        private ArrayList<DiscreteValue> _valueList = null;
        private HashSet<String> _uniqueValueSet = new HashSet();
        private boolean _canUseMunValues = false;
        private boolean _isSlicerType = false;
        private boolean _canUseKeyValues = false;

        public ModelAndValues(String valuesModelPath, String keyColumnName, String valuesType) {
            this._modelPath = valuesModelPath;
            this._keyColumnName = keyColumnName;
            this._valuesType = valuesType;
            this._valueList = new ArrayList();
        }

        public void setIsSlicerType() {
            this._isSlicerType = true;
        }

        public boolean getIsSlicerType() {
            return this._isSlicerType;
        }

        public boolean canUseMunValues() {
            return this._canUseMunValues;
        }

        public boolean canUseKeyValues() {
            return this._canUseKeyValues;
        }

        public void addValue(String caption, String key, String mun) {
            String hashKey = caption + "//" + key + "//" + mun;
            if (!this._uniqueValueSet.contains(hashKey)) {
                this._uniqueValueSet.add(hashKey);
                this._valueList.add(new DiscreteValue(caption, key, mun));
            }
        }

        public String getModelPath() {
            return this._modelPath;
        }

        public String getKeyColumnName() {
            return this._keyColumnName;
        }

        public String getValuesType() {
            return this._valuesType;
        }

        public ArrayList<DiscreteValue> getValues() {
            return this._valueList;
        }

        public boolean filterHasMuns() {
            if (this._valueList != null && this._valueList.size() > 0) {
                for (DiscreteValue valueEntry : this._valueList) {
                    if (valueEntry.getMun() == null) continue;
                    return true;
                }
            }
            return false;
        }

        public void applyRulesForUsingMunsOrKeys() {
            if (this._modelPath == null) {
                this._canUseMunValues = false;
                this._canUseKeyValues = false;
                DynamicDiscreteValuesFilter.this.setHun(null);
                return;
            }
            this._canUseMunValues = !DynamicDiscreteValuesFilter.this._multipleNamespaceReportItem;
            this._canUseKeyValues = this._keyColumnName != null;
            ArrayList<DiscreteValue> munsInThisNamespace = new ArrayList<DiscreteValue>();
            String hun = DynamicDiscreteValuesFilter.this._hun;
            for (DiscreteValue valueEntry : this._valueList) {
                if ((valueEntry.getMun() == null || "".equals(valueEntry.getMun())) && !this._isSlicerType) {
                    this._canUseMunValues = false;
                    if (!this._canUseKeyValues) {
                        break;
                    }
                } else if (this._canUseMunValues && hun != null && valueEntry.getMun() != null && DynamicDiscreteValuesFilter.this.hunsMatch(valueEntry.getMun())) {
                    munsInThisNamespace.add(valueEntry);
                } else if (this._canUseMunValues && this._isSlicerType) {
                    munsInThisNamespace.add(valueEntry);
                }
                if (!this._canUseKeyValues || valueEntry.getKey() != null) continue;
                this._canUseKeyValues = false;
                if (this._canUseMunValues) continue;
                break;
            }
            if (!this._canUseMunValues && !this._canUseKeyValues) {
                DynamicDiscreteValuesFilter.this.setHun(null);
            } else if (this._canUseMunValues && hun != null) {
                if (munsInThisNamespace.size() == 0) {
                    this._canUseMunValues = false;
                    DynamicDiscreteValuesFilter.this.setHun(null);
                } else if (munsInThisNamespace.size() < this._valueList.size()) {
                    this._valueList.clear();
                    this._valueList.addAll(munsInThisNamespace);
                }
            }
        }
    }

    public class ParmValue {
        private String _useValue = null;
        private String _displayValue = null;

        public ParmValue(String use, String display) {
            this._useValue = use;
            this._displayValue = display;
        }

        public String getUseValueAttribute() {
            return this._useValue;
        }

        public void setUseValue(String newUseValue) {
            this._useValue = newUseValue;
        }

        public String getDisplayValueAttribute() {
            return this._displayValue;
        }

        public String getEncodedUseValueAttribute() {
            if (this._useValue == null) {
                return null;
            }
            return XMLUtility.xmlencode(this._useValue);
        }

        public String getEncodedDisplayValueAttribute() {
            if (this._displayValue == null) {
                return null;
            }
            return XMLUtility.xmlencode(this._displayValue);
        }

        public boolean useAndDisplayValuesAreEqual() {
            if (this._useValue == null) {
                return this._displayValue == null;
            }
            return this._useValue.equals(this._displayValue);
        }

        public SelectedCell getAsSelectedCell() {
            SelectedCell cell = new SelectedCell();
            cell.nodeUse = this._useValue;
            cell.nodeDisplay = this._displayValue;
            return cell;
        }
    }
}

