/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.RangeValue;
import com.cognos.rap.actions.WidgetContextManager;
import com.cognos.rap.actions.WidgetSelectValueControlContext;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.dom4j.Element;

public class DynamicRangeFilter
extends DynamicDataFilter {
    private RangeValue _rangeValue = new RangeValue();

    public DynamicRangeFilter(String clientId, String reportModelPath) {
        super(clientId, reportModelPath);
    }

    @Override
    public void initialize(JSONObject filterJSON) {
        super.initialize(filterJSON);
        if (!this.initializeFromWidgetContext(filterJSON)) {
            if (filterJSON.get((Object)"min") != null) {
                this._rangeValue.setMin(filterJSON.get((Object)"min").toString());
            }
            if (filterJSON.get((Object)"minDisplay") != null) {
                this._rangeValue.setMinDisplay(filterJSON.get((Object)"minDisplay").toString());
            }
            if (filterJSON.get((Object)"max") != null) {
                this._rangeValue.setMax(filterJSON.get((Object)"max").toString());
            }
            if (filterJSON.get((Object)"maxDisplay") != null) {
                this._rangeValue.setMaxDisplay(filterJSON.get((Object)"maxDisplay").toString());
            }
            this._rangeValue.setValueType((String)filterJSON.get((Object)"valuetype"));
        }
    }

    public boolean initializeFromWidgetContext(JSONObject jsonWidgetContext) {
        if (!WidgetContextManager.isValid(jsonWidgetContext)) {
            return false;
        }
        WidgetContextManager widgetContextManager = new WidgetContextManager(jsonWidgetContext);
        this._rangeValue = widgetContextManager.getRangeValue(this._filterName);
        WidgetSelectValueControlContext selectValueControlContext = widgetContextManager.getSelectValueControlContext();
        if (selectValueControlContext != null) {
            this._rangeValue.setValueType(selectValueControlContext.getValueType());
        }
        if (null == this._rangeValue.getValueType()) {
            this._rangeValue.setValueType("number");
        }
        return true;
    }

    @Override
    public void initializeFromXML(Element eFilterValue) {
        super.initializeFromXML(eFilterValue);
        if (eFilterValue != null) {
            this._rangeValue.setValueType(eFilterValue.elementText("valuesType"));
            List eValues = XMLUtility.selectNodes(eFilterValue, "./*[local-name()='values']/*[local-name()='value']");
            if (eValues.size() >= 2) {
                this._rangeValue.setMin(((Element)eValues.get(0)).getText());
                this._rangeValue.setMax(((Element)eValues.get(1)).getText());
            } else if (eValues.size() == 1) {
                this._rangeValue.setMin(((Element)eValues.get(0)).getText());
                this._rangeValue.setMax(((Element)eValues.get(0)).getText());
            }
        }
    }

    private boolean isNumericValuesType() {
        return "number".equals(this._rangeValue.getValueType()) || "numeric".equals(this._rangeValue.getValueType());
    }

    @Override
    public void generateV5DetailFilter(Element v5DetailFiltersNode, boolean caption, boolean postAutoAggregation) {
        this.populateFilterOutput(false);
        this._detailFilterOutput.create(this.getId(), v5DetailFiltersNode, this.generateV5FilterDescriptor(), postAutoAggregation, this.isNumericValuesType());
    }

    @Override
    public void populateFilterOutput(boolean isMemberTypeColumn) {
        this._detailFilterOutput.setLHS("[" + V5SpecHelper.escapeQueryReferenceTerm(this.getRDIName()) + "]");
        this._detailFilterOutput.setOperator("in_range");
        StringBuilder RHS = new StringBuilder();
        RHS.append("{");
        RHS.append(this._rangeValue.getMin());
        RHS.append(":");
        RHS.append(this._rangeValue.getMax());
        RHS.append("}");
        this._detailFilterOutput.setRHS(RHS.toString());
    }

    @Override
    public String generateV5FilterDescriptor() {
        JSONObject filterDescriptor = new JSONObject();
        filterDescriptor.put((Object)"name", (Object)this.getName());
        filterDescriptor.put((Object)"type", (Object)"in_range");
        filterDescriptor.put((Object)"min", (Object)this._rangeValue.getMinDisplay());
        filterDescriptor.put((Object)"max", (Object)this._rangeValue.getMaxDisplay());
        String clientId = this.getClientId();
        if (clientId != null) {
            filterDescriptor.put((Object)"clientId", (Object)clientId);
        }
        return filterDescriptor.toString();
    }

    @Override
    public String getSelectChoices() {
        if (this._detailFilterOutput != null && (this._rangeValue.getMin() != null || this._rangeValue.getMax() != null)) {
            StringBuilder selectBoundRange = new StringBuilder();
            selectBoundRange.append("<selectChoices>");
            selectBoundRange.append("<selectBoundRange>");
            if (this._rangeValue.getMin() != null) {
                selectBoundRange.append("<start useValue=\"");
                selectBoundRange.append(this._rangeValue.getMin());
                selectBoundRange.append("\"/>");
            }
            if (this._rangeValue.getMax() != null) {
                selectBoundRange.append("<end useValue=\"");
                selectBoundRange.append(this._rangeValue.getMax());
                selectBoundRange.append("\"/>");
            }
            selectBoundRange.append("</selectBoundRange></selectChoices>");
            return selectBoundRange.toString();
        }
        return null;
    }
}

