/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.utility.RAPMessageManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class FilterInfo {
    public static final String ITEM = "item";
    public static final String ITEMLABEL = "itemLabel";
    public static final String IN = "in";
    public static final String NOTIN = "notIn";
    public static final String RANGE = "range";
    public static final String NOTRANGE = "notRange";
    public static final String FROM = "from";
    public static final String TO = "to";
    Element _filterElement = null;
    String _filterLabel = null;
    String _locale;

    public FilterInfo(Element filterElement, String filterLabel, String locale) {
        this._filterElement = filterElement;
        this._filterLabel = filterLabel;
        this._locale = locale;
    }

    public JSONObject createJSON() {
        boolean bFilterIsParameterised;
        String rdi = V5QueryFilters.getItemName(this._filterElement);
        Attribute parameterized = this._filterElement.attribute("parameterized");
        boolean bl = bFilterIsParameterised = parameterized == null ? false : "true".equals(parameterized.getValue());
        if (rdi != null && !bFilterIsParameterised) {
            boolean filterMembers;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)ITEM, (Object)rdi);
            if (this._filterLabel != null && !rdi.equals(this._filterLabel)) {
                jsonObject.put((Object)ITEMLABEL, (Object)this._filterLabel);
            }
            if ((filterMembers = V5QueryFilters.isMemberFilter(this._filterElement)) || "filterInValues".equals(this._filterElement.getName())) {
                this.filterInToJSON(jsonObject, filterMembers);
            } else if ("filterRange".equals(this._filterElement.getName())) {
                this.filterRangeToJSON(jsonObject);
            } else if ("filterNulls".equals(this._filterElement.getName())) {
                this.filterNullToJSON(jsonObject);
            } else {
                Element filterValue = this._filterElement.element("filterValue");
                if (filterValue != null && this._filterElement.attribute("operator") != null) {
                    String formattedNumber = V5SpecHelper.getXMLAttribute(this._filterElement, "RAP_FormattedNumber");
                    if (formattedNumber != null) {
                        jsonObject.put((Object)this._filterElement.attributeValue("operator"), (Object)formattedNumber);
                    } else {
                        jsonObject.put((Object)this._filterElement.attributeValue("operator"), (Object)filterValue.getText());
                    }
                    if (this._filterElement.attribute("not") != null) {
                        jsonObject.put((Object)"not", (Object)this._filterElement.attributeValue("not"));
                    }
                }
            }
            return jsonObject;
        }
        return null;
    }

    private void filterInToJSON(JSONObject jsonObject, boolean filterMembers) {
        JSONArray values = new JSONArray();
        if (V5QueryFilters.isExcludeFilter(this._filterElement)) {
            jsonObject.put((Object)NOTIN, (Object)values);
        } else {
            jsonObject.put((Object)IN, (Object)values);
        }
        List valuesList = null;
        valuesList = filterMembers ? V5X.selectNodes(this._filterElement, "//V5X//CHILD", "dmMembers", "dmMember", "itemCaption") : V5X.selectNodes(this._filterElement, "filterValue");
        boolean firstTime = true;
        for (Element thisEntry : valuesList) {
            values.add((Object)thisEntry.getText());
        }
    }

    private void filterRangeToJSON(JSONObject jsonObject) {
        List fromList = this._filterElement.elements("filterFrom");
        List toList = this._filterElement.elements("filterTo");
        JSONArray ranges = new JSONArray();
        if ("true".equals(this._filterElement.attributeValue("not"))) {
            jsonObject.put((Object)NOTRANGE, (Object)ranges);
        } else {
            jsonObject.put((Object)RANGE, (Object)ranges);
        }
        JSONObject range = new JSONObject();
        String from = V5SpecHelper.getXMLAttribute(this._filterElement, "RAP_FormattedNumber");
        if (from != null) {
            range.put((Object)FROM, (Object)from);
        } else if (!fromList.isEmpty()) {
            Element fromValue = (Element)fromList.get(0);
            range.put((Object)FROM, (Object)fromValue.getText());
        }
        String to = V5SpecHelper.getXMLAttribute(this._filterElement, "RAP_FormattedEndNumber");
        if (to != null) {
            range.put((Object)TO, (Object)to);
        } else {
            Element toValue = (Element)toList.get(0);
            range.put((Object)TO, (Object)toValue.getText());
        }
        ranges.add((Object)range);
    }

    private void filterNullToJSON(JSONObject jsonObject) {
        JSONArray ranges = new JSONArray();
        ranges.add((Object)RAPMessageManager.convert("IDS_JS_NULL", this._locale));
        if ("true".equals(this._filterElement.attributeValue("not"))) {
            jsonObject.put((Object)NOTIN, (Object)ranges);
        } else {
            jsonObject.put((Object)IN, (Object)ranges);
        }
    }
}

