/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DiscreteValue;
import com.cognos.rap.actions.RangeValue;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.JSONUtility;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class FilterValuesInfo {
    private static final String fmtPatrn = "fmtPatrn";
    private static final String fmtVal = "fmtVal";
    private String _item = null;
    private String _modelPath = null;
    private String _keyColumn = null;
    private ArrayList<DiscreteValue> _filterValues = new ArrayList();
    private RangeValue _rangeValue = null;
    private ActionEnv _actionEnv = null;
    private static String promptInfoProperties = "<Properties><Property name=\"*/@name\"/><Property name=\"*/@_path\"/><Property name=\"*/@_ref\"/><Property name=\"./querySubject\"/><Property name=\"./queryItem\"/><Property name=\"./queryItemFolder\"/><Property name=\"./filter\"/><Property name=\"*/@datatype\"/><Property name=\"*/@usage\"/><Property name=\"*/@regularAggregate\"/><Property name=\"*/@_effectivePromptInfo\"/></Properties>";

    public boolean populated() {
        return this._filterValues.size() > 0 || this._rangeValue != null;
    }

    public FilterValuesInfo(String item) {
        this._item = item;
    }

    public void setModelPath(String modelPath) {
        this._modelPath = modelPath;
    }

    public String getKeyColumn() {
        return this._keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this._keyColumn = keyColumn;
    }

    public void setEnv(ActionEnv env) {
        this._actionEnv = env;
    }

    public void setRangeValue() {
        this._rangeValue = new RangeValue();
    }

    public RangeValue getRangeValue() {
        return this._rangeValue;
    }

    public ArrayList<DiscreteValue> getFilterValues() {
        return this._filterValues;
    }

    private void addDiscreteFilterValue(String value, String keyValue, String munValue) {
        if (munValue == null || !munValue.startsWith("uuid:")) {
            DiscreteValue discreteValue = new DiscreteValue(value, keyValue, munValue);
            this._filterValues.add(discreteValue);
        }
    }

    public JSONObject createJSON() {
        JSONObject filterValuesContainer = new JSONObject();
        JSONObject filterValues = new JSONObject();
        filterValuesContainer.put((Object)"filterValues", (Object)filterValues);
        filterValues.put((Object)"name", (Object)this._item);
        if (this._modelPath != null) {
            JSONObject modelInfo = new JSONObject();
            modelInfo.put((Object)"path", (Object)this._modelPath);
            if (this._keyColumn != null) {
                modelInfo.put((Object)"keyCol", (Object)this._keyColumn);
            }
            filterValues.put((Object)"modelInfo", (Object)modelInfo);
        }
        if (this._rangeValue != null) {
            JSONObject jsonRange = this._rangeValue.createJSON();
            filterValues.put((Object)"range", (Object)jsonRange);
        } else {
            JSONArray discreteValuesArray = new JSONArray();
            for (DiscreteValue dv : this._filterValues) {
                discreteValuesArray.add((Object)dv.createJSON());
            }
            filterValues.put((Object)"values", (Object)discreteValuesArray);
        }
        return filterValuesContainer;
    }

    public int populateRange(String currentMin, String currentMax, String metaData, String contextData) throws ActionException {
        Double rangeMax;
        Double rangeMin = currentMin == null ? null : Double.valueOf(currentMin);
        Double d = rangeMax = currentMax == null ? null : Double.valueOf(currentMax);
        if (metaData != null && contextData != null) {
            JSONObject jsonCtx = JSONUtility.parse(contextData);
            JSONObject jsonMd = JSONUtility.parse(metaData);
            for (int i = 1; i <= jsonCtx.size(); ++i) {
                String refDataItem;
                JSONObject rEntry;
                JSONObject value = (JSONObject)jsonCtx.get((Object)Integer.toString(i));
                Long rEntryKey = (Long)value.get((Object)"r");
                if (rEntryKey == null || (rEntry = (JSONObject)jsonMd.get((Object)rEntryKey.toString())) == null || !(refDataItem = (String)rEntry.get((Object)"r")).equals(this._item)) continue;
                String useValue = (String)value.get((Object)"u");
                try {
                    Double currentValue = Double.valueOf(useValue);
                    if (rangeMin == null || currentValue < rangeMin) {
                        rangeMin = currentValue;
                    }
                    if (rangeMax != null && !(currentValue > rangeMax)) continue;
                    rangeMax = currentValue;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (rangeMin != null) {
                this._rangeValue.setMin(rangeMin.toString());
            }
            if (rangeMax != null) {
                this._rangeValue.setMax(rangeMax.toString());
            }
            return jsonCtx.size();
        }
        if (rangeMin != null) {
            this._rangeValue.setMin(rangeMin.toString());
        }
        if (rangeMax != null) {
            this._rangeValue.setMax(rangeMax.toString());
        }
        return 0;
    }

    public void populateRangeFromLDX(Element ldx) {
        List items;
        Element table = V5X.selectSingleNode(ldx, "table");
        if (table != null && (items = V5X.selectNodes(table, "item", "txt")).size() >= 2) {
            this.populateRangeEndPointsFromLDX((Element)items.get(0), (Element)items.get(1));
        }
    }

    public void populateRangeEndPointsFromLDX(Element ldxMinItem, Element ldxMaxItem) {
        if (this._rangeValue == null) {
            this.setRangeValue();
        }
        if (ldxMinItem == null || ldxMaxItem == null) {
            return;
        }
        this._rangeValue.setMin(ldxMinItem.elementText("val"));
        this._rangeValue.setMinDisplay(ldxMinItem.elementText(fmtVal));
        this._rangeValue.setMax(ldxMaxItem.elementText("val"));
        this._rangeValue.setMaxDisplay(ldxMaxItem.elementText(fmtVal));
        this.populateRangeFormatAndScaleInfo(ldxMinItem);
    }

    public void populateRangeFormatAndScaleInfo(Element ldxMinItem) {
        if (this._rangeValue == null) {
            this.setRangeValue();
        }
        if (ldxMinItem == null) {
            return;
        }
        this._rangeValue.setNumberFormat(ldxMinItem.elementText(fmtPatrn));
        this._rangeValue.setScale(ldxMinItem.elementText("fmtScale"));
        String excelFormat = ldxMinItem.elementText("exclPatrn");
        if (excelFormat != null && excelFormat.contains("%")) {
            this._rangeValue.setPercentage();
        }
    }

    public void populateNumberFormatFromLDX(Element ldxFormatResponse) {
        List items;
        Element lstRow = V5X.selectSingleNode(ldxFormatResponse, "lst", "row");
        if (lstRow != null && (items = V5X.selectNodes(lstRow, "item", "txt")).size() >= 1) {
            this._rangeValue.setMinDisplay(((Element)items.get(0)).elementText(fmtVal));
            this._rangeValue.setMaxDisplay(((Element)items.get(0)).elementText(fmtVal));
            this._rangeValue.setNumberFormat(((Element)items.get(0)).elementText(fmtPatrn));
            this._rangeValue.setScale(((Element)items.get(0)).elementText("fmtScale"));
            String excelFormat = ((Element)items.get(0)).elementText("exclPatrn");
            if (excelFormat != null && excelFormat.contains("%")) {
                this._rangeValue.setPercentage();
            }
        }
    }

    public boolean findKeyColumn(JSONObject jsonCtx, JSONObject jsonMd) throws CognosServiceRequestException {
        if (this._actionEnv == null || this._actionEnv.getRapServiceRequestManager() == null) {
            return false;
        }
        for (int i = 1; i <= jsonCtx.size(); ++i) {
            String metadataModelItem;
            JSONObject metadataModelEntry;
            JSONObject value = (JSONObject)jsonCtx.get((Object)Integer.toString(i));
            if (value == null) continue;
            Long munKey = (Long)value.get((Object)"m");
            if (munKey != null) {
                return false;
            }
            Long metadataModelKey = (Long)value.get((Object)"i");
            if (metadataModelKey == null || (metadataModelEntry = (JSONObject)jsonMd.get((Object)metadataModelKey.toString())) == null || metadataModelEntry.get((Object)"i") == null || (metadataModelItem = metadataModelEntry.get((Object)"i").toString()) == null) continue;
            this._keyColumn = FilterValuesInfo.findAssociatedKeyColumn(this._actionEnv, this._modelPath, metadataModelItem);
            return this._keyColumn != null;
        }
        return false;
    }

    public static String findAssociatedKeyColumn(ActionEnv env, String modelPath, String metadataModelItem) throws CognosServiceRequestException {
        block3: {
            String promptInfoRequest = "<metadataRequest connection=\"" + modelPath + "\">" + "<Metadata authoringLocale=\"" + env.getLocale() + "\" xml:lang=\"" + env.getLocale() + "\" " + "start_at=\"" + metadataModelItem + "\" " + "Depth=\"0\" no_collections=\"1\">" + promptInfoProperties + "</Metadata>" + "</metadataRequest>";
            try {
                Element queryItem;
                Element maResponse = env.getRapServiceRequestManager().executeMAQuery(promptInfoRequest, null);
                if (maResponse != null && maResponse.element("queryItem") != null && (queryItem = maResponse.element("queryItem")).attributeValue("promptFilterItemRef") != null && !"".equals(queryItem.attributeValue("promptFilterItemRef"))) {
                    return queryItem.attributeValue("promptFilterItemRef");
                }
            }
            catch (Exception e) {
                ICognosViewerActionResponse response;
                if (!(e instanceof CognosServiceRequestException) || !(((CognosServiceRequestException)e).getCustomValue() instanceof ICognosViewerActionResponse) || !"working".equals((response = (ICognosViewerActionResponse)((CognosServiceRequestException)e).getCustomValue()).getStatus()) && !"stillWorking".equals(response.getStatus())) break block3;
                throw (CognosServiceRequestException)e;
            }
        }
        return null;
    }

    public int populateDiscreteValues(Element cognosServiceResponse) {
        int rowsProcessed = 0;
        int munIdx = -1;
        int keyIdx = -1;
        Element metadata = V5X.selectSingleNode(cognosServiceResponse, "metadata");
        Element data = V5X.selectSingleNode(cognosServiceResponse, "data");
        if (metadata != null && data != null) {
            List metadataItems = V5X.selectNodes(metadata, "item");
            for (int i = 0; i < metadataItems.size(); ++i) {
                Element metadataItem = (Element)metadataItems.get(i);
                String itemName = metadataItem.attributeValue("name");
                if (itemName == null) continue;
                if (itemName.equals("__munColumn__")) {
                    munIdx = i;
                    continue;
                }
                if (!itemName.equals("__keyColumn__")) continue;
                keyIdx = i;
            }
            List rows = V5X.selectNodes(data, "row");
            for (Element row : rows) {
                List values = V5X.selectNodes(row, "value");
                if (munIdx >= values.size() || keyIdx >= values.size()) continue;
                Element subNode = (Element)values.get(0);
                Attribute xsiNil = subNode.attribute(SOAPEnvelope.XSI_NIL);
                if (xsiNil != null && xsiNil.getValue().compareTo("true") == 0) {
                    this.addDiscreteFilterValue(null, null, null);
                    continue;
                }
                this.addDiscreteFilterValue(((Element)values.get(0)).getText(), keyIdx == -1 ? null : ((Element)values.get(keyIdx)).getText(), munIdx == -1 ? null : ((Element)values.get(munIdx)).getText());
            }
            rowsProcessed = rows.size();
        }
        return rowsProcessed;
    }

    public static class ReportInfoJSON {
        public static final String filterValues = "filterValues";
        public static final String name = "name";
        public static final String path = "path";
        public static final String keyCol = "keyCol";
        public static final String modelInfo = "modelInfo";
        public static final String range = "range";
        public static final String values = "values";
    }
}

