/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.ItemLabel;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class FilterableItemsInfo {
    private HashMap<String, FilterableItemInfo> _filterableItemInfoMap = null;

    public FilterableItemsInfo() {
        this.initialize();
    }

    private void initialize() {
        this._filterableItemInfoMap = new HashMap();
    }

    public List<ItemLabel> getItemLabels() {
        ArrayList<ItemLabel> result = new ArrayList<ItemLabel>();
        for (FilterableItemInfo fi : this._filterableItemInfoMap.values()) {
            result.add(fi._itemLabel);
        }
        return result;
    }

    public FilterableItemInfo add(String name, String label, boolean isRange, boolean visible) {
        FilterableItemInfo item = this._filterableItemInfoMap.get(name);
        if (item == null) {
            item = new FilterableItemInfo(name, isRange, visible);
            this._filterableItemInfoMap.put(name, item);
        }
        if (label != null && !item.labelIsCustomized()) {
            item.setLabel(label);
        }
        return item;
    }

    public void appendJSON(StringBuilder JSON) {
        Collection<FilterableItemInfo> filterableItems = this._filterableItemInfoMap.values();
        JSONObject filterableItemsJSON = new JSONObject();
        JSONObject filterableItemsJSONContents = new JSONObject();
        filterableItemsJSON.put((Object)"filterableItems", (Object)filterableItemsJSONContents);
        JSONArray visibleItems = new JSONArray();
        JSONArray invisibleItems = new JSONArray();
        filterableItemsJSONContents.put((Object)"visible", (Object)visibleItems);
        filterableItemsJSONContents.put((Object)"invisible", (Object)invisibleItems);
        for (FilterableItemInfo filterableItem : filterableItems) {
            if (!filterableItem.isVisible()) continue;
            filterableItem.appendJSON(visibleItems, filterableItem);
        }
        for (FilterableItemInfo filterableItem : filterableItems) {
            if (filterableItem.isVisible()) continue;
            filterableItem.appendJSON(invisibleItems, filterableItem);
        }
        JSON.append(filterableItemsJSON.toString());
    }

    public class FilterableItemInfo {
        String _name = null;
        ItemLabel _itemLabel = null;
        boolean _visible = false;
        boolean _isModel = false;
        boolean _isRange = false;

        FilterableItemInfo(String name, boolean isRange, boolean visible) {
            this._name = name;
            this._itemLabel = new ItemLabel(this._name);
            this._visible = visible;
            this._isRange = isRange;
        }

        public void setLabel(String label) {
            this._itemLabel.setLabel(label);
        }

        public boolean labelIsCustomized() {
            return this._itemLabel.labelIsCustomized();
        }

        public void setIsModel(boolean value) {
            this._isModel = value;
        }

        public boolean isVisible() {
            return this._visible;
        }

        public void appendJSON(JSONArray visibleItems, FilterableItemInfo fii) {
            JSONObject filterableItem = new JSONObject();
            filterableItem.put((Object)"name", (Object)this._name);
            if (this._itemLabel.getLabel() != null) {
                filterableItem.put((Object)"label", (Object)this._itemLabel.getLabel());
            }
            if (this._isModel) {
                filterableItem.put((Object)"model", (Object)Boolean.TRUE);
            }
            if (this._isRange) {
                filterableItem.put((Object)"range", (Object)Boolean.TRUE);
            }
            visibleItems.add((Object)filterableItem);
        }
    }
}

