/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.BaseActionSet;
import com.cognos.rap.actions.IAction;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public class ObjectActionSet
extends BaseActionSet {
    private static Map<String, Constructor<IAction>> _loadedActionConstructors = new HashMap<String, Constructor<IAction>>();
    private String _packageName = null;

    public ObjectActionSet(String packageName) {
        this._packageName = packageName;
    }

    @Override
    public boolean isActionSupported(String actionName) {
        try {
            this.getActionConstructor(actionName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void applyAction(RAPReport rapReport, String actionName, Element actionArgs) throws ActionException {
        try {
            BaseAction action = (BaseAction)this.getAction(actionName);
            action.setReportActionController(this.reportActionController);
            action.setRAPReport(rapReport);
            action.apply(rapReport, actionArgs);
        }
        catch (Exception e) {
            if (e instanceof ActionException) {
                throw (ActionException)e;
            }
            throw new ActionException(e);
        }
    }

    protected IAction getAction(String actionName) throws Exception {
        Constructor<IAction> constructor = this.getActionConstructor(actionName);
        return constructor.newInstance(null);
    }

    private Constructor<IAction> getActionConstructor(String actionName) throws ClassNotFoundException, NoSuchMethodException {
        String key = this.getClass().getName() + this._packageName + actionName;
        Constructor<IAction> constructor = _loadedActionConstructors.get(key);
        if (constructor == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> actionClass = cl.loadClass(this._packageName + "." + actionName);
            constructor = actionClass.getConstructor(null);
            _loadedActionConstructors.put(key, constructor);
        }
        return constructor;
    }
}

