/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.DataContainerInfo;
import com.cognos.rap.actions.FilterValuesInfo;
import com.cognos.rap.actions.FilterableItemsInfo;
import com.cognos.rap.controller.IReportInfo;
import com.cognos.rap.controller.RAPTimer;
import com.cognos.rap.exceptions.ActionException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ReportInfo
implements IReportInfo {
    private boolean _shouldDisableReuseResults = false;
    private boolean _shouldNotPassTrackingtoBUA = false;
    private boolean _updateExisting = false;
    private ArrayList<String> _updatedFeatures = null;
    private JSONArray _drilledOnHUNs = null;
    private RAPTimer _eventTimings = null;
    private boolean _detailFilteringDisabled = false;
    private boolean _promptWidget = false;
    private String _promptWidgetParametersJSON = null;
    private JSONArray non_visible_filter_items_jsonArray = null;
    private FilterableItemsInfo _filterableItemsInfo = null;
    private FilterValuesInfo _filterValuesInfo = null;
    private HashMap<String, DataContainerInfo> _dataContainerInfoMap = null;
    private boolean _singleContainerReport = false;

    @Override
    public void setRAPTimer(RAPTimer timer) {
        this._eventTimings = timer;
    }

    public void setUpdateExisting(boolean flag) {
        this._updateExisting = flag;
    }

    @Override
    public boolean getUpdateExisting() {
        return this._updateExisting;
    }

    public void setShouldNotPassTrackingtoBUA() {
        this._shouldNotPassTrackingtoBUA = true;
    }

    public void setShouldDisableReuseResults() {
        this._shouldDisableReuseResults = true;
    }

    @Override
    public boolean getShouldDisableReuseResults() {
        return this._shouldDisableReuseResults;
    }

    public void addUpdatedFeature(String feature) {
        if (this._updatedFeatures == null) {
            this._updatedFeatures = new ArrayList();
        }
        this._updatedFeatures.add(feature);
    }

    public DataContainerInfo setDataContainerInfo(String layoutID) {
        DataContainerInfo containerInfo;
        if (this._dataContainerInfoMap == null) {
            this._dataContainerInfoMap = new HashMap();
        }
        if ((containerInfo = this._dataContainerInfoMap.get(layoutID)) == null) {
            containerInfo = new DataContainerInfo(layoutID);
            this._dataContainerInfoMap.put(layoutID, containerInfo);
        }
        return containerInfo;
    }

    @Override
    public DataContainerInfo getDataContainerInfo(String layoutId) {
        if (this._dataContainerInfoMap != null) {
            return this._dataContainerInfoMap.get(layoutId);
        }
        return null;
    }

    public int getNumberOfDataContainer() {
        return this._dataContainerInfoMap.size();
    }

    public Set<String> getDataContainerIds() {
        return this._dataContainerInfoMap.keySet();
    }

    public void setFilterableItemsInfo(FilterableItemsInfo filterableItemsInfo) {
        this._filterableItemsInfo = filterableItemsInfo;
    }

    public void setFilterValuesInfo(FilterValuesInfo filterValuesInfo) {
        this._filterValuesInfo = filterValuesInfo;
    }

    public FilterValuesInfo getFilterValuesInfo() {
        return this._filterValuesInfo;
    }

    public void setDetailFilteringDisabled(boolean flag) {
        this._detailFilteringDisabled = flag;
    }

    public void setPromptWidget(boolean flag) {
        this._promptWidget = flag;
    }

    public void setSingleContainerReport(boolean flag) {
        this._singleContainerReport = flag;
    }

    public boolean isSingleContainerReport() {
        return this._singleContainerReport;
    }

    public void setPromptWidgetParams(String params) {
        this._promptWidgetParametersJSON = params;
    }

    public void setReportLevelnonVisibleFiltersItemInfo(JSONArray itemInfoJSONArrayString) {
        this.non_visible_filter_items_jsonArray = itemInfoJSONArrayString;
    }

    private String reportLevelPropertiesToJSON() throws ActionException {
        JSONObject reportLevelProps = new JSONObject();
        if (this._detailFilteringDisabled) {
            reportLevelProps.put((Object)"detailFilteringDisabled", (Object)Boolean.TRUE);
        }
        if (this._shouldNotPassTrackingtoBUA) {
            reportLevelProps.put((Object)"shouldNotPassTrackingtoBUA", (Object)Boolean.TRUE);
        }
        if (this.non_visible_filter_items_jsonArray != null) {
            reportLevelProps.put((Object)"nonVisibleFiltersMemberItemInfo", (Object)this.non_visible_filter_items_jsonArray);
        }
        if (this._promptWidget) {
            reportLevelProps.put((Object)"promptWidget", (Object)Boolean.TRUE);
            if (this._promptWidgetParametersJSON != null && this._promptWidgetParametersJSON.length() > 0) {
                try {
                    JSONArray promptWidgetParametersJSON = JSONArray.parse((String)this._promptWidgetParametersJSON);
                    reportLevelProps.put((Object)"promptWidgetParams", (Object)promptWidgetParametersJSON);
                }
                catch (IOException e) {
                    throw new ActionException(e.getMessage());
                }
            }
        }
        if (this._drilledOnHUNs != null && !this._drilledOnHUNs.isEmpty()) {
            reportLevelProps.put((Object)"drilledOnHUNs", (Object)this._drilledOnHUNs);
        }
        reportLevelProps.put((Object)"singleContainerReport", (Object)this._singleContainerReport);
        if (this._eventTimings != null) {
            this._eventTimings.addEventTiming("Logging eventTimings....");
            reportLevelProps.put((Object)"eventTimings", (Object)this._eventTimings.asJSONArray());
        }
        return "\"reportLevelProperties\": " + reportLevelProps.toString();
    }

    @Override
    public String toJSON() throws ActionException, IOException {
        StringBuilder JSON = new StringBuilder();
        if (this._filterableItemsInfo != null) {
            this._filterableItemsInfo.appendJSON(JSON);
        } else if (this._filterValuesInfo != null) {
            JSON.append(this._filterValuesInfo.createJSON().toString());
        } else {
            JSON.append("{");
            JSON.append(this.reportLevelPropertiesToJSON());
            if (this._dataContainerInfoMap != null) {
                JSON.append(", \"");
                JSON.append("containers");
                JSON.append("\": [");
                Collection<DataContainerInfo> dataContainerInfoList = this._dataContainerInfoMap.values();
                boolean first = true;
                for (DataContainerInfo dataContainerInfo : dataContainerInfoList) {
                    if (!first) {
                        JSON.append(",");
                    }
                    first = false;
                    JSON.append(dataContainerInfo.toJSON());
                }
                JSON.append("]");
            }
            JSON.append("}");
        }
        return JSON.toString();
    }

    @Override
    public String updateJSON(String previousReportInfo) throws Exception {
        if (this._eventTimings != null) {
            this._eventTimings.addEventTiming("spec updated....");
        }
        if (!this._updateExisting || previousReportInfo == null || previousReportInfo.length() == 0) {
            return this.toJSON();
        }
        JSONObject targetJSONReportInfoObject = JSONObject.parse((String)previousReportInfo);
        JSONObject newJSONReportInfoObject = JSONObject.parse((String)this.toJSON());
        JSONArray targetJSON = (JSONArray)targetJSONReportInfoObject.get((Object)"containers");
        JSONArray newJSON = (JSONArray)newJSONReportInfoObject.get((Object)"containers");
        if (null != newJSON) {
            for (int newI = 0; newI < newJSON.size(); ++newI) {
                JSONObject newContainerInfo = (JSONObject)newJSON.get(newI);
                JSONObject targetContainerInfo = this.findContainerInJSONOutput(targetJSON, (String)newContainerInfo.get((Object)"container"));
                if (targetContainerInfo == null) {
                    targetJSON.add((Object)newContainerInfo);
                    continue;
                }
                for (String keyToUpdate : this._updatedFeatures) {
                    if (newContainerInfo.get((Object)keyToUpdate) != null) {
                        targetContainerInfo.put((Object)keyToUpdate, newContainerInfo.get((Object)keyToUpdate));
                        continue;
                    }
                    targetContainerInfo.remove((Object)keyToUpdate);
                }
                if (targetJSONReportInfoObject.get((Object)"reportLevelProperties") == null || this._eventTimings == null) continue;
                this._eventTimings.addEventTiming("Logging eventTimings....");
                ((JSONObject)targetJSONReportInfoObject.get((Object)"reportLevelProperties")).put((Object)"eventTimings", (Object)this._eventTimings.asJSONArray());
            }
        }
        return targetJSONReportInfoObject.toString();
    }

    private JSONObject findContainerInJSONOutput(JSONArray targetJSON, String containerID) {
        if (this._dataContainerInfoMap.get(containerID) != null) {
            for (int i = 0; i < targetJSON.size(); ++i) {
                JSONObject containerInfo = (JSONObject)targetJSON.get(i);
                if (!containerID.equals(containerInfo.get((Object)"container"))) continue;
                return containerInfo;
            }
        }
        return null;
    }

    public static JSONObject getReportLevelProperties(String json) throws Exception {
        JSONObject reportLevelProps = null;
        if (json != null && json.length() > 0) {
            JSONObject JSONReportInfoObject = JSONObject.parse((String)json);
            reportLevelProps = (JSONObject)JSONReportInfoObject.get((Object)"reportLevelProperties");
        }
        return reportLevelProps;
    }

    public static boolean isPromptWidget(JSONObject reportLevelProps) {
        Boolean promptWidget = (Boolean)reportLevelProps.get((Object)"promptWidget");
        boolean result = Boolean.TRUE.equals(promptWidget);
        return result;
    }

    public static Set<String> getPromptWidgetParameters(JSONObject reportLevelProps) {
        JSONArray promptWidgetParameters = (JSONArray)reportLevelProps.get((Object)"promptWidgetParams");
        HashSet<String> result = promptWidgetParameters != null ? new HashSet<String>((Collection<String>)promptWidgetParameters) : null;
        return result;
    }

    public void setDrilledOnInfo(JSONArray aDrilledOnHUNS) {
        this._drilledOnHUNs = aDrilledOnHUNS;
    }

    public static class ReportInfoJSON {
        public static final String reportLevelProperties = "reportLevelProperties";
        public static final String promptWidget = "promptWidget";
        public static final String promptWidgetParameters = "promptWidgetParams";
        public static final String detailFilteringDisabled = "detailFilteringDisabled";
        public static final String containers = "containers";
        public static final String container = "container";
        public static final String singleContainerReport = "singleContainerReport";
        public static final String shouldNotPassTrackingtoBUA = "shouldNotPassTrackingtoBUA";
        public static final String drilledOnHUN = "drilledOnHUNs";
        public static final String eventTimings = "eventTimings";
    }
}

