/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.CCLDbTypesInfo;
import com.cognos.rap.utility.RAPLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class SelectedCell {
    public static final String memberUniqueName = "memberUniqueName";
    public static final String measure = "measure";
    public static final String nonMeasure = "nonMeasure";
    public static final String NODE_USE_PREFIX_UUID = "uuid:";
    public static final String NODE_USE_PREFIX_CALC_UUID = "calc_uuid:";
    public String nodeName = null;
    public String nodeUse = null;
    public String nodeDisplay = null;
    public String queryName = null;
    public String nodeType = null;
    public String nodeUsage = null;
    public String nodeHierarchyUniqueName = null;
    public String nodeDimensionUniqueName = null;
    public List<SelectedCell> definingCells = new ArrayList<SelectedCell>();
    public String rapLayoutTag = null;

    private String readMetadataRef(Element selectionContext, Element metadataCell, String rAttributeName) {
        if (metadataCell.attribute(rAttributeName) != null) {
            String rAttributeValue = metadataCell.attributeValue(rAttributeName);
            Element cellNameStringTableEntry = (Element)selectionContext.selectSingleNode("./*[local-name()='strings']/*[local-name()='s'][@*[local-name()='id']='" + rAttributeValue + "']");
            if (cellNameStringTableEntry != null) {
                return cellNameStringTableEntry.getText();
            }
        }
        return null;
    }

    public void load(Element selectionContext, Element scSelectedCell) {
        this.nodeDisplay = scSelectedCell.attributeValue("display");
        String rValue = scSelectedCell.attributeValue("rValue");
        Element useValueStringTableEntry = (Element)selectionContext.selectSingleNode("./*[local-name()='strings']/*[local-name()='s'][@*[local-name()='id']='" + rValue + "']");
        if (useValueStringTableEntry != null) {
            this.nodeUse = useValueStringTableEntry.getText();
        }
        String rMetadataCell = scSelectedCell.attributeValue("rMetadataCell");
        Element metadataCell = (Element)selectionContext.selectSingleNode("./*[local-name()='metadataCells']/*[local-name()='metadataCell'][@*[local-name()='id']='" + rMetadataCell + "']");
        if (metadataCell != null) {
            this.nodeName = this.readMetadataRef(selectionContext, metadataCell, "rName");
            String cellQueryName = this.readMetadataRef(selectionContext, metadataCell, "rQueryName");
            if (cellQueryName != null) {
                this.queryName = cellQueryName;
            }
            this.nodeType = this.readMetadataRef(selectionContext, metadataCell, "rType");
            this.nodeUsage = this.readMetadataRef(selectionContext, metadataCell, "rUsage");
            this.nodeHierarchyUniqueName = this.readMetadataRef(selectionContext, metadataCell, "rHierarchyUniqueName");
            this.nodeDimensionUniqueName = this.readMetadataRef(selectionContext, metadataCell, "rDimensionUniqueName");
        }
        this.loadDefiningCells(selectionContext, scSelectedCell);
    }

    private void loadDefiningCells(Element selectionContext, Element cell) {
        Element definingCellsElement = (Element)cell.selectSingleNode("./*[local-name()='definingCells']");
        if (definingCellsElement != null) {
            List axisCells = definingCellsElement.selectNodes("./*[local-name()='axis']");
            for (int i = 0; i < axisCells.size(); ++i) {
                Element axisElement = (Element)axisCells.get(i);
                String cellId = axisElement.attributeValue("rCell");
                Element axisCellElement = (Element)selectionContext.selectSingleNode("./*[local-name()='cells']/*[local-name()='cell'][@*[local-name()='id']='" + cellId + "']");
                SelectedCell axisCell = new SelectedCell();
                axisCell.queryName = this.queryName;
                axisCell.load(selectionContext, axisCellElement);
                this.definingCells.add(axisCell);
            }
        }
    }

    public void load(Element selectedCell) {
        List cellAttrNodes = selectedCell.elements();
        for (Element cellAttrNode : cellAttrNodes) {
            if ("name".equals(cellAttrNode.getName())) {
                this.nodeName = cellAttrNode.getText();
                continue;
            }
            if ("display".equals(cellAttrNode.getName())) {
                this.nodeDisplay = cellAttrNode.getText();
                continue;
            }
            try {
                Field selectedCellField = SelectedCell.class.getField(cellAttrNode.getName());
                selectedCellField.set(this, cellAttrNode.getText());
            }
            catch (Exception e) {
                RAPLogger.info("RAP_INT: unsupported selected cell field: " + cellAttrNode.getText() + e.getMessage(), SelectedCell.class);
            }
        }
    }

    public boolean isMemberUniqueName() {
        return memberUniqueName.equals(this.nodeType);
    }

    public boolean isMeasure() {
        return measure.equals(this.nodeUsage);
    }

    public boolean isRelationalNumericType() {
        if (this.isMeasure()) {
            return true;
        }
        if (this.nodeType == null) {
            return false;
        }
        try {
            return CCLDbTypesInfo.isKnownNumericType(Integer.valueOf(this.nodeType));
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public boolean isOLAPMeasure() {
        return this.isMeasure() && this.isMemberUniqueName();
    }

    public boolean isUnsupportedType() {
        try {
            return CCLDbTypesInfo.isUnsupportedType(Integer.valueOf(this.nodeType));
        }
        catch (NumberFormatException n) {
            return true;
        }
    }

    public boolean isStringType() {
        try {
            return CCLDbTypesInfo.isStringType(Integer.valueOf(this.nodeType));
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public boolean isDateType() {
        try {
            int nodeDateType = Integer.getInteger(this.nodeType);
            return CCLDbTypesInfo.isKnownDateType(nodeDateType);
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public SelectedCell findDefiningCell(String definingCellName) {
        for (SelectedCell definingCell : this.definingCells) {
            if (!definingCell.nodeName.equals(definingCellName)) continue;
            return definingCell;
        }
        return null;
    }

    public void changeSelectedCellQueryName(String newQueryName) {
        this.queryName = newQueryName;
        for (SelectedCell definingCell : this.definingCells) {
            definingCell.changeSelectedCellQueryName(newQueryName);
        }
    }
}

