/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.ISelectionManager;
import com.cognos.rap.actions.SelectedCell;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class SelectionContextManager
implements ISelectionManager {
    public static final String ARG_SELECTED_CELL_TAGS = "selectedCellTags";
    public static final String TAG = "tag";
    public static final String TAG_VALUE = "tagValue";
    public static final String DATA_ITEM = "dataItem";

    @Override
    public ArrayList<SelectedCell> loadSelectedCells(Element selectionContext) {
        ArrayList<SelectedCell> selectedCells = this.loadSelectionContext(selectionContext);
        if (selectionContext != null && selectionContext.getParent() != null) {
            this.loadLayoutTags(selectedCells, selectionContext.getParent().element(ARG_SELECTED_CELL_TAGS));
        }
        return selectedCells;
    }

    private ArrayList<SelectedCell> loadSelectionContext(Element selectionContext) {
        ArrayList<SelectedCell> selectedCells;
        block4: {
            selectedCells = new ArrayList<SelectedCell>();
            if (selectionContext == null) break block4;
            SelectedCell result = null;
            String rSelectedCells = selectionContext.attributeValue("rSelectedCells");
            if (rSelectedCells != null) {
                String[] sIDs = rSelectedCells.split(" ");
                for (int i = 0; i < sIDs.length; ++i) {
                    Element scSelectedCell = (Element)selectionContext.selectSingleNode("./*[local-name()='cells']/*[@*[local-name()='id']='" + sIDs[i] + "']");
                    if (scSelectedCell == null) continue;
                    result = new SelectedCell();
                    result.load(selectionContext, scSelectedCell);
                    selectedCells.add(result);
                }
            } else {
                List selectedCellNodeList = selectionContext.elements("selectedCell");
                for (Element selectedCellNode : selectedCellNodeList) {
                    result = new SelectedCell();
                    result.load(selectedCellNode);
                    selectedCells.add(result);
                }
            }
        }
        return selectedCells;
    }

    private void loadLayoutTags(ArrayList<SelectedCell> selectedCells, Element layoutTags) {
        if (layoutTags == null) {
            return;
        }
        List tags = layoutTags.elements(TAG);
        for (int i = 0; i < tags.size(); ++i) {
            String tagValue = ((Element)tags.get(i)).element(TAG_VALUE).getText();
            String dataItem = ((Element)tags.get(i)).element(DATA_ITEM).getText();
            if (tagValue == null || tagValue.length() == 0) continue;
            if (dataItem == null || dataItem.length() == 0) {
                if (selectedCells.size() < tags.size()) {
                    SelectedCell taggedCell = new SelectedCell();
                    taggedCell.rapLayoutTag = tagValue;
                    selectedCells.add(i, taggedCell);
                    continue;
                }
                this.tagSelectedCellWithNoDataItem(selectedCells, tagValue);
                continue;
            }
            selectedCells.get((int)i).rapLayoutTag = tagValue;
        }
    }

    private void tagSelectedCellWithNoDataItem(ArrayList<SelectedCell> selectedCells, String tagValue) {
        for (SelectedCell selectedCell : selectedCells) {
            if (selectedCell.nodeName != null && selectedCell.nodeName.length() != 0 || selectedCell.rapLayoutTag != null) continue;
            selectedCell.rapLayoutTag = tagValue;
            break;
        }
    }
}

