/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions;

import com.cognos.rap.actions.SortReference;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;

public class SortInfo {
    protected String _sortItem = null;
    protected String _sortLabel = null;
    public boolean _setSorting = false;
    public boolean _sortByItems = false;
    private boolean _isList = false;
    private boolean _ascending = true;
    protected ArrayList<SortReference> _sortReferences = null;

    public SortInfo(String item, boolean setSorting, boolean isList) {
        this._sortItem = item;
        this._setSorting = setSorting;
        this._isList = isList;
    }

    public void setLabel(String label) {
        this._sortLabel = label;
    }

    public void setDescending() {
        this._ascending = false;
    }

    public void setSortByItems() {
        this._sortByItems = true;
    }

    public void addSortByValue(String item, boolean ascending, boolean isDataItemName) {
        if (this._sortReferences == null) {
            this._sortReferences = new ArrayList();
        }
        SortReference newSortRef = new SortReference(item, ascending, isDataItemName);
        this._sortReferences.add(newSortRef);
    }

    public void addSortByItem(String item, boolean ascending) {
        if (this._sortReferences == null) {
            this._sortReferences = new ArrayList();
        }
        SortReference newSortRef = new SortReference(item, ascending, true);
        this._sortReferences.add(newSortRef);
    }

    public ArrayList<SortReference> getSortReferences() {
        return this._sortReferences;
    }

    public JSONObject createJSON() {
        JSONObject SortInfoJSON = new JSONObject();
        if (this._sortReferences == null) {
            if (this._isList) {
                SortInfoJSON.put((Object)"valuesOf", (Object)this._sortItem);
            } else {
                SortInfoJSON.put((Object)"labels", (Object)this._sortItem);
            }
        } else {
            JSONArray SortRefArray = new JSONArray();
            for (SortReference sortRef : this._sortReferences) {
                SortRefArray.add((Object)sortRef.createJSON());
            }
            if (this._sortByItems) {
                if (this._isList) {
                    SortInfoJSON.put((Object)"valuesOf", (Object)this._sortItem);
                } else {
                    SortInfoJSON.put((Object)"labels", (Object)this._sortItem);
                }
                SortInfoJSON.put((Object)"byItems", (Object)SortRefArray);
            } else {
                SortInfoJSON.put((Object)"valuesOf", (Object)SortRefArray);
            }
        }
        if (this._ascending) {
            SortInfoJSON.put((Object)"order", (Object)"ascending");
        } else {
            SortInfoJSON.put((Object)"order", (Object)"descending");
        }
        if (this._sortLabel != null && !this._sortLabel.equals(this._sortItem)) {
            SortInfoJSON.put((Object)"itemLabel", (Object)this._sortLabel);
        }
        if (this._setSorting) {
            SortInfoJSON.put((Object)"setSorting", (Object)Boolean.TRUE);
        }
        return SortInfoJSON;
    }

    public static class ReportInfoJSON {
        public static final String valuesOf = "valuesOf";
        public static final String byItems = "byItems";
        public static final String labels = "labels";
        public static final String itemLabel = "itemLabel";
        public static final String order = "order";
        public static final String setSorting = "setSorting";
        public static final String descending = "descending";
        public static final String ascending = "ascending";
    }
}

