/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.mahelpers;

import com.cognos.rap.actions.mahelpers.MetaDataRequestBuilder;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.XMLUtility;
import org.dom4j.Element;

public class MAMemberParentInfoRequest
extends MetaDataRequestBuilder {
    private String startAt;
    private int level;
    private RapServiceRequestManager rapServiceRequestManager;

    public MAMemberParentInfoRequest(RapServiceRequestManager inRapServiceRequestManager, int inLevel, String inStartAt) {
        this.startAt = inStartAt;
        this.level = inLevel;
        this.rapServiceRequestManager = inRapServiceRequestManager;
    }

    public MemberInfo requestMemberInfo() throws CognosServiceRequestException {
        if (this.isParametersNull()) {
            return new MemberInfo("", "");
        }
        String modelPath = this.rapServiceRequestManager.getActionEnv().getRAPReport().getModelPath();
        String local = this.rapServiceRequestManager.getActionEnv().getLocale();
        String caption = "";
        String mun = this.startAt;
        for (int i = 1; i <= this.level; ++i) {
            Element result;
            String request = this.buildMetaDataRequestWithPath(XMLUtility.xmlencode(modelPath), XMLUtility.xmlencode(mun), 1, local, 1, MetaDataRequestBuilder.getPropertyMemberparentSimple());
            if (this.rapServiceRequestManager.getActionEnv() != null) {
                this.rapServiceRequestManager.getActionEnv().addEventTiming("MAMemberParentInfoRequest: level: " + i + this.startAt, "2");
            }
            if ((result = this.rapServiceRequestManager.executeMAQuery(request, null)) == null) {
                mun = "";
                break;
            }
            mun = this.getParentPun(result);
            if (mun == null) {
                mun = "";
                break;
            }
            if (i != this.level) continue;
            request = this.buildMetaDataRequestWithPath(XMLUtility.xmlencode(modelPath), XMLUtility.xmlencode(mun), 1, local, 1, MetaDataRequestBuilder.getPropertyCaptionSimple());
            if (this.rapServiceRequestManager.getActionEnv() != null) {
                this.rapServiceRequestManager.getActionEnv().addEventTiming("MAMemberParentInfoRequest: Caption: level: " + i + this.startAt, "2");
            }
            if ((caption = this.getParentPunCaption(result = this.rapServiceRequestManager.executeMAQuery(request, null))) != null) continue;
            mun = "";
        }
        MemberInfo memberInfo = new MemberInfo(mun, caption);
        return memberInfo;
    }

    private String getParentPun(Element result) {
        if (result == null) {
            return null;
        }
        Element rowElement = (Element)result.selectSingleNode(".//*[local-name()='member']");
        if (rowElement == null) {
            return null;
        }
        String pun = rowElement.attributeValue("parentUniqueName");
        return pun;
    }

    private String getParentPunCaption(Element result) {
        if (result == null) {
            return null;
        }
        Element rowElement = (Element)result.selectSingleNode(".//*[local-name()='member']");
        if (rowElement == null) {
            return null;
        }
        String memberCaption = rowElement.attributeValue("memberCaption");
        return memberCaption;
    }

    private boolean isParametersNull() {
        return this.rapServiceRequestManager == null || this.rapServiceRequestManager.getActionEnv() == null || this.rapServiceRequestManager.getActionEnv().getLocale() == null || this.rapServiceRequestManager.getActionEnv().getRAPReport() == null || this.rapServiceRequestManager.getActionEnv().getRAPReport().getModelPath() == null || this.startAt == null;
    }
}

