/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SelectionContextManager;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Style;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPCommand;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class Calculation
extends BaseAction {
    protected String calculationOperator = null;
    protected V5Query m_v5query = null;
    static final String dataItemMeasureSetCalculation = "dataItemMeasureSetCalculation";

    CalculationData buildCalculation(ArrayList selectedCells) throws ActionException {
        CalculationData returnCalculation = null;
        if (selectedCells.size() >= 2 && this.calculationOperator != null) {
            ListIterator iterator = selectedCells.listIterator();
            returnCalculation = new CalculationData();
            while (iterator.hasNext()) {
                SelectedCell selectedCell = (SelectedCell)iterator.next();
                returnCalculation.name = returnCalculation.name + this.getOperandLabel(selectedCell);
                returnCalculation.expression = returnCalculation.expression + this.processOperand(returnCalculation, selectedCell);
                if (!iterator.hasNext()) continue;
                returnCalculation.name = returnCalculation.name + " " + this.calculationOperator + " ";
                returnCalculation.expression = returnCalculation.expression + " " + this.calculationOperator + " ";
            }
        }
        return returnCalculation;
    }

    CalculationData buildConstantCalculation(SelectedCell selectedCell, String constantValue) throws ActionException {
        CalculationData returnCalculation = null;
        returnCalculation = new CalculationData();
        returnCalculation.name = this.getOperandLabel(selectedCell);
        returnCalculation.name = returnCalculation.name + " " + this.calculationOperator + " ";
        returnCalculation.name = returnCalculation.name + constantValue;
        returnCalculation.expression = this.processOperand(returnCalculation, selectedCell);
        returnCalculation.expression = returnCalculation.expression + " " + this.calculationOperator + " " + constantValue;
        return returnCalculation;
    }

    CalculationData buildConstantFirstCalculation(SelectedCell selectedCell, String constantValue) throws ActionException {
        CalculationData returnCalculation = null;
        returnCalculation = new CalculationData();
        returnCalculation.name = constantValue;
        returnCalculation.name = returnCalculation.name + " " + this.calculationOperator + " ";
        returnCalculation.name = returnCalculation.name + this.getOperandLabel(selectedCell);
        returnCalculation.expression = constantValue;
        returnCalculation.expression = returnCalculation.expression + " " + this.calculationOperator + " " + this.processOperand(returnCalculation, selectedCell);
        return returnCalculation;
    }

    public void addCalculationToSpec(Document reportToModify, Element actionArgs, String dataFormat) throws ActionException {
        SelectionContextManager selMgr = new SelectionContextManager();
        ArrayList<SelectedCell> selectedCells = selMgr.loadSelectedCells(actionArgs.element("selection"));
        String constantValue = this.getArgument(actionArgs, "constant");
        if (selectedCells.size() > 0) {
            this.m_v5query = new V5Query(reportToModify.getRootElement(), selectedCells.get((int)0).queryName);
            CalculationData calculationData = null;
            calculationData = constantValue != null ? (this.getArgument(actionArgs, "constantFirst") != null ? this.buildConstantFirstCalculation(selectedCells.get(0), constantValue) : this.buildConstantCalculation(selectedCells.get(0), constantValue)) : this.buildCalculation(selectedCells);
            if (calculationData != null) {
                if (this.getArgument(actionArgs, "columnName") != null) {
                    calculationData.name = this.getArgument(actionArgs, "columnName");
                }
                String queryName = selectedCells.get((int)0).queryName;
                calculationData.dataFormat = dataFormat;
                calculationData.locale = this.getLocale();
                SelectedCell lastSelectedCell = selectedCells.get(selectedCells.size() - 1);
                this.insertCalculationElements(reportToModify, queryName, calculationData, this.getArgument(actionArgs, "id"), lastSelectedCell.nodeName);
            }
        }
    }

    public void addCalculationToSpec(Document reportToModify, Element actionArgs) throws ActionException {
        this.addCalculationToSpec(reportToModify, actionArgs, null);
    }

    protected String processOperand(CalculationData calcData, SelectedCell cell) throws ActionException {
        if (!"dataItem".equals(calcData.tag)) {
            boolean prevParamIsDataItemMeasureSetCalculation;
            boolean prevParamIsDataItemCalculatedMember = "dataItemCalculatedMember".equals(calcData.tag) || calcData.tag == null;
            boolean prevParamIsDataItemCalculatedMeasure = "dataItemCalculatedMeasure".equals(calcData.tag) || calcData.tag == null;
            boolean bl = prevParamIsDataItemMeasureSetCalculation = dataItemMeasureSetCalculation.equals(calcData.tag) && calcData.tag != null;
            if (prevParamIsDataItemCalculatedMember && this.operandIsMember(cell)) {
                calcData.tag = "dataItemCalculatedMember";
                calcData.hun = cell.nodeHierarchyUniqueName;
                calcData.dun = cell.nodeDimensionUniqueName;
                return cell.nodeUse;
            }
            if (prevParamIsDataItemCalculatedMember && this.operandIsCalculatedMemberRef(cell)) {
                calcData.tag = "dataItemCalculatedMember";
                calcData.hun = cell.nodeHierarchyUniqueName;
                calcData.dun = cell.nodeDimensionUniqueName;
            } else {
                if (this.operandIsMeasureSet(cell)) {
                    calcData.tag = dataItemMeasureSetCalculation;
                    calcData.hun = cell.nodeHierarchyUniqueName;
                    calcData.dun = cell.nodeDimensionUniqueName;
                    return cell.nodeUse;
                }
                if (this.operandIsMeasure(cell) && !prevParamIsDataItemMeasureSetCalculation) {
                    calcData.tag = "dataItemCalculatedMeasure";
                    calcData.dun = cell.nodeDimensionUniqueName != null ? cell.nodeDimensionUniqueName : cell.nodeHierarchyUniqueName;
                } else {
                    calcData.tag = prevParamIsDataItemCalculatedMeasure && this.operandIsCalculatedMeasureRef(cell) ? "dataItemCalculatedMeasure" : (prevParamIsDataItemMeasureSetCalculation ? dataItemMeasureSetCalculation : "dataItem");
                }
            }
        }
        return "[" + cell.nodeName + "]";
    }

    private boolean operandIsMember(SelectedCell cell) {
        return cell.isMemberUniqueName() && !cell.isMeasure();
    }

    public boolean operandIsMeasureSet(SelectedCell cell) throws ActionException {
        return V5SpecHelper.isMeasureSetItem(cell.isMeasure(), false, cell.nodeName, this.m_v5query, this.getEnv());
    }

    private boolean operandIsCalculatedMemberRef(SelectedCell cell) {
        Element calculatedElement;
        return this.m_v5query != null && (calculatedElement = this.m_v5query.findItem(cell.nodeName)) != null && "dataItemCalculatedMember".equals(calculatedElement.getName());
    }

    private boolean operandIsMeasure(SelectedCell cell) {
        return cell.isMeasure() && (cell.nodeDimensionUniqueName != null || cell.nodeHierarchyUniqueName != null);
    }

    private boolean operandIsCalculatedMeasureRef(SelectedCell cell) {
        Element calculatedElement;
        return this.m_v5query != null && (calculatedElement = this.m_v5query.findItem(cell.nodeName)) != null && "dataItemCalculatedMeasure".equals(calculatedElement.getName());
    }

    protected String getOperandLabel(SelectedCell cell) throws ActionException {
        if (this.operandIsMember(cell)) {
            return cell.nodeDisplay;
        }
        if (this.operandIsMeasureSet(cell)) {
            return cell.nodeDisplay;
        }
        return cell.nodeName;
    }

    protected String getArgument(Element actionArgs, String sArgName) {
        Element argElement = actionArgs.element(sArgName);
        if (argElement != null) {
            return argElement.getText();
        }
        return null;
    }

    public void insertCalculationElements(Document reportToModify, String queryName, CalculationData calcData, String layoutID, String layoutInsertionPoint) throws ActionException {
        Element eReport = reportToModify.getRootElement();
        V5Query v5Query = new V5Query();
        if (eReport != null && v5Query.focusQuery(eReport, queryName)) {
            if (dataItemMeasureSetCalculation.equals(calcData.tag)) {
                calcData.tag = "dataItem";
            }
            Element newDI = v5Query.getItemList().addCalculation(calcData.tag, calcData.name, calcData.expression, calcData.dun, calcData.hun);
            String itemNameAdded = newDI.attributeValue("name");
            if (layoutID != null && layoutInsertionPoint != null) {
                Element dataContainer = V5X.selectSingleNode(reportToModify.getRootElement(), "layout", "//V5X//ANYCHILD", "//V5X//ATTR", "name", layoutID);
                V5Style v5Style = new V5Style();
                V5DataContainer container = null;
                if (dataContainer.getName().equals("crosstab")) {
                    V5Crosstab v5Crosstab = new V5Crosstab(dataContainer);
                    Element calculationMember = v5Crosstab.insertNodeAfter(layoutInsertionPoint, itemNameAdded);
                    if (calculationMember != null) {
                        this.removeClonedHistory(calculationMember);
                        Element sortList = calculationMember.element("sortList");
                        if (sortList != null) {
                            sortList.detach();
                        }
                        v5Style.setDefaultStyle(calculationMember, "cl");
                        Element factCellStyleElement = v5Style.addFactCellStyle(calculationMember, "cv");
                        v5Style.setDataFormat(factCellStyleElement, calcData.dataFormat);
                        v5Crosstab.updateIntersectionDataFormats(calculationMember, calcData.dataFormat);
                    }
                    container = v5Crosstab;
                } else if (dataContainer.getName().equals(RAPCommand.list)) {
                    V5List v5List = new V5List(dataContainer);
                    Element calculationColumn = v5List.insertColumnAfter(layoutInsertionPoint, itemNameAdded);
                    this.removeClonedHistory(calculationColumn);
                    v5Style.setDefaultStyle(calculationColumn.element("listColumnTitle"), "cl");
                    Element bodyStyleElement = v5Style.setDefaultStyle(calculationColumn.element("listColumnBody"), "cv");
                    v5Style.setDataFormat(bodyStyleElement, calcData.dataFormat);
                    container = v5List;
                }
                this.updateCalculationLabel(container, itemNameAdded, calcData);
            }
        }
    }

    private void updateCalculationLabel(V5DataContainer container, String itemNameAdded, CalculationData calcData) {
        V5SpecHelper.resetCustomizedLabels(container, itemNameAdded, "locale");
        if (!itemNameAdded.equals(calcData.name)) {
            V5Variables variables = new V5Variables(container.getContainerElement().getDocument().getRootElement());
            Element eLocale = variables.addLocaleVariable("locale");
            variables.addVariableValue(eLocale, calcData.locale);
            V5Style style = new V5Style();
            Element cdsParent = container.findItemLabelByRDI(itemNameAdded);
            if (cdsParent != null) {
                style.setConditionalText(cdsParent, "locale", calcData.locale, calcData.name);
            }
        }
    }

    private void removeClonedHistory(Element clonedElement) {
        this.removeClonedRenameHistory(clonedElement);
    }

    public void removeClonedRenameHistory(Element clonedElement) {
        List xmlAttributes;
        List xmlAttributeList = XMLUtility.selectNodes(clonedElement, ".//*[local-name()='XMLAttribute'][starts-with(@name, 'rp_originalName_')]");
        Element parentNode = null;
        for (Element element : xmlAttributeList) {
            if (parentNode == null) {
                parentNode = element.getParent();
            }
            element.detach();
        }
        if (parentNode != null && (xmlAttributes = parentNode.elements()).size() == 0) {
            parentNode.detach();
        }
    }

    public class CalculationData {
        public static final String defaultStyle = "cl";
        public static final String defaultFactCellStyle = "cv";
        public String dataFormat = null;
        public String tag = null;
        public String name = "";
        public String expression = "";
        public String locale = "";
        public String hun = null;
        public String dun = null;
    }
}

