/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5VizChart;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import javax.swing.text.html.CSS;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ChangeDataContainerSize
extends BaseAction {
    private static final String STYLE_CSS = "style/CSS";
    public static final String ARG_WIDTH = "width";
    public static final String ARG_HEIGHT = "height";

    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        super.apply(reportToModify, actionArgs);
        String height = this.getActionArguments().getArgument(ARG_HEIGHT);
        String width = this.getActionArguments().getArgument(ARG_WIDTH);
        String idSelectAll = this.getActionArguments().getArgument("idSelectAll");
        if (idSelectAll != null) {
            Element reportPages = V5X.selectSingleNode(reportToModify, "layouts", "layout", "reportPages");
            ArrayList<V5DataContainer> containers = V5DataContainerFactory.createChildContainers(reportPages);
            for (V5DataContainer container : containers) {
                if (!(container instanceof V5Chart) || !container.getID().startsWith(idSelectAll)) continue;
                this.setDataContainerSize(container, width, height);
            }
        } else {
            V5DataContainer dataContainer = V5DataContainerFactory.create(reportToModify.getRootElement(), this.getActionArguments().getArgument("id"));
            if (dataContainer == null) {
                dataContainer = V5SpecHelper.getDefaultDataContainer(reportToModify);
            }
            if (dataContainer == null) {
                return;
            }
            this.setDataContainerSize(dataContainer, width, height);
        }
    }

    private void setDataContainerSize(V5DataContainer dataContainer, String width, String height) {
        if (dataContainer instanceof V5VizChart) {
            ((V5VizChart)dataContainer).setSize(width, height);
        } else {
            Element cssElement = DocumentHelper.makeElement((Branch)dataContainer.getContainerElement(), (String)STYLE_CSS);
            if (width == null) {
                this.resetDataContainerSize(cssElement);
            } else {
                this.setDataContainerSize(cssElement, width, height);
            }
        }
    }

    private void resetDataContainerSize(Element cssElement) {
        String oldValue = cssElement.attributeValue("value");
        if (oldValue == null) {
            return;
        }
        String newValue = V5SpecHelper.stripCSSAttribute(oldValue, CSS.Attribute.WIDTH.toString());
        newValue = V5SpecHelper.stripCSSAttribute(newValue, CSS.Attribute.HEIGHT.toString());
        cssElement.addAttribute("value", newValue);
    }

    private void setDataContainerSize(Element cssElement, String width, String height) {
        String oldValue = cssElement.attributeValue("value");
        String newValue = V5SpecHelper.setCSSValue(oldValue, CSS.Attribute.WIDTH.toString(), width);
        newValue = V5SpecHelper.setCSSValue(newValue, CSS.Attribute.HEIGHT.toString(), height);
        cssElement.addAttribute("value", newValue);
    }
}

