/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.DataContainerInfo;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayPrimaryLayout;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeRulesProcessor;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.viscoachhelpers.RecommenderInfo;
import com.cognos.rap.actions.viscoachhelpers.SmartMetaDataProcessor;
import com.cognos.rap.actions.viscoachhelpers.VisCoachParameterRegistrationHandler;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.aurora.v5viscoach.V5InputManager;
import com.ibm.aurora.v5viscoach.V5OutputManager;
import com.ibm.aurora.v5viscoach.V5VisCoach;
import com.ibm.aurora.visCoach.core.IVariationsInitializationHandle;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.output.OutputManager;
import com.ibm.aurora.visCoach.core.output.variationMatchRec;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class ChangeDataContainerVisCoach
extends BaseAction {
    private static final String ARGUMENT_TARGET = "target";
    private static final String CONTAINER_TYPE_CHART = "Chart";
    private static final String CONTAINER_TYPE_CROSSTAB = "Crosstab";
    private static final String CONTAINER_TYPE_LIST = "List";
    private static final String CONTAINER_TYPE_VIZ = "viz";
    protected ActionEnv m_env = null;
    protected SmartMetaDataProcessor m_smdProcessor = null;
    private static V5VisCoach m_cachedV5VisCoach = null;
    protected static boolean m_debugEnabled = true;

    public ChangeDataContainerVisCoach(ActionEnv env) {
        this.m_env = env;
        this.m_smdProcessor = new SmartMetaDataProcessor(m_debugEnabled);
    }

    public void updateContainer(Document reportDoc, V5DataContainer selectedDataContainer, Element actionArgs) {
        if (this.m_env.getViscoachMode() != 1) {
            return;
        }
        try {
            VisCoachInitializationInfo v5VisCoachInfo = this.setupVisCoach(reportDoc, selectedDataContainer, actionArgs);
            String resolvedTemplate = null;
            String templateID = actionArgs.elementText("templateId");
            String variationID = actionArgs.elementText("variationId");
            if (templateID == null && variationID == null) {
                resolvedTemplate = v5VisCoachInfo.v5VisCoach.getBestResolvedVariation(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, this.m_env.getProductLocale());
            } else if (variationID.equals("")) {
                List variations = v5VisCoachInfo.v5VisCoach.getTemplateVariations(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, templateID, this.m_env.getProductLocale());
                if (!variations.isEmpty()) {
                    resolvedTemplate = v5VisCoachInfo.v5VisCoach.resolveTemplate(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, templateID, ((variationMatchRec)variations.get((int)0)).variationId);
                }
            } else {
                resolvedTemplate = v5VisCoachInfo.v5VisCoach.resolveTemplate(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, templateID, variationID);
            }
            resolvedTemplate = this.runPostProcessor(selectedDataContainer, resolvedTemplate);
            this.replaceDocument(reportDoc, resolvedTemplate);
        }
        catch (Exception ex) {
            RAPLogger.error(ex, ChangeDataContainerVisCoach.class);
        }
    }

    protected String runPostProcessor(V5DataContainer selectedDataContainer, String resolvedTemplate) throws DocumentException, ActionException {
        if (resolvedTemplate == null) {
            return null;
        }
        Document doc = DocumentHelper.parseText((String)resolvedTemplate);
        if (doc != null) {
            Element originalChart = selectedDataContainer.getContainerElement().createCopy();
            V5DataContainer dataContainer = V5DataContainerFactory.create(doc.getRootElement(), this.m_env.getActionArguments().getArgument("id"));
            if (dataContainer == null) {
                dataContainer = V5SpecHelper.getDefaultDataContainer(doc);
            }
            if (dataContainer == null || dataContainer.getContainerElement().getName().equals(CONTAINER_TYPE_VIZ)) {
                return resolvedTemplate;
            }
            Element newDataContainerElement = dataContainer.getContainerElement();
            ChangeDisplayTypeRulesProcessor rulesProcessor = new ChangeDisplayTypeRulesProcessor(this.m_env);
            rulesProcessor.applyChartConversionRules(originalChart, newDataContainerElement, true);
            ChangeDisplayTypeHelper.stripConversionRulesNodes(newDataContainerElement);
            String newContainerName = selectedDataContainer.getContainerElement().attributeValue("name");
            Element target = this.m_env.getActionArguments().getActionArgs().element(ARGUMENT_TARGET);
            if (target == null) {
                target = this.m_env.getActionArguments().getActionArgs().addElement(ARGUMENT_TARGET);
                if (newContainerName.startsWith(CONTAINER_TYPE_LIST)) {
                    target.setText(CONTAINER_TYPE_LIST);
                } else if (newContainerName.startsWith(CONTAINER_TYPE_CROSSTAB)) {
                    target.setText(CONTAINER_TYPE_CROSSTAB);
                } else {
                    target.setText(CONTAINER_TYPE_CHART);
                }
            }
            ChangeDisplayTypeHelper.setDataContainerName(newDataContainerElement, newContainerName, this.m_env.getActionArguments());
            ChangeDisplayPrimaryLayout primaryLayout = this.m_env.getChangeDisplayPrimaryLayout();
            if (primaryLayout != null && !primaryLayout.replace(newDataContainerElement)) {
                primaryLayout.save(newDataContainerElement);
            }
            resolvedTemplate = doc.asXML();
        }
        return resolvedTemplate;
    }

    protected void replaceDocument(Document originalDocument, String newDocumentAsString) {
        if (newDocumentAsString == null) {
            return;
        }
        Document newDoc = null;
        try {
            newDoc = DocumentHelper.parseText((String)newDocumentAsString);
        }
        catch (DocumentException e1) {
            RAPLogger.error(e1, ChangeDataContainerVisCoach.class);
        }
        originalDocument.remove(originalDocument.getRootElement());
        originalDocument.add((Node)newDoc.getRootElement().clone());
    }

    public void updateRecommendedDisplayTypes(RAPReport rapReport, DataContainerInfo containerInfo, V5DataContainer container, Element actionArgs) {
        if (this.m_env.getViscoachMode() != 1) {
            return;
        }
        try {
            VisCoachInitializationInfo v5VisCoachInfo = this.setupVisCoach(rapReport.getDOM(), container, actionArgs);
            RecommenderInfo recInfo = new RecommenderInfo(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, v5VisCoachInfo.v5VisCoach, actionArgs, this.m_env.getProductLocale());
            containerInfo.setRecommendedDisplayTypes(recInfo.generateJSONDisplayTypes());
        }
        catch (Exception ex) {
            RAPLogger.error(ex, ChangeDataContainerVisCoach.class);
        }
    }

    public void updateRecommendedDisplayVariations(RAPReport rapReport, DataContainerInfo containerInfo, V5DataContainer container, Element actionArgs) {
        if (this.m_env.getViscoachMode() != 1) {
            return;
        }
        try {
            VisCoachInitializationInfo v5VisCoachInfo = this.setupVisCoach(rapReport.getDOM(), container, actionArgs);
            RecommenderInfo recInfo = new RecommenderInfo(v5VisCoachInfo.handle, (OutputManager)v5VisCoachInfo.outputManager, v5VisCoachInfo.v5VisCoach, actionArgs, this.m_env.getProductLocale());
            containerInfo.setRecommendedDisplayVariations(recInfo.generateJSONDisplayVariations());
        }
        catch (Exception ex) {
            RAPLogger.error(ex, ChangeDataContainerVisCoach.class);
        }
    }

    private VisCoachInitializationInfo setupVisCoach(Document reportSpec, V5DataContainer container, Element actionArgs) throws Exception {
        VisCoachInitializationInfo initInfo = new VisCoachInitializationInfo();
        ArrayList<String> inputs = new ArrayList<String>();
        inputs.add(reportSpec.asXML());
        container.prepareForVisCoach(this.m_env);
        inputs.add(container.getContainerElement().asXML());
        String smdModel = this.m_smdProcessor.run(container, this.m_env);
        inputs.add(smdModel);
        initInfo.inputManager = new V5InputManager(inputs, container.getID());
        initInfo.outputManager = new V5OutputManager(initInfo.inputManager);
        initInfo.outputManager.setLocale(this.m_env.getProductLocale());
        if (m_cachedV5VisCoach == null) {
            m_cachedV5VisCoach = new V5VisCoach(V5VisCoach.createXPathRulesManager(null));
            new VisCoachParameterRegistrationHandler().register(m_cachedV5VisCoach.getParameterFactory());
        }
        initInfo.v5VisCoach = m_cachedV5VisCoach;
        initInfo.handle = initInfo.v5VisCoach.initializeFromInput((InputManager)initInfo.inputManager);
        return initInfo;
    }

    private class VisCoachInitializationInfo {
        public IVariationsInitializationHandle handle;
        public V5InputManager inputManager;
        public V5OutputManager outputManager;
        public V5VisCoach v5VisCoach;
    }
}

