/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DataContainerInfo;
import com.cognos.rap.actions.v5actionset.ChangeDataContainerVisCoach;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.viscoachhelpers.RecommenderInfoV2;
import com.cognos.rap.actions.viscoachhelpers.ViewerRAREProviderFactory;
import com.cognos.rap.actions.viscoachhelpers.VisCoachLogger;
import com.cognos.rap.actions.viscoachhelpers.VisCoachModeUtil;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.IOutputManager;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IRAREProvider;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.RAREPerProviderSingletonFixture;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.vcv5lib.VCV5Lib;
import com.ibm.aurora.rare.vcv5lib.input.V5InputManager;
import com.ibm.aurora.rare.vcv5lib.output.V5OutputManager;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import java.util.HashSet;
import org.dom4j.Document;
import org.dom4j.Element;

public class ChangeDataContainerVisCoachV2
extends ChangeDataContainerVisCoach {
    private String m_cachedSpec;
    private String m_cachedContainerID;
    private IAssociativeModel m_cachedModel;
    private RAREInitializationInfo m_initInfo;
    private static IRARE m_rareObj;
    private static VisCoachLogger m_logger;

    public ChangeDataContainerVisCoachV2(ActionEnv env) {
        super(env);
        m_logger = new VisCoachLogger();
    }

    @Override
    public void updateContainer(Document reportDoc, V5DataContainer selectedDataContainer, Element actionArgs) {
        try {
            if (this.m_env.getViewerLogger() != null) {
                this.m_env.getViewerLogger().startTimedEvent("Other", "Time spent in VisCoach", "Other");
            }
            RAREInitializationInfo rareInitInfo = this.setupVisCoach(reportDoc, selectedDataContainer, actionArgs);
            String resolvedTemplate = null;
            String templateID = actionArgs.elementText("templateId");
            String variationID = actionArgs.elementText("variationId");
            if (templateID == null && variationID == null) {
                IClassificationEntry bestVisType = (IClassificationEntry)m_rareObj.getRanked(rareInitInfo.handle, "vistype", null, null, false).get(0);
                HashSet<String> defaultSet = new HashSet<String>();
                defaultSet.add("default");
                IClassificationEntry best = (IClassificationEntry)m_rareObj.getRanked(rareInitInfo.handle, "visualization", RecommenderInfoV2.getVisTypeMap(bestVisType), defaultSet, false).get(0);
                StringBuilder output = m_rareObj.resolve(rareInitInfo.handle, best);
                resolvedTemplate = output.toString();
            } else if (variationID.equals("")) {
                IClassificationEntry selectedGroup = m_rareObj.deserializeCLassificationEntry(templateID);
                StringBuilder output = m_rareObj.resolve(rareInitInfo.handle, selectedGroup);
                resolvedTemplate = output.toString();
            }
            if (m_debugEnabled) {
                this.m_smdProcessor.dump(resolvedTemplate, "v5VCoutput.xml");
                this.m_smdProcessor.dump(reportDoc.asXML(), "v5Vieweroutput.xml");
            }
            resolvedTemplate = this.runPostProcessor(selectedDataContainer, resolvedTemplate);
            if (this.m_env.getViewerLogger() != null) {
                this.m_env.getViewerLogger().endTimedEvent("Other");
                this.m_env.getViewerLogger().logXML(reportDoc.asXML(), "originalReport.xml", true, "visCoach");
                this.m_env.getViewerLogger().logXML(resolvedTemplate, "afterVisCoachReport.xml", false, "");
            }
            this.replaceDocument(reportDoc, resolvedTemplate);
        }
        catch (Exception ex) {
            if (this.m_env.getViewerLogger() != null) {
                this.m_env.getViewerLogger().endTimedEvent("Other");
            }
            RAPLogger.error(ex, ChangeDataContainerVisCoachV2.class);
        }
    }

    @Override
    public void updateRecommendedDisplayTypes(RAPReport rapReport, DataContainerInfo containerInfo, V5DataContainer container, Element actionArgs) {
        try {
            RAREInitializationInfo v5VisCoachInfo = this.setupVisCoach(rapReport.getDOM(), container, actionArgs);
            RecommenderInfoV2 recInfo = new RecommenderInfoV2(v5VisCoachInfo.handle, v5VisCoachInfo.outputManager, v5VisCoachInfo.vcV5Lib, actionArgs, this.m_env.getProductLocale(), this.m_env.getViscoachMode());
            containerInfo.setRecommendedDisplayTypes(recInfo.generateJSONDisplayTypes());
        }
        catch (Exception ex) {
            RAPLogger.error(ex, ChangeDataContainerVisCoachV2.class);
        }
    }

    @Override
    public void updateRecommendedDisplayVariations(RAPReport rapReport, DataContainerInfo containerInfo, V5DataContainer container, Element actionArgs) {
        try {
            RAREInitializationInfo v5VisCoachInfo = this.setupVisCoach(rapReport.getDOM(), container, actionArgs);
            RecommenderInfoV2 recInfo = new RecommenderInfoV2(v5VisCoachInfo.handle, v5VisCoachInfo.outputManager, v5VisCoachInfo.vcV5Lib, actionArgs, this.m_env.getProductLocale(), this.m_env.getViscoachMode());
            containerInfo.setRecommendedDisplayVariations(recInfo.generateJSONDisplayVariations());
        }
        catch (Exception ex) {
            RAPLogger.error(ex, ChangeDataContainerVisCoachV2.class);
        }
    }

    private RAREInitializationInfo setupVisCoach(Document reportSpec, V5DataContainer container, Element actionArgs) throws Exception {
        container.prepareForVisCoach(this.m_env);
        this.m_smdProcessor.run(container, this.m_env);
        IAssociativeModel smdModel = this.m_smdProcessor.getModel();
        if (reportSpec.asXML().equals(this.m_cachedSpec) && container.getID().equals(this.m_cachedContainerID) && this.m_cachedModel == smdModel) {
            return this.m_initInfo;
        }
        this.m_initInfo = new RAREInitializationInfo();
        this.m_initInfo.inputManager = new V5InputManager(smdModel, reportSpec.asXML(), container.getID(), (ILogger)m_logger);
        this.m_initInfo.outputManager = new V5OutputManager(this.m_initInfo.inputManager, this.m_env.getProductLocale(), (ILogger)m_logger);
        if (m_rareObj == null) {
            m_rareObj = RAREPerProviderSingletonFixture.getRare((IRAREProvider)ViewerRAREProviderFactory.getRAREProvider(VisCoachModeUtil.getVisCoachMode(this.m_env.getViscoachMode())), (ILogger)m_logger);
        }
        this.m_initInfo.handle = m_rareObj.initializeHandle((IInputManager)this.m_initInfo.inputManager, (IOutputManager)this.m_initInfo.outputManager);
        this.m_cachedSpec = reportSpec.asXML();
        this.m_cachedContainerID = container.getID();
        this.m_cachedModel = smdModel;
        return this.m_initInfo;
    }

    private class RAREInitializationInfo {
        public IVariationsInitializationHandle handle;
        public V5InputManager inputManager;
        public V5OutputManager outputManager;
        public VCV5Lib vcV5Lib;
    }
}

