/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SelectionContextManager;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5DrillUpDownWithBehaviors;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPConfigProperties;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class DrillDown
extends BaseAction {
    private DimensionalOperations dimensionalOperations = new DimensionalOperations(this);

    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        super.apply(reportToModify, actionArgs);
        if (!RAPConfigProperties.isBackwardsCompatibleDrillEnabled()) {
            this.dimensionalOperations.initializeNewDrillRules(true);
        }
        V5DataContainer dataContainer = V5DataContainerFactory.create(reportToModify.getRootElement(), this.getActionArguments().getArgument("id"));
        SelectionContextManager selMgr = new SelectionContextManager();
        ArrayList<SelectedCell> selectedCells = selMgr.loadSelectedCells(actionArgs.element("selection"));
        if ("resetDimension".equals(actionArgs.elementText("action"))) {
            HashSet<String> hunsToReset = null;
            Element huns = actionArgs.element("HUNS");
            if (huns != null && huns.elements("HUN") != null) {
                hunsToReset = new HashSet<String>();
                List hunElements = huns.elements("HUN");
                for (Element hunElement : hunElements) {
                    hunsToReset.add(hunElement.getText());
                }
            }
            this.doDrillReset(reportToModify, hunsToReset);
            return;
        }
        for (int i = 0; i < selectedCells.size(); ++i) {
            List<SelectedCell> cellsToDrill = DimensionalOperations.buildSelectedCellsToDrill(selectedCells.get(i), actionArgs.elementText("userSelectedDrillItem"), dataContainer);
            for (SelectedCell cellToDrill : cellsToDrill) {
                if (!DimensionalOperations.isDrillableMember(cellToDrill)) continue;
                V5DrillUpDownWithBehaviors drillUpDownHelper = new V5DrillUpDownWithBehaviors(this, reportToModify, cellToDrill);
                if (drillUpDownHelper.shouldUseAuthoredDrillBehaviors()) {
                    drillUpDownHelper.applyAuthoredDrillBehaviors("DrillDown");
                    continue;
                }
                if (RAPConfigProperties.isBackwardsCompatibleDrillEnabled()) {
                    drillUpDownHelper.revertToRegularSet();
                }
                this.drillDownWithoutBehaviours(reportToModify, cellToDrill);
            }
        }
    }

    private void doDrillReset(Document reportToModify, HashSet<String> hunsToReset) {
        List<Element> queryNodes = V5Query.getQueryNodes(reportToModify.getRootElement());
        if (queryNodes == null) {
            return;
        }
        for (Element queryNode : queryNodes) {
            this.drillResetItems(reportToModify, queryNode, hunsToReset);
            this.drillResetExpressions(queryNode, hunsToReset);
        }
    }

    private void drillResetItems(Document reportToModify, Element queryNode, HashSet<String> hunsToReset) {
        List resetNodes = V5X.selectNodes(queryNode, "//V5X//CHILD", "selection", "//V5X//ANY", "XMLAttribute", "//V5X//ATTR", "name", "RAP_DrillResetItem");
        if (resetNodes != null && resetNodes.size() > 0) {
            for (Element resetNode : resetNodes) {
                Element containingItem = resetNode.getParent().getParent();
                if (hunsToReset != null && !hunsToReset.contains(V5QueryItem.getHun(containingItem))) continue;
                List<Element> dataContainersToReset = V5SpecHelper.getLayoutComponentsByQuery(reportToModify.getRootElement(), queryNode.attributeValue("name"));
                String itemNameToReset = containingItem.attributeValue("name");
                for (Element dataContainerToReset : dataContainersToReset) {
                    V5DataContainer container = V5DataContainerFactory.create(dataContainerToReset);
                    List<Element> itemsWithRefDataItem = container.selectNodes("//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", itemNameToReset);
                    if (itemsWithRefDataItem == null) continue;
                    for (Element itemWithRefDataItem : itemsWithRefDataItem) {
                        if ("".equals(resetNode.attributeValue("value"))) {
                            if (!"crosstabNodeMember".equals(itemWithRefDataItem.getName())) continue;
                            ((V5Crosstab)container).deleteCrosstabNodeMember(itemWithRefDataItem);
                            continue;
                        }
                        itemWithRefDataItem.addAttribute("refDataItem", resetNode.attributeValue("value"));
                    }
                }
                V5SpecHelper.removeXMLAttribute(containingItem, "RAP_DrillResetItem");
            }
        }
    }

    private void drillResetExpressions(Element queryNode, HashSet<String> hunsToReset) {
        List resetExpressions = V5X.selectNodes(queryNode, "//V5X//CHILD", "selection", "//V5X//ANY", "XMLAttribute", "//V5X//ATTR", "name", "RAP_DrillResetExpression");
        if (resetExpressions != null && resetExpressions.size() > 0) {
            for (Element resetExpression : resetExpressions) {
                Element containingItem = resetExpression.getParent().getParent();
                String resetExpressionStr = resetExpression.attributeValue("value");
                Element expressionNode = containingItem.element("expression");
                if (expressionNode != null && resetExpressionStr != null) {
                    expressionNode.setText(resetExpressionStr);
                    V5SpecHelper.removeXMLAttribute(containingItem, "RAP_DrillResetExpression");
                }
                V5SpecHelper.removeXMLAttribute(containingItem, "RAP_HUN");
            }
        }
    }

    public void drillDownWithoutBehaviours(Document reportToModify, SelectedCell selectedCell) throws ActionException {
        Element matchingLinkedDrillItem = V5SpecHelper.getLinkedDrillItem(reportToModify, selectedCell.queryName, selectedCell.nodeName);
        if (matchingLinkedDrillItem == null) {
            this.drillDownWithoutBehavioursAllContainersOfSameQuery(reportToModify, selectedCell);
        } else {
            List linkedDrillItemElements = matchingLinkedDrillItem.getParent().elements();
            for (Element linkedDrillItem : linkedDrillItemElements) {
                selectedCell.nodeName = linkedDrillItem.attributeValue("refDataItem");
                selectedCell.queryName = linkedDrillItem.attributeValue("refQuery");
                selectedCell.nodeType = "memberUniqueName";
                V5DrillUpDownWithBehaviors drillUpDownHelper = new V5DrillUpDownWithBehaviors(this, reportToModify, selectedCell);
                if (drillUpDownHelper.shouldUseAuthoredDrillBehaviors()) {
                    drillUpDownHelper.drillOnMemberSet("DrillDown");
                    continue;
                }
                Collection<Element> createdDataItems = this.drillDownWithoutBehavioursAllContainersOfSameQuery(reportToModify, selectedCell);
                if (createdDataItems.isEmpty()) continue;
                String newDataItemName = createdDataItems.iterator().next().attributeValue("name");
                linkedDrillItem.addAttribute("refDataItem", newDataItemName);
            }
        }
    }

    public Collection<Element> drillDownWithoutBehavioursAllContainersOfSameQuery(Document reportToModify, SelectedCell selectedCell) throws ActionException {
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(reportToModify, selectedCell.queryName);
        ArrayList<Element> allCreatedDataItems = new ArrayList<Element>();
        boolean bIsDrillOnInitialXtabOrChartContainer = true;
        while (containerInDomainIter.hasNext()) {
            Element nodeToDrillOn;
            V5DataContainer dataContainer = containerInDomainIter.next();
            if (dataContainer == null || dataContainer.getContainerElement().getDocument() == null) continue;
            V5Query query = dataContainer.getV5Query();
            selectedCell.nodeHierarchyUniqueName = DimensionalOperations.getHUN(query, selectedCell);
            selectedCell.nodeDimensionUniqueName = DimensionalOperations.getDUN(query, selectedCell);
            dataContainer.setActionEnv(this.getEnv());
            if (dataContainer instanceof V5List) {
                Element detailDataItem = this.doDrillDownOnList((V5List)dataContainer, selectedCell);
                if (detailDataItem == null) continue;
                allCreatedDataItems.add(detailDataItem);
                continue;
            }
            if (!DimensionalOperations.isDrillableMember(selectedCell) || (nodeToDrillOn = this.getNodeToDrillOn(selectedCell, allCreatedDataItems, dataContainer)) == null) continue;
            Collection<Element> createdDataItems = this.drillDownOnCrosstabOrChart(dataContainer, selectedCell, nodeToDrillOn);
            allCreatedDataItems.addAll(createdDataItems);
        }
        return allCreatedDataItems;
    }

    private Element getNodeToDrillOn(SelectedCell selectedCell, Collection<Element> allCreatedDataItems, V5DataContainer dataContainer) throws ActionException {
        Element nodeToDrillOn = this.dimensionalOperations.createDrillUpCellToEdge(dataContainer, selectedCell);
        if (nodeToDrillOn != null) {
            this.dimensionalOperations.setIsDrillOnSingleDimensionNestedNode(dataContainer, nodeToDrillOn, selectedCell, dataContainer.getV5Query());
            if (!this.dimensionalOperations.getIsDrillOnSingleDimensionNestedNode()) {
                nodeToDrillOn = this.dimensionalOperations.getHighestNestedNodeWithSameHun(nodeToDrillOn, selectedCell, dataContainer.getV5Query());
            }
        }
        return nodeToDrillOn;
    }

    private Collection<Element> drillDownOnCrosstabOrChart(V5DataContainer dataContainer, SelectedCell selectedCell, Element nodeToDrillOn) throws ActionException {
        ArrayList<Element> createdDataItems = new ArrayList<Element>();
        boolean bDrillUpToRoot = false;
        Element createdDataItem = this.dimensionalOperations.doDrillOnCrosstabOrChart(dataContainer, nodeToDrillOn, selectedCell, null, bDrillUpToRoot);
        if (createdDataItem != null) {
            createdDataItems.add(createdDataItem);
        }
        return createdDataItems;
    }

    private Element doDrillDownOnList(V5List v5List, SelectedCell selectedCell) throws ActionException {
        V5Query v5Query = new V5Query();
        v5Query.focusQuery(this.getReport().getDOM().getRootElement(), selectedCell.queryName);
        List<Element> listColumnElementsInSameDimension = this.dimensionalOperations.getDrillableListColumnsOfSameDimension(this.getReport(), v5Query, v5List, selectedCell);
        if (listColumnElementsInSameDimension.size() == 0) {
            return null;
        }
        Element detailDataItem = null;
        boolean detailHasChildren = false;
        if (listColumnElementsInSameDimension.size() == 1) {
            detailHasChildren = this.getRapServiceRequestManager().ifHasChild(v5Query, selectedCell.nodeUse);
            detailDataItem = this.dimensionalOperations.doDrillingOnList(v5List, v5Query, listColumnElementsInSameDimension.get(0), selectedCell, detailHasChildren, true);
        } else if (listColumnElementsInSameDimension.size() == 2) {
            String rdi = v5List.getRDIName(listColumnElementsInSameDimension.get(0));
            Element childColumn = rdi.equals(selectedCell.nodeName) ? listColumnElementsInSameDimension.get(0) : listColumnElementsInSameDimension.get(1);
            Element parentColumn = rdi.equals(selectedCell.nodeName) ? listColumnElementsInSameDimension.get(1) : listColumnElementsInSameDimension.get(0);
            detailHasChildren = this.getRapServiceRequestManager().ifHasChild(v5Query, selectedCell.nodeUse);
            detailDataItem = this.dimensionalOperations.doDrillingOnList(v5List, v5Query, childColumn, selectedCell, detailHasChildren, true);
            MemberInfo ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, selectedCell.nodeUse, detailHasChildren ? 1 : 2);
            if (ancestorInfo != null) {
                SelectedCell parentSelectedCell = DimensionalOperations.createSelectedCell(ancestorInfo.getMemberCaption(), ancestorInfo.getMUN(), selectedCell);
                this.dimensionalOperations.doDrillingOnList(v5List, v5Query, parentColumn, parentSelectedCell, true, true);
            }
        } else {
            Element selectedListColumn = v5List.findItem(selectedCell.nodeName);
            int selectedColumnDepth = this.dimensionalOperations.getHierarchyDepthOfListColumn(v5List, v5Query, selectedListColumn);
            listColumnElementsInSameDimension.remove(selectedListColumn);
            Map<Integer, Collection<Element>> depthListColumnMap = this.dimensionalOperations.getHierarchyDepthsOfListColumns(v5Query, v5List, listColumnElementsInSameDimension);
            detailHasChildren = this.getRapServiceRequestManager().ifHasChild(v5Query, selectedCell.nodeUse);
            detailDataItem = this.dimensionalOperations.doDrillingOnList(v5List, v5Query, selectedListColumn, selectedCell, detailHasChildren, true);
            Element previouslyDrilledColumn = selectedListColumn;
            int startDepth = selectedColumnDepth;
            while (startDepth >= 0) {
                String rdi;
                Element dataItem;
                Element exprNode;
                Integer key;
                Collection<Element> listColumns;
                if ((listColumns = depthListColumnMap.get(key = Integer.valueOf(startDepth--))) == null || (exprNode = (Element)(dataItem = v5Query.findItem(rdi = v5List.getRDIName(previouslyDrilledColumn))).selectSingleNode(".//*[local-name()='MUN'] | .//*[local-name()='expression']")) == null) continue;
                String expression = this.toLowLevelExpression(dataItem);
                MemberInfo ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, expression, 2);
                if (ancestorInfo == null || !ancestorInfo.isValid()) continue;
                for (Element listColumn : listColumns) {
                    SelectedCell parentSelectedCell = DimensionalOperations.createSelectedCell(ancestorInfo.getMemberCaption(), ancestorInfo.getMUN(), selectedCell);
                    this.dimensionalOperations.doDrillingOnList(v5List, v5Query, listColumn, parentSelectedCell, true, true);
                }
                previouslyDrilledColumn = listColumns.iterator().next();
            }
        }
        if (!detailHasChildren && detailDataItem != null) {
            V5Drillability.setDrillDownDisabled(v5Query, detailDataItem);
        } else if (detailDataItem != null && V5Drillability.isDrillUpDisabled(detailDataItem)) {
            V5Drillability.clearDrillUpDisabled(v5Query, detailDataItem);
        }
        return detailDataItem;
    }

    private String toLowLevelExpression(Element dataItem) throws ActionException {
        Element munNode = (Element)dataItem.selectSingleNode(V5X.select("MUN"));
        if ("dataItemMember".equals(dataItem.getName())) {
            return munNode.getText();
        }
        if ("dataItemChildrenSet".equals(dataItem.getName())) {
            return "children(" + munNode.getText() + ")";
        }
        if ("dataItem".equals(dataItem.getName())) {
            Element expressionNode = (Element)dataItem.selectSingleNode(V5X.select("expression"));
            return expressionNode.getText();
        }
        throw new ActionException("RAP_INT: Unexpected data item type: " + dataItem.getName());
    }
}

