/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SelectionContextManager;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5DrillUpDownWithBehaviors;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5ListColumn;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.controller.RAPConfigProperties;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class DrillUp
extends BaseAction {
    private DimensionalOperations dimensionalOperations = new DimensionalOperations(this);

    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        super.apply(reportToModify, actionArgs);
        if (!RAPConfigProperties.isBackwardsCompatibleDrillEnabled()) {
            this.dimensionalOperations.initializeNewDrillRules(false);
        }
        V5DataContainer dataContainer = V5DataContainerFactory.create(reportToModify.getRootElement(), this.getActionArguments().getArgument("id"));
        SelectionContextManager selMgr = new SelectionContextManager();
        ArrayList<SelectedCell> selectedCells = selMgr.loadSelectedCells(actionArgs.element("selection"));
        for (int i = 0; i < selectedCells.size(); ++i) {
            List<SelectedCell> cellsToDrill = DimensionalOperations.buildSelectedCellsToDrill(selectedCells.get(i), actionArgs.elementText("userSelectedDrillItem"), dataContainer);
            for (SelectedCell cellToDrill : cellsToDrill) {
                if (!DimensionalOperations.isDrillableMember(cellToDrill)) continue;
                V5DrillUpDownWithBehaviors drillUpDownHelper = new V5DrillUpDownWithBehaviors(this, reportToModify, cellToDrill);
                if (drillUpDownHelper.shouldUseAuthoredDrillBehaviors()) {
                    drillUpDownHelper.applyAuthoredDrillBehaviors("DrillUp");
                    continue;
                }
                if (RAPConfigProperties.isBackwardsCompatibleDrillEnabled()) {
                    drillUpDownHelper.revertToRegularSet();
                }
                this.drillUpWithoutBehaviours(reportToModify, cellToDrill);
            }
        }
    }

    public void drillUpWithoutBehaviours(Document reportToModify, SelectedCell selectedCell) throws ActionException {
        Element matchingLinkedDrillItem = V5SpecHelper.getLinkedDrillItem(reportToModify, selectedCell.queryName, selectedCell.nodeName);
        if (matchingLinkedDrillItem == null) {
            this.drillUpWithoutBehavioursAllContainersOfSameQuery(reportToModify, selectedCell);
        } else {
            List linkedDrillItemElements = matchingLinkedDrillItem.getParent().elements();
            for (Element linkedDrillItem : linkedDrillItemElements) {
                selectedCell.nodeName = linkedDrillItem.attributeValue("refDataItem");
                selectedCell.queryName = linkedDrillItem.attributeValue("refQuery");
                selectedCell.nodeType = "memberUniqueName";
                V5DrillUpDownWithBehaviors drillUpDownHelper = new V5DrillUpDownWithBehaviors(this, reportToModify, selectedCell);
                if (drillUpDownHelper.shouldUseAuthoredDrillBehaviors()) {
                    drillUpDownHelper.drillOnMemberSet("DrillDown");
                    continue;
                }
                Collection<Element> createdDataItems = this.drillUpWithoutBehavioursAllContainersOfSameQuery(reportToModify, selectedCell);
                if (createdDataItems.isEmpty()) continue;
                String newDataItemName = createdDataItems.iterator().next().attributeValue("name");
                linkedDrillItem.addAttribute("refDataItem", newDataItemName);
            }
        }
    }

    public Collection<Element> drillUpWithoutBehavioursAllContainersOfSameQuery(Document reportToModify, SelectedCell selectedCell) throws ActionException {
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(reportToModify, selectedCell.queryName);
        ArrayList<Element> allCreatedDataItems = new ArrayList<Element>();
        boolean bIsDrillOnInitialXtabOrChartContainer = true;
        while (containerInDomainIter.hasNext()) {
            Element nodeToDrillOn;
            V5DataContainer dataContainer = containerInDomainIter.next();
            if (dataContainer == null || dataContainer.getContainerElement().getDocument() == null) continue;
            V5Query query = dataContainer.getV5Query();
            selectedCell.nodeHierarchyUniqueName = DimensionalOperations.getHUN(query, selectedCell);
            selectedCell.nodeDimensionUniqueName = DimensionalOperations.getDUN(query, selectedCell);
            dataContainer.setActionEnv(this.getEnv());
            if (dataContainer instanceof V5List) {
                Element detailDataItem = this.doDrillUpOnList((V5List)dataContainer, selectedCell);
                if (detailDataItem == null) continue;
                allCreatedDataItems.add(detailDataItem);
                continue;
            }
            if (!DimensionalOperations.isDrillableMember(selectedCell) || (nodeToDrillOn = this.getNodeToDrillOn(selectedCell, allCreatedDataItems, dataContainer)) == null) continue;
            Collection<Element> createdDataItems = this.drillUpOnCrosstabOrChart(dataContainer, selectedCell);
            allCreatedDataItems.addAll(createdDataItems);
        }
        return allCreatedDataItems;
    }

    private Element getNodeToDrillOn(SelectedCell selectedCell, Collection<Element> allCreatedDataItems, V5DataContainer dataContainer) throws ActionException {
        Element nodeToDrillOn = this.dimensionalOperations.createDrillUpCellToEdge(dataContainer, selectedCell);
        if (nodeToDrillOn != null) {
            this.dimensionalOperations.setIsDrillOnSingleDimensionNestedNode(dataContainer, nodeToDrillOn, selectedCell, dataContainer.getV5Query());
            if (!this.dimensionalOperations.getIsDrillOnSingleDimensionNestedNode()) {
                nodeToDrillOn = this.dimensionalOperations.getHighestNestedNodeWithSameHun(nodeToDrillOn, selectedCell, dataContainer.getV5Query());
            }
        }
        return nodeToDrillOn;
    }

    private Collection<Element> drillUpOnCrosstabOrChart(V5DataContainer dataContainer, SelectedCell selectedCell) throws ActionException {
        Element nodeToDrillOn;
        ArrayList<Element> createdDataItems = new ArrayList<Element>();
        V5Query v5Query = dataContainer.getV5Query();
        if (DimensionalOperations.isDrillableMember(selectedCell) && (nodeToDrillOn = this.dimensionalOperations.createDrillUpCellToEdge(dataContainer, selectedCell)) != null) {
            Element createdDataItem;
            this.dimensionalOperations.setIsDrillOnSingleDimensionNestedNode(dataContainer, nodeToDrillOn, selectedCell, v5Query);
            if (!this.dimensionalOperations.getIsDrillOnSingleDimensionNestedNode()) {
                nodeToDrillOn = this.dimensionalOperations.getHighestNestedNodeWithSameHun(nodeToDrillOn, selectedCell, v5Query);
            }
            MemberInfo ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, selectedCell.nodeUse, this.dimensionalOperations.getAncestorDistance(v5Query, selectedCell));
            boolean bDrillUpToRoot = false;
            if (!ancestorInfo.isValid() && !RAPConfigProperties.isBackwardsCompatibleDrillEnabled()) {
                ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, selectedCell.nodeUse, 1);
                bDrillUpToRoot = true;
            }
            if ((createdDataItem = this.dimensionalOperations.doDrillUp(dataContainer, nodeToDrillOn, ancestorInfo, selectedCell, bDrillUpToRoot)) != null) {
                createdDataItems.add(createdDataItem);
            }
        }
        return createdDataItems;
    }

    private Element doDrillUpOnList(V5List v5List, SelectedCell selectedCell) throws ActionException {
        V5Query v5Query = new V5Query();
        v5Query.focusQuery(this.getReport().getDOM().getRootElement(), selectedCell.queryName);
        List<Element> listColumnElements = this.dimensionalOperations.getDrillableListColumnsOfSameDimension(this.getReport(), v5Query, v5List, selectedCell);
        Element selectedListColumn = v5List.findItem(selectedCell.nodeName);
        if (selectedListColumn == null) {
            return null;
        }
        Element detailDataItem = null;
        if (listColumnElements.size() == 1) {
            detailDataItem = this.doDrillupOnListColumn(v5List, v5Query, selectedListColumn, selectedCell, this.dimensionalOperations.getAncestorDistance(v5Query, selectedCell));
        } else {
            int selectedColumnDepth = this.dimensionalOperations.getHierarchyDepthOfListColumn(v5List, v5Query, selectedListColumn);
            listColumnElements.remove(selectedListColumn);
            Map<Integer, Collection<Element>> depthListColumnMap = this.dimensionalOperations.getHierarchyDepthsOfListColumns(v5Query, v5List, listColumnElements);
            detailDataItem = this.doDrillupOnListColumn(v5List, v5Query, selectedListColumn, selectedCell, this.dimensionalOperations.getAncestorDistance(v5Query, selectedCell));
            Element previouslyDrilledColumn = selectedListColumn;
            int startDepth = selectedColumnDepth;
            while (startDepth >= 0) {
                Integer key;
                Collection<Element> listColumns;
                if ((listColumns = depthListColumnMap.get(key = Integer.valueOf(startDepth--))) == null) continue;
                for (Element listColumn : listColumns) {
                    String rdi = v5List.getRDIName(previouslyDrilledColumn);
                    SelectedCell parentSelectedCell = this.createSelectedCell(v5Query.findItem(rdi), selectedCell);
                    this.doDrillupOnListColumn(v5List, v5Query, listColumn, parentSelectedCell, 2);
                }
                previouslyDrilledColumn = listColumns.iterator().next();
                depthListColumnMap.remove(key);
            }
            if (depthListColumnMap.size() > 0) {
                Collection<Element> listColumns = depthListColumnMap.values().iterator().next();
                for (Element listColumn : listColumns) {
                    detailDataItem = this.doDrillupOnListColumn(v5List, v5Query, listColumn, selectedCell, 1);
                }
            }
        }
        return detailDataItem;
    }

    private Element doDrillupOnListColumn(V5List v5List, V5Query v5Query, Element nodeToDrillOn, SelectedCell selectedCell, int distance) throws ActionException {
        if (nodeToDrillOn == null) {
            return null;
        }
        Element detailDataItem = this.drillUpUsingBreadcrumb(v5List, v5Query, nodeToDrillOn);
        if (detailDataItem == null) {
            MemberInfo ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, selectedCell.nodeUse, distance);
            if (ancestorInfo == null || !ancestorInfo.isValid()) {
                if (distance != 1) {
                    ancestorInfo = this.getRapServiceRequestManager().getAncestorInfo(v5Query, selectedCell.nodeUse, 1);
                    if (ancestorInfo == null || !ancestorInfo.isValid()) {
                        return null;
                    }
                    SelectedCell newSelectedCell = this.createSelectedCell(ancestorInfo, selectedCell);
                    detailDataItem = this.dimensionalOperations.doDrillingOnList(v5List, v5Query, nodeToDrillOn, newSelectedCell, false, false);
                }
            } else {
                SelectedCell newSelectedCell = this.createSelectedCell(ancestorInfo, selectedCell);
                detailDataItem = this.dimensionalOperations.doDrillingOnList(v5List, v5Query, nodeToDrillOn, newSelectedCell, true, false);
            }
        }
        if (detailDataItem != null && V5Drillability.isDrillDownDisabled(detailDataItem)) {
            V5Drillability.clearDrillDownDisabled(v5Query, detailDataItem);
        }
        return detailDataItem;
    }

    public Element drillUpUsingBreadcrumb(V5List v5List, V5Query v5query, Element listColumn) {
        String drillUpItemName;
        Element dataItemElement = null;
        if (listColumn == null) {
            return null;
        }
        V5ListColumn v5ListColumn = new V5ListColumn(listColumn);
        String oldRDI = v5ListColumn.getDataItemName();
        String breadCrumbName = DimensionalOperations.getLastBreadCrumbName(listColumn);
        if (breadCrumbName != null && (drillUpItemName = V5SpecHelper.getXMLAttribute(listColumn, breadCrumbName)) != null && v5query.findItem(drillUpItemName) != null) {
            V5SpecHelper.removeXMLAttribute(listColumn, breadCrumbName);
            dataItemElement = v5query.findItem(drillUpItemName);
            v5List.replaceDataItemRefOfListColumn(dataItemElement, listColumn, v5query);
            V5SpecHelper.resetCustomizedLabels((V5DataContainer)v5List, dataItemElement.attributeValue("name"), null);
            v5List.replaceRDIOfSortItem(oldRDI, dataItemElement.attributeValue("name"));
        }
        return dataItemElement;
    }

    private SelectedCell createSelectedCell(Element dataItem, SelectedCell selectedCell) {
        Element exprNode = (Element)dataItem.selectSingleNode(".//*[local-name()='expression'] | .//*[local-name()='MUN']");
        String expression = exprNode != null ? exprNode.getText() : null;
        String name = dataItem.attributeValue("name");
        if ("dataItemChildrenSet".equals(dataItem.getName())) {
            expression = "item(children(" + expression + "), 0)";
        }
        return DimensionalOperations.createSelectedCell(name, expression, selectedCell);
    }

    private SelectedCell createSelectedCell(MemberInfo memberInfo, SelectedCell selectedCell) {
        return DimensionalOperations.createSelectedCell(memberInfo.getMemberCaption(), memberInfo.getMUN(), selectedCell);
    }
}

