/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5PromptPage;
import com.cognos.rap.actions.v5spechelpers.V5RSXChart;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.JSONUtility;
import com.cognos.rap.utility.RAPMessageManager;
import com.cognos.rap.utility.XMLUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ExtractReportPart
extends BaseAction {
    public static final String RDS_PATH_DELIMITER = "$$$";

    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        Element eReport = reportToModify.getRootElement();
        if (eReport.attribute("viewPagesAsTabs") != null) {
            eReport.remove(eReport.attribute("viewPagesAsTabs"));
        }
        Arguments args = new Arguments(actionArgs);
        Element sourceLayouts = (Element)eReport.selectSingleNode(V5X.selectImmediateChildren("layouts"));
        Element sourcePart = this.getReportPartElement(sourceLayouts, args.getArgument("id"));
        if (sourcePart == null && args.getArgument("ANSUpgrade") != null) {
            sourcePart = this.findANSUpgradePart(sourceLayouts, args);
        }
        if (sourcePart == null) {
            return;
        }
        Element targetLayouts = eReport.addElement("layouts");
        String partName = sourcePart.getName();
        if (partName.equals("textItem")) {
            sourcePart = this.getTextItemParentDataContainer(sourcePart);
        }
        Element clonePart = (Element)sourcePart.clone();
        Element promptPages = null;
        Element targetLayout = null;
        ArrayList<String> promptParameterNames = null;
        boolean singlePrompt = false;
        if (partName.equals("page")) {
            Element pageParent = this.createLayoutAbovePage(sourceLayouts, sourcePart, targetLayouts);
            this.removeTOCEntriesFromPage(clonePart);
            pageParent.add(clonePart);
            promptPages = (Element)clonePart.selectSingleNode(V5X.selectAncestors("promptPages"));
            if (promptPages != null) {
                promptParameterNames = this.extractPromptPageParameterNames(clonePart);
                this.processPromptPage(clonePart, this.createApplyButtonContent(sourceLayouts));
            }
        } else {
            promptParameterNames = new ArrayList<String>();
            promptParameterNames.add(clonePart.attributeValue("parameter"));
            if (V5PromptPage.isPromptCtrl(partName)) {
                targetLayout = targetLayouts.addElement("layout");
                promptPages = this.processSinglePromptControl(clonePart, sourceLayouts, targetLayout);
                singlePrompt = true;
            } else {
                Element partParent = this.createLayoutAbovePart(sourceLayouts, sourcePart, targetLayouts);
                partParent.add(clonePart);
                promptPages = (Element)clonePart.selectSingleNode(V5X.selectAncestors("promptPages"));
            }
        }
        Element sourceLayout = (Element)sourcePart.selectSingleNode(V5X.selectAncestors("layout"));
        targetLayout = targetLayouts.element("layout");
        Element sourceDefaultDataFormats = sourceLayout.element("defaultDataFormats");
        if (targetLayout != null && sourceDefaultDataFormats != null) {
            Element targetDefaultDataFormats = (Element)sourceDefaultDataFormats.clone();
            targetLayout.add(targetDefaultDataFormats);
        }
        if (promptPages != null) {
            V5SpecHelper.setXMLAttribute(eReport, "RAP_PromptWidget", "true", "no");
            try {
                V5SpecHelper.setXMLAttribute(eReport, "RAP_PromptWidget_Parameters", JSONUtility.StringList2JSONArray(promptParameterNames).serialize(), "no");
            }
            catch (IOException e) {
                throw new ActionException(e.getMessage());
            }
            if (!singlePrompt) {
                promptPages.setQName(DocumentHelper.createQName((String)"reportPages", (Namespace)promptPages.getNamespace()));
            }
        } else {
            Element sourcePage;
            ArrayList<Element> promptControls;
            V5DataContainer.cloneChild(sourceLayout, "promptPages", targetLayout);
            if (!sourcePart.getName().equals("page") && (promptControls = V5PromptPage.collectPromptControls(sourcePage = (Element)sourcePart.selectSingleNode(V5X.selectAncestors("page")))) != null) {
                V5PromptPage v5PromptPage = new V5PromptPage(targetLayout);
                v5PromptPage.removeExistingPromptControls(promptControls);
                Element lastPromptPage = V5SpecHelper.getLastPromptPage(targetLayout);
                boolean result = v5PromptPage.addPromptPageWithControls(promptControls, targetLayout);
                if (result && lastPromptPage != null) {
                    V5PromptPage.insertNextButton(lastPromptPage);
                }
            }
        }
        ExtractReportPart.removeMissingLayoutComponentReferences(targetLayout);
        eReport.remove(sourceLayouts);
    }

    private static void removeMissingLayoutComponentReferences(Element reportSpec) {
        if (reportSpec != null) {
            List layoutComponentRefs = V5X.selectNodes(reportSpec, "layoutComponentRef");
            for (Element layoutComponentRef : layoutComponentRefs) {
                String refLayoutElementAttribValue = layoutComponentRef.attributeValue("refLayoutElement");
                if (layoutComponentRef.element("reportPath") != null || V5X.selectSingleNode(reportSpec, "//V5X//ANYCHILD", "//V5X//ATTR", "name", refLayoutElementAttribValue) != null) continue;
                layoutComponentRef.detach();
            }
        }
    }

    private Element findANSUpgradePart(Element sourceLayouts, Arguments args) {
        String ansUpgradeType = args.getArgument("ANSUpgrade");
        if (ansUpgradeType != null) {
            boolean extractCrosstab = "crosstab".equals(ansUpgradeType);
            List layoutContainers = V5X.selectNodes(sourceLayouts, "page", "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refQuery");
            for (Element layoutContainer : layoutContainers) {
                if (extractCrosstab && "crosstab".equals(layoutContainer.getName())) {
                    return layoutContainer;
                }
                if (!V5RSXChart.isChart(layoutContainer.getName())) continue;
                return layoutContainer;
            }
        }
        return null;
    }

    private Element processSinglePromptControl(Element clonePart, Element sourceLayouts, Element targetLayout) {
        V5PromptPage v5PromptPage = new V5PromptPage(targetLayout);
        ArrayList<Object[]> buttons = null;
        Attribute cascadeAttr = clonePart.attribute("cascadeOn");
        if (clonePart.attributeValue("cascadeOn") != null) {
            clonePart.remove(cascadeAttr);
        }
        String autoSubmit = clonePart.attributeValue("autoSubmit");
        Element pageFooter = null;
        if (autoSubmit == null || !autoSubmit.equalsIgnoreCase("true")) {
            Element buttonContent = this.createApplyButtonContent(sourceLayouts);
            Object[] applyButton = new Object[]{"reprompt", buttonContent};
            buttons = new ArrayList<Object[]>(1);
            buttons.add(applyButton);
            pageFooter = v5PromptPage.createPromptPageFooter(buttons);
        }
        ArrayList<Element> promptControls = new ArrayList<Element>(1);
        promptControls.add(clonePart);
        return v5PromptPage.addPromptPageWithCustomFooter(promptControls, targetLayout, pageFooter, "reportPages");
    }

    private void processPromptPage(Element clonePage, Element buttonContent) {
        boolean applyButton = this.doesPromptPageNeedApplyButton(clonePage);
        List buttons = XMLUtility.selectNodes(clonePage, V5X.select("promptButton"));
        for (Element button : buttons) {
            String buttonType = button.attributeValue("type");
            if (buttonType == null) continue;
            if (buttonType.equalsIgnoreCase("finish") && applyButton) {
                button.addAttribute("type", "reprompt");
                this.addContentToButton(button, buttonContent);
                continue;
            }
            if (buttonType.equalsIgnoreCase("reprompt")) continue;
            button.detach();
        }
    }

    private ArrayList<String> extractPromptPageParameterNames(Element clonePage) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Element> promptControls = V5PromptPage.collectPromptControls(clonePage);
        for (Element p : promptControls) {
            String parameterName = p.attributeValue("parameter");
            if (parameterName == null) continue;
            result.add(parameterName);
        }
        return result;
    }

    private Element createApplyButtonContent(Element sourceLayoutElement) {
        Element buttonContent = XMLUtility.createElementInSameNamespace("textItem", sourceLayoutElement);
        Element buttonLabel = buttonContent.addElement("dataSource").addElement("staticValue");
        buttonLabel.addText(RAPMessageManager.convert("RAP_PROMPT_BUTTON_APPLY", this.getLocale()));
        return buttonContent;
    }

    private void addContentToButton(Element button, Element buttonContent) {
        Element contentElem = (Element)button.selectSingleNode(V5X.selectImmediateChildren("contents"));
        if (contentElem != null && !contentElem.hasContent() && buttonContent != null) {
            contentElem.add(buttonContent);
        }
    }

    private boolean doesPromptPageNeedApplyButton(Element clonePage) {
        boolean result = false;
        ArrayList<Element> promptControls = V5PromptPage.collectPromptControls(clonePage);
        String autoSubmit = null;
        for (Element p : promptControls) {
            autoSubmit = p.attributeValue("autoSubmit");
            if (autoSubmit != null && autoSubmit.equalsIgnoreCase("true")) continue;
            result = true;
            break;
        }
        return result;
    }

    protected Element createLayoutAbovePage(Element sourceLayouts, Element sourcePage, Element targetLayouts) {
        Element targetPageParent = null;
        Element targetNode = null;
        Element targetChild = null;
        for (Element sourceNode = sourcePage.getParent(); sourceNode != sourceLayouts; sourceNode = sourceNode.getParent()) {
            targetNode = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)sourceNode.getName(), (Namespace)sourcePage.getNamespace()));
            if ("pageSet".equals(sourceNode.getName())) {
                V5DataContainer.cloneAttribute(sourceNode, "name", targetNode);
                V5DataContainer.cloneAttribute(sourceNode, "refQuery", targetNode);
                V5DataContainer.cloneChild(sourceNode, "sortList", targetNode);
                if (!"pageGroups".equals(targetChild.getName())) {
                    V5DataContainer.cloneChild(sourceNode, "pageGroups", targetNode);
                }
                V5DataContainer.cloneChild(sourceNode, "masterDetailLinks", targetNode);
                if (!"detailPages".equals(targetChild.getName())) {
                    targetNode.addElement("detailPages");
                }
            }
            if ("pageGroup".equals(sourceNode.getName())) {
                V5DataContainer.cloneAttribute(sourceNode, "refDataItem", targetNode);
            }
            if (targetPageParent == null) {
                targetPageParent = targetNode;
            } else {
                targetNode.add(targetChild);
            }
            targetChild = targetNode;
        }
        targetLayouts.add(targetNode);
        return targetPageParent;
    }

    protected Element createLayoutAbovePart(Element sourceLayouts, Element sourcePart, Element targetLayouts) {
        Element sourcePage = (Element)sourcePart.selectSingleNode(V5X.selectAncestors("page"));
        Element sourcePageBody = (Element)sourcePage.selectSingleNode(V5X.selectImmediateChildren("pageBody"));
        Element targetPageParent = this.createLayoutAbovePage(sourceLayouts, sourcePage, targetLayouts);
        Element targetPage = targetPageParent.addElement("page");
        V5DataContainer.cloneAttribute(sourcePage, "name", targetPage);
        V5DataContainer.cloneAttribute(sourcePage, "refQuery", targetPage);
        V5DataContainer.cloneChild(sourcePage, "masterDetailLinks", targetPage);
        V5DataContainer.cloneChild(sourcePage, "style", targetPage);
        Element css = V5X.selectSingleNode(targetPage, "//V5X//CHILD", "style", "CSS");
        if (css != null) {
            css.detach();
        }
        Element targetPageBody = targetPage.addElement("pageBody");
        V5DataContainer.cloneChild(sourcePageBody, "style", targetPageBody);
        css = V5X.selectSingleNode(targetPageBody, "//V5X//CHILD", "style", "CSS");
        if (css != null) {
            css.detach();
        }
        Element pageBodyContents = targetPageBody.addElement("contents");
        return pageBodyContents;
    }

    private void removeTOCEntriesFromPage(Element pageElement) {
        List tocEntryList = pageElement.selectNodes(V5X.select("TOCEntry"));
        ListIterator iterator = tocEntryList.listIterator();
        while (iterator.hasNext()) {
            Element tocEntry = (Element)iterator.next();
            if (tocEntry.getParent() == null) continue;
            tocEntry.getParent().remove(tocEntry);
        }
    }

    private Element getReportPartElement(Element sourceLayouts, String name) {
        Element part;
        block2: {
            if (name == null) {
                return null;
            }
            part = (Element)sourceLayouts.selectSingleNode(V5X.selectByName(name));
            if (part != null || name.indexOf(RDS_PATH_DELIMITER) < 0) break block2;
            String bestName = name;
            while (bestName.indexOf(RDS_PATH_DELIMITER) >= 0 && (part = (Element)sourceLayouts.selectSingleNode(V5X.selectByName(bestName = bestName.substring(bestName.indexOf(RDS_PATH_DELIMITER) + RDS_PATH_DELIMITER.length())))) == null) {
            }
        }
        return part;
    }

    private Element getTextItemParentDataContainer(Element sourcePart) {
        Element parentDataContainer;
        if (null != V5X.selectSingleNode(sourcePart, "//V5X//CHILD", "dataSource", "dataItemValue", "//V5X//OR", "dataItemLabel", "//V5X//ATTR_DEFINED", "refDataItem") && null != (parentDataContainer = (Element)sourcePart.selectSingleNode("ancestor::*[@refQuery][1]"))) {
            sourcePart = parentDataContainer;
        }
        return sourcePart;
    }
}

