/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SelectionContextManager;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Filter
extends BaseAction {
    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        String signCharacterArg;
        Arguments actionArguments = new Arguments(actionArgs);
        SelectionContextManager selMgr = new SelectionContextManager();
        ArrayList<SelectedCell> selectedCells = selMgr.loadSelectedCells(actionArgs.element("selection"));
        String filterType = actionArguments.getArgument("type");
        String formattedNumber = actionArguments.getArgument("formattedNumber");
        String formattedEndNumber = actionArguments.getArgument("formattedEndNumber");
        List containerElementList = null;
        if ("removeAllForWidget".equals(filterType)) {
            containerElementList = XMLUtility.selectNodes(reportToModify, V5X.select("layouts") + "//*[@name!='' and @refQuery!='']");
            filterType = "removeAll";
        } else {
            containerElementList = V5SpecHelper.findLayoutElementsFromActionArguments(reportToModify, actionArgs);
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        char decimalSeparator = dfs.getDecimalSeparator();
        char signCharacter = dfs.getMinusSign();
        String decimalSeparatorArg = actionArguments.getArgument("decimalSeparator");
        if (decimalSeparatorArg != null && decimalSeparatorArg.length() > 0) {
            decimalSeparator = decimalSeparatorArg.charAt(0);
        }
        if ((signCharacterArg = actionArguments.getArgument("signCharacter")) != null && signCharacterArg.length() > 0) {
            signCharacter = signCharacterArg.charAt(0);
        }
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(containerElementList);
        while (containerInDomainIter.hasNext()) {
            V5DataContainer dataContainer = containerInDomainIter.next();
            if (dataContainer == null) continue;
            this.splitQueryIfNeeded(dataContainer.getContainerElement());
            V5Query query = new V5Query();
            if (!query.focusQuery(reportToModify.getRootElement(), dataContainer.getRefQuery())) continue;
            V5QueryFilters queryFilters = new V5QueryFilters(this.getEnv(), query);
            if ("remove".equals(filterType)) {
                this.removeFilter(dataContainer, actionArgs, selectedCells);
                continue;
            }
            if ("removeAll".equals(filterType) || selectedCells.size() == 0 && filterType == null) {
                queryFilters.clearExistingFilters();
                continue;
            }
            if (selectedCells.size() > 0) {
                Element filterAdded = null;
                if (filterType == null) {
                    queryFilters.clearExistingFilters(selectedCells.get((int)0).nodeName);
                } else if ("in".equals(filterType)) {
                    filterAdded = queryFilters.setFilterMembersOrValues(selectedCells, true);
                } else if ("not".equals(filterType)) {
                    filterAdded = queryFilters.setFilterMembersOrValues(selectedCells, false);
                } else if ("between".equals(filterType)) {
                    filterAdded = queryFilters.setFilterBetween(selectedCells, decimalSeparator, signCharacter);
                } else if ("notBetween".equals(filterType)) {
                    filterAdded = queryFilters.setFilterNotBetween(selectedCells, decimalSeparator, signCharacter);
                } else {
                    filterAdded = queryFilters.setFilterCompare(selectedCells.get(0), filterType, decimalSeparator, signCharacter);
                    if (filterAdded == null) {
                        throw new ActionException("RAP_INT: Unknown filter type: " + filterType);
                    }
                }
                if (filterAdded == null) continue;
                V5SpecHelper.setXMLAttribute(filterAdded, "RAP_filterLocale", this.getLocale(), "no");
                if (formattedNumber == null) continue;
                V5SpecHelper.setXMLAttribute(filterAdded, "RAP_FormattedNumber", formattedNumber, "no");
                if (formattedEndNumber == null) continue;
                V5SpecHelper.setXMLAttribute(filterAdded, "RAP_FormattedEndNumber", formattedEndNumber, "no");
                continue;
            }
            throw new ActionException("RAP_INT: Selected cells=0 unsRported for filter type: " + filterType);
        }
    }

    private void removeFilter(V5DataContainer container, Element actionArgs, List<SelectedCell> selectedCells) {
        String itemName = actionArgs.elementText("item");
        if (itemName == null && selectedCells.size() > 0) {
            V5QueryFilters queryFilters = new V5QueryFilters(this.getEnv(), container.getV5Query());
            queryFilters.clearExistingFilters(selectedCells.get((int)0).nodeName);
        }
        ArrayList<V5DataContainer> containerAndChildContainers = V5DataContainerFactory.createChildContainers(container.getContainerElement());
        containerAndChildContainers.add(container);
        Element details = actionArgs.element("details");
        JSONObject jsonFilterDetails = this.getJSONRemoveFilterDetails(details);
        if (jsonFilterDetails != null && "contextSlice".equals(jsonFilterDetails.get((Object)"type"))) {
            for (V5DataContainer thisContainer : containerAndChildContainers) {
                V5Query v5Query = thisContainer.getV5Query();
                if (v5Query == null) continue;
                v5Query.removeContextSlicer((String)jsonFilterDetails.get((Object)"HUN"));
            }
        } else {
            for (V5DataContainer thisContainer : containerAndChildContainers) {
                V5QueryFilters queryFilters = new V5QueryFilters(this.getEnv(), thisContainer.getV5Query());
                if (details != null) {
                    queryFilters.clearExistingFiltersUsingReportInfoFilterJSON(itemName, details.getText());
                    continue;
                }
                queryFilters.clearExistingFilters(itemName);
            }
        }
    }

    private JSONObject getJSONRemoveFilterDetails(Element details) {
        if (details != null) {
            try {
                JSONArray detailsArray = JSONArray.parse((String)details.getText());
                return (JSONObject)detailsArray.get(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void splitQueryIfNeeded(Element dataContainer) {
        Element parentWithRefQuery;
        if (dataContainer.element("masterDetailLinks") == null) {
            return;
        }
        for (parentWithRefQuery = dataContainer.getParent(); parentWithRefQuery != null && parentWithRefQuery.attribute("refQuery") == null; parentWithRefQuery = parentWithRefQuery.getParent()) {
        }
        if (parentWithRefQuery != null && V5SpecHelper.ifInnerMostDetailContainerWithSameQuery(parentWithRefQuery.attributeValue("refQuery"), dataContainer)) {
            V5Query v5Query = new V5Query(dataContainer, dataContainer.attributeValue("refQuery"));
            V5SpecHelper.cloneQueryAndRedirectContainer(dataContainer, v5Query);
        }
    }
}

