/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SelectionContextManager;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.Element;

public class Sort
extends BaseAction {
    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        Arguments actionArguments = new Arguments(actionArgs);
        V5DataContainer dataContainer = V5DataContainerFactory.create(reportToModify.getRootElement(), actionArguments.getArgument("id"));
        String sortOrder = actionArguments.getArgument("order");
        if (dataContainer != null) {
            boolean disableSecondarySorting;
            dataContainer.setActionEnv(this.getEnv());
            SelectionContextManager selMgr = new SelectionContextManager();
            ArrayList<SelectedCell> selectedCells = selMgr.loadSelectedCells(actionArgs.element("selection"));
            boolean bl = disableSecondarySorting = this.getEnv().isSecondarySortDisabledForLists() && "list".equals(dataContainer.getContainerElement().getName());
            if (disableSecondarySorting) {
                List<Element> groupSortLists;
                Element sortList = dataContainer.selectSingleNode("//V5X//CHILD", "sortList");
                if (sortList != null) {
                    sortList.detach();
                }
                if ((groupSortLists = dataContainer.selectNodes("//V5X//CHILD", "listGroups", "listGroup", "sortList")) != null) {
                    for (Element groupSortlist : groupSortLists) {
                        groupSortlist.detach();
                    }
                }
            } else if (selectedCells.size() == 0) {
                String item = actionArguments.getArgument("item");
                boolean byLabel = actionArguments.getArgument("byLabel") != null;
                this.removeSorting(dataContainer, reportToModify, item, byLabel);
                for (V5DataContainer childContainer : V5DataContainerFactory.createChildContainers(dataContainer.getContainerElement())) {
                    this.removeSorting(childContainer, reportToModify, item, byLabel);
                }
            }
            ListIterator<SelectedCell> iterator = selectedCells.listIterator();
            while (iterator.hasNext()) {
                SelectedCell selectedCell = iterator.next();
                String byLabel = actionArguments.getArgument("byLabel");
                if (byLabel != null) {
                    this.sortByLabel(dataContainer, reportToModify, selectedCell, sortOrder);
                } else {
                    this.sortByValue(dataContainer, reportToModify, selectedCell, sortOrder);
                }
                if (!disableSecondarySorting) continue;
                break;
            }
            dataContainer.tagSortedLayoutItems();
        }
    }

    private void sortByLabel(V5DataContainer container, Document reportToModify, SelectedCell selectedCell, String sortOrder) throws ActionException {
        if (!"list".equals(container.getContainerElement().getName())) {
            if ("memberUniqueName".equals(selectedCell.nodeType)) {
                V5Query query = new V5Query();
                query.focusQuery(reportToModify.getRootElement(), container.getRefQuery());
                Element dataItem = query.findItem(selectedCell.nodeName);
                V5QueryItem queryItem = new V5QueryItem(this.getEnv(), query, dataItem);
                if (queryItem.confirmIsSet()) {
                    Element targetQueryItem = query.getItemList().findItem(selectedCell.nodeName);
                    if (targetQueryItem != null) {
                        if ("none".equals(sortOrder)) {
                            query.setSorting(targetQueryItem, null);
                        } else if ("ascending".equals(sortOrder)) {
                            query.setSorting(targetQueryItem, "true");
                        } else if ("descending".equals(sortOrder)) {
                            query.setSorting(targetQueryItem, "false");
                        } else {
                            throw new ActionException("RAP_INT: Invalid sort order: " + sortOrder);
                        }
                    }
                    container.removeSortList(selectedCell.nodeName);
                }
            } else if ("none".equals(sortOrder)) {
                container.removeSortList(selectedCell.nodeName);
            } else if ("ascending".equals(sortOrder) || "descending".equals(sortOrder)) {
                container.addSortList(selectedCell.nodeName, sortOrder);
            } else {
                throw new ActionException("RAP_INT: Invalid sort order: " + sortOrder);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sortByValue(V5DataContainer container, Document reportToModify, SelectedCell selectedCell, String sortOrder) throws ActionException {
        if ("V5List".equals(container.getClass().getSimpleName())) {
            String columnName;
            V5List list = (V5List)container;
            String columnRDIName = list.getRDIName(list.findLayoutItemByTag(selectedCell.rapLayoutTag));
            String string = columnName = columnRDIName != null ? columnRDIName : selectedCell.nodeName;
            if ("none".equals(sortOrder)) {
                container.removeSortList(columnName);
                return;
            } else {
                if (!"ascending".equals(sortOrder) && !"descending".equals(sortOrder)) throw new ActionException("RAP_INT: Invalid sort order: " + sortOrder);
                container.addSortList(columnName, sortOrder);
            }
            return;
        } else {
            List<Element> axisNodeMembers;
            Element oppositeAxis = container.findOppositeAxis(selectedCell.nodeName);
            if (oppositeAxis == null || (axisNodeMembers = container.axisNodeMembers(oppositeAxis)).size() <= 0) return;
            ArrayList<Element> aggregateItems = new ArrayList<Element>();
            V5Query query = new V5Query();
            query.focusQuery(reportToModify.getRootElement(), container.getRefQuery());
            ListIterator<Element> axisNodeMemberIter = axisNodeMembers.listIterator();
            while (axisNodeMemberIter.hasNext()) {
                Element axisNodeMember = axisNodeMemberIter.next();
                String nodeNameToSort = axisNodeMember.attributeValue("refDataItem");
                Element matchingQueryItem = query.findItem(nodeNameToSort);
                V5QueryItem queryItem = new V5QueryItem(this.getEnv(), query, matchingQueryItem);
                if (queryItem.confirmIsSet()) {
                    if ("none".equals(sortOrder)) {
                        query.setSorting_ByValue(matchingQueryItem, selectedCell, null);
                    } else if ("ascending".equals(sortOrder)) {
                        query.setSorting_ByValue(matchingQueryItem, selectedCell, "true");
                    } else {
                        if (!"descending".equals(sortOrder)) throw new ActionException("RAP_INT: Invalid sort order: " + sortOrder);
                        query.setSorting_ByValue(matchingQueryItem, selectedCell, "false");
                    }
                    container.removeSortList(nodeNameToSort);
                    continue;
                }
                if (!queryItem.isKnownAggregateForm()) continue;
                aggregateItems.add(queryItem.getDOM());
            }
            for (Element aggregateItem : aggregateItems) {
                V5QueryItem.upgradeIfKnownAggregateItem(aggregateItem, query);
            }
        }
    }

    private void removeSorting(V5DataContainer container, Document reportToModify, String item, boolean byLabel) throws ActionException {
        V5Query query = new V5Query();
        query.focusQuery(reportToModify.getRootElement(), container.getRefQuery());
        if (byLabel && item != null) {
            container.removeSortByLabel(item);
        } else {
            List<Element> nodeList = container.collectNodes();
            for (Element node : nodeList) {
                boolean detachSortingNode;
                Element setSortingNode;
                Element dataItem;
                String rdiName = container.getRDIName(node);
                if (item == null || byLabel) {
                    container.removeSortByLabel(rdiName);
                }
                if (item != null && byLabel || (dataItem = query.findItem(rdiName)) == null || (setSortingNode = dataItem.element("setSorting")) == null) continue;
                boolean bl = detachSortingNode = item == null;
                if (!detachSortingNode) {
                    List memberCaptionNodes = V5X.selectNodes(dataItem, "dmTuplePart", "dmMember", "itemCaption");
                    for (Element memberCaptionNode : memberCaptionNodes) {
                        if (!memberCaptionNode.getText().equals(item)) continue;
                        detachSortingNode = true;
                        break;
                    }
                }
                if (!detachSortingNode) {
                    List dataItemRefs = V5X.selectNodes(dataItem, "dmTuplePartDataItemRef");
                    for (Element dataItemRef : dataItemRefs) {
                        String dataItemRefRDI = dataItemRef.attributeValue("refDataItem");
                        if (dataItemRefRDI == null || !dataItemRefRDI.equals(item)) continue;
                        detachSortingNode = true;
                        break;
                    }
                }
                if (!detachSortingNode) continue;
                setSortingNode.detach();
            }
        }
    }
}

