/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5actionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.DiscreteValue;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.DynamicDataFilterResetter;
import com.cognos.rap.actions.DynamicDiscreteValuesFilter;
import com.cognos.rap.actions.DynamicRangeFilter;
import com.cognos.rap.actions.WidgetContextManager;
import com.cognos.rap.actions.v5spechelpers.MeasureFacetHelper;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.JSONUtility;
import com.cognos.rap.utility.RAPCommand;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class UpdateDataFilter
extends BaseAction {
    @Override
    public void apply(Document reportToModify, Element actionArgs) throws ActionException {
        super.apply(reportToModify, actionArgs);
        int nextPayloadItemIndex = 0;
        while ((nextPayloadItemIndex = this.applyItemFromPayload(reportToModify, actionArgs, nextPayloadItemIndex)) > 0) {
        }
    }

    private int applyItemFromPayload(Document reportToModify, Element actionArgs, int currentPayloadItemToProcess) throws ActionException {
        DynamicDataFilter dynamicDataFilter = null;
        String clientId = actionArgs.elementText("clientId");
        boolean postAutoAggregationOption = true;
        if (actionArgs.element("postAutoAggregation") != null && "false".equals(actionArgs.element("postAutoAggregation").getText())) {
            postAutoAggregationOption = false;
        }
        if (actionArgs.element("filter") != null || clientId != null) {
            dynamicDataFilter = this.processXMLFilterArgs(actionArgs, actionArgs.element("filter"), this.getRAPReport());
        } else {
            dynamicDataFilter = this.processJSONFilterArgs(actionArgs, this.getRAPReport().getModelPath(), currentPayloadItemToProcess);
            if (dynamicDataFilter == null) {
                clientId = this.getClientIdToDeleteFromJSON(actionArgs);
            }
        }
        if (dynamicDataFilter == null) {
            dynamicDataFilter = new DynamicDataFilterResetter(clientId);
        }
        if (!dynamicDataFilter.isResetter()) {
            dynamicDataFilter.setListSeparator(V5SpecHelper.getListSeparator(reportToModify));
        }
        boolean inlineValues = actionArgs.element("inlineValues") != null;
        List<Element> queryElementList = this.findQueriesToFilter(dynamicDataFilter, reportToModify);
        if (!dynamicDataFilter.isFacet() || !this.applyMeasureFacet(reportToModify, queryElementList, dynamicDataFilter)) {
            this.applyFilterToQueries(dynamicDataFilter, queryElementList, clientId, inlineValues, postAutoAggregationOption);
        }
        return dynamicDataFilter.getNextPayloadItemIndex();
    }

    public boolean applyMeasureFacet(Document reportToModify, List<Element> queryElementList, DynamicDataFilter dynamicDataFilter) throws CognosServiceRequestException {
        List<DiscreteValue> values = null;
        if (!MeasureFacetHelper.isMeasureFacetDimension(dynamicDataFilter.getName(), reportToModify)) {
            return false;
        }
        if (dynamicDataFilter instanceof DynamicDiscreteValuesFilter) {
            DynamicDiscreteValuesFilter discreteValuesFilter = (DynamicDiscreteValuesFilter)dynamicDataFilter;
            values = discreteValuesFilter.getModelAndValues().getValues();
        } else if (!(dynamicDataFilter instanceof DynamicDataFilterResetter)) {
            return false;
        }
        Element layout = V5X.selectSingleNode(reportToModify, "//V5X//CHILD", "layouts", "layout");
        ArrayList<V5DataContainer> containers = V5DataContainerFactory.createChildContainers(layout);
        MeasureFacetHelper measureFacetHelper = new MeasureFacetHelper(this.getEnv());
        for (V5DataContainer container : containers) {
            Element measureDataItem;
            V5Query v5Query = container.getV5Query();
            v5Query.setEnv(this.getEnv());
            if (dynamicDataFilter.isResetter() && ((values = measureFacetHelper.loadMeasuresAsDiscreteValues(v5Query, this.getRAPReport().getModelPath(), dynamicDataFilter.getName())) == null || values.size() == 0) || (measureDataItem = this.applyMeasureFacet(container, dynamicDataFilter.getName(), values, measureFacetHelper)) == null) continue;
            dynamicDataFilter.setFilterOutputType(DynamicDataFilter.FilterOutputType.dataItem);
            dynamicDataFilter.addFilterTags(measureDataItem, dynamicDataFilter.getClientId(), dynamicDataFilter.generateV5FilterDescriptor(), false, true);
        }
        return true;
    }

    private Element applyMeasureFacet(V5DataContainer container, String dimensionName, List<DiscreteValue> values, MeasureFacetHelper measureFacetHelper) throws CognosServiceRequestException {
        Element measureDataItem = null;
        if (measureFacetHelper.initialize(dimensionName, container)) {
            DiscreteValue finalValue;
            if (measureFacetHelper.isMeasureOnEdgeType()) {
                for (DiscreteValue value : values) {
                    DiscreteValue finalValue2 = measureFacetHelper.loadMeasureAsDiscreteValue(container.getV5Query(), this.getRAPReport().getModelPath(), dimensionName, value.getCaption());
                    if (finalValue2 == null) continue;
                    measureDataItem = measureFacetHelper.addUpdateMeasureOnEdge(container, finalValue2);
                }
            } else if (measureFacetHelper.isDefaultMeasureType() && (finalValue = measureFacetHelper.loadMeasureAsDiscreteValue(container.getV5Query(), this.getRAPReport().getModelPath(), dimensionName, values.get(0).getCaption())) != null) {
                measureDataItem = measureFacetHelper.addUpdateDefaultMeasure(container, finalValue);
            }
        }
        return measureDataItem;
    }

    private void applyFilterToQueries(DynamicDataFilter dynamicDataFilter, List<Element> queryElementList, String clientId, boolean inlineValues, boolean postAutoAggregationOption) throws ActionException {
        this.modifyFilterIfReportItemIsInMultipleNamespaces(dynamicDataFilter, queryElementList);
        boolean protectedFilter = false;
        String paramNameToDelete = null;
        V5Query query = new V5Query();
        if (dynamicDataFilter.isResetter() && dynamicDataFilter.getClientId() == null) {
            this.getRAPReport().setReportModificationSafeForSecondaryRequest(false);
            V5Query.removeAllDynamicDataFilters(this.getReport().getDOM().getRootElement(), true);
            return;
        }
        for (Element queryElement : queryElementList) {
            query.focusQuery(queryElement, queryElement.attributeValue("name"));
            if (dynamicDataFilter.isResetter()) {
                Element ddf = query.findDynamicDataFilter(clientId);
                if (ddf != null) {
                    paramNameToDelete = V5SpecHelper.getXMLAttribute(ddf, "RAP_DataFilterParam");
                    if (!protectedFilter) {
                        protectedFilter = V5SpecHelper.getXMLAttribute(ddf, "RAP_DataFilterProtected") != null;
                    }
                }
                this.getRAPReport().setReportModificationSafeForSecondaryRequest(false);
                query.removeDynamicDataFilter((DynamicDataFilterResetter)dynamicDataFilter, true);
                continue;
            }
            dynamicDataFilter.setInlineValues(inlineValues);
            query.updateDynamicDataFilter(this.getEnv(), dynamicDataFilter, postAutoAggregationOption);
        }
        this.updateParameter(dynamicDataFilter, inlineValues, protectedFilter, paramNameToDelete);
    }

    private void modifyFilterIfReportItemIsInMultipleNamespaces(DynamicDataFilter dynamicDataFilter, List<Element> queryElementList) throws ActionException {
        if (dynamicDataFilter != null && dynamicDataFilter.getClass() == DynamicDiscreteValuesFilter.class && queryElementList.size() > 1) {
            String hun = null;
            for (Element queryElement : queryElementList) {
                V5Query query = new V5Query(queryElement, queryElement.attributeValue("name"));
                Element queryItemToFilter = query.findItem(dynamicDataFilter.getRDIName());
                if (queryItemToFilter == null) continue;
                V5QueryItem queryItem = new V5QueryItem(this.getEnv(), query, queryItemToFilter);
                queryItem.setEvaluateSpecOnly(true);
                if (!queryItem.confirmIsSetOrMember()) continue;
                if (hun == null) {
                    hun = queryItem.getProperties()._hun;
                    continue;
                }
                if (hun.equals(queryItem.getProperties()._hun)) continue;
                dynamicDataFilter.setMultipleNamespaceReportItem(true);
                break;
            }
        }
    }

    private void updateParameter(DynamicDataFilter dynamicDataFilter, boolean inlineValues, boolean protectedFilter, String paramNameToDelete) {
        if (this.getRAPReport() != null && !inlineValues) {
            if (!dynamicDataFilter.isResetter()) {
                this.getRAPReport().addParamUpdate(dynamicDataFilter.getParamName(), dynamicDataFilter.getSelectChoices());
            } else if (!protectedFilter && paramNameToDelete != null) {
                this.getRAPReport().addParamUpdate(paramNameToDelete, null);
            }
        }
    }

    public List<Element> findQueriesToFilter(DynamicDataFilter dynamicDataFilter, Document reportToModify) {
        int size;
        List<Element> potentialQueriesToFilter = V5Query.getQueryNodes(reportToModify.getRootElement());
        if (dynamicDataFilter != null && DynamicRangeFilter.class == dynamicDataFilter.getClass()) {
            this.eliminateMasterQueriesFromQueryListForDetailRanges(dynamicDataFilter.getName(), potentialQueriesToFilter, reportToModify);
        }
        if ((size = potentialQueriesToFilter.size()) == 0) {
            return potentialQueriesToFilter;
        }
        HashSet<String> queriesInLayout = V5SpecHelper.getQueriesInLayout(reportToModify.getRootElement());
        ArrayList<Element> queriesToFilter = new ArrayList<Element>();
        for (Element query : potentialQueriesToFilter) {
            String queryName = query.attributeValue("name");
            if (!queriesInLayout.contains(queryName)) continue;
            queriesToFilter.add(query);
        }
        return queriesToFilter;
    }

    private void eliminateMasterQueriesFromQueryListForDetailRanges(String rangeItemName, List<Element> queriesToFilter, Document reportToModify) {
        List mdLinkNodes = V5X.selectNodes(reportToModify, "//V5X//CHILD", "layouts", "layout", "//V5X//ANY", "masterDetailLink");
        for (Element mdLinkNode : mdLinkNodes) {
            Element parentWithRefQuery;
            V5Query detailQuery;
            Element detailContainer = V5SpecHelper.findParentContainer(mdLinkNode);
            if (detailContainer == null || detailContainer.attributeValue("refQuery") == null || (detailQuery = new V5Query(detailContainer, detailContainer.attributeValue("refQuery"))).findItem(rangeItemName) == null) continue;
            for (parentWithRefQuery = detailContainer.getParent(); parentWithRefQuery != null && parentWithRefQuery.attribute("refQuery") == null; parentWithRefQuery = parentWithRefQuery.getParent()) {
            }
            if (parentWithRefQuery == null) continue;
            V5Query masterQuery = new V5Query(parentWithRefQuery, parentWithRefQuery.attributeValue("refQuery"));
            queriesToFilter.remove(masterQuery.getQueryElement());
            if (!V5SpecHelper.ifInnerMostDetailContainerWithSameQuery(parentWithRefQuery.attributeValue("refQuery"), detailContainer)) continue;
            V5Query newDetailQuery = V5SpecHelper.cloneQueryAndRedirectContainer(detailContainer, detailQuery);
            queriesToFilter.add(newDetailQuery.getQueryElement());
        }
    }

    private String getClientIdToDeleteFromJSON(Element actionArgs) throws ActionException {
        JSONObject filterDefinitionJSON = JSONUtility.parse(actionArgs.getText());
        if (filterDefinitionJSON != null) {
            return (String)filterDefinitionJSON.get((Object)"clientId");
        }
        return null;
    }

    private DynamicDataFilter processJSONFilterArgs(Element actionArgs, String reportModelPath, int currentPayloadItemToProcess) throws ActionException {
        DynamicDataFilter dataFilter = null;
        if (actionArgs.getText() != null) {
            JSONObject filterDefinitionJSON = JSONUtility.parse(actionArgs.getText());
            String clientId = actionArgs.elementText("clientId");
            if (filterDefinitionJSON != null) {
                if ("true".equals(filterDefinitionJSON.get(RAPCommand.removeAll))) {
                    return null;
                }
                if (WidgetContextManager.isSelectValueControlContext(filterDefinitionJSON)) {
                    WidgetContextManager wcm = new WidgetContextManager(filterDefinitionJSON);
                    clientId = wcm.getSelectValueControlContext().getId();
                    dataFilter = wcm.containsRangeSpec() ? new DynamicRangeFilter(clientId, reportModelPath) : (wcm.containsValueSpec() ? new DynamicDiscreteValuesFilter(clientId, reportModelPath) : new DynamicDataFilterResetter(clientId));
                    dataFilter.setCurrentPayloadItemIndex(currentPayloadItemToProcess);
                    dataFilter.initialize(filterDefinitionJSON);
                } else {
                    if (clientId == null) {
                        clientId = (String)filterDefinitionJSON.get((Object)"clientId");
                    }
                    if (filterDefinitionJSON.get((Object)"name") != null) {
                        dataFilter = filterDefinitionJSON.get((Object)"min") != null || filterDefinitionJSON.get((Object)"max") != null ? new DynamicRangeFilter(clientId, reportModelPath) : new DynamicDiscreteValuesFilter(clientId, reportModelPath);
                        dataFilter.initialize(filterDefinitionJSON);
                    }
                }
            }
            return dataFilter;
        }
        return null;
    }

    private DynamicDataFilter processXMLFilterArgs(Element actionArgs, Element filterArg, RAPReport rapReport) {
        String clientId = actionArgs.elementText("clientId");
        if (clientId == null && filterArg != null && (clientId = filterArg.elementText("clientId")) == null) {
            Element filterValueElement = (Element)filterArg.selectSingleNode("./*[local-name()='condition']/*[local-name()='filterValue']");
            clientId = filterValueElement.elementText("name");
        }
        if (clientId != null && filterArg != null) {
            V5List goDashboardListPart;
            Element actualRDINode;
            DynamicDataFilter dataFilter = null;
            Element filterValueElement = (Element)filterArg.selectSingleNode("./*[local-name()='condition']/*[local-name()='filterValue']");
            Element valuesTypeElement = (Element)filterValueElement.selectSingleNode("./*[local-name()='valuesType']");
            if (valuesTypeElement != null && "datetime".equals(valuesTypeElement.getText())) {
                return null;
            }
            dataFilter = "DISCRETE".equals(filterValueElement.elementText("type")) ? new DynamicDiscreteValuesFilter(clientId, rapReport.getModelPath()) : new DynamicRangeFilter(clientId, rapReport.getModelPath());
            dataFilter.initializeFromXML(filterValueElement);
            Element listPart = V5X.selectSingleNode(rapReport.getDOM(), "//V5X//CHILD", "layouts", "layout", "//V5X//ANY", "list");
            if (listPart != null && V5X.selectSingleNode(listPart, "//V5X//CHILDATTR", "refDataItem", dataFilter.getName()) == null && (actualRDINode = (goDashboardListPart = (V5List)V5DataContainerFactory.create(listPart)).findRDINodeByStaticTextTitle(this.getEnv(), clientId, null)) != null) {
                dataFilter.setCustomRDIName(actualRDINode.attributeValue("refDataItem"));
            }
            return dataFilter;
        }
        return null;
    }
}

