/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5infoactionset;

import com.cognos.rap.actions.FilterValuesInfo;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.rap.actions.v5actionset.ExtractReportPart;
import com.cognos.rap.actions.v5requestcreators.V5DiscreteValuesRequest;
import com.cognos.rap.actions.v5requestcreators.V5MaxMinRangeRequest;
import com.cognos.rap.actions.v5requestcreators.V5NumberFormatRequest;
import com.cognos.rap.actions.v5requestcreators.V5ReportRequest;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5ContextSlicer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5Singleton;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class CollectFilterValues
extends ExtractReportPart {
    private String _preCalculatedMin = null;
    private String _preCalculatedMax = null;
    private boolean _singlePageReport = false;
    private int _currentBlockSize = 150;
    private int _rerunThreshold = 5;
    private int _maxRowsRangeRequest = 1000;

    @Override
    public void apply(Document reportDoc, Element actionArgs) throws ActionException {
        RAPReport report = this.getRAPReport();
        List<Element> v5ContainerElementList = V5SpecHelper.findLayoutElementsFromActionArguments(report.getDOM(), actionArgs);
        ReportInfo reportInfo = (ReportInfo)report.getReportInfo();
        if (reportInfo == null) {
            reportInfo = new ReportInfo();
            report.setReportInfo(reportInfo);
        }
        Element nameToGetValuesFor = (Element)actionArgs.selectSingleNode(".//*[local-name()='item']/*[local-name()='name']");
        boolean isRange = false;
        Element rangeEl = (Element)actionArgs.selectSingleNode(".//*[local-name()='item']/*[local-name()='range']");
        if (rangeEl != null && "true".equals(rangeEl.getText())) {
            isRange = true;
        }
        Element modelItem = (Element)actionArgs.selectSingleNode(".//*[local-name()='modelItem']");
        Element currentFilterSort = (Element)actionArgs.selectSingleNode(".//*[local-name()='item']/*[local-name()='currentFilterSort']");
        String modelPath = reportDoc.getRootElement().elementText("modelPath");
        boolean isCurrentFilterSortingOn = true;
        if (currentFilterSort != null && currentFilterSort.getText() != null && Integer.parseInt(currentFilterSort.getText()) == 0) {
            isCurrentFilterSortingOn = false;
        }
        String keyColumn = null;
        if (modelItem != null && modelItem.getText() != null) {
            keyColumn = FilterValuesInfo.findAssociatedKeyColumn(this.getEnv(), modelPath, modelItem.getText());
        }
        V5Query businessInsightQueryWithItem = V5Query.findBusinessInsightQuery(reportDoc, this.getLocale(), nameToGetValuesFor.getText());
        V5DataContainer dataContainer = null;
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(v5ContainerElementList);
        while (containerInDomainIter.hasNext()) {
            dataContainer = containerInDomainIter.next();
            if (dataContainer == null) continue;
            V5Query containerQuery = new V5Query(dataContainer.getContainerElement(), dataContainer.getRefQuery());
            if (dataContainer.findItem(nameToGetValuesFor.getText()) == null && dataContainer.findListGroup(nameToGetValuesFor.getText()) == null && (dataContainer.getDefaultMeasure() == null || !nameToGetValuesFor.getText().equals(dataContainer.getDefaultMeasure().attributeValue("refDataItem"))) && containerQuery.findContextSlicer(nameToGetValuesFor.getText()) == null && !containerQuery.isAdditionalDynamicFilterItem(nameToGetValuesFor.getText())) continue;
            if (businessInsightQueryWithItem != null) break;
            FilterValuesInfo fvi = this.collectFilterValues(report.getDOM(), dataContainer, nameToGetValuesFor.getText(), isCurrentFilterSortingOn, keyColumn);
            if (!fvi.populated() && fvi.getKeyColumn() != null) {
                fvi = this.collectFilterValues(report.getDOM(), dataContainer, nameToGetValuesFor.getText(), isCurrentFilterSortingOn, fvi.getKeyColumn());
            }
            reportInfo.setFilterValuesInfo(fvi);
            break;
        }
        if (businessInsightQueryWithItem != null) {
            for (int i = v5ContainerElementList.size() - 1; i >= 0; --i) {
                FilterValuesInfo biQueryValuesInfo;
                dataContainer = V5DataContainerFactory.create(reportDoc.getRootElement(), v5ContainerElementList.get(i).attributeValue("name"));
                if (dataContainer == null || (biQueryValuesInfo = this.processBIQuery(businessInsightQueryWithItem, nameToGetValuesFor.getText(), isCurrentFilterSortingOn, keyColumn, dataContainer, v5ContainerElementList.get(i), isRange)) == null) continue;
                reportInfo.setFilterValuesInfo(biQueryValuesInfo);
                break;
            }
        }
    }

    private FilterValuesInfo processBIQuery(V5Query biQuery, String nameToGetValuesFor, boolean isCurrentFilterSortingOn, String keyColumn, V5DataContainer containerUsed, Element firstContainerElement, boolean isRange) throws ActionException {
        if (biQuery == null) {
            return null;
        }
        V5Query containerQuery = biQuery;
        V5DataContainer dataContainer = containerUsed;
        Element report = biQuery.getQueryElement().getDocument().getRootElement();
        if (dataContainer == null) {
            dataContainer = V5DataContainerFactory.create(report, firstContainerElement.attributeValue("name"));
        }
        if (dataContainer != null) {
            containerQuery = new V5Query(dataContainer.getContainerElement(), dataContainer.getRefQuery());
        }
        FilterValuesInfo filterValuesInfo = null;
        if (containerQuery.findItem(nameToGetValuesFor) != null) {
            filterValuesInfo = new FilterValuesInfo(nameToGetValuesFor);
            filterValuesInfo.setModelPath(report.elementText("modelPath"));
            filterValuesInfo.setKeyColumn(keyColumn);
            filterValuesInfo.setEnv(this.getEnv());
            V5QueryItem queryItem = new V5QueryItem(this.getEnv(), containerQuery, containerQuery.findItem(nameToGetValuesFor));
            if (isRange) {
                this.collectRange(report.getDocument(), dataContainer, nameToGetValuesFor, filterValuesInfo);
            } else {
                this.collectDiscreteValues(report.getDocument(), queryItem, dataContainer, nameToGetValuesFor, isCurrentFilterSortingOn, keyColumn, filterValuesInfo);
            }
        }
        return filterValuesInfo;
    }

    private FilterValuesInfo collectFilterValues(Document report, V5DataContainer sourceContainer, String nameToGetValuesFor, boolean isCurrentFilterSortingOn, String keyColumn) throws CognosServiceRequestException, ActionException {
        FilterValuesInfo filterValuesInfo = null;
        V5Query query = new V5Query();
        if (query.focusQuery(report.getRootElement(), sourceContainer.getRefQuery()) && (query.findItem(nameToGetValuesFor) != null || query.findContextSlicer(nameToGetValuesFor) != null)) {
            filterValuesInfo = new FilterValuesInfo(nameToGetValuesFor);
            filterValuesInfo.setModelPath(report.getRootElement().elementText("modelPath"));
            filterValuesInfo.setKeyColumn(keyColumn);
            filterValuesInfo.setEnv(this.getEnv());
            if (query.findItem(nameToGetValuesFor) != null) {
                V5QueryItem queryItem = new V5QueryItem(this.getEnv(), query, query.findItem(nameToGetValuesFor));
                if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_USE_GET_PARAMS_REQ_FOR_FILTERITEM")) {
                    queryItem.setUseGetParamReqForFiltItem(true);
                }
                if (queryItem.confirmIsNumeric() && queryItem.getNumericSubType() != V5QueryItem.NumericSubType.dataValues) {
                    this.collectRange(report, sourceContainer, nameToGetValuesFor, filterValuesInfo);
                } else {
                    this.collectDiscreteValues(report, queryItem, sourceContainer, nameToGetValuesFor, isCurrentFilterSortingOn, keyColumn, filterValuesInfo);
                }
            } else {
                this.collectDiscreteValuesForContextSlicer(report, sourceContainer, nameToGetValuesFor, isCurrentFilterSortingOn, filterValuesInfo);
            }
        }
        return filterValuesInfo;
    }

    private void addWaitOptions(CognosServiceOptions options) {
        String primaryOverride = CognosViewerDispatcherHandler.getConfigValues().getProperty("ViewerPrimaryWaitThreshold");
        if (primaryOverride == null) {
            primaryOverride = "60";
        }
        options.addOption("asynch.primaryWaitThreshold", primaryOverride);
        String secondaryOverride = CognosViewerDispatcherHandler.getConfigValues().getProperty("ViewerSecondaryWaitThreshold");
        if (secondaryOverride == null) {
            secondaryOverride = "60";
        }
        options.addOption("asynch.secondaryWaitThreshold", secondaryOverride);
        options.setRapWaitDisabled(true);
    }

    private void addPromptOptions(CognosServiceOptions options) {
        options.addOption("run.promptFormat", "HTMLFragment");
        options.addOption("run.xslURL", "sa.xsl");
        options.addOption("run.prompt", "false");
    }

    private void collectRange(Document report, V5DataContainer sourceContainer, String nameToGetValuesFor, FilterValuesInfo filterValuesInfo) throws ActionException {
        filterValuesInfo.setRangeValue();
        if ((sourceContainer instanceof V5List || sourceContainer instanceof V5Singleton) && V5DataContainerFactory.createChildContainers(sourceContainer.getContainerElement()).isEmpty()) {
            V5MaxMinRangeRequest minmaxReport = new V5MaxMinRangeRequest(this.getEnv(), sourceContainer, nameToGetValuesFor, null, null);
            if (sourceContainer instanceof V5List) {
                minmaxReport.setRowRetrievalLimit(this._maxRowsRangeRequest);
            }
            ((V5ReportRequest)minmaxReport).create();
            CognosServiceOptions options = new CognosServiceOptions();
            options.addOption("run.outputFormat", "layoutDataXML");
            this.addWaitOptions(options);
            CognosServiceResponse ldxResponse = this.getRapServiceRequestManager().runReportSpecification(minmaxReport.getDocument().asXML(), options);
            if (ldxResponse != null && ldxResponse.getDOMValue() != null) {
                this.processLDXRangeResponse(ldxResponse.getDOMValue(), filterValuesInfo, nameToGetValuesFor);
            }
            return;
        }
        if (this._singlePageReport && this._preCalculatedMin != null && this._preCalculatedMax != null && !V5SpecHelper.hasDynamicDataFilters(report.getRootElement())) {
            filterValuesInfo.populateRange(this._preCalculatedMin, this._preCalculatedMax, null, null);
        } else {
            for (int i = 0; i < this._rerunThreshold; ++i) {
                String contextData;
                V5MaxMinRangeRequest minmaxReport = new V5MaxMinRangeRequest(this.getEnv(), sourceContainer, nameToGetValuesFor, this._preCalculatedMin, this._preCalculatedMax);
                ((V5ReportRequest)minmaxReport).create();
                if (minmaxReport.getDocument() == null) continue;
                CognosServiceOptions options = new CognosServiceOptions();
                options.addOption("run.xslURL", "null.xsl");
                options.addOption("run.verticalElements", "0");
                this.addWaitOptions(options);
                CognosServiceResponse response = this.getRapServiceRequestManager().runReportSpecification(minmaxReport.getDocument().asXML(), options);
                if (response == null) continue;
                String metaData = response.getJSONMetaDataBlock();
                int ctxEntriesProcessed = filterValuesInfo.populateRange(this._preCalculatedMin, this._preCalculatedMax, metaData, contextData = response.getJSONContextDataBlock());
                if (ctxEntriesProcessed < this._currentBlockSize || filterValuesInfo.getRangeValue() == null) break;
                this._preCalculatedMin = filterValuesInfo.getRangeValue().getMin();
                this._preCalculatedMax = filterValuesInfo.getRangeValue().getMax();
            }
        }
        V5NumberFormatRequest numberFormatReport = new V5NumberFormatRequest(this.getEnv(), sourceContainer, nameToGetValuesFor);
        ((V5ReportRequest)numberFormatReport).create();
        if (numberFormatReport.getDocument() != null) {
            CognosServiceOptions options = new CognosServiceOptions();
            options.addOption("run.outputFormat", "layoutDataXML");
            this.addWaitOptions(options);
            Element ldxResponse = this.getRapServiceRequestManager().executeQuery(numberFormatReport.getDocument(), options);
            if (ldxResponse != null) {
                filterValuesInfo.populateNumberFormatFromLDX(ldxResponse);
            }
        }
    }

    private void collectDiscreteValues(Document report, V5QueryItem queryItem, V5DataContainer sourceContainer, String nameToGetValuesFor, boolean isCurrentFilterSortingOn, String keyColumn, FilterValuesInfo filterValuesInfo) throws ActionException {
        V5DiscreteValuesRequest discreteValuesReport = null;
        if (queryItem.confirmIsSet() || queryItem.getItemType() == V5QueryItem.ItemType.member) {
            discreteValuesReport = new V5DiscreteValuesRequest(sourceContainer, nameToGetValuesFor, isCurrentFilterSortingOn, keyColumn, true);
        } else {
            if (keyColumn == null && queryItem.getProperties() != null && queryItem.getProperties().getModelItem() != null) {
                keyColumn = FilterValuesInfo.findAssociatedKeyColumn(this.getEnv(), report.getRootElement().elementText("modelPath"), queryItem.getProperties().getModelItem());
            }
            discreteValuesReport = new V5DiscreteValuesRequest(sourceContainer, nameToGetValuesFor, isCurrentFilterSortingOn, keyColumn, false);
        }
        discreteValuesReport.create();
        this.collectDiscreteValues(discreteValuesReport, filterValuesInfo);
    }

    private void collectDiscreteValues(V5DiscreteValuesRequest discreteValuesReport, FilterValuesInfo filterValuesInfo) throws ActionException {
        CognosServiceOptions options = new CognosServiceOptions();
        options.addOption("run.outputFormat", "XML");
        options.addOption("run.verticalElements", "0");
        options.addOption("run.selectionBasedFeatures", "false");
        this.addPromptOptions(options);
        this.addWaitOptions(options);
        Element response = this.getRapServiceRequestManager().executeQuery(discreteValuesReport.getDocument(), options);
        if (response != null && filterValuesInfo.populateDiscreteValues(response) == 0) {
            discreteValuesReport.disableFilters();
            response = this.getRapServiceRequestManager().executeQuery(discreteValuesReport.getDocument(), options);
            if (response != null) {
                filterValuesInfo.populateDiscreteValues(response);
            }
        }
    }

    public void collectDiscreteValuesForContextSlicer(Document report, V5DataContainer sourceContainer, String nameToGetValuesFor, boolean isCurrentFilterSortingOn, FilterValuesInfo filterValuesInfo) throws ActionException {
        Element initialContextSlicer;
        V5DiscreteValuesRequest discreteValuesReport = new V5DiscreteValuesRequest(sourceContainer, nameToGetValuesFor, isCurrentFilterSortingOn, null, true);
        V5Query sourceV5Query = sourceContainer.getV5Query();
        Element contextSlicer = sourceV5Query.findContextSlicer(nameToGetValuesFor);
        if (contextSlicer != null && (initialContextSlicer = V5ContextSlicer.SliderInfo.loadInitial(contextSlicer)) != null) {
            discreteValuesReport.setContextSlicer(initialContextSlicer);
            discreteValuesReport.create();
            this.collectDiscreteValues(discreteValuesReport, filterValuesInfo);
        }
    }

    private void processLDXRangeResponse(Element ldxResponse, FilterValuesInfo filterValuesInfo, String rdiName) {
        Element ref = (Element)ldxResponse.selectSingleNode("*[local-name()='locationReference'][contains(*[local-name()='loc'], 'listColumnBody') or contains(*[local-name()='loc'], 'singleton')][*[local-name()='di']='" + rdiName + "']/*[local-name()='ref']");
        Element minItem = null;
        Element maxItem = null;
        String refText = ref.getText();
        if (refText != null) {
            List referencers = V5X.selectNodes(ldxResponse, "//V5X//CHILD", "pages", "//V5X//ANY", "lst", "cell", "item", "ref", "//V5X//PREDICATE", "text", refText);
            List refSingletons = V5X.selectNodes(ldxResponse, "//V5X//CHILD", "pages", "//V5X//ANY", "sngl", "item", "ref", "//V5X//PREDICATE", "text", refText);
            if (refSingletons.size() > 0) {
                if (referencers.size() == 0) {
                    referencers = refSingletons;
                } else {
                    referencers.addAll(refSingletons);
                }
            }
            if (referencers.size() >= this._maxRowsRangeRequest) {
                Element currentItem = ((Element)referencers.get(0)).getParent();
                filterValuesInfo.populateRangeFormatAndScaleInfo(currentItem);
                return;
            }
            Double rangeMin = null;
            Double rangeMax = null;
            for (Element referencer : referencers) {
                Element currentItem = referencer.getParent();
                String valNodeText = currentItem.elementText("val");
                if (valNodeText == null || valNodeText.length() <= 0) continue;
                try {
                    Double currentValue = Double.valueOf(valNodeText);
                    if (rangeMin == null || currentValue < rangeMin) {
                        rangeMin = currentValue;
                        minItem = currentItem;
                    }
                    if (rangeMax != null && !(currentValue > rangeMax)) continue;
                    rangeMax = currentValue;
                    maxItem = currentItem;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        filterValuesInfo.populateRangeEndPointsFromLDX(minItem, maxItem);
    }

    public int get_maxRowsRangeRequest() {
        return this._maxRowsRangeRequest;
    }

    public void set_maxRowsRangeRequest(int _maxRowsRangeRequest) {
        this._maxRowsRangeRequest = _maxRowsRangeRequest;
    }
}

