/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5infoactionset;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.FilterableItemsInfo;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.rap.actions.v5spechelpers.MemberSetsAndDrillBehaviors;
import com.cognos.rap.actions.v5spechelpers.QueryItemPropertyManager;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class CollectFilterableItems
extends BaseAction {
    @Override
    public void apply(Document reportDoc, Element actionArgs) throws ActionException {
        RAPReport report = this.getRAPReport();
        ReportInfo reportInfo = (ReportInfo)report.getReportInfo();
        if (reportInfo == null) {
            reportInfo = new ReportInfo();
            report.setReportInfo(reportInfo);
        }
        boolean includeMembers = actionArgs != null && actionArgs.selectSingleNode("./*[local-name()='includeMembers']") != null;
        List<Element> v5ContainerElementList = V5SpecHelper.findLayoutElementsFromActionArguments(report.getDOM(), actionArgs);
        FilterableItemsInfo filterableItems = new FilterableItemsInfo();
        ReportInfo ri = (ReportInfo)report.getReportInfo();
        ri.setFilterableItemsInfo(filterableItems);
        this.processLayouts(report, v5ContainerElementList, filterableItems, includeMembers);
        this.processBusinessInsightQuery(report, v5ContainerElementList, filterableItems, includeMembers);
        List queryElements = XMLUtility.selectNodes(report.getDOM(), V5X.select("query"));
        V5Query v5Query = new V5Query();
        for (Element queryElement : queryElements) {
            v5Query.focusQuery(queryElement);
            v5Query.getItemList().collectFilterableItems(this.getEnv(), filterableItems, includeMembers);
        }
        QueryItemPropertyManager qipm = new QueryItemPropertyManager(this.getEnv(), v5Query);
        qipm.localizeItemLabels(filterableItems.getItemLabels());
    }

    private boolean preprocessCandidateFilterableItem(MemberSetsAndDrillBehaviors memberSetsAndBehaviors, V5Query v5Query, Element dataItemElement, String rdiName, boolean includeMembers) {
        if (memberSetsAndBehaviors.hasMemberSet(rdiName) && memberSetsAndBehaviors.findBehaviorTypeForSet(rdiName) == null || "replaceItem".equals(memberSetsAndBehaviors.findBehaviorTypeForSet(rdiName))) {
            return false;
        }
        if (dataItemElement.elementText("expression") != null) {
            V5QueryItem qi = new V5QueryItem(this.getEnv(), v5Query, dataItemElement);
            if (qi.isKnownAggregateForm()) {
                return false;
            }
            if (!includeMembers && qi.isKnownMunForm()) {
                return false;
            }
        }
        return true;
    }

    private HashSet<String> processLayouts(RAPReport report, List<Element> v5ContainerElementList, FilterableItemsInfo filterableItems, boolean includeMembers) throws ActionException {
        V5Query biQuery = V5Query.findBusinessInsightQuery(report.getDOM(), this.getLocale());
        LocalePruner localePruner = new LocalePruner(this.getEnv().getLocale());
        Document localizedReport = localePruner.pruneReportForCurrentLocale(report.getDOM());
        MemberSetsAndDrillBehaviors memberSetsAndBehaviors = new MemberSetsAndDrillBehaviors(localizedReport);
        memberSetsAndBehaviors.initialize();
        HashSet<String> processedQueries = new HashSet<String>();
        if (!V5SpecHelper.isDetailFilteringAvailable(report.getDOM().getRootElement())) {
            return processedQueries;
        }
        HashSet<Element> linkedSetItemsAdded = new HashSet<Element>();
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(v5ContainerElementList);
        while (containerInDomainIter.hasNext()) {
            V5DataContainer container = containerInDomainIter.next();
            if (container == null) continue;
            V5Query v5Query = new V5Query();
            v5Query.focusQuery(container.getContainerElement(), container.getRefQuery());
            List visibleNodes = V5X.selectNodes(container.getContainerElement(), "//V5X//ANYCHILD", "//V5X//EXCEPT_TAG", "propertyItem", "//V5X//ATTR_IFNONEMPTY", "refDataItem");
            for (Element visibleNode : visibleNodes) {
                Element dataItemOrSubtype;
                if (!CollectFilterableItems.isValidSliderNode(visibleNode)) continue;
                String rdiName = visibleNode.attributeValue("refDataItem");
                if (biQuery != null && biQuery.findItem(rdiName) != null || (dataItemOrSubtype = v5Query.findItem(rdiName)) == null || dataItemOrSubtype.getName().equals("dataItemCalculatedMember") || !this.preprocessCandidateFilterableItem(memberSetsAndBehaviors, v5Query, dataItemOrSubtype, rdiName, includeMembers)) continue;
                Element linkedSetItem = V5SpecHelper.getLinkedSetItem(v5Query, dataItemOrSubtype);
                if (linkedSetItem != null) {
                    if (linkedSetItemsAdded.contains(linkedSetItem)) continue;
                    linkedSetItemsAdded.add(dataItemOrSubtype);
                }
                String userLabel = container.getBestItemLabel(rdiName, this.getEnv());
                v5Query.addFilterableItem(this.getEnv(), filterableItems, dataItemOrSubtype, true, userLabel, includeMembers);
            }
        }
        return processedQueries;
    }

    private void processBusinessInsightQuery(RAPReport report, List<Element> v5ContainerElementList, FilterableItemsInfo filterableItems, boolean includeMembers) throws ActionException {
        V5Query biQuery = V5Query.findBusinessInsightQuery(report.getDOM(), this.getLocale());
        if (biQuery == null) {
            return;
        }
        V5Query.ItemList biQueryItems = biQuery.getItemList();
        V5Query containerQueryWithItem = null;
        for (Element dataItemOrSubtype : biQueryItems.getDataItemElements()) {
            String itemName = dataItemOrSubtype.attributeValue("name");
            String userLabel = dataItemOrSubtype.attributeValue("label");
            userLabel = userLabel == null ? itemName : userLabel;
            String expression = dataItemOrSubtype.elementText("expression");
            if (expression != null && "null".equals(expression) || (containerQueryWithItem = this.findFirstContainerQueryWithItem(containerQueryWithItem, v5ContainerElementList, itemName)) == null) continue;
            containerQueryWithItem.addFilterableItem(this.getEnv(), filterableItems, dataItemOrSubtype, true, userLabel, includeMembers);
        }
    }

    public V5Query findFirstContainerQueryWithItem(V5Query previousContainerQuery, List<Element> containerElementList, String itemName) {
        if (previousContainerQuery != null && previousContainerQuery.findItem(itemName) != null) {
            return previousContainerQuery;
        }
        V5ContainerInDomainIterator iter = new V5ContainerInDomainIterator(containerElementList);
        while (iter.hasNext()) {
            V5DataContainer container = iter.next();
            V5Query containerQuery = container.getV5Query();
            if (containerQuery.findItem(itemName) == null) continue;
            return containerQuery;
        }
        return null;
    }

    public static boolean isValidSliderNode(Element rdiLayoutElement) {
        Element parentContainer = V5SpecHelper.findParentContainer(rdiLayoutElement);
        if (parentContainer != null && "list".equals(parentContainer.getName())) {
            return CollectFilterableItems.isValidListSliderNode(rdiLayoutElement);
        }
        return rdiLayoutElement.attributeValue("refDataItem") != null && !"dataItemLabel".equals(rdiLayoutElement.getName()) && !"dataItemContext".equals(rdiLayoutElement.getName());
    }

    private static boolean isValidListSliderNode(Element layoutNode) {
        if (layoutNode == null || layoutNode.attributeValue("refDataItem") == null) {
            return false;
        }
        if ("listGroup".equals(layoutNode.getName())) {
            return true;
        }
        if ("listColumnRowSpan".equals(layoutNode.getName())) {
            return false;
        }
        for (Element searchElement = layoutNode; searchElement != null && !"list".equals(searchElement.getName()); searchElement = searchElement.getParent()) {
            if (!"listColumnBody".equals(searchElement.getName())) continue;
            return true;
        }
        return false;
    }

    public class LocalePruner {
        private String _currentLocale = null;

        public LocalePruner(String currentLocale) {
            this._currentLocale = currentLocale;
        }

        protected Document pruneReportForCurrentLocale(Document report) {
            V5Variables localeVariables = new V5Variables(report.getRootElement());
            List<String> localeVariableNames = localeVariables.findLocaleVariables();
            if (localeVariableNames == null) {
                return report;
            }
            List allConditionalBlocksNodes = V5X.selectNodes(report, "//V5X//CHILD", "layouts", "//V5X//ANY", "conditionalBlocks");
            if (allConditionalBlocksNodes.size() == 0) {
                return report;
            }
            Document localizedReport = (Document)report.clone();
            allConditionalBlocksNodes = V5X.selectNodes(localizedReport, "//V5X//CHILD", "layouts", "//V5X//ANY", "conditionalBlocks");
            for (Element thisConditionalBlocksNode : allConditionalBlocksNodes) {
                boolean anyConditionalBlockIncluded = false;
                for (String localeVariableName : localeVariableNames) {
                    Element conditionalBlockCasesNodeForVariable = V5X.selectSingleNode(thisConditionalBlocksNode, "//V5X//CHILD", "conditionalBlockCases", "//V5X//ATTR", "refVariable", localeVariableName);
                    if (conditionalBlockCasesNodeForVariable == null || !this.processConditionalBlockCasesForVariable(conditionalBlockCasesNodeForVariable)) continue;
                    anyConditionalBlockIncluded = true;
                }
                if (!anyConditionalBlockIncluded) continue;
                this.removeDefaultConditionalBlockContents(thisConditionalBlocksNode);
            }
            return localizedReport;
        }

        private boolean processConditionalBlockCasesForVariable(Element conditionalBlockCases) {
            boolean conditionalBlockKept = false;
            List conditionalBlocks = conditionalBlockCases.elements("conditionalBlock");
            for (Element conditionalBlock : conditionalBlocks) {
                String variableValueForBlock = conditionalBlock.attributeValue("refVariableValue");
                if (variableValueForBlock == null) continue;
                if (this._currentLocale.startsWith(variableValueForBlock)) {
                    conditionalBlockKept = true;
                    continue;
                }
                conditionalBlock.detach();
            }
            return conditionalBlockKept;
        }

        private void removeDefaultConditionalBlockContents(Element conditionalBlocks) {
            Element conditionalBlockDefault = conditionalBlocks.element("conditionalBlockDefault");
            if (conditionalBlockDefault != null) {
                conditionalBlockDefault.detach();
                conditionalBlockDefault = conditionalBlocks.addElement("conditionalBlockDefault");
                conditionalBlockDefault.addElement("contents");
            }
        }
    }
}

