/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5infoactionset;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.DataContainerInfo;
import com.cognos.rap.actions.DrillabilityInfo;
import com.cognos.rap.actions.FilterInfo;
import com.cognos.rap.actions.ItemInfo;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.rap.actions.SlicerInfo;
import com.cognos.rap.actions.SortInfo;
import com.cognos.rap.actions.SortReference;
import com.cognos.rap.actions.v5actionset.ChangeDataContainerVisCoach;
import com.cognos.rap.actions.v5actionset.ChangeDataContainerVisCoachV2;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5ContainerInDomainIterator;
import com.cognos.rap.actions.v5spechelpers.V5ContextSlicer;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SetExpandCollapse;
import com.cognos.rap.actions.v5spechelpers.V5SetFiltering;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Translations;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.JSONUtility;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetInfo
extends BaseAction {
    private static final String FEATURE_RECOMMENDED_DISPLAY_TYPES = "suggestedDisplayTypes";
    private static final String FEATURE_RECOMMENDED_DISPLAY_VARIATIONS = "suggestedDisplayVariations";
    private static final String FEATURE_RECOMMENDED_DISPLAY_TYPES_ENABLED = "suggestedDisplayTypesEnabled";
    private V5Translations _translationValues = null;
    public static final String FEATURE_SORT = "sort";
    public static final String FEATURE_FILTER = "filter";
    public static final String FEATURE_LOCKEDFILTERS = "lockedFilters";
    public static final String FEATURE_SLIDERS = "sliders";
    public static final String FEATURE_DRILLABILITY = "drillability";
    public static final String FEATURE_DISPLAY_TYPE_ID = "displayTypeId";
    public static final String FEATURE_POSSIBLE_DISPLAY_TYPES = "possibleDisplayTypes";
    public static final String FEATURE_RENAME = "rename";
    public static final String FEATURE_ITEMINFO = "itemInfo";
    public static final String FEATURE_DRILLEDON = "drilledOn";
    public static final String[] NoChangeDisplayTypeSelectableComponents = new String[]{"textItem", "HTMLItem", "richTextItem", "image", "CMMMap", "bookmark", "repeater", "repeaterTable", "date", "time", "pageNumber"};
    public static ArrayList<String> SelectableComponentsSearchPath = new ArrayList();
    public static final String UNSUPPORTED_CONTAINER_NAME = "unsupported_container";
    public static final String PROMPT_WIDGET_CONTAINER_NAME = "promptWidget_container";

    @Override
    public void apply(Document reportDoc, Element actionArgs) throws ActionException {
        this.getInfo(this.getRAPReport(), actionArgs);
    }

    @Override
    public boolean doQueryForListSeparator() {
        return false;
    }

    public ReportInfo getInfo(RAPReport report, Element actionArgs) throws ActionException {
        this.setEnv(report, actionArgs);
        ReportInfo reportInfo = (ReportInfo)report.getReportInfo();
        if (report.getReportInfo() == null) {
            reportInfo = new ReportInfo();
            this.getRAPReport().setReportInfo(reportInfo);
        }
        Object argIdList = null;
        boolean allReportInfo = false;
        HashSet<String> customFeatureSet = null;
        boolean defaultReportInfo = true;
        boolean replaceReportInfo = true;
        boolean preserveTags = false;
        this._translationValues = new V5Translations(this.getEnv().getLocale());
        boolean specUpdatedInBUA = false;
        if (actionArgs != null) {
            boolean bl = allReportInfo = actionArgs.element("includeAll") != null;
            if (!allReportInfo && (customFeatureSet = this.buildCustomFeatureSet(actionArgs.element("include"), actionArgs.element("exclude"))) != null) {
                replaceReportInfo = actionArgs.element("replace") != null;
                defaultReportInfo = false;
            }
            boolean bl2 = preserveTags = actionArgs.element("preserveTags") != null;
            if (actionArgs.element("specUpdatedInBUA") != null) {
                V5ContextSlicer.SliderInfo.refresh(report.getDOM());
                V5SetFiltering setFiltering = new V5SetFiltering();
                setFiltering.refreshSetFiltersAfterBUA(report.getDOM());
                if (V5SpecHelper.useSetFilterForSliders(report.getDOM())) {
                    setFiltering.refreshBasedOnItemContents(report.getDOM().getRootElement(), true);
                }
                V5Translations.notifyValuesChanged(this.getEnv(), report.getDOM());
                specUpdatedInBUA = true;
            }
        }
        reportInfo.setUpdateExisting(!replaceReportInfo);
        List<Element> v5ContainerElementList = V5SpecHelper.findLayoutElementsFromActionArguments(report.getDOM(), actionArgs);
        reportInfo.setDetailFilteringDisabled(!V5SpecHelper.isDetailFilteringAvailable(report.getDOM().getRootElement()));
        reportInfo.setSingleContainerReport(this.isSingleContainerReport(this.getRAPReport()));
        ChangeDataContainerVisCoach dcRecommendedType = this.getEnv().getViscoachMode() >= 2 ? new ChangeDataContainerVisCoachV2(this.getEnv()) : new ChangeDataContainerVisCoach(this.getEnv());
        V5ContainerInDomainIterator containerInDomainIter = new V5ContainerInDomainIterator(v5ContainerElementList);
        while (containerInDomainIter.hasNext()) {
            V5DataContainer container = containerInDomainIter.next();
            if (container == null) continue;
            container.tagLayoutItems(preserveTags);
            container.setNoDataHandler(this.getLocale());
            if (this.isCrosstabWithEmptyRowOrColumnEdge(container)) {
                if (specUpdatedInBUA) {
                    reportInfo.setShouldDisableReuseResults();
                }
                reportInfo.setShouldNotPassTrackingtoBUA();
            }
            DataContainerInfo containerInfo = reportInfo.setDataContainerInfo(container.getID());
            V5Query v5Query = new V5Query();
            boolean hasRelatedQuery = v5Query.focusQuery(container.getContainerElement(), container.getRefQuery());
            container.setV5Query(v5Query);
            Element parentContainer = V5SpecHelper.findParentContainer(container.getContainerElement());
            if (parentContainer != null) {
                containerInfo.setParentContainerName(parentContainer.attributeValue("name"));
            }
            if (!hasRelatedQuery) continue;
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_SORT)) {
                this.processSorting(container, v5Query, containerInfo);
                reportInfo.addUpdatedFeature(FEATURE_SORT);
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_FILTER) || customFeatureSet.contains(FEATURE_SLIDERS) && v5Query.getSlicerRootElement() != null) {
                this.processFiltering(container, v5Query, containerInfo, reportInfo, specUpdatedInBUA);
                this.processSlicers(v5Query, containerInfo);
                reportInfo.addUpdatedFeature(FEATURE_FILTER);
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_RENAME)) {
                this.processRename(container, v5Query, containerInfo);
                reportInfo.addUpdatedFeature(FEATURE_RENAME);
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_LOCKEDFILTERS)) {
                containerInfo.setLockedFilterInfo(V5SpecHelper.getXMLAttribute(report.getDOM().getRootElement(), "BUX_LockedFilters"));
                reportInfo.addUpdatedFeature(FEATURE_LOCKEDFILTERS);
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_SLIDERS)) {
                this.processSliders(container, report, containerInfo);
                reportInfo.addUpdatedFeature(FEATURE_SLIDERS);
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_ITEMINFO) || customFeatureSet.contains(FEATURE_DRILLABILITY)) {
                boolean itemInfo = defaultReportInfo || customFeatureSet.contains(FEATURE_ITEMINFO);
                boolean drillability = defaultReportInfo || customFeatureSet.contains(FEATURE_DRILLABILITY);
                this.processItemInfo(container, v5Query, reportInfo, containerInfo, itemInfo, drillability);
                if (itemInfo) {
                    reportInfo.addUpdatedFeature(FEATURE_ITEMINFO);
                }
                if (drillability) {
                    reportInfo.addUpdatedFeature(FEATURE_DRILLABILITY);
                    reportInfo.addUpdatedFeature(FEATURE_DRILLEDON);
                }
            }
            if (defaultReportInfo || customFeatureSet.contains(FEATURE_DISPLAY_TYPE_ID)) {
                containerInfo.setDisplayTypeId(ChangeDisplayTypeHelper.getDisplayTypeId(container.getContainerElement()));
                reportInfo.addUpdatedFeature(FEATURE_DISPLAY_TYPE_ID);
                if (this.getEnv().getViscoachMode() > 0) {
                    containerInfo.setRecommendedDisplayTypesEnabled(true);
                    reportInfo.addUpdatedFeature(FEATURE_RECOMMENDED_DISPLAY_TYPES_ENABLED);
                }
            }
            if (this.getEnv().getViscoachMode() > 0 && (allReportInfo || customFeatureSet != null && customFeatureSet.contains(FEATURE_RECOMMENDED_DISPLAY_TYPES))) {
                dcRecommendedType.updateRecommendedDisplayTypes(report, containerInfo, container, actionArgs);
                reportInfo.addUpdatedFeature(FEATURE_POSSIBLE_DISPLAY_TYPES);
                reportInfo.addUpdatedFeature(FEATURE_RECOMMENDED_DISPLAY_TYPES);
            }
            if (allReportInfo || customFeatureSet != null && customFeatureSet.contains(FEATURE_POSSIBLE_DISPLAY_TYPES)) {
                this.processDisplayType(container, containerInfo);
                if (this.getEnv().getViscoachMode() > 0) {
                    dcRecommendedType.updateRecommendedDisplayTypes(report, containerInfo, container, actionArgs);
                    reportInfo.addUpdatedFeature(FEATURE_RECOMMENDED_DISPLAY_TYPES);
                }
                reportInfo.addUpdatedFeature(FEATURE_POSSIBLE_DISPLAY_TYPES);
            }
            if (this.getEnv().getViscoachMode() <= 0 || !allReportInfo && (customFeatureSet == null || !customFeatureSet.contains(FEATURE_RECOMMENDED_DISPLAY_VARIATIONS))) continue;
            dcRecommendedType.updateRecommendedDisplayVariations(report, containerInfo, container, actionArgs);
            reportInfo.addUpdatedFeature(FEATURE_POSSIBLE_DISPLAY_TYPES);
            reportInfo.addUpdatedFeature(FEATURE_RECOMMENDED_DISPLAY_VARIATIONS);
        }
        if (v5ContainerElementList.size() > 0 && (defaultReportInfo || customFeatureSet.contains(FEATURE_DISPLAY_TYPE_ID))) {
            this.addUnsupportedContainer(reportInfo);
            reportInfo.addUpdatedFeature(FEATURE_DISPLAY_TYPE_ID);
        }
        if ("true".equalsIgnoreCase(V5SpecHelper.getXMLAttribute(report.getDOM().getRootElement(), "RAP_PromptWidget"))) {
            reportInfo.setPromptWidget(true);
            String params = V5SpecHelper.getXMLAttribute(report.getDOM().getRootElement(), "RAP_PromptWidget_Parameters");
            reportInfo.setPromptWidgetParams(params);
        }
        reportInfo.setReportLevelnonVisibleFiltersItemInfo(this.getNonVisibleFiltersItemInfo(report));
        return reportInfo;
    }

    private JSONArray getNonVisibleFiltersItemInfo(RAPReport report) {
        V5Query biQuery = V5Query.findBusinessInsightQuery(report.getDOM(), this.getLocale());
        if (biQuery != null) {
            ArrayList<String> nameList = new ArrayList<String>();
            Collection<Element> collection = biQuery.getItemList().getDataItemElements();
            for (Element ele : collection) {
                nameList.add(ele.attribute("name").getText());
            }
            return JSONUtility.StringList2JSONArray(nameList);
        }
        return null;
    }

    private boolean isCrosstabWithEmptyRowOrColumnEdge(V5DataContainer container) {
        if (container instanceof V5Crosstab) {
            return container.getContainerElement().element("crosstabRows") == null || container.getContainerElement().element("crosstabColumns") == null;
        }
        return false;
    }

    private void addUnsupportedContainer(ReportInfo reportInfo) {
        Element reportSpec = this.getReport().getDOM().getRootElement().createCopy();
        this.removeSupportedElements(reportSpec);
        List nodes = V5X.selectNodes(reportSpec, SelectableComponentsSearchPath.toArray(new String[0]));
        if (nodes.size() > 0) {
            DataContainerInfo containerInfo = reportInfo.setDataContainerInfo(UNSUPPORTED_CONTAINER_NAME);
            containerInfo.setDisplayTypeId("unknown");
        }
    }

    private void removeSupportedElements(Element reportSpec) {
        Element layouts = V5X.selectSingleNode(reportSpec, "//V5X//CHILD", "layouts");
        this.removeDescendants(layouts, "crosstab", "//V5X//OR", "list");
        List chartElements = XMLUtility.selectNodes(layouts, V5X.selectContainsName("Chart"));
        for (Element chartElement : chartElements) {
            chartElement.detach();
        }
    }

    private void removeDescendants(Element report, String ... descendantName) {
        List elementsToBeRemoved = V5X.selectNodes(report, descendantName);
        for (Element element : elementsToBeRemoved) {
            element.detach();
        }
    }

    private HashSet<String> buildCustomFeatureSet(Element updateList, Element excludeList) {
        HashSet<String> featureSet;
        block4: {
            featureSet = null;
            if (updateList == null && excludeList == null) break block4;
            featureSet = new HashSet<String>();
            if (updateList != null) {
                for (Element feature : updateList.elements()) {
                    featureSet.add(feature.getName());
                }
            } else {
                featureSet.add(FEATURE_SORT);
                featureSet.add(FEATURE_FILTER);
                featureSet.add(FEATURE_RENAME);
                featureSet.add(FEATURE_LOCKEDFILTERS);
                featureSet.add(FEATURE_SLIDERS);
                featureSet.add(FEATURE_DRILLABILITY);
                featureSet.add(FEATURE_ITEMINFO);
                featureSet.add(FEATURE_DISPLAY_TYPE_ID);
                for (Element feature : excludeList.elements()) {
                    if (!featureSet.contains(feature.getName())) continue;
                    featureSet.remove(feature.getName());
                }
            }
        }
        return featureSet;
    }

    void processSorting(V5DataContainer container, V5Query v5Query, DataContainerInfo containerInfo) throws ActionException {
        boolean isList = "list".equals(container.getType());
        List<Element> layoutNodes = container.collectEdgeNodes();
        if (layoutNodes == null) {
            return;
        }
        for (Element layoutNode : layoutNodes) {
            Element sortList = layoutNode.element("sortList");
            this.processSortList(container, containerInfo, sortList);
        }
        if (containerInfo.getSortInfoCount() > 0) {
            container.tagSortedLayoutItems();
        }
        if (v5Query == null) {
            return;
        }
        ArrayList<Element> relatedQueryItems = v5Query.findRefDataItems(layoutNodes);
        for (Element relatedQueryItem : relatedQueryItems) {
            Element setSorting = relatedQueryItem.element("setSorting");
            if (setSorting == null) continue;
            SortInfo si = new SortInfo(V5Query.getItemName(relatedQueryItem), true, isList);
            v5Query.initializeSortInfo(si, relatedQueryItem, this._translationValues);
            if (si.getSortReferences() != null && si.getSortReferences().size() > 0) {
                si.setLabel(this.getBestLabelForSortReference(container, si.getSortReferences()));
            } else {
                si.setLabel(container.getBestItemLabel(V5Query.getItemName(relatedQueryItem), this.getEnv()));
            }
            containerInfo.addSortInfo(si);
        }
    }

    private boolean isSimpleSort(Element sortList) {
        String rdiBeingSorted = sortList.getParent().attributeValue("refDataItem");
        if (rdiBeingSorted == null) {
            return true;
        }
        List sortItemsInSortList = sortList.elements("sortItem");
        return sortItemsInSortList.size() == 1 && rdiBeingSorted.equals(((Element)sortItemsInSortList.get(0)).attributeValue("refDataItem"));
    }

    private void processSortList(V5DataContainer container, DataContainerInfo containerInfo, Element sortList) throws ActionException {
        if (sortList != null) {
            boolean isList = "list".equals(container.getType());
            if (this.isSimpleSort(sortList)) {
                List sortItems = sortList.elements("sortItem");
                for (int i = 0; i < sortItems.size(); ++i) {
                    Element thisSortItem = (Element)sortItems.get(i);
                    String rdi = thisSortItem.attributeValue("refDataItem");
                    SortInfo si = new SortInfo(rdi, false, isList);
                    si.setLabel(container.getBestItemLabel(rdi, this.getEnv()));
                    String sortOrder = thisSortItem.attributeValue("sortOrder");
                    if (sortOrder != null && "descending".equals(sortOrder)) {
                        si.setDescending();
                    }
                    containerInfo.addSortInfo(si);
                }
            } else {
                String rdiBeingSorted = sortList.getParent().attributeValue("refDataItem");
                List sortItems = sortList.elements("sortItem");
                SortInfo si = new SortInfo(rdiBeingSorted, false, isList);
                si.setLabel(container.getBestItemLabel(rdiBeingSorted, this.getEnv()));
                si.setSortByItems();
                for (int i = 0; i < sortItems.size(); ++i) {
                    Element thisSortItem = (Element)sortItems.get(i);
                    String rdi = thisSortItem.attributeValue("refDataItem");
                    String sortOrder = thisSortItem.attributeValue("sortOrder");
                    boolean ascending = sortOrder == null || !"descending".equals(sortOrder);
                    si.addSortByItem(container.getBestItemLabel(rdi, this.getEnv()), ascending);
                    if (ascending || i != sortItems.size() - 1) continue;
                    si.setDescending();
                }
                containerInfo.addSortInfo(si);
            }
        }
    }

    private String getBestLabelForSortReference(V5DataContainer container, List<SortReference> sortReferences) throws ActionException {
        StringBuilder strBuilder = new StringBuilder();
        for (SortReference sr : sortReferences) {
            strBuilder.append(" -- ");
            if (sr._isDataItemName) {
                strBuilder.append(container.getBestItemLabel(sr._referenceItem, this.getEnv()));
                continue;
            }
            strBuilder.append(sr._referenceItem);
        }
        return strBuilder.substring(4);
    }

    void processFiltering(V5DataContainer container, V5Query v5Query, DataContainerInfo containerInfo, ReportInfo reportInfo, boolean specUpdatedInBUA) throws ActionException {
        if (v5Query != null) {
            V5QueryFilters queryFilters = v5Query.getFilters(this.getEnv());
            for (Element filterDefinition : queryFilters.findFilterDefinitionRDINodes()) {
                if ("prohibited".equals(filterDefinition.getParent().getParent().attributeValue("use"))) continue;
                String rdiName = filterDefinition.attributeValue("refDataItem");
                String label = container.getBestItemLabel(rdiName, this.getEnv());
                FilterInfo fi = new FilterInfo(filterDefinition, label, this.getEnv().getLocale());
                containerInfo.addFilterInfo(fi);
                if (!specUpdatedInBUA || !"true".equals(filterDefinition.attributeValue("parameterized"))) continue;
                reportInfo.setShouldDisableReuseResults();
            }
            V5SetFiltering.collectFilterValueInfo(this.getEnv(), v5Query, containerInfo, container);
        }
    }

    void processSlicers(V5Query v5Query, DataContainerInfo containerInfo) {
        Element slicerRoot = v5Query.getSlicerRootElement();
        if (slicerRoot != null) {
            List contextSlices = slicerRoot.elements("contextSlice");
            for (Element contextSlice : contextSlices) {
                String slicerName;
                boolean isParameterizedSlice = contextSlice.element("parameterizedSlice") != null;
                Element dmDimension = contextSlice.element("dmDimension");
                Element dmHierarchy = contextSlice.element("dmHierarchy");
                Element dmLevel = contextSlice.element("dmLevel");
                if (dmHierarchy == null || dmDimension == null) continue;
                String string = slicerName = dmLevel == null ? dmHierarchy.elementText("itemCaption") : dmLevel.elementText("itemCaption");
                if (V5ContextSlicer.SliderInfo.exists(contextSlice)) continue;
                SlicerInfo si = new SlicerInfo(slicerName, dmDimension.elementText("DUN"), dmHierarchy.elementText("HUN"), dmLevel == null ? null : dmLevel.elementText("LUN"), isParameterizedSlice ? null : contextSlice.element("contextSliceDefinition"), this._translationValues);
                containerInfo.addSlicerInfo(si);
            }
        }
    }

    void processRename(V5DataContainer container, V5Query v5Query, DataContainerInfo containerInfo) {
        if (v5Query != null && (container instanceof V5Crosstab || container instanceof V5List)) {
            List<Element> layoutNodes = container.collectNodes();
            for (Element layoutNode : layoutNodes) {
                Element renameNode;
                String originalName = container.getRDIName(layoutNode);
                if (originalName == null || (renameNode = container.findItemLabel(layoutNode)) == null || V5X.selectSingleNode(renameNode, "//V5X//CHILD", "dataSource", "staticValue") == null && V5X.selectSingleNode(renameNode, "//V5X//CHILD", "conditionalDataSources", "conditionalDataSource", "staticValue") == null) continue;
                if (V5SpecHelper.getXMLAttribute(renameNode, "rp_originalName_" + this.getLocale()) != null) {
                    originalName = V5SpecHelper.getXMLAttribute(renameNode, "rp_originalName_" + this.getLocale());
                }
                V5SpecHelper.setXMLAttribute(renameNode.getParent().getParent(), "rp_name", originalName, "HTML");
            }
        }
    }

    void processItemInfo(V5DataContainer container, V5Query v5Query, ReportInfo reportInfo, DataContainerInfo containerInfo, boolean itemInfo, boolean drillability) throws ActionException {
        if (v5Query != null) {
            List<Element> layoutNodes = container.collectItemInfo();
            HashMap<String, Boolean> hierachyExpandedMap = new HashMap<String, Boolean>();
            JSONArray aDrilledOnHUNs = new JSONArray();
            if (layoutNodes != null) {
                for (Element layoutNode : layoutNodes) {
                    boolean useServerDrillFlags;
                    Element relatedQueryItem = v5Query.findItem(container.getRDIName(layoutNode));
                    if (relatedQueryItem == null) continue;
                    if (itemInfo) {
                        V5QueryItem qi = new V5QueryItem(this.getEnv(), v5Query, relatedQueryItem);
                        qi.setEvaluateSpecOnly(true);
                        String itemName = V5Query.getItemName(relatedQueryItem);
                        V5QueryItem.ItemType itemType = qi.getItemType();
                        ArrayList<String> expandedMembers = V5Query.getExpandedMembers(relatedQueryItem);
                        String sHUN = V5QueryItem.getHun(relatedQueryItem);
                        if (expandedMembers.size() > 0 && !hierachyExpandedMap.containsKey(sHUN)) {
                            hierachyExpandedMap.put(sHUN, new Boolean(true));
                        }
                        ItemInfo ii = new ItemInfo(itemName, container.getBestItemLabel(layoutNode, itemName, this.getEnv(), false), V5QueryItem.itemTypeToNumericFlagValue(itemType), V5QueryItem.IsSingleMember(itemType), expandedMembers, V5QueryItem.canExpand(itemType), V5SetExpandCollapse.alwaysCanExpandCollapse(relatedQueryItem), V5Query.isRSDrillParent(relatedQueryItem), hierachyExpandedMap.containsKey(sHUN), sHUN, V5QueryItem.getDimensionName(relatedQueryItem), v5Query.getQueryName());
                        containerInfo.addItemInfo(ii);
                        boolean isDrilledOn = V5Query.isDrilledOn(relatedQueryItem);
                        if (isDrilledOn) {
                            aDrilledOnHUNs.add((Object)sHUN);
                        }
                    }
                    if (!drillability) continue;
                    boolean drillDownDisabled = V5Drillability.isDrillDownDisabled(relatedQueryItem);
                    boolean drillUpDisabled = V5Drillability.isDrillUpDisabled(relatedQueryItem);
                    boolean isLeafNode = container.isLeafNode(layoutNode);
                    boolean isIsolated = V5Drillability.isIsolated(relatedQueryItem);
                    boolean bl = useServerDrillFlags = v5Query.findMemberSet(relatedQueryItem) != null;
                    if (!drillDownDisabled && !drillUpDisabled && !useServerDrillFlags && !isLeafNode) continue;
                    DrillabilityInfo di = new DrillabilityInfo(V5Query.getItemName(relatedQueryItem), drillDownDisabled, drillUpDisabled, useServerDrillFlags, isLeafNode, isIsolated);
                    containerInfo.addDrillabilityInfo(di);
                }
            }
            if (!aDrilledOnHUNs.isEmpty()) {
                reportInfo.setDrilledOnInfo(aDrilledOnHUNs);
            }
        }
    }

    void processDisplayType(V5DataContainer originalContainer, DataContainerInfo containerInfo) throws ActionException {
        V5DataContainer container = this.creatTempDataContainer(originalContainer);
        ActionEnv actionEnv = this.createActionEnvToChangeToCrosstab(container);
        Element crosstabElement = container.changeDisplayType(actionEnv);
        Set<String> possibleChartTypes = null;
        if (crosstabElement != null && "crosstab".equals(crosstabElement.getName())) {
            V5Crosstab crosstab = new V5Crosstab(crosstabElement);
            int numberOfMeasures = crosstab.getNumberOfMeasuresForChangeDisplayType(this.getEnv());
            possibleChartTypes = GetInfo.createPossibleChartTypes(numberOfMeasures, originalContainer.getContainerElement());
            possibleChartTypes.addAll(this.getPossibleTextDataContainers(originalContainer));
        }
        containerInfo.setPossibleDisplayTypeIds(possibleChartTypes);
    }

    void processSliders(V5DataContainer container, RAPReport report, DataContainerInfo containerInfo) throws ActionException {
        JSONObject descriptorJSON;
        ArrayList<String> descriptors = new ArrayList<String>();
        V5Query containerQuery = new V5Query(container.getContainerElement(), container.getRefQuery());
        List<Element> dynamicDataFilters = containerQuery.findDynamicDataFilters();
        if (dynamicDataFilters != null) {
            for (Element df : dynamicDataFilters) {
                try {
                    String label;
                    String name;
                    String descriptor = V5SpecHelper.getXMLAttribute(df, "RAP_DataFilterDescriptor");
                    if (descriptor == null) continue;
                    JSONObject descriptorJSON2 = JSONObject.parse((String)descriptor);
                    if (descriptorJSON2 != null && !(name = (String)descriptorJSON2.get((Object)"name")).equals(label = container.getBestItemLabel(name, this.getEnv()))) {
                        descriptorJSON2.put((Object)"label", (Object)label);
                        descriptor = descriptorJSON2.toString();
                    }
                    descriptors.add(descriptor);
                }
                catch (IOException ioe) {}
            }
        }
        for (Element contextSlicer : V5ContextSlicer.findDynamicContextSlicers(containerQuery.getQueryElement())) {
            String itemHun;
            descriptorJSON = new JSONObject();
            String itemName = V5ContextSlicer.getContextSlicerName(contextSlicer);
            if ("".equals(itemName)) continue;
            String itemLabel = this._translationValues.getItemCaption(contextSlicer.element("dmHierarchy"));
            descriptorJSON.put((Object)"name", (Object)itemName);
            if (!itemLabel.equals(itemName)) {
                descriptorJSON.put((Object)"label", (Object)itemLabel);
            }
            if ((itemHun = V5ContextSlicer.getContextSlicerHUN(contextSlicer)) != null && itemHun.length() > 0) {
                descriptorJSON.put((Object)"hun", (Object)itemHun);
            }
            descriptorJSON.put((Object)"clientId", (Object)V5ContextSlicer.SliderInfo.getClientId(contextSlicer));
            descriptorJSON.put((Object)"controlType", (Object)V5ContextSlicer.SliderInfo.getControlType(contextSlicer));
            JSONArray descriptorValues = new JSONArray();
            descriptorJSON.put((Object)"values", (Object)descriptorValues);
            for (Element slicerMember : V5ContextSlicer.getMembers(contextSlicer)) {
                descriptorValues.add((Object)slicerMember.elementText("itemCaption"));
            }
            descriptors.add(descriptorJSON.toString());
        }
        for (String resetFacet : V5ContextSlicer.SliderInfo.getResetFacetIDs(containerQuery.getQueryElement())) {
            descriptorJSON = new JSONObject();
            descriptorJSON.put((Object)"clientId", (Object)resetFacet);
            descriptors.add(descriptorJSON.toString());
        }
        if (descriptors.size() > 0) {
            containerInfo.setDynamicDataFilterDescriptors(descriptors);
        }
    }

    private Set<String> getPossibleTextDataContainers(V5DataContainer dataContainer) {
        HashSet<String> targets = new HashSet<String>();
        if (dataContainer instanceof V5List) {
            targets.add("crosstab");
        } else {
            if (dataContainer.ifCanConvertToList()) {
                targets.add("list");
            }
            if (dataContainer instanceof V5Chart) {
                targets.add("crosstab");
            }
        }
        return targets;
    }

    public static Set<String> createPossibleChartTypes(int numberOfMeasures, Element containerElement) throws ActionException {
        if (numberOfMeasures == 0) {
            return new HashSet<String>();
        }
        Set<String> possibleChartTypes = ChangeDisplayTypeHelper.getPossibleTargetChartTypes(containerElement);
        Iterator<String> ite = possibleChartTypes.iterator();
        while (ite.hasNext()) {
            String chartType = ite.next();
            String chartElementName = ChangeDisplayTypeHelper.getChartElementName(chartType);
            int expectedNumberOfMeasures = GetInfo.getExpectedMinimumNumberOfMeasures(chartElementName);
            if (numberOfMeasures >= expectedNumberOfMeasures) continue;
            ite.remove();
        }
        return possibleChartTypes;
    }

    public static int getExpectedMinimumNumberOfMeasures(String chartElementName) {
        Integer number = ChartElements.chartMinimunNumberOfMeasures.get(chartElementName);
        if (number == null) {
            return 1;
        }
        return number;
    }

    private V5DataContainer creatTempDataContainer(V5DataContainer dataContainer) {
        Document reportSpec = (Document)dataContainer.getContainerElement().getDocument().clone();
        return V5DataContainerFactory.create(reportSpec.getRootElement(), dataContainer.getID());
    }

    private ActionEnv createActionEnvToChangeToCrosstab(V5DataContainer container) {
        Document document = DocumentHelper.createDocument();
        Element reportAction = document.addElement("reportAction");
        reportAction.addAttribute("name", "ChangeDisplayType");
        Element id = reportAction.addElement("id");
        id.setText(container.getID());
        Element target = reportAction.addElement("target");
        target.setText("Crosstab");
        Arguments argument = new Arguments(reportAction);
        RAPReport rapReport = new RAPReport(container.getContainerElement().getDocument());
        ActionEnv env = new ActionEnv(rapReport, argument);
        env.setReportActionController(this.getReportActionController());
        return env;
    }

    public boolean isSingleContainerReport(RAPReport rapReport) {
        Element containerElement;
        V5DataContainer v5DataContainer;
        Document reportSpec = rapReport.getDOM();
        Element reportPagesElement = V5X.selectSingleNode(reportSpec, "//V5X//CHILD", "layouts", "layout", "reportPages");
        if (reportPagesElement == null) {
            return false;
        }
        List pageElements = V5X.selectNodes(reportPagesElement, "page");
        if (pageElements.size() != 1) {
            return false;
        }
        Element pageElement = (Element)pageElements.get(0);
        if (pageElement.element("pageHeader") != null || pageElement.element("pageFooter") != null) {
            return false;
        }
        Element contentsElement = V5X.selectSingleNode(pageElement, "//V5X//CHILD", "pageBody", "contents");
        return contentsElement != null && contentsElement.elements().size() == 1 && (v5DataContainer = V5DataContainerFactory.create(containerElement = (Element)contentsElement.elements().get(0))) != null;
    }

    static {
        for (String elementName : NoChangeDisplayTypeSelectableComponents) {
            if (SelectableComponentsSearchPath.size() == 0) {
                SelectableComponentsSearchPath.add("//V5X//CHILD");
                SelectableComponentsSearchPath.add("layouts");
                SelectableComponentsSearchPath.add("layout");
                SelectableComponentsSearchPath.add("reportPages");
                SelectableComponentsSearchPath.add("page");
                SelectableComponentsSearchPath.add("pageBody");
                SelectableComponentsSearchPath.add("//V5X//ANY");
            } else {
                SelectableComponentsSearchPath.add("//V5X//OR");
            }
            SelectableComponentsSearchPath.add(elementName);
        }
    }
}

