/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5requestcreators;

import com.cognos.rap.actions.v5requestcreators.V5ReportRequest;
import com.cognos.rap.actions.v5spechelpers.V5ContextSlicer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5DiscreteValuesRequest
extends V5ReportRequest {
    private V5DataContainer _sourceContainer = null;
    private String _nameToGetValuesFor = null;
    private boolean _isCurrentFilterSortingOn = true;
    private String _keyColumn = null;
    private boolean _requestMuns = false;
    private Element _contextSlicer = null;

    public V5DiscreteValuesRequest(V5DataContainer sourceContainer, String nameToGetValuesFor, boolean isCurrentFilterSortingOn, String keyColumn, boolean requestMuns) {
        this._sourceContainer = sourceContainer;
        this._nameToGetValuesFor = nameToGetValuesFor;
        this._isCurrentFilterSortingOn = isCurrentFilterSortingOn;
        this._keyColumn = keyColumn;
        this._requestMuns = requestMuns;
        this._createdReportId = "DiscreteValues";
        if (this._isCurrentFilterSortingOn) {
            this.setRowRetrievalLimit(500);
        }
    }

    public void disableFilters() {
        V5QueryFilters.disableFilters(this.getDocument().getRootElement());
    }

    @Override
    public void create() throws ActionException {
        Element keyColumnDataItem;
        Element dataColumnItem;
        Element pageGroups;
        Document sourceDocument = this._sourceContainer.getContainerElement().getDocument();
        String listSeparator = V5SpecHelper.getListSeparator(sourceDocument.getDocument());
        Element targetReportFramework = this.cloneReportFramework(sourceDocument, this._sourceContainer);
        if (V5SpecHelper.hasDetailFilters(targetReportFramework.getDocument().getRootElement()) && !CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_CW_RETAIN_DETAIL_FILTERS_FROM_REPORT_WIDGET_IN_SELECT_VALUE_FILTER_DLG")) {
            V5SpecHelper.disableAllDetailFilters(targetReportFramework.getDocument().getRootElement());
        }
        V5SpecHelper.removeAllDynamicDataFilters(targetReportFramework.getDocument().getRootElement());
        V5Query targetQuery = new V5Query();
        targetQuery.focusQuery(targetReportFramework, this._sourceContainer.getRefQuery());
        V5QueryFilters.disableRangeFilters(targetReportFramework.getDocument().getRootElement());
        Element containingPageSet = V5SpecHelper.getAncestor(targetReportFramework, "pageSet");
        if (containingPageSet != null && (pageGroups = containingPageSet.element("pageGroups")) != null) {
            pageGroups.detach();
        }
        Element newList = targetReportFramework.addElement("list");
        newList.addAttribute("name", this._createdReportId);
        newList.addAttribute("refQuery", this._sourceContainer.getRefQuery());
        Element listColumns = newList.addElement("listColumns");
        if (this._contextSlicer != null) {
            this._nameToGetValuesFor = this.addContextSlicerItem(targetQuery, listSeparator);
        }
        if (this._requestMuns) {
            this.preprocessSortByValue(this._sourceContainer, targetQuery);
            dataColumnItem = targetQuery.getItemList().addDataItem("__itemColumn__", this.getDimensionalItemColumnExpression(this._nameToGetValuesFor, listSeparator));
            this.addListColumn(listColumns, dataColumnItem.attributeValue("name"));
        } else {
            dataColumnItem = targetQuery.getItemList().addDataItem("__itemColumn__", "[" + this._nameToGetValuesFor + "]");
            if (dataColumnItem != null) {
                this.addListColumn(listColumns, dataColumnItem.attributeValue("name"));
                this.limitRowsToRetrieve(targetQuery, this.getRowRetrievalLimit(), dataColumnItem.attributeValue("name"));
            }
        }
        if (this._keyColumn != null && (keyColumnDataItem = targetQuery.getItemList().addDataItem("__keyColumn__", this._keyColumn)) != null) {
            this.addListColumn(listColumns, keyColumnDataItem.attributeValue("name"));
            this.limitRowsToRetrieve(targetQuery, this.getRowRetrievalLimit(), keyColumnDataItem.attributeValue("name"));
        }
        if (this._requestMuns) {
            Element munColumnDataItem = targetQuery.getItemList().addDataItem("__munColumn__", "roleValue('_memberUniqueName'" + listSeparator + "[__itemColumn__])");
            this.addListColumn(listColumns, munColumnDataItem.attributeValue("name"));
            Element listGroups = newList.addElement("listGroups");
            Element groupItemColumn = listGroups.addElement("listGroup");
            groupItemColumn.addAttribute("refDataItem", "__itemColumn__");
        }
        if (!this._isCurrentFilterSortingOn) {
            this.preserveSortListsOnItemAndContainer(newList);
        }
    }

    private void preprocessSortByValue(V5DataContainer sourceContainer, V5Query targetQuery) {
        Element measureLayoutItem;
        Element rootTuple;
        Element existingItemRef;
        boolean removeSortByValue;
        Element dataItem = targetQuery.findItem(this._nameToGetValuesFor);
        if (dataItem == null || dataItem.element("setSorting") == null) {
            return;
        }
        List rootTuples = dataItem.element("setSorting").elements("dmTuple");
        if (rootTuples == null || rootTuples.size() == 0) {
            return;
        }
        boolean bl = removeSortByValue = rootTuples.size() > 1;
        if (!removeSortByValue && (existingItemRef = V5X.selectSingleNode(rootTuple = (Element)rootTuples.get(0), "dmTuplePartDataItemRef")) == null && (measureLayoutItem = sourceContainer.getDefaultMeasure()) != null) {
            Element measureDataItem = targetQuery.findItem(measureLayoutItem.attributeValue("refDataItem"));
            if (V5QueryItem.isHighLevelSortReferenceItemType(measureDataItem)) {
                String measureDun = V5QueryItem.getDun(measureDataItem);
                List existingDUNS = V5X.selectNodes(rootTuple, "DUN");
                for (Element dun : existingDUNS) {
                    if (!measureDun.equals(dun.getText())) continue;
                    return;
                }
                Element dataItemRef = rootTuple.addElement("dmTuplePartDataItemRef");
                dataItemRef.addAttribute("refDataItem", measureDataItem.attributeValue("name"));
            } else {
                removeSortByValue = true;
            }
        }
        if (removeSortByValue) {
            for (Element rootTuple2 : rootTuples) {
                rootTuple2.detach();
            }
        }
    }

    private void preserveSortListsOnItemAndContainer(Element targetList) {
        Element thisRDINode = this._sourceContainer.findItem(this._nameToGetValuesFor);
        if (thisRDINode != null) {
            Element propList;
            Element targetSortList = null;
            List<Element> sortItemsOnItem = V5DataContainer.selectNodes(this._sourceContainer.getContainerElement(), thisRDINode, "sortItem");
            List<Element> sortItemsOnContainer = this._sourceContainer.selectNodes("//V5X//CHILD", "sortList", "sortItem");
            if (sortItemsOnItem.size() + sortItemsOnContainer.size() > 0) {
                Element targetListGroup = this.addUpdateItemListGroup(targetList, this._nameToGetValuesFor);
                targetSortList = targetListGroup.addElement("sortList");
                this.preserveSorts(targetSortList, sortItemsOnItem);
                this.preserveSorts(targetSortList, sortItemsOnContainer);
            }
            Element element = propList = (propList = V5DataContainer.selectSingleNode(this._sourceContainer.getContainerElement(), thisRDINode, "propertyList")) != null ? propList : this._sourceContainer.selectSingleNode("//V5X//CHILD", "propertyList");
            if (propList != null) {
                List propItems = V5X.selectNodes(propList, "propertyItem");
                if (targetSortList == null) {
                    Element targetListGroup = this.addUpdateItemListGroup(targetList, this._nameToGetValuesFor);
                    targetSortList = targetListGroup.addElement("sortList");
                }
                for (Element propItem : propItems) {
                    this.addNewSortItem(targetSortList, propItem.attributeValue("refDataItem"));
                }
            }
        }
    }

    private Element addUpdateItemListGroup(Element targetList, String rdiName) {
        Element listGroups = DocumentHelper.makeElement((Branch)targetList, (String)"listGroups");
        Element existingListGroup = V5X.selectSingleNode(listGroups, "//V5X//CHILD", "listGroup", "//V5X//ATTR", "refDataItem", rdiName);
        if (existingListGroup == null) {
            Element newListGroup = listGroups.addElement("listGroup");
            newListGroup.addAttribute("refDataItem", rdiName);
            return newListGroup;
        }
        return existingListGroup;
    }

    private void addNewSortItem(Element sortList, String rdiName) {
        if (rdiName == null || sortList == null) {
            return;
        }
        Element existingSortItem = V5X.selectSingleNode(sortList, "//V5X//CHILD", "listGroup", "//V5X//ATTR", "refDataItem", rdiName);
        if (existingSortItem == null) {
            Element newSortItem = sortList.addElement("sortItem");
            newSortItem.addAttribute("refDataItem", rdiName);
        }
    }

    private void preserveSorts(Element targetSortList, List<Element> sortItems) {
        if (sortItems != null && sortItems.size() > 0) {
            for (Element sortItem : sortItems) {
                Element targetSortItem = (Element)sortItem.clone();
                targetSortList.add(targetSortItem);
            }
        }
    }

    public void setContextSlicer(Element contextSlicer) {
        this._contextSlicer = contextSlicer;
    }

    private String addContextSlicerItem(V5Query targetQuery, String listSeparator) throws ActionException {
        if (this._outputReportDoc != null) {
            List<Element> slicerMembers = V5ContextSlicer.getMembers(this._contextSlicer);
            String newItemExpression = null;
            if (slicerMembers.size() > 1) {
                int i = 0;
                newItemExpression = "set(";
                for (Element slicerMember : slicerMembers) {
                    newItemExpression = newItemExpression + slicerMember.elementText("MUN");
                    if (++i >= slicerMembers.size()) continue;
                    newItemExpression = newItemExpression + listSeparator;
                }
                newItemExpression = newItemExpression + ")";
            } else {
                String MUN = slicerMembers.get(0).elementText("MUN");
                newItemExpression = "children(item(union(head(parent(" + MUN + "))" + listSeparator + MUN + ")" + listSeparator + "0))";
            }
            Element newItem = targetQuery.getItemList().addDataItem(this._nameToGetValuesFor, newItemExpression);
            return newItem.attributeValue("name");
        }
        return null;
    }

    private String getDimensionalItemColumnExpression(String refDataItem, String listSeparator) {
        if (this._isCurrentFilterSortingOn) {
            return "head([" + this._nameToGetValuesFor + "]" + listSeparator + " " + this._rowRetrievalLimit + ")";
        }
        return "[" + this._nameToGetValuesFor + "]";
    }

    public static class Response {
        public static final String metadata = "metadata";
        public static final String item = "item";
        public static final String munColumn = "__munColumn__";
        public static final String keyColumn = "__keyColumn__";
        public static final String data = "data";
        public static final String row = "row";
        public static final String value = "value";
    }
}

