/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5requestcreators;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5requestcreators.V5ReportRequest;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Translations;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5LocalizeItemLabelsRequest
extends V5ReportRequest {
    private String _expressionLocaleOfReport = null;
    ActionEnv _env = null;
    CognosServiceOptions _requestOptions = new CognosServiceOptions();
    private HashSet<String> _requestedDataItems = new HashSet();
    private HashMap<String, String> _results = new HashMap();
    private V5Translations _translatedValues = null;
    private HashSet<String> _referencedItems = null;
    private TranslationSet _translationSet = new TranslationSet();

    public V5LocalizeItemLabelsRequest(ActionEnv env, String expressionLocale) {
        this._env = env;
        this._expressionLocaleOfReport = expressionLocale;
        this._createdReportId = "LocalizedNames";
        this._translatedValues = new V5Translations(env.getLocale());
    }

    public void initReferencedItems(Document report) {
        Collection<Element> dataItemElements;
        V5Query businessInsightQuery;
        this._referencedItems = new HashSet();
        List allSpecReferences = V5X.selectNodes(report, "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refDataItem");
        if (allSpecReferences.size() > 0) {
            for (Element specRef : allSpecReferences) {
                this._referencedItems.add(specRef.attributeValue("refDataItem"));
            }
        }
        if ((businessInsightQuery = V5Query.findBusinessInsightQuery(report, this._env.getLocale())) != null && (dataItemElements = businessInsightQuery.getItemList().getDataItemElements()).size() > 0) {
            for (Element dataItem : dataItemElements) {
                this._referencedItems.add(dataItem.attributeValue("name"));
            }
        }
    }

    public boolean hasItems() {
        return this._translationSet.hasItems();
    }

    public boolean hasValuesToBeTranslated() {
        return this._translationSet._valuesToBeTranslated.size() > 0;
    }

    public boolean translationRequired() {
        return this._translationSet.hasItems() || this.hasValuesToBeTranslated();
    }

    public void loadExisting(Document report) {
        this._translatedValues.loadTranslations(report);
    }

    public void addToTranslationSet(V5Query v5Query) {
        if (V5SpecHelper.compareLocales(this._env.getLocale(), this._expressionLocaleOfReport, true) && V5SpecHelper.getXMLAttribute(v5Query.getQueryElement().getDocument(), "RAP_NonNativeLocaleEdits") == null) {
            return;
        }
        Collection<Element> elementsToTranslate = v5Query.getItemList().getDataItemElements();
        for (Element item : elementsToTranslate) {
            if (this._referencedItems != null && !this._referencedItems.contains(item.attributeValue("name")) || !V5QueryItem.isNameLocalizable(item)) continue;
            this._translationSet.addItem(this._env, v5Query, item);
        }
        this.addValuesToTranslationSet(v5Query, "MUN");
        this.addValuesToTranslationSet(v5Query, "HUN");
    }

    private void addValuesToTranslationSet(V5Query v5Query, String valueType) {
        List munvalues = V5X.selectNodes(v5Query.getQueryElement(), "contextSlice", "//V5X//OR", "setSorting", valueType);
        if (munvalues != null) {
            for (Element value : munvalues) {
                String expressionStr;
                String valueStr = value.getText();
                String string = expressionStr = "MUN".equals(valueType) ? valueStr : "rootMembers(" + valueStr + ")";
                if (this._translatedValues.hasTranslation(valueStr)) continue;
                this._translationSet._valuesToBeTranslated.put(valueStr, expressionStr);
            }
        }
    }

    public HashMap<String, String> getResults() {
        return this._results;
    }

    public void disableFilters() {
        V5QueryFilters.disableFilters(this.getDocument().getRootElement());
    }

    @Override
    public void create() throws ActionException {
        V5Query v5ValuesQuery;
        if (!this.translationRequired()) {
            return;
        }
        Element targetReport = this.cloneReportQueries(this._translationSet.getDocument());
        Element targetPageBodyContents = this.createBasicReportPageContents("LocalizedItemsRequestPage");
        V5SpecHelper.removeAllDynamicDataFilters(targetReport.getDocument().getRootElement());
        this.disableFilters();
        List setSortingElements = V5X.selectNodes(targetReport, "//V5X//CHILD", "queries", "query", "selection", "//V5X//ANY", "setSorting");
        if (setSortingElements != null) {
            for (Element element : setSortingElements) {
                element.detach();
            }
        }
        if (this._translationSet._valuesToBeTranslated.size() > 0 && (v5ValuesQuery = new V5Query()).createNew(targetReport, "valuesQuery")) {
            Element element = targetPageBodyContents.addElement("crosstab");
            element.addAttribute("name", this._createdReportId + "_values");
            element.addAttribute("refQuery", v5ValuesQuery.getQueryName());
            Element crosstabAxis = element.addElement("crosstabRows");
            for (Map.Entry<String, String> valueEntry : this._translationSet._valuesToBeTranslated.entrySet()) {
                String value = valueEntry.getKey();
                String expression = valueEntry.getValue();
                v5ValuesQuery.getItemList().addDataItem(value, expression);
                Element newCrosstabNode = crosstabAxis.addElement("crosstabNode");
                Element newNodeMember = DocumentHelper.makeElement((Branch)newCrosstabNode, (String)V5X.getMakeElementPath("crosstabNodeMembers", "crosstabNodeMember"));
                newNodeMember.addAttribute("refDataItem", value);
                DocumentHelper.makeElement((Branch)newNodeMember, (String)V5X.getMakeElementPath("contents", "textItem", "dataSource", "memberCaption"));
            }
        }
        for (Map.Entry entry : this._translationSet._dataItemsForQuery.entrySet()) {
            V5Query sourceV5Query = (V5Query)entry.getKey();
            DataItems dataItemsForQuery = (DataItems)entry.getValue();
            V5Query targetQuery = new V5Query(this._env, targetReport, sourceV5Query.getQueryName());
            for (Element item : dataItemsForQuery.getDataItems()) {
                String name = item.attributeValue("name");
                Element targetQueryItem = targetQuery.findItem(name);
                if (targetQueryItem == null) continue;
                this._requestedDataItems.add(name);
                if ("dataItemMember".equals(item.getName()) || V5QueryItem.isHighLevelSetType(item) && !"dataItemLevelSet".equals(item.getName())) {
                    Element newCrosstab = targetPageBodyContents.addElement("crosstab");
                    newCrosstab.addAttribute("name", this._createdReportId);
                    newCrosstab.addAttribute("refQuery", sourceV5Query.getQueryName());
                    Element crosstabAxis = newCrosstab.addElement("crosstabRows");
                    Element newCrosstabNode = crosstabAxis.addElement("crosstabNode");
                    Element newNodeMember = DocumentHelper.makeElement((Branch)newCrosstabNode, (String)V5X.getMakeElementPath("crosstabNodeMembers", "crosstabNodeMember"));
                    newNodeMember.addAttribute("refDataItem", name);
                    Element munNode = V5X.selectSingleNode(item, "//V5X//CHILD", "dmMember", "MUN");
                    Element hunNode = V5X.selectSingleNode(item, "//V5X//CHILD", "dmHierarchy", "HUN");
                    if (!("dataItemMember".equals(item.getName()) || munNode == null && hunNode == null)) {
                        targetQuery.getItemList().removeDataItem(targetQueryItem);
                        targetQuery.getItemList().addDataItem(name, munNode == null ? "rootMembers(" + hunNode.getText() + ")" : munNode.getText());
                    }
                    DocumentHelper.makeElement((Branch)newNodeMember, (String)V5X.getMakeElementPath("contents", "textItem", "dataSource", "memberCaption"));
                    continue;
                }
                this.addSingleton(targetPageBodyContents, this._createdReportId, sourceV5Query.getQueryName(), name);
            }
        }
    }

    public Document initializeRequest() throws ActionException {
        if (!this.translationRequired()) {
            return null;
        }
        this.create();
        this._requestOptions.addOption("run.outputFormat", "rawXML");
        this._requestOptions.addOption("run.verticalElements", "0");
        this._requestOptions.addOption("run.selectionBasedFeatures", "false");
        return this.getDocument();
    }

    public boolean execute(RapServiceRequestManager rapServiceRequestMgr) throws ActionException {
        Document requestDoc;
        if (rapServiceRequestMgr != null && (requestDoc = this.initializeRequest()) != null) {
            return this.processResponse(rapServiceRequestMgr.runReportSpecification(requestDoc.asXML(), this._requestOptions));
        }
        return false;
    }

    public boolean processResponse(CognosServiceResponse response) {
        if (response != null && response.getDOMValue() != null) {
            List outputRows = V5X.selectNodes(response.getDOMValue(), "OTD", "//V5X//OR", "LIST", "OTI");
            for (Element row : outputRows) {
                String nonLocalizedName = row.attributeValue("refItem");
                if (nonLocalizedName == null) continue;
                String localizedName = row.attributeValue("RawXML");
                this._results.put(nonLocalizedName, localizedName);
                this._translatedValues.put(nonLocalizedName, localizedName);
            }
            return true;
        }
        return false;
    }

    public void applyResponseToReportSpec(Document report) {
        for (String string : this._requestedDataItems) {
            if (this._results.get(string) != null) continue;
            this.markMatchingItems(report, string, "");
        }
        for (Map.Entry entry : this._results.entrySet()) {
            this.markMatchingItems(report, (String)entry.getKey(), (String)entry.getValue());
        }
        this._translatedValues.saveTranslations(report);
    }

    private void markMatchingItems(Document report, String name, String translatedLabel) {
        String labelProp = "label_" + this._env.getLocale();
        List matches = V5X.selectNodes(report.getRootElement(), "//V5X//CHILD", "queries", "query", "selection", "//V5X//ANYCHILD", "//V5X//ATTR", "name", name);
        if (matches.size() > 0) {
            for (Element item : matches) {
                V5SpecHelper.setXMLAttribute(item, labelProp, translatedLabel, "no");
            }
        }
    }

    class TranslationSet {
        private Document _document = null;
        protected HashMap<String, DataItems> _dataItemsForName = new HashMap();
        protected HashMap<V5Query, DataItems> _dataItemsForQuery = new HashMap();
        protected HashMap<String, String> _valuesToBeTranslated = new HashMap();

        TranslationSet() {
        }

        public void addItem(ActionEnv env, V5Query v5Query, Element dataItem) {
            String customLabel;
            String labelProp;
            if (this._document == null) {
                this._document = dataItem.getDocument();
            }
            if (!(V5SpecHelper.getXMLAttribute(dataItem, labelProp = "label_" + env.getLocale()) != null || (customLabel = dataItem.attributeValue("label")) != null && V5SpecHelper.compareLocales(env.getLocale(), V5SpecHelper.getExpressionLocale(dataItem), true))) {
                this.addToQueryItemList(v5Query, dataItem);
                this.addToNameList(dataItem);
            }
        }

        public boolean hasItems() {
            return this._dataItemsForName.size() > 0;
        }

        public Document getDocument() {
            return this._document;
        }

        private void addToQueryItemList(V5Query v5Query, Element dataItem) {
            if (this._dataItemsForName.get(dataItem.attributeValue("name")) != null) {
                return;
            }
            DataItems dataItemsForQuery = this._dataItemsForQuery.get(v5Query);
            if (dataItemsForQuery == null) {
                dataItemsForQuery = new DataItems();
                this._dataItemsForQuery.put(v5Query, dataItemsForQuery);
            }
            dataItemsForQuery.addDataItem(dataItem);
        }

        private void addToNameList(Element dataItem) {
            String dataItemName = dataItem.attributeValue("name");
            DataItems dataItemsForName = this._dataItemsForName.get(dataItemName);
            if (dataItemsForName == null) {
                dataItemsForName = new DataItems();
                this._dataItemsForName.put(dataItemName, dataItemsForName);
            }
            dataItemsForName.addDataItem(dataItem);
        }
    }

    class DataItems {
        private ArrayList<Element> _dataItems = new ArrayList();

        DataItems() {
        }

        public void addDataItem(Element dataItem) {
            this._dataItems.add(dataItem);
        }

        public ArrayList<Element> getDataItems() {
            return this._dataItems;
        }
    }
}

