/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5requestcreators;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5requestcreators.V5ReportRequest;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5LocalizedNamesRequest
extends V5ReportRequest {
    ActionEnv _env = null;
    V5Query _sourceV5Query = null;
    CognosServiceOptions _requestOptions = new CognosServiceOptions();
    private List<String> _itemNameList = new ArrayList<String>();
    private HashMap<String, String> _results = new HashMap();

    public V5LocalizedNamesRequest(ActionEnv env, V5Query v5Query) {
        this._env = env;
        this._sourceV5Query = v5Query;
        this._createdReportId = "LocalizedNames";
    }

    public void addItem(String name) {
        Element itemElement = this._sourceV5Query.findItem(name);
        if (itemElement != null && V5QueryItem.isNameLocalizable(itemElement)) {
            this._itemNameList.add(name);
        }
    }

    public boolean hasItems() {
        return this._itemNameList.size() > 0;
    }

    public HashMap<String, String> getResults() {
        return this._results;
    }

    public void disableFilters() {
        V5QueryFilters.disableFilters(this.getDocument().getRootElement());
    }

    @Override
    public void create() throws ActionException {
        Element targetReport = this.cloneReportQueries(this._sourceV5Query.getQueryElement().getDocument());
        Element targetPageBodyContents = this.createBasicReportPageContents("LocalizedItemsRequestPage");
        V5SpecHelper.removeAllDynamicDataFilters(targetReport.getDocument().getRootElement());
        this.disableFilters();
        Element newCrosstab = targetPageBodyContents.addElement("crosstab");
        newCrosstab.addAttribute("name", this._createdReportId);
        newCrosstab.addAttribute("refQuery", this._sourceV5Query.getQueryName());
        Element crosstabAxis = newCrosstab.addElement("crosstabRows");
        for (String name : this._itemNameList) {
            Element newNameNode = crosstabAxis.addElement("crosstabNode");
            Element newName = DocumentHelper.makeElement((Branch)newNameNode, (String)V5X.getMakeElementPath("crosstabNodeMembers", "crosstabSpacer", "contents", "textItem", "dataSource", "staticValue"));
            newName.setText(name);
            Element newCrosstabNode = crosstabAxis.addElement("crosstabNode");
            Element newNodeMember = DocumentHelper.makeElement((Branch)newCrosstabNode, (String)V5X.getMakeElementPath("crosstabNodeMembers", "crosstabNodeMember"));
            newNodeMember.addAttribute("refDataItem", name);
            Element dataItemLabel = DocumentHelper.makeElement((Branch)newNodeMember, (String)V5X.getMakeElementPath("contents", "textItem", "dataSource", "dataItemLabel"));
            dataItemLabel.addAttribute("refDataItem", name);
            Element newSpacerNode = crosstabAxis.addElement("crosstabNode");
            Element element = DocumentHelper.makeElement((Branch)newSpacerNode, (String)V5X.getMakeElementPath("crosstabNodeMembers", "crosstabSpacer", "contents", "textItem", "dataSource", "staticValue"));
        }
    }

    public Document initializeRequest() throws ActionException {
        this.create();
        this._requestOptions.addOption("run.outputFormat", "XML");
        this._requestOptions.addOption("run.verticalElements", "0");
        this._requestOptions.addOption("run.selectionBasedFeatures", "false");
        this._requestOptions.addOption("asynch.primaryWaitThreshold", "0");
        this._requestOptions.addOption("asynch.secondaryWaitThreshold", "0");
        return this.getDocument();
    }

    public boolean execute(RapServiceRequestManager rapServiceRequestMgr) throws ActionException {
        Document responseDoc;
        if (rapServiceRequestMgr != null && (responseDoc = this.initializeRequest()) != null) {
            return this.processResponse(rapServiceRequestMgr.runReportSpecification(responseDoc.asXML(), this._requestOptions));
        }
        return false;
    }

    public boolean processResponse(CognosServiceResponse response) {
        if (response != null && response.getDOMValue() != null) {
            List outputRows = V5X.selectNodes(response.getDOMValue(), "rows", "caption");
            String nonLocalizedName = null;
            String localizedName = null;
            for (Element row : outputRows) {
                if (nonLocalizedName == null) {
                    nonLocalizedName = row.getText();
                    continue;
                }
                if ("".equals(row.getText())) {
                    if (localizedName != null) {
                        this._results.put(nonLocalizedName, localizedName);
                    }
                    localizedName = null;
                    nonLocalizedName = null;
                    continue;
                }
                localizedName = row.getText();
            }
            return true;
        }
        return false;
    }
}

