/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5requestcreators;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5requestcreators.V5CrosstabReportRequest;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5MaxMinRangeRequest
extends V5CrosstabReportRequest {
    ActionEnv _env = null;
    V5DataContainer _sourceContainer = null;
    String _nameToGetValuesFor = null;
    String _previousMin = null;
    String _previousMax = null;

    public V5MaxMinRangeRequest(ActionEnv env, V5DataContainer sourceContainer, String nameToGetValuesFor, String previousMin, String previousMax) {
        this._createdReportId = "MaxMinRange";
        this._env = env;
        this._sourceContainer = sourceContainer;
        this._nameToGetValuesFor = nameToGetValuesFor;
        this._previousMin = previousMin;
        this._previousMax = previousMax;
    }

    @Override
    public void create() throws ActionException {
        Document sourceDocument = this._sourceContainer.getContainerElement().getDocument();
        this._outputReportDoc = (Document)sourceDocument.clone();
        V5SpecHelper.removeAllDynamicDataFilters(this._outputReportDoc.getRootElement());
        this.preprocessReport();
    }

    private void preprocessReport() throws ActionException {
        this.changeQueryForDetailContainer();
        String minmaxFilterExpression = null;
        if (this._previousMin != null && this._previousMax != null) {
            minmaxFilterExpression = "[" + this._nameToGetValuesFor + "] < " + this._previousMin + " or " + "[" + this._nameToGetValuesFor + "] > " + this._previousMax;
        }
        List queries = V5X.selectNodes(this._outputReportDoc.getRootElement(), "queries", "query");
        for (Element query : queries) {
            if (minmaxFilterExpression != null) {
                this.addFilterNotBetween(query, minmaxFilterExpression);
            }
            this.changeTotalAggregatesToMinimum(query);
        }
        if (this.getRowRetrievalLimit() > 0) {
            String sourceQueryName = this._sourceContainer.getV5Query().getQueryName();
            V5Query targetQuery = new V5Query(this._env, this._outputReportDoc.getRootElement(), sourceQueryName);
            this.limitRowsToRetrieve(targetQuery, this.getRowRetrievalLimit(), this._nameToGetValuesFor);
        }
        List pageGroups = V5X.selectNodes(this._outputReportDoc.getRootElement(), "//V5X//CHILD", "layouts", "layout", "//V5X//ANY", "pageGroups");
        for (Element pageGroup : pageGroups) {
            pageGroup.detach();
        }
    }

    private void changeQueryForDetailContainer() {
        Element targetContainerElement = V5X.selectSingleNode(this._outputReportDoc, this._sourceContainer.getContainerElement().getName(), "//V5X//ATTR", "name", this._sourceContainer.getID());
        if (targetContainerElement == null) {
            return;
        }
        String masterContainerQueryName = targetContainerElement.attributeValue("refQuery");
        if (masterContainerQueryName == null) {
            return;
        }
        List mdLinkNodes = V5X.selectNodes(targetContainerElement, "//V5X//CHILD", "//V5X//ANYCHILD", "//V5X//ANY", "masterDetailLink");
        for (Element mdLinkNode : mdLinkNodes) {
            Element detailContainer = V5SpecHelper.findParentContainer(mdLinkNode);
            if (detailContainer == null || !V5SpecHelper.ifInnerMostDetailContainerWithSameQuery(masterContainerQueryName, detailContainer)) continue;
            V5Query detailQuery = new V5Query(detailContainer, detailContainer.attributeValue("refQuery"));
            V5SpecHelper.cloneQueryAndRedirectContainer(detailContainer, detailQuery);
        }
    }

    private void changeTotalAggregatesToMinimum(Element query) {
        List dimensionalEdgeSummaries = V5X.selectNodes(query, "dataItemDimensionalEdgeSummary");
        for (Element summary : dimensionalEdgeSummaries) {
            summary.addAttribute("aggregateMethod", "minimum");
        }
        List dataItems = V5X.selectNodes(query, "dataItem");
        for (Element dataItem : dataItems) {
            Element expression;
            String rollupAggregateValue;
            if (dataItem.attribute("rollupAggregate") != null && ("total".equals(rollupAggregateValue = dataItem.attributeValue("rollupAggregate")) || "aggregate".equals(rollupAggregateValue))) {
                dataItem.addAttribute("rollupAggregate", "minimum");
            }
            if ((expression = dataItem.element("expression")) == null) continue;
            String elementText = expression.getText();
            elementText = elementText.replaceAll("[T|t][O|o][T|t][A|a][L|l]\\s*\\(\\s*[C|c][U|u][R|r][R|r][E|e][N|n][T|t][M|m][E|e][A|a][S|s][U|u][R|r][E|e]", "minimum(currentMeasure");
            elementText = elementText.replaceAll("[A|a][G|g][G|g][R|r][E|e][G|g][A|a][T|t][E|e]\\s*\\(\\s*[C|c][U|u][R|r][R|r][E|e][N|n][T|t][M|m][E|e][A|a][S|s][U|u][R|r][E|e]", "minimum(currentMeasure");
            expression.setText(elementText);
        }
    }

    public void addFilterNotBetween(Element queryElement, String filterExpression) {
        Element detailFilters = DocumentHelper.makeElement((Branch)queryElement, (String)"detailFilters");
        Element detailFilter = detailFilters.addElement("detailFilter");
        detailFilter.addAttribute("postAutoAggregation", "true");
        Element detailFilterExpressionElement = detailFilter.addElement("filterExpression");
        detailFilterExpressionElement.setText(filterExpression);
    }
}

