/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5requestcreators;

import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class V5ReportRequest {
    protected String _createdReportId = null;
    protected Document _outputReportDoc = null;
    protected int _rowRetrievalLimit = 0;

    public Document getDocument() {
        return this._outputReportDoc;
    }

    public void create() throws ActionException {
        throw new ActionException("Can't call create() on an unknown report type!");
    }

    public void setRowRetrievalLimit(int value) {
        this._rowRetrievalLimit = value;
    }

    public int getRowRetrievalLimit() {
        return this._rowRetrievalLimit;
    }

    protected Element cloneReportFramework(Document sourceReportDoc, V5DataContainer sourceContainer) {
        Element targetReport = this.cloneReportQueries(sourceReportDoc);
        return this.createLayouts(sourceReportDoc.getRootElement(), targetReport, sourceContainer);
    }

    protected Element cloneReportQueries(Document sourceReportDoc) {
        Element sourceReport = sourceReportDoc.getRootElement();
        Element sourceQueries = sourceReport.element("queries");
        Element sourceModelPath = sourceReport.element("modelPath");
        Element sourceXMLAttributes = sourceReport.element("XMLAttributes");
        this._outputReportDoc = DocumentHelper.createDocument();
        Element targetReport = V5SpecHelper.shallowCopy(sourceReport);
        targetReport.add((Element)sourceQueries.clone());
        targetReport.add((Element)sourceModelPath.clone());
        targetReport.add((Element)sourceXMLAttributes.clone());
        this._outputReportDoc.add(targetReport);
        return targetReport;
    }

    protected Element createLayouts(Element sourceReport, Element targetReport, V5DataContainer sourceContainer) {
        Element sourceLayouts = (Element)sourceReport.selectSingleNode(V5X.selectImmediateChildren("layouts"));
        Element targetLayouts = targetReport.addElement("layouts");
        return V5ReportRequest.createSimilarReportPage(sourceLayouts, sourceContainer.getContainerElement(), targetLayouts);
    }

    protected static Element createSimilarLayoutAbovePage(Element sourceLayouts, Element sourcePage, Element targetLayouts) {
        Element targetPageParent = null;
        Element targetNode = null;
        Element targetChild = null;
        for (Element sourceNode = sourcePage.getParent(); sourceNode != sourceLayouts; sourceNode = sourceNode.getParent()) {
            targetNode = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)sourceNode.getName(), (Namespace)sourcePage.getNamespace()));
            if ("pageSet".equals(sourceNode.getName())) {
                V5DataContainer.cloneAttribute(sourceNode, "name", targetNode);
                V5DataContainer.cloneAttribute(sourceNode, "refQuery", targetNode);
                V5DataContainer.cloneChild(sourceNode, "pageGroups", targetNode);
                V5DataContainer.cloneChild(sourceNode, "masterDetailLinks", targetNode);
                if (!"detailPages".equals(targetChild.getName())) {
                    targetNode.addElement("detailPages");
                }
            }
            if (targetPageParent == null) {
                targetPageParent = targetNode;
            } else {
                targetNode.add(targetChild);
            }
            targetChild = targetNode;
        }
        targetLayouts.add(targetNode);
        return targetPageParent;
    }

    protected static Element createSimilarReportPage(Element sourceLayouts, Element sourcePart, Element targetLayouts) {
        Element sourcePage = (Element)sourcePart.selectSingleNode(V5X.selectAncestors("page"));
        Element sourcePageBody = (Element)sourcePage.selectSingleNode(V5X.selectImmediateChildren("pageBody"));
        Element targetPageParent = V5ReportRequest.createSimilarLayoutAbovePage(sourceLayouts, sourcePage, targetLayouts);
        Element targetPage = targetPageParent.addElement("page");
        V5DataContainer.cloneAttribute(sourcePage, "name", targetPage);
        V5DataContainer.cloneAttribute(sourcePage, "refQuery", targetPage);
        V5DataContainer.cloneChild(sourcePage, "masterDetailLinks", targetPage);
        V5DataContainer.cloneChild(sourcePage, "style", targetPage);
        Element targetPageBody = targetPage.addElement("pageBody");
        V5DataContainer.cloneChild(sourcePageBody, "style", targetPageBody);
        Element pageBodyContents = targetPageBody.addElement("contents");
        return pageBodyContents;
    }

    public Element createBasicReportPageContents(String pageName) {
        Element pageNode = DocumentHelper.makeElement((Branch)this._outputReportDoc.getRootElement(), (String)"layouts/layout/reportPages/page");
        pageNode.addAttribute("name", pageName);
        Element pageContentsNode = DocumentHelper.makeElement((Branch)pageNode, (String)"pageBody/contents");
        return pageContentsNode;
    }

    protected Element addListColumn(Element listColumns, String columnRDI) {
        Element newColumn = listColumns.addElement("listColumn");
        DocumentHelper.makeElement((Branch)newColumn, (String)"listColumnTitle/contents");
        Element listColumnRDI = DocumentHelper.makeElement((Branch)newColumn, (String)"listColumnBody/contents/textItem/dataSource/dataItemValue");
        listColumnRDI.addAttribute("refDataItem", columnRDI);
        return newColumn;
    }

    protected Element addLabelListColumn(Element listColumns, String columnRDI) {
        Element newColumn = listColumns.addElement("listColumn");
        DocumentHelper.makeElement((Branch)newColumn, (String)"listColumnTitle/contents");
        Element listColumnRDI = DocumentHelper.makeElement((Branch)newColumn, (String)"listColumnBody/contents/textItem/dataSource/dataItemLabel");
        listColumnRDI.addAttribute("refDataItem", columnRDI);
        return newColumn;
    }

    protected void limitRowsToRetrieve(V5Query query, int limit, String dataItemName) throws ActionException {
        if (limit > 0) {
            Element runningCountDataItem = query.getItemList().addDataItem("__runningcount__" + dataItemName, "running-count([" + V5SpecHelper.escapeQueryReferenceTerm(dataItemName) + "])");
            Element detailFilters = DocumentHelper.makeElement((Branch)query.getQueryElement(), (String)"detailFilters");
            Element runningCountFilter = detailFilters.addElement("detailFilter");
            runningCountFilter.addAttribute("postAutoAggregation", "true");
            Element filterExpressionElement = runningCountFilter.addElement("filterExpression");
            filterExpressionElement.setText("[" + V5SpecHelper.escapeQueryReferenceTerm(runningCountDataItem.attributeValue("name")) + "] <= " + limit);
        }
    }

    protected void addSingleton(Element contents, String singletonName, String singletonRefQuery, String dataItemLabelRDI) {
        Element singleton = contents.addElement("singleton");
        singleton.addAttribute("name", singletonName);
        singleton.addAttribute("refQuery", singletonRefQuery);
        Element dataItemLabel = DocumentHelper.makeElement((Branch)singleton, (String)"contents/textItem/dataSource/dataItemLabel");
        dataItemLabel.addAttribute("refDataItem", dataItemLabelRDI);
    }
}

