/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.AnnotationInfoBarAdornment;
import com.cognos.rap.actions.v5spechelpers.CSSHelper;
import com.cognos.rap.actions.v5spechelpers.IV5PageAdornment;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5TableHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPMessageManager;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class AnnotationAdornment
implements IV5PageAdornment {
    private final boolean enableReportMarkers = false;
    private static final String _annotations = "annotations";
    private static final String _AnnotationsSpec = "AnnotationsSpec";
    private static final String _layoutComponentId = "layoutComponentId";
    private static final String _cellAnnotations = "cellAnnotations";
    private static final String _contextValues = "contextValues";
    private static final String _displayValue = "displayValue";
    private static final String _useValue = "useValue";
    private static final String _isMeasure = "isMeasure";
    private static final String _comments = "comments";
    private static final String expStartBracket = "[";
    private static final String expEndBracket = "]";
    private static final String expSeperator = ".";
    private static final String apos = "'";
    private static final String quote = "\"";
    private static final String equals = "=";
    private static final String _if = "if";
    private static final String _elseIf = "else if";
    private static final String then = "then";
    private static final String and = "and";
    private static final String conditionStartBracket = "(";
    private static final String conditionEndBracket = ")";
    private static final String InScope = "InScope";
    private static final String space = " ";
    private boolean _isFirstComponent = true;

    @Override
    public boolean canAdd(Element actionArguments) {
        String addAnnotations = actionArguments.attributeValue(_annotations);
        return "true".equals(addAnnotations);
    }

    @Override
    public void add(Document v5Report, Element actionArguments, String locale) throws ActionException {
        try {
            Element annotationsSpec = actionArguments.element(_AnnotationsSpec);
            if (annotationsSpec != null) {
                JSONObject jsonAnnotationsSpecification = (JSONObject)JSON.parse((String)annotationsSpec.getText());
                JSONArray widgetLevelAnnotationArray = (JSONArray)jsonAnnotationsSpecification.get((Object)"widgetAnnotations");
                if (widgetLevelAnnotationArray.size() > 0) {
                    Element parent = this.getAnnotationPageContents(v5Report.getRootElement(), locale);
                    String title = RAPMessageManager.convert("RAP_REPORT_ANNOTATIONS_TITLE", locale);
                    this.addLayoutComponentId(parent, title);
                    this.addCellAnnotationsToAnnotationsPage("", null, widgetLevelAnnotationArray, parent, locale);
                    this._isFirstComponent = false;
                }
                JSONArray jsonLayoutComponentCellAnnotations = (JSONArray)jsonAnnotationsSpecification.get((Object)_cellAnnotations);
                List reportPageContents = XMLUtility.selectNodes(v5Report, "./*[local-name()='report']/*[local-name()='layouts']/*[local-name()='layout']/*[local-name()='reportPages']//*[local-name()='page']/*[local-name()='pageBody']//*[local-name()='contents']/*[local-name()='crosstab' or local-name()='list']");
                block2: for (Element content : reportPageContents) {
                    String contentName = content.getName();
                    if (!"crosstab".equals(contentName) && !"list".equals(contentName)) continue;
                    String reportLayoutComponentName = content.attributeValue("name");
                    int numberOflayoutComponentCellAnnotations = jsonLayoutComponentCellAnnotations.size();
                    for (int index = 0; index < numberOflayoutComponentCellAnnotations; ++index) {
                        JSONObject layoutComponentCellAnnotations = (JSONObject)jsonLayoutComponentCellAnnotations.get(index);
                        String layoutComponentId = (String)layoutComponentCellAnnotations.get((Object)_layoutComponentId);
                        if (!reportLayoutComponentName.equals(layoutComponentId)) continue;
                        Element layoutComponentNode = (Element)v5Report.selectSingleNode(V5X.selectByName(layoutComponentId));
                        if (layoutComponentNode == null) continue block2;
                        JSONArray jsonCellAnnotations = (JSONArray)layoutComponentCellAnnotations.get((Object)_cellAnnotations);
                        this.addLayoutComponentCellAnnotations(layoutComponentNode, jsonCellAnnotations, locale, layoutComponentId);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ActionException(exception.getLocalizedMessage());
        }
    }

    private Element getAnnotationPageContents(Element v5Report, String locale) {
        Element annotationPageContents = null;
        Element reportPages = (Element)v5Report.selectSingleNode("./*[local-name()='layouts']/*[local-name()='layout']/*[local-name()='reportPages']");
        if (reportPages != null) {
            Element annotationsPage = (Element)reportPages.selectSingleNode(".//*[local-name()='page'][./*[local-name()='XMLAttributes']/*[local-name()='XMLAttribute'][@name='RAP_COMMENT_PAGE']]");
            if (annotationsPage == null) {
                annotationsPage = reportPages.addElement("page");
                annotationsPage.addAttribute("name", RAPMessageManager.convert("RAP_ANNOTATIONS_PAGE_TITLE", locale));
                V5SpecHelper.setXMLAttribute(annotationsPage, "RAP_COMMENT_PAGE", "true", "no");
                Element pageBody = annotationsPage.addElement("pageBody");
                annotationPageContents = pageBody.addElement("contents");
            } else {
                annotationPageContents = (Element)annotationsPage.selectSingleNode(V5X.selectImmediateChildren("pageBody") + V5X.subselectImmediateChildren("contents"));
            }
        }
        return annotationPageContents;
    }

    private void addLayoutComponentCellAnnotations(Element layoutComponentNode, JSONArray jsonCellAnnotations, String locale, String layoutComponentId) {
        Element annotationPageContents = this.getAnnotationPageContents(layoutComponentNode.getDocument().getRootElement(), locale);
        if (annotationPageContents != null) {
            this.addLayoutComponentId(annotationPageContents, layoutComponentId);
            int numberOfCellAnotations = jsonCellAnnotations.size();
            for (int index = 0; index < numberOfCellAnotations; ++index) {
                JSONObject cellAnnotation = (JSONObject)jsonCellAnnotations.get(index);
                this.addCellAnnotation(Integer.toString(index), annotationPageContents, layoutComponentNode, cellAnnotation, locale);
            }
        }
    }

    private void buildReportVariable(Element layoutComponentNode, JSONArray jsonCellAnnotations) {
        boolean isCrosstab = "crosstab".equals(layoutComponentNode.getName());
        Element report = (Element)layoutComponentNode.selectSingleNode(V5X.selectAncestors("report"));
        Element reportVariables = report.element("reportVariables");
        if (reportVariables == null) {
            reportVariables = report.addElement("reportVariables");
        }
        Element reportVariable = reportVariables.addElement("reportVariable");
        reportVariable.addAttribute("type", "string");
        String layoutComponentNodeName = layoutComponentNode.attributeValue("name");
        reportVariable.addAttribute("name", _annotations + layoutComponentNodeName);
        Element variableValues = reportVariable.addElement("variableValues");
        StringBuffer reportExpression = new StringBuffer("");
        int numberOfCellAnotations = jsonCellAnnotations.size();
        for (int cellAnnotationIndex = 0; cellAnnotationIndex < numberOfCellAnotations; ++cellAnnotationIndex) {
            JSONObject cellAnnotation = (JSONObject)jsonCellAnnotations.get(cellAnnotationIndex);
            this.buildReportExpression(reportExpression, cellAnnotationIndex, cellAnnotation, isCrosstab);
            Element variableValue = variableValues.addElement("variableValue");
            variableValue.addAttribute("value", Integer.toString(cellAnnotationIndex));
        }
        Element reportExpressionNode = reportVariable.addElement("reportExpression");
        reportExpressionNode.setText(reportExpression.toString());
    }

    private void buildReportExpression(StringBuffer reportExpression, int cellAnnotationIndex, JSONObject cellAnnotation, boolean isCrosstab) {
        String query = (String)cellAnnotation.get((Object)"query");
        if (query != null && query.length() > 0) {
            JSONArray contextValues = (JSONArray)cellAnnotation.get((Object)_contextValues);
            if (reportExpression.length() == 0) {
                reportExpression.append("if(");
            } else {
                reportExpression.append("else if(");
            }
            int numberOfContextItems = contextValues.size();
            String inScopeStr = "";
            StringBuffer contextExpression = new StringBuffer("");
            for (int contextItemIndex = 0; contextItemIndex < numberOfContextItems; ++contextItemIndex) {
                JSONObject contextItem = (JSONObject)contextValues.get(contextItemIndex);
                if (contextExpression.length() != 0) {
                    contextExpression.append(" and ");
                }
                String refDataItem = (String)contextItem.get((Object)"refDataItem");
                Boolean isMeasure = (Boolean)contextItem.get((Object)_isMeasure);
                if (isMeasure.booleanValue() && isCrosstab && numberOfContextItems > 1) {
                    inScopeStr = expStartBracket + query + expEndBracket + expSeperator + expStartBracket + refDataItem + expEndBracket;
                    continue;
                }
                String displayValue = (String)contextItem.get((Object)_displayValue);
                contextExpression.append(expStartBracket + query + expEndBracket + expSeperator + expStartBracket + refDataItem + expEndBracket + space + equals + space);
                if (isMeasure.booleanValue()) {
                    contextExpression.append(displayValue);
                    continue;
                }
                contextExpression.append(apos + displayValue + apos);
            }
            if (!"".equals(inScopeStr)) {
                contextExpression.append(" and InScope(" + inScopeStr + conditionEndBracket);
            }
            contextExpression.append(") then\"" + Integer.toString(cellAnnotationIndex) + quote);
            reportExpression.append(contextExpression);
        }
    }

    private void addCellAnnotation(String annotationId, Element annotationPageContents, Element layoutComponentNode, JSONObject cellAnnotation, String locale) {
        JSONArray contextValues = (JSONArray)cellAnnotation.get((Object)_contextValues);
        JSONArray comments = (JSONArray)cellAnnotation.get((Object)_comments);
        this.addCellAnnotationsToAnnotationsPage(annotationId, contextValues, comments, annotationPageContents, locale);
    }

    private void addCellAnnotationIndicators(String annotationId, JSONArray contextValues, Element layoutComponentNode) {
        String layoutComponentType = layoutComponentNode.getName();
        JSONObject contextValue = (JSONObject)contextValues.get(0);
        String refDataItem = (String)contextValue.get((Object)"refDataItem");
        boolean isContextColumnTitle = this.isContextColumnTitleSelection(layoutComponentNode, contextValues);
        if ("list".equals(layoutComponentType) && isContextColumnTitle) {
            this.addAnnotationIndicatorToListColumnTitle(annotationId, layoutComponentNode, contextValue);
        } else {
            String targetXPath = "";
            if ("crosstab".equals(layoutComponentType)) {
                Boolean isMeasure = (Boolean)contextValue.get((Object)_isMeasure);
                targetXPath = isMeasure.booleanValue() ? (contextValues.size() == 1 ? V5X.selectImmediateChildren("crosstabCorner") + V5X.subselectImmediateChildren("contents") : V5X.selectImmediateChildren("crosstabFactCell") + V5X.subselectImmediateChildren("contents")) : V5X.selectByRdi(refDataItem) + V5X.subselectImmediateChildren("contents");
            } else if ("list".equals(layoutComponentType)) {
                targetXPath = V5X.selectImmediateChildren("listColumns") + V5X.subselectImmediateChildren("listColumn") + V5X.subselectImmediateChildren("listColumnBody") + expStartBracket + V5X.selectByRdi(refDataItem) + expEndBracket + V5X.subselectImmediateChildren("contents");
            }
            if (!targetXPath.equals("")) {
                this.buildConditionalBlock(annotationId, layoutComponentNode, (Element)layoutComponentNode.selectSingleNode(targetXPath));
            }
        }
    }

    private void addAnnotationIndicatorToListColumnTitle(String annotationId, Element layoutComponentNode, JSONObject contextValue) {
        String refDataItem = (String)contextValue.get((Object)"refDataItem");
        String targetXPath = "./*[local-name()='listColumns']/*[local-name()='listColumn']/*[local-name()='listColumnTitle'][.//*[@refDataItem=" + V5X.safeValue(refDataItem) + "]]";
        Element listColumnTitle = (Element)layoutComponentNode.selectSingleNode(targetXPath);
        if (listColumnTitle != null) {
            V5TableHelper.addText(listColumnTitle, annotationId, CSSHelper.concat("font-weight:bold", CSSHelper.color("red"), "vertical-align:super", CSSHelper.fontSizePt(5)));
        }
    }

    private boolean isContextColumnTitleSelection(Element layoutComponentNode, JSONArray contextValues) {
        int numberOfContextValues;
        Element listColumns = layoutComponentNode.element("listColumns");
        if (listColumns != null && (numberOfContextValues = contextValues.size()) == 1) {
            int numberOfColumns = listColumns.elements("listColumn").size();
            if (numberOfColumns > 1) {
                return true;
            }
            JSONObject contextItem = (JSONObject)contextValues.get(0);
            String refDataItem = (String)contextItem.get((Object)"refDataItem");
            String displayValue = (String)contextItem.get((Object)_displayValue);
            String useValue = (String)contextItem.get((Object)_useValue);
            return refDataItem.equals(displayValue) && refDataItem.equals(useValue);
        }
        return false;
    }

    private void buildConditionalBlock(String annotationId, Element layoutComponentNode, Element target) {
        if (target != null) {
            Element conditionalBlocks = target.element("conditionalBlocks");
            if (conditionalBlocks == null) {
                conditionalBlocks = target.addElement("conditionalBlocks");
                Element conditionalBlockDefaults = conditionalBlocks.addElement("conditionalBlockDefault");
                conditionalBlockDefaults.addElement("contents");
                V5TableHelper.addCSS(conditionalBlockDefaults, CSSHelper.concat("text-decoration:line-through", "display:inline"));
            }
            String layoutComponentNodeName = layoutComponentNode.attributeValue("name");
            Element conditionalBlockCases = V5X.selectSingleNode(conditionalBlocks, "//V5X//CHILD", "conditionalBlockCases", "//V5X//ATTR", "refVariable", _annotations + layoutComponentNodeName);
            if (conditionalBlockCases == null) {
                conditionalBlockCases = conditionalBlocks.addElement("conditionalBlockCases");
                conditionalBlockCases.addAttribute("refVariable", _annotations + layoutComponentNodeName);
            }
            Element conditionalBlock = conditionalBlockCases.addElement("conditionalBlock");
            conditionalBlock.addAttribute("refVariableValue", annotationId);
            V5TableHelper.addCSS(conditionalBlock, CSSHelper.concat("font-weight:bold", CSSHelper.color("red"), "display:inline"));
            V5TableHelper.addText(conditionalBlock, annotationId, CSSHelper.concat("vertical-align:super", CSSHelper.fontSizePt(5)));
        }
    }

    private void addCellAnnotationsToAnnotationsPage(String annotationId, JSONArray contextValues, JSONArray comments, Element annotationPageContents, String locale) {
        this.addAnnotationDetailsTable(annotationPageContents, contextValues, comments, locale);
    }

    private void addAnnotationDetailsTable(Element parent, JSONArray contextValues, JSONArray comments, String locale) {
        if (contextValues != null) {
            StringBuffer title = new StringBuffer();
            this.addDisplayValuesToBuffer(title, contextValues, " - ");
            Element block = parent.addElement("block");
            V5TableHelper.addText(block, title.toString(), CSSHelper.concat("font-weight:bold", CSSHelper.fontSizePt(10)));
            V5TableHelper.addCSS(block, "margin-top:6px");
        }
        int numberOfComments = comments.size();
        for (int index = 0; index < numberOfComments; ++index) {
            JSONObject jsonComment = (JSONObject)comments.get(index);
            this.addAuthorTimeStampRow(parent, jsonComment);
            this.addFilterContext(parent, jsonComment, locale);
            this.addDescriptionRow(parent, jsonComment);
        }
    }

    private void addAuthorTimeStampRow(Element parent, JSONObject jsonComment) {
        String timeStamp = (String)jsonComment.get((Object)"timestamp");
        String author = (String)jsonComment.get((Object)"author");
        Element block = parent.addElement("block");
        V5TableHelper.addText(block, author, CSSHelper.concat("font-weight:bold", CSSHelper.fontSizePt(10), CSSHelper.color("#0F64BE")));
        V5TableHelper.addCSS(block, "margin-top:6px");
        block = parent.addElement("block");
        V5TableHelper.addText(block, timeStamp, CSSHelper.concat(CSSHelper.fontSizePt(8), CSSHelper.color("#666666")));
        V5TableHelper.addCSS(block, "font-size:10pt;margin-top:1px");
    }

    private void addDescriptionRow(Element parent, JSONObject jsonComment) {
        String description = (String)jsonComment.get((Object)"description");
        Element block = parent.addElement("block");
        V5TableHelper.addText(block, description, "font-size:10pt;line-height:13pt");
        V5TableHelper.addCSS(block, "margin-top:2px");
    }

    private void addDisplayValuesToBuffer(StringBuffer buffer, JSONArray contextValues, String seperator) {
        int numberOfItems = contextValues.size();
        String measureDisplayValue = null;
        for (int index = 0; index < numberOfItems; ++index) {
            JSONObject contextItem;
            Boolean isMeasure;
            if (buffer.length() != 0) {
                buffer.append(seperator);
            }
            if (!(isMeasure = (Boolean)(contextItem = (JSONObject)contextValues.get(index)).get((Object)_isMeasure)).booleanValue()) {
                buffer.append((String)contextItem.get((Object)_displayValue));
                continue;
            }
            measureDisplayValue = (String)contextItem.get((Object)_displayValue);
        }
        if (measureDisplayValue != null && buffer.length() != 0) {
            buffer.append(seperator);
            buffer.append(measureDisplayValue);
        }
    }

    private void addLayoutComponentId(Element parent, String id) {
        Element block = parent.addElement("block");
        V5TableHelper.addText(block, id, "font-weight:bold;font-size:12pt;");
        if (this._isFirstComponent) {
            this._isFirstComponent = false;
        } else {
            V5TableHelper.addCSS(block, "margin-top:18px");
        }
    }

    private void addFilterContext(Element parent, JSONObject jsonComment, String locale) {
        String parameterValues = (String)jsonComment.get((Object)"parameterValues");
        JSONObject reportInfo = (JSONObject)jsonComment.get((Object)"reportInfo");
        if (parameterValues != null || reportInfo != null) {
            Element block = parent.addElement("block");
            V5TableHelper.addText(block, "Filter Applied:", CSSHelper.color("#666666"));
            V5TableHelper.addCSS(block, "font-size:10pt;margin-top:2px");
            block = parent.addElement("block");
            Element contents = block.addElement("contents");
            AnnotationInfoBarAdornment annoInfoBar = new AnnotationInfoBarAdornment();
            annoInfoBar.addInfoBar(contents, reportInfo, parameterValues, locale);
        }
    }
}

