/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class CSSDefinition {
    public static String border = "border";
    public static final String border_top_color = "border-top-color";
    public static final String border_bottom_color = "border-bottom-color";
    public static final String border_left_color = "border-left-color";
    public static final String border_right_color = "border-right-color";
    public static final String border_top_style = "border-top-style";
    public static final String border_bottom_style = "border-bottom-style";
    public static final String border_left_style = "border-left-style";
    public static final String border_right_style = "border-right-style";
    public static final String border_top_width = "border-top-width";
    public static final String border_bottom_width = "border-bottom-width";
    public static final String border_left_width = "border-left-width";
    public static final String border_right_width = "border-right-width";
    public static final String border_top = "border-top";
    public static final String border_bottom = "border-bottom";
    public static final String border_left = "border-left";
    public static final String border_right = "border-right";
    public static final String padding = "padding";
    public static final String padding_top = "padding-top";
    public static final String padding_right = "padding-right";
    public static final String padding_bottom = "padding-bottom";
    public static final String padding_left = "padding-left";
    private String m_sCSSValue = null;
    private Map<String, String> m_mCSSProperties;

    public CSSDefinition(Element eCSS) {
        this.m_sCSSValue = eCSS.attributeValue("value");
        this.m_mCSSProperties = this.getProperties(this.m_sCSSValue);
        this.expandBorder();
        this.expandPadding();
    }

    private Map<String, String> getProperties(String sCSSValue) {
        StringTokenizer stringTokens = new StringTokenizer(sCSSValue, ";");
        HashMap<String, String> cssPropertiesMap = new HashMap<String, String>();
        while (stringTokens.hasMoreTokens()) {
            String cssPropertyAndValue = stringTokens.nextToken();
            String[] parms = cssPropertyAndValue.split(":");
            cssPropertiesMap.put(parms[0], parms[1]);
        }
        return cssPropertiesMap;
    }

    public Map<String, String> getProperties() {
        return this.m_mCSSProperties;
    }

    public String getProperty(String propName) {
        return this.m_mCSSProperties.get(propName);
    }

    public void setProperty(String name, String value) {
        this.m_mCSSProperties.put(name, value == null ? "" : value);
    }

    private void expandBorder() {
        String sBorderValue = this.m_mCSSProperties.get(border);
        if (sBorderValue != null && sBorderValue.length() > 0) {
            sBorderValue = sBorderValue.trim();
            String[] propValues = sBorderValue.split(" ");
            switch (propValues.length) {
                case 3: {
                    this.setBordersColor(propValues);
                    this.setBordersStyle(propValues);
                    this.setBordersWidth(propValues);
                    break;
                }
                case 2: {
                    this.setBordersStyle(propValues);
                    this.setBordersWidth(propValues);
                    break;
                }
                case 1: {
                    this.setBordersWidth(propValues);
                }
            }
        }
        if (this.m_mCSSProperties.containsKey(border_top)) {
            this.expandBorderSide(border_top);
        }
        if (this.m_mCSSProperties.containsKey(border_bottom)) {
            this.expandBorderSide(border_bottom);
        }
        if (this.m_mCSSProperties.containsKey(border_left)) {
            this.expandBorderSide(border_left);
        }
        if (this.m_mCSSProperties.containsKey(border_right)) {
            this.expandBorderSide(border_right);
        }
    }

    private void setBordersWidth(String[] propValues) {
        this.m_mCSSProperties.put(border_top_width, propValues[0]);
        this.m_mCSSProperties.put(border_bottom_width, propValues[0]);
        this.m_mCSSProperties.put(border_left_width, propValues[0]);
        this.m_mCSSProperties.put(border_right_width, propValues[0]);
    }

    private void setBordersStyle(String[] propValues) {
        this.m_mCSSProperties.put(border_top_style, propValues[1]);
        this.m_mCSSProperties.put(border_bottom_style, propValues[1]);
        this.m_mCSSProperties.put(border_left_style, propValues[1]);
        this.m_mCSSProperties.put(border_right_style, propValues[1]);
    }

    private void setBordersColor(String[] propValues) {
        this.m_mCSSProperties.put(border_top_color, propValues[2]);
        this.m_mCSSProperties.put(border_bottom_color, propValues[2]);
        this.m_mCSSProperties.put(border_left_color, propValues[2]);
        this.m_mCSSProperties.put(border_right_color, propValues[2]);
    }

    private void expandBorderSide(String sBorderSide) {
        String value = this.m_mCSSProperties.get(sBorderSide);
        if (value == null || value.length() == 0) {
            return;
        }
        value = value.trim();
        String[] propValues = value.split(" ");
        switch (propValues.length) {
            case 3: {
                this.m_mCSSProperties.put(sBorderSide + "-color", propValues[2]);
                this.m_mCSSProperties.put(sBorderSide + "-style", propValues[1]);
                this.m_mCSSProperties.put(sBorderSide + "-width", propValues[0]);
                break;
            }
            case 2: {
                this.m_mCSSProperties.put(sBorderSide + "-style", propValues[1]);
                this.m_mCSSProperties.put(sBorderSide + "-width", propValues[0]);
                break;
            }
            case 1: {
                this.m_mCSSProperties.put(sBorderSide + "-width", propValues[0]);
            }
        }
        this.m_mCSSProperties.remove(sBorderSide);
    }

    private void expandPadding() {
        String sPaddingValue = this.m_mCSSProperties.get(padding);
        if (sPaddingValue == null || sPaddingValue.length() == 0) {
            return;
        }
        sPaddingValue = sPaddingValue.trim();
        String[] values = sPaddingValue.split(" ");
        switch (values.length) {
            case 1: {
                this.setProperty(padding_top, values[0]);
                this.setProperty(padding_bottom, values[0]);
                this.setProperty(padding_left, values[0]);
                this.setProperty(padding_right, values[0]);
                break;
            }
            case 2: {
                this.setProperty(padding_top, values[0]);
                this.setProperty(padding_bottom, values[0]);
                this.setProperty(padding_left, values[1]);
                this.setProperty(padding_right, values[1]);
                break;
            }
            case 3: {
                this.setProperty(padding_top, values[0]);
                this.setProperty(padding_left, values[1]);
                this.setProperty(padding_right, values[1]);
                this.setProperty(padding_bottom, values[2]);
                break;
            }
            case 4: {
                this.setProperty(padding_top, values[0]);
                this.setProperty(padding_right, values[1]);
                this.setProperty(padding_bottom, values[2]);
                this.setProperty(padding_left, values[3]);
            }
        }
    }

    private void optimizeBorder() {
        String[] aBorders = new String[]{border_top, border_bottom, border_left, border_right};
        for (int i = 0; i < aBorders.length; ++i) {
            String sWidth = this.m_mCSSProperties.get(aBorders[i] + "-width");
            String sStyle = this.m_mCSSProperties.get(aBorders[i] + "-style");
            String sColor = this.m_mCSSProperties.get(aBorders[i] + "-color");
            if (sWidth == null || sWidth.length() == 0 || sStyle == null || sStyle.length() == 0 || sColor == null || sColor.length() == 0) continue;
            String sTemp = sWidth + " ";
            sTemp = sTemp + sStyle + " ";
            sTemp = sTemp + sColor;
            this.m_mCSSProperties.put(aBorders[i], sTemp);
            this.m_mCSSProperties.remove(aBorders[i] + "-width");
            this.m_mCSSProperties.remove(aBorders[i] + "-style");
            this.m_mCSSProperties.remove(aBorders[i] + "-color");
        }
        String sBorder_0 = this.m_mCSSProperties.get(aBorders[0]);
        String sBorder_1 = this.m_mCSSProperties.get(aBorders[1]);
        String sBorder_2 = this.m_mCSSProperties.get(aBorders[2]);
        String sBorder_3 = this.m_mCSSProperties.get(aBorders[3]);
        if (sBorder_0 != null && sBorder_0.length() != 0 && sBorder_1 != null && sBorder_1.length() != 0 && sBorder_2 != null && sBorder_2.length() != 0 && sBorder_3 != null && sBorder_3.length() != 0 && sBorder_0.equals(sBorder_1) && sBorder_1.equals(sBorder_2) && sBorder_2.equals(sBorder_3)) {
            this.m_mCSSProperties.put(border, sBorder_0);
            this.m_mCSSProperties.remove(aBorders[0]);
            this.m_mCSSProperties.remove(aBorders[1]);
            this.m_mCSSProperties.remove(aBorders[2]);
            this.m_mCSSProperties.remove(aBorders[3]);
        }
    }

    private void optimizePadding() {
        String sPaddingTop = this.m_mCSSProperties.get(padding_top);
        String sPaddingRight = this.m_mCSSProperties.get(padding_right);
        String sPaddingBottom = this.m_mCSSProperties.get(padding_bottom);
        String sPaddingLeft = this.m_mCSSProperties.get(padding_left);
        if (sPaddingTop != null && sPaddingTop.length() != 0 && sPaddingRight != null && sPaddingRight.length() != 0 && sPaddingBottom != null && sPaddingBottom.length() != 0 && sPaddingLeft != null && sPaddingLeft.length() != 0) {
            String sTemp = sPaddingTop;
            if (!(sPaddingTop.equals(sPaddingBottom) && sPaddingBottom.equals(sPaddingLeft) && sPaddingLeft.equals(sPaddingRight))) {
                sTemp = sTemp + " ";
                sTemp = sTemp + sPaddingRight;
                sTemp = sTemp + " ";
                sTemp = sTemp + sPaddingBottom;
                sTemp = sTemp + " ";
                sTemp = sTemp + sPaddingLeft;
            }
            this.m_mCSSProperties.put(padding, sTemp);
            this.m_mCSSProperties.remove(padding_top);
            this.m_mCSSProperties.remove(padding_right);
            this.m_mCSSProperties.remove(padding_bottom);
            this.m_mCSSProperties.remove(padding_left);
        }
    }

    public String toString() {
        this.optimizeBorder();
        this.optimizePadding();
        Iterator<Map.Entry<String, String>> it = this.m_mCSSProperties.entrySet().iterator();
        StringBuilder str = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<String, String> nameValuePair = it.next();
            if (nameValuePair.getValue() == null || nameValuePair.getValue().length() == 0) continue;
            str.append(nameValuePair.getKey());
            str.append(":");
            str.append(nameValuePair.getValue());
            if (!it.hasNext()) continue;
            str.append(";");
        }
        return str.toString();
    }
}

