/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.ibm.json.java.JSONArray;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ChangeDisplayPrimaryLayout {
    private static final String _primaryLayoutTagProp = "primaryLayoutTag";
    private static final String _primaryLayoutXMLProp = "primaryLayoutXML";
    private String _primaryLayoutTag = null;
    private String _primaryLayoutXML = null;

    public void initialize(V5DataContainer container) {
        if (!this.initializeFromXMLAttributes(container)) {
            this._primaryLayoutXML = container.getContainerElement().asXML();
            this._primaryLayoutTag = this.classify(container.getContainerElement());
        }
    }

    private boolean initializeFromXMLAttributes(V5DataContainer container) {
        this._primaryLayoutXML = null;
        this._primaryLayoutTag = V5SpecHelper.getXMLAttribute(container.getContainerElement(), _primaryLayoutTagProp);
        if (this._primaryLayoutTag != null) {
            this._primaryLayoutXML = V5SpecHelper.getXMLAttribute(container.getContainerElement(), _primaryLayoutXMLProp);
            return true;
        }
        return false;
    }

    public void save(Element targetChart) {
        if (this._primaryLayoutXML != null && this._primaryLayoutTag != null) {
            V5SpecHelper.setXMLAttribute(targetChart, _primaryLayoutXMLProp, this._primaryLayoutXML, "no");
            V5SpecHelper.setXMLAttribute(targetChart, _primaryLayoutTagProp, this._primaryLayoutTag, "no");
        }
        this._primaryLayoutXML = null;
        this._primaryLayoutTag = null;
    }

    public boolean matchesPrimaryLayout(Element targetDataContainer) {
        return this._primaryLayoutTag != null && this._primaryLayoutTag.equals(this.classify(targetDataContainer));
    }

    public boolean replace(Element containerToReplace) {
        if (this._primaryLayoutTag != null && this._primaryLayoutXML != null && this.matchesPrimaryLayout(containerToReplace)) {
            Element containerParent;
            List containerToReplaceAndSiblings;
            int iContainerToReplace;
            Document primaryLayoutDoc = null;
            try {
                primaryLayoutDoc = DocumentHelper.parseText((String)this._primaryLayoutXML);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (primaryLayoutDoc != null && primaryLayoutDoc.getRootElement() != null && this.validateReplaceContainer(containerToReplace, primaryLayoutDoc.getRootElement()) && (iContainerToReplace = (containerToReplaceAndSiblings = (containerParent = containerToReplace.getParent()).elements()).indexOf(containerToReplace)) != -1) {
                containerToReplaceAndSiblings.set(iContainerToReplace, primaryLayoutDoc.getRootElement());
                return true;
            }
            this._primaryLayoutTag = null;
            this._primaryLayoutXML = null;
        }
        return false;
    }

    private boolean validateReplaceContainer(Element containerInDoc, Element replaceWithContainer) {
        V5Query v5Query = new V5Query(containerInDoc.getDocument().getRootElement(), containerInDoc.attributeValue("refQuery"));
        if (v5Query.getItemList().getDataItemElements().size() > 0) {
            List<Element> rdiNodes = V5DataContainer.selectNodes(replaceWithContainer, "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refDataItem");
            for (Element rdiNode : rdiNodes) {
                if (v5Query.findItem(rdiNode.attributeValue("refDataItem")) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String classify(Element dataContainer) {
        JSONArray classifier = new JSONArray();
        classifier.add((Object)dataContainer.getName());
        if (!"crosstab".equals(dataContainer.getName()) && !"list".equals(dataContainer.getName())) {
            Element v5ComboAxis;
            if ("v2_combinationChart".equals(dataContainer.getName())) {
                v5ComboAxis = V5DataContainer.selectSingleNode(dataContainer, "v2_topLeftAxis", "v2_combinationChartTypes", "v2_bar", "//V5X//OR", "v2_line", "//V5X//OR", "v2_area");
                if (v5ComboAxis != null) {
                    classifier.add((Object)v5ComboAxis.getName());
                    if (v5ComboAxis.attributeValue("valueType") != null) {
                        classifier.add((Object)v5ComboAxis.attributeValue("valueType"));
                    }
                    if (v5ComboAxis.attributeValue("barShape") != null) {
                        classifier.add((Object)v5ComboAxis.attributeValue("barShape"));
                    }
                    if (v5ComboAxis.attributeValue("lineAreaShape") != null) {
                        classifier.add((Object)v5ComboAxis.attributeValue("lineAreaShape"));
                    }
                }
            } else if ("combinationChart".equals(dataContainer.getName()) && (v5ComboAxis = V5DataContainer.selectSingleNode(dataContainer, "combinationChartTypes", "bar", "//V5X//OR", "line", "//V5X//OR", "area")) != null) {
                classifier.add((Object)v5ComboAxis.getName());
                if (v5ComboAxis.attributeValue("seriesType") != null) {
                    classifier.add((Object)v5ComboAxis.attributeValue("seriesType"));
                }
            }
            String depth = dataContainer.attributeValue("depth");
            String orientation = dataContainer.attributeValue("orientation");
            String holeSize = dataContainer.attributeValue("holeSize");
            if (depth != null) {
                classifier.add((Object)("depth" + depth));
            }
            if (orientation != null) {
                classifier.add((Object)orientation);
            }
            if (holeSize != null) {
                classifier.add((Object)("holeSize" + holeSize));
            }
        }
        return classifier.toString();
    }
}

