/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.NameSpaceSetter;
import com.cognos.rap.utility.XMLUtility;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.Visitor;

public class ChangeDisplayTypeHelper {
    public static final String useOldName = "useOldName";
    public static final String ChartGroups_target = "target";
    private static final String CHART_GROUPS_PATH = "../templates/ps/portal/RAPChartGroups.xml";
    private static Element chartTemplates = null;
    public static final String chartTemplate = "chartTemplate";
    public static final String xmlFragment = "xmlFragment";
    public static final String convertMergeNodes = "convertMergeNodes";
    public static final String convertCopyNodes = "convertCopyNodes";
    public static final String convertOverrideNodes = "convertOverrideNodes";
    public static final String convertDeepCopyNodes = "convertDeepCopyNodes";
    public static final String convertOverrideAttributes = "convertOverrideAttributes";
    public static final String convertOverrideStyles = "convertOverrideStyles";
    public static final String convertNamedSetRef = "convertNamedSetRef";
    public static final String convertNamedSet = "convertNamedSet";
    private static Map<String, Element> chartIdToElementMap = new HashMap<String, Element>();

    public static synchronized Element getChartTemplates() throws ActionException {
        if (chartTemplates == null) {
            try {
                File file = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(CHART_GROUPS_PATH));
                Document document = XMLUtility.createXMLDocument(file);
                chartTemplates = document.getRootElement();
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }
        return chartTemplates;
    }

    public static TargetDisplayType getTargetDisplayType(Arguments arguments) {
        String type = arguments.getArgument(ChartGroups_target);
        if ("crosstab".equals(type) || "crosstab".equals(type.toLowerCase())) {
            return TargetDisplayType.crosstab;
        }
        if ("list".equals(type) || "list".equals(type.toLowerCase())) {
            return TargetDisplayType.list;
        }
        return TargetDisplayType.chart;
    }

    public static boolean ifUseNewDataContainerName(Arguments arguments) {
        String value = arguments.getArgument(useOldName);
        if (value == null || value.length() == 0) {
            return true;
        }
        return !Boolean.parseBoolean(value);
    }

    public static void setDataContainerName(Element newDataContainer, String oldName, Arguments arguments) {
        V5DataContainer dataContainer = V5DataContainerFactory.create(newDataContainer);
        if (ChangeDisplayTypeHelper.ifUseNewDataContainerName(arguments)) {
            TargetDisplayType targetType = ChangeDisplayTypeHelper.getTargetDisplayType(arguments);
            String prefix = ChangeDisplayTypeHelper.getContainerNamePrefix(targetType);
            String containerName = V5SpecHelper.findUniqueName(newDataContainer.getDocument().getRootElement(), ".//*", prefix);
            dataContainer.setID(containerName);
        } else {
            dataContainer.setID(oldName);
        }
    }

    public static String getContainerNamePrefix(TargetDisplayType targetType) {
        if (targetType == TargetDisplayType.chart) {
            return "Chart";
        }
        if (targetType == TargetDisplayType.list) {
            return "List";
        }
        if (targetType == TargetDisplayType.crosstab) {
            return "Crosstab";
        }
        return "DataContainer";
    }

    public static Element getNewChartElement(Arguments arguments, Namespace namespace) throws ActionException {
        return ChangeDisplayTypeHelper.getNewChartElement(arguments.getArgument(ChartGroups_target).toLowerCase(), namespace);
    }

    public static Element getNewChartElement(String chartTypeId, Namespace namespace) throws ActionException {
        NameSpaceSetter nameSpaceSetter = new NameSpaceSetter(namespace);
        Element templateElement = ChangeDisplayTypeHelper.getChartElement(chartTypeId);
        Element chartElement = templateElement.createCopy();
        chartElement.accept((Visitor)nameSpaceSetter);
        return chartElement;
    }

    public static String getChartElementName(String displayTypeId) throws ActionException {
        return ChangeDisplayTypeHelper.getChartElement(displayTypeId).getName();
    }

    private static Element getChartElement(String chartTypeId) throws ActionException {
        Element chartElement = chartIdToElementMap.get(chartTypeId.toLowerCase());
        if (chartElement == null) {
            Element element = V5X.selectSingleNode(ChangeDisplayTypeHelper.getChartTemplates(), "//V5X//CHILD", xmlFragment, chartTemplate, "//V5X//ATTR", "name", chartTypeId);
            chartElement = (Element)element.elements().get(0);
            chartIdToElementMap.put(chartTypeId.toLowerCase(), chartElement);
        }
        return chartElement;
    }

    public static void updateDefaultMeasure(Element crosstabElement, Element chartElement) {
        Element defaultMeasureElement = (Element)crosstabElement.selectSingleNode(V5X.select("defaultMeasure"));
        String[] measures = ChartElements.measureNames.get(chartElement.getName());
        String defaultChartMeasureTagName = measures[measures.length - 1];
        Element defaultChartMeasureElement = (Element)chartElement.selectSingleNode(V5X.select(defaultChartMeasureTagName));
        if (defaultMeasureElement != null) {
            if (defaultChartMeasureElement == null) {
                defaultChartMeasureElement = chartElement.addElement(defaultChartMeasureTagName);
            }
            defaultChartMeasureElement.addAttribute("refDataItem", defaultMeasureElement.attributeValue("refDataItem"));
        } else if (defaultChartMeasureElement != null) {
            defaultChartMeasureElement.detach();
        }
    }

    public static void setDefaultMeasureForChart(String measureRDI, Element chartElement) {
        String[] measures = ChartElements.measureNames.get(chartElement.getName());
        String defaultChartMeasureTagName = measures[measures.length - 1];
        Element defaultChartMeasureElement = (Element)chartElement.selectSingleNode(V5X.select(defaultChartMeasureTagName));
        if (defaultChartMeasureElement == null) {
            defaultChartMeasureElement = chartElement.addElement(defaultChartMeasureTagName);
        }
        defaultChartMeasureElement.addAttribute("refDataItem", measureRDI);
    }

    public static void stripConversionRulesNodes(Element chartElement) {
        String[] nodesToRemove = new String[]{convertMergeNodes, convertCopyNodes, convertOverrideNodes, convertDeepCopyNodes, convertOverrideAttributes, convertOverrideStyles};
        for (int i = 0; i < nodesToRemove.length; ++i) {
            Node node = chartElement.selectSingleNode(V5X.select(nodesToRemove[i]));
            if (node == null) continue;
            node.detach();
        }
    }

    public static void puffChart(Element chartElement) {
        if (chartElement.getName().equalsIgnoreCase("list")) {
            DocumentHelper.makeElement((Branch)chartElement, (String)"listColumns");
        } else if (chartElement.getName().equalsIgnoreCase("crosstab")) {
            Element crosstabCorner = (Element)chartElement.selectSingleNode(V5X.selectImmediateChildren("crosstabCorner"));
            DocumentHelper.makeElement((Branch)crosstabCorner, (String)"contents");
            DocumentHelper.makeElement((Branch)chartElement, (String)"crosstabRows");
            DocumentHelper.makeElement((Branch)chartElement, (String)"crosstabColumns");
        } else {
            if (V5Chart.isV2Chart(chartElement)) {
                DocumentHelper.makeElement((Branch)chartElement, (String)"v2_chartBody");
            } else {
                DocumentHelper.makeElement((Branch)chartElement, (String)"chartBody");
            }
            if (!chartElement.getName().equals("mapChart")) {
                String legend;
                String[] measures = ChartElements.measureNames.get(chartElement.getName());
                DocumentHelper.makeElement((Branch)chartElement, (String)measures[measures.length - 1]);
                String ordinal = ChartElements.ordinalAxis.get(chartElement.getName());
                if (ordinal != null) {
                    DocumentHelper.makeElement((Branch)chartElement, (String)ordinal);
                }
                if ((legend = ChartElements.legendEdgeName.get(chartElement.getName())) != null) {
                    DocumentHelper.makeElement((Branch)chartElement, (String)legend);
                }
            } else {
                Element pointLayer;
                Element regionLayer = (Element)chartElement.selectSingleNode(V5X.selectImmediateChildren("regionLayer"));
                if (regionLayer != null) {
                    DocumentHelper.makeElement((Branch)regionLayer, (String)"mapRegionLocation");
                    DocumentHelper.makeElement((Branch)regionLayer, (String)"regionMeasure");
                    DocumentHelper.makeElement((Branch)regionLayer, (String)"defaultChartMeasure");
                }
                if ((pointLayer = (Element)chartElement.selectSingleNode(V5X.selectImmediateChildren("pointLayer"))) != null) {
                    DocumentHelper.makeElement((Branch)pointLayer, (String)"mapPointLocation");
                    DocumentHelper.makeElement((Branch)pointLayer, (String)"pointMeasure");
                    DocumentHelper.makeElement((Branch)pointLayer, (String)"pointSizeMeasure");
                    DocumentHelper.makeElement((Branch)pointLayer, (String)"defaultChartMeasure");
                }
            }
        }
    }

    public static void fixRefQuery(Element layoutElement) {
        List elements = XMLUtility.selectNodes(layoutElement, "( .//*[local-name()='baseline'] | .//*[local-name()='noteContent'] | .//*[local-name()='marker'] | .//*[local-name()='pointChartBaseline'] | .//*[local-name()='threeDComboBaseline'] | .//*[local-name()='chartTitle'] | .//*[local-name()='chartFooter'] | .//*[local-name()='chartSubTitle'] | .//*[local-name()='threeDScatterBaseline'] | .//*[local-name()='pointChartMarker'] | .//*[local-name()='v2_axisTitle'] | .//*[local-name()='v2_legendTitle'] | .//*[local-name()='axisTitle'] | .//*[local-name()='legendTitle'] | .//*[local-name()='regionColorLegendTitle'] | .//*[local-name()='pointColorLegendTitle'] | .//*[local-name()='pointSizeLegendTitle'])[not(@refQuery)]");
        for (Element element : elements) {
            Element refQueryNode = (Element)element.selectSingleNode("ancestor-or-self::*[@refQuery][1]");
            element.addAttribute("refQuery", refQueryNode.attributeValue("refQuery"));
        }
    }

    public static int getNumberOfMeasuresForChart(String chartType) {
        int measures = ChartElements.measureNames.get(chartType).length;
        if (ChartElements.bogusDefaultMeasureCharts.contains(chartType)) {
            --measures;
        }
        return measures;
    }

    public static void fixChartElement(Element chartElement) {
        String refDataItem;
        V5SpecHelper.removeLeafNodesByName(chartElement, "chartNodes");
        String legendEdgeName = ChartElements.legendEdgeName.get(chartElement.getName());
        V5SpecHelper.removeLeafNodesByName(chartElement, legendEdgeName);
        String ordinalAxisName = ChartElements.ordinalAxis.get(chartElement.getName());
        V5SpecHelper.removeLeafNodesByName(chartElement, ordinalAxisName);
        Element defaultChartMeasure = (Element)chartElement.selectSingleNode(V5X.select("defaultChartMeasure"));
        if (defaultChartMeasure != null && ((refDataItem = defaultChartMeasure.attributeValue("refDataItem")) == null || refDataItem.length() == 0)) {
            defaultChartMeasure.detach();
        }
    }

    public static void setMatrixElementForV2Chart(Element chartElement) {
        if (("v2_pieChart".equals(chartElement.getName()) || "v2_gaugeChart".equals(chartElement.getName())) && chartElement.element("v2_category") != null) {
            Element matrixColumns = DocumentHelper.makeElement((Branch)chartElement, (String)"v2_matrix/v2_matrixColumns");
            matrixColumns.addAttribute("matrixLevels", "1");
            Element matrixColumnLabels = DocumentHelper.makeElement((Branch)matrixColumns, (String)"v2_matrixColumnLabels");
            Element labelDefaultStyle = DocumentHelper.makeElement((Branch)matrixColumnLabels, (String)"style/defaultStyles/defaultStyle");
            labelDefaultStyle.addAttribute("refStyle", "al");
            Element axisTitle = DocumentHelper.makeElement((Branch)matrixColumns, (String)"v2_axisTitle");
            axisTitle.addAttribute("refQuery", chartElement.attributeValue("refQuery"));
            Element titleDefaultStyle = DocumentHelper.makeElement((Branch)matrixColumnLabels, (String)"style/defaultStyles/defaultStyle");
            titleDefaultStyle.addAttribute("refStyle", "at");
            DocumentHelper.makeElement((Branch)axisTitle, (String)"v2_chartTextContents/v2_automaticText");
        }
    }

    public static Element getDataItem(Element source, String queryName, String refDataItem) {
        Element dataItem = null;
        Element selectionQuery = (Element)source.selectSingleNode(V5X.subselectImmediateChildren("report") + V5X.subselectImmediateChildren("queries") + V5X.subselect("query", "name", queryName) + V5X.subselectImmediateChildren("selection"));
        dataItem = (Element)selectionQuery.selectSingleNode(V5X.selectByName(refDataItem));
        return dataItem;
    }

    public static boolean isContainedInCrosstabFactCell(Element layoutElement) {
        Element crosstabFactCell = (Element)layoutElement.selectSingleNode(V5X.selectAncestors("crosstabFactCell"));
        return crosstabFactCell != null;
    }

    public static String getDisplayTypeId(Element dataContainerElement) {
        return dataContainerElement.getName();
    }

    public static Set<String> getPossibleTargetChartTypes(Element containerElement) {
        if (V5Chart.isV2Chart(containerElement) || containerElement.getName().equals("crosstab") || containerElement.getName().equals("list")) {
            return new HashSet<String>(ChartElements.targetV2ChartTypes);
        }
        return new HashSet<String>(ChartElements.targetChartTypes);
    }

    public static String getLegendEdgeSubTypeName(String targetDisplayType) {
        if (targetDisplayType.contains("_line_")) {
            return "v2_line";
        }
        if (targetDisplayType.startsWith("v2_point")) {
            return "v2_line";
        }
        if (targetDisplayType.startsWith("v2_area")) {
            return "v2_area";
        }
        return "v2_bar";
    }

    public static void populateMeasuresForChart(Element chartElement, List<Element> measureNodes) {
        if (V5Chart.isV2Chart(chartElement)) {
            ChangeDisplayTypeHelper.populateMeasuresForV2Chart(chartElement, measureNodes);
        } else {
            ChangeDisplayTypeHelper.populateMeasuresForV1Chart(chartElement, measureNodes);
        }
    }

    private static void populateMeasuresForV1Chart(Element chartElement, List<Element> measureNodes) {
        Element chartMeasureNode;
        int i;
        String[] chartMeasures = ChartElements.measureNames.get(chartElement.getName());
        int number = Math.min(chartMeasures.length, measureNodes.size());
        for (i = 0; i < number; ++i) {
            chartMeasureNode = DocumentHelper.makeElement((Branch)chartElement, (String)chartMeasures[i]);
            chartMeasureNode.addAttribute("refDataItem", measureNodes.get(i).attributeValue("refDataItem"));
        }
        for (i = number; i < chartMeasures.length; ++i) {
            chartMeasureNode = chartElement.element(chartMeasures[i]);
            if (chartMeasureNode == null) continue;
            chartMeasureNode.detach();
        }
    }

    private static void populateMeasuresForV2Chart(Element chartElement, List<Element> measureNodes) {
        String chartElementName = chartElement.getName();
        if ("v2_scatterChart".equals(chartElementName) || "v2_bubbleChart".equals(chartElementName)) {
            int i;
            String[] chartMeasures = ChartElements.measureNames.get(chartElement.getName());
            Element xAxis = chartElement.element("v2_xAxis");
            Element chartMeasureNode = DocumentHelper.makeElement((Branch)xAxis, (String)chartMeasures[0]);
            chartMeasureNode.addAttribute("refDataItem", measureNodes.get(0).attributeValue("refDataItem"));
            Element yAxis = chartElement.element("v2_yAxis");
            chartMeasureNode = DocumentHelper.makeElement((Branch)yAxis, (String)chartMeasures[1]);
            chartMeasureNode.addAttribute("refDataItem", measureNodes.get(1).attributeValue("refDataItem"));
            for (i = 2; i < measureNodes.size() && i < chartMeasures.length; ++i) {
                chartMeasureNode = V5X.selectSingleNode(chartElement, chartMeasures[i]);
                if (chartMeasureNode == null) {
                    chartMeasureNode = DocumentHelper.makeElement((Branch)chartElement, (String)chartMeasures[i]);
                }
                chartMeasureNode.addAttribute("refDataItem", measureNodes.get(i).attributeValue("refDataItem"));
            }
            for (i = measureNodes.size(); i < chartMeasures.length; ++i) {
                chartMeasureNode = V5X.selectSingleNode(chartElement, chartMeasures[i]);
                if (chartMeasureNode == null) continue;
                Element parent = chartMeasureNode.getParent();
                chartMeasureNode.detach();
                if (parent.elements().size() != 0) continue;
                parent.detach();
            }
        } else {
            ChangeDisplayTypeHelper.populateMeasuresForV1Chart(chartElement, measureNodes);
        }
    }

    public static enum TargetDisplayType {
        crosstab,
        list,
        chart;

    }
}

