/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5infoactionset.GetInfo;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.V1ToV2PaletteMigrationHelper;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerNode;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5RSXChart;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ChangeDisplayTypeRulesProcessor {
    private static final String Entry = "Entry";
    private ActionEnv actionEnv;

    public ChangeDisplayTypeRulesProcessor(ActionEnv actionEnv) {
        this.actionEnv = actionEnv;
    }

    public void applyChartConversionRules(Element sourceChart, Element targetChart) throws ActionException {
        this.applyChartConversionRules(sourceChart, targetChart, false);
    }

    public void applyChartConversionRules(Element sourceChart, Element targetChart, boolean preventAxisManipulation) throws ActionException {
        String[] attributes;
        Collection<String> copyRules = this.getPropertyRules(targetChart, "convertCopyNodes");
        Collection<String> deepCopyRules = this.getPropertyRules(targetChart, "convertDeepCopyNodes");
        Collection<String> overrideAttributeRules = this.getPropertyRules(targetChart, "convertOverrideAttributes");
        Collection<String> convertMergeRules = this.getPropertyRules(targetChart, "convertMergeNodes");
        String sourceChartName = sourceChart.getName();
        for (String rule : copyRules) {
            this.applyConvertCopy(rule, sourceChart, targetChart);
        }
        for (String rule : deepCopyRules) {
            this.applyConvertDeepCopy(rule, sourceChart, targetChart);
        }
        for (String rule : convertMergeRules) {
            this.applyConvertMerge(rule, sourceChart, targetChart);
        }
        if (!sourceChartName.equals("crosstab") && !sourceChartName.equals("list") && (attributes = ChartElements.SupportedAttributes.get(targetChart.getName())) != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].equals("refQuery") || overrideAttributeRules.contains(attributes[i])) continue;
                this.copyAttributeByRules(sourceChart, targetChart, attributes[i]);
            }
        }
        if (V5Chart.isV2Chart(targetChart) && !sourceChartName.equals("crosstab") && !sourceChartName.equals("list")) {
            List targetPaletteParents;
            Element sourcePaletteParent;
            if (sourceChartName.equals("marimekkoChart") || sourceChartName.equals("radarChart")) {
                V1ToV2PaletteMigrationHelper.migratePalette(sourceChart, targetChart);
            } else {
                String sourcePath = ChartElements.V2PaletteParentPath.get(sourceChart.getName());
                String targetPath = ChartElements.V2PaletteParentPath.get(targetChart.getName());
                if (sourcePath != null && targetPath != null) {
                    sourcePaletteParent = (Element)sourceChart.selectSingleNode(ChartElements.V2PaletteParentPath.get(sourceChart.getName()));
                    targetPaletteParents = XMLUtility.selectNodes(targetChart, ChartElements.V2PaletteParentPath.get(targetChart.getName()));
                    if (sourcePaletteParent != null) {
                        for (Element targetPaletteParent : targetPaletteParents) {
                            this.convertPaletteV2(sourcePaletteParent, targetPaletteParent);
                        }
                    }
                }
            }
            String sourceConditionalPath = ChartElements.V2ConditionalPaletteParentPath.get(sourceChart.getName());
            String targetConditionalPath = ChartElements.V2ConditionalPaletteParentPath.get(targetChart.getName());
            if (sourceConditionalPath != null && targetConditionalPath != null) {
                sourcePaletteParent = (Element)sourceChart.selectSingleNode(sourceConditionalPath);
                targetPaletteParents = XMLUtility.selectNodes(targetChart, targetConditionalPath);
                if (sourcePaletteParent != null) {
                    for (Element targetPalleteParent : targetPaletteParents) {
                        this.convertConditionalPaletteV2(sourcePaletteParent, targetPalleteParent);
                    }
                }
            }
            this.removeConditionalPaletteForUnusedDataItems(targetChart);
            this.copyDataLabelsV2(sourceChart, targetChart);
            this.copyTooltipsV2(sourceChart, targetChart);
            this.copyV2Matrix(sourceChart, targetChart);
        }
        this.copyStyle(sourceChart, targetChart);
        this.copySortList(sourceChart, targetChart);
        this.copyCustomizedStyle(sourceChart, targetChart);
        this.copyConditionalStyles(sourceChart, targetChart);
        if (!preventAxisManipulation) {
            this.convertMultipleAxes(sourceChart, targetChart);
        }
        this.copyAxisElementAttributes(this.getFirstAxisElement(sourceChart), this.getFirstAxisElement(targetChart));
        this.postprocessMicroChart(sourceChart, targetChart);
        this.setDataItemLabelForRenamedNodes(sourceChart, targetChart);
    }

    private void copyAxisElementAttributes(Element sourceAxis, Element targetAxis) {
        String[] supportedAttributes;
        if (sourceAxis != null && targetAxis != null && (supportedAttributes = ChartElements.SupportedAttributes.get(targetAxis.getName())) != null) {
            for (String attrToCopy : supportedAttributes) {
                if (sourceAxis.attributeValue(attrToCopy) == null) continue;
                targetAxis.addAttribute(attrToCopy, sourceAxis.attributeValue(attrToCopy));
            }
        }
    }

    private void postprocessMicroChart(Element sourceChartElement, Element targetChartElement) {
        if (!V5RSXChart.isChart(sourceChartElement.getName()) || !V5RSXChart.isChart(targetChartElement.getName())) {
            return;
        }
        V5Chart sourceChart = new V5Chart(sourceChartElement);
        if (!sourceChart.isMicroChart()) {
            return;
        }
        if (this.canTurnIntoMicroChart(targetChartElement)) {
            if (V5Chart.isV1Chart(targetChartElement)) {
                this.turnToV1MicroChart(targetChartElement);
            } else {
                this.turnToV2MicroChart(targetChartElement);
            }
        } else {
            Element css = V5X.selectSingleNode(targetChartElement, "//V5X//CHILD", "style", "CSS");
            String value = this.removeSizeProperties(css.attributeValue("value"));
            if (value.length() > 0) {
                css.addAttribute("value", value);
            } else {
                css.detach();
            }
        }
    }

    private String removeSizeProperties(String css) {
        String[] values;
        StringBuilder sb = new StringBuilder();
        for (String value : values = css.split(";")) {
            if (value.contains("width") || value.contains("height") || value.contains("padding")) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    private boolean canTurnIntoMicroChart(Element chartElement) {
        return "v2_combinationChart".equals(chartElement.getName()) || "combinationChart".equals(chartElement.getName()) || "threeDCombinationChart".equals(chartElement.getName());
    }

    private void turnToV2MicroChart(Element chartElement) {
        Element v2_axis;
        Element ordinalAxis;
        Element v2_legend = V5X.selectSingleNode(chartElement, "v2_legend");
        if (v2_legend != null) {
            v2_legend.detach();
        }
        if ((ordinalAxis = V5X.selectSingleNode(chartElement, "v2_commonAxis", "//V5X//CHILD", "v2_ordinalAxis")) != null) {
            Element parent = ordinalAxis.getParent();
            ordinalAxis.detach();
            parent.addElement("v2_ordinalAxis");
        }
        if ((v2_axis = V5X.selectSingleNode(chartElement, "v2_topLeftAxis", "v2_axis")) != null) {
            ArrayList<String> exclude = new ArrayList<String>();
            exclude.add("v2_axisRange");
            this.removeChildElements(v2_axis, exclude);
        }
        V5SpecHelper.setXMLAttribute(chartElement, "beganAsMicroChart", "true", "no");
    }

    private void turnToV1MicroChart(Element chartElement) {
        Element legend = V5X.selectSingleNode(chartElement, "legend");
        if (legend != null) {
            legend.detach();
        }
        this.hideAxis(chartElement, "ordinalAxis");
        this.hideAxis(chartElement, "ordinalAxisY");
        this.hideAxis(chartElement, "ordinalAxisX");
        this.hideAxis(chartElement, "numericalAxisY1");
        this.hideAxis(chartElement, "numericalAxisY2");
        this.hideAxis(chartElement, "numericalAxis");
        V5SpecHelper.setXMLAttribute(chartElement, "beganAsMicroChart", "true", "no");
    }

    private void hideAxis(Element chartElement, String axisName) {
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("style");
        Element axis = V5X.selectSingleNode(chartElement, axisName);
        if (axis != null) {
            this.removeChildElements(axis, exclude);
            axis.addAttribute("showAxisLabels", "false");
        }
    }

    private void removeChildElements(Element parent, Collection<String> exclude) {
        if (parent == null) {
            return;
        }
        Iterator ite = parent.elementIterator();
        while (ite.hasNext()) {
            Element child = (Element)ite.next();
            if (exclude.contains(child.getName())) continue;
            child.detach();
        }
    }

    public Collection<String> getPropertyRules(Element chartElement, String ruleSetName) throws ActionException {
        Element ruleSet = (Element)chartElement.selectSingleNode(V5X.select(ruleSetName));
        if (ruleSet == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (Element rule : ruleSet.elements()) {
            if ("convertNamedSetRef".equals(rule.getName())) {
                String xPath = V5X.selectPath("//V5X//CHILD", "xmlFragment", "convertNamedSet", "//V5X//ATTR", "name", rule.attributeValue("ref"));
                Element refSet = (Element)ChangeDisplayTypeHelper.getChartTemplates().selectSingleNode(xPath);
                for (Element ruleInRef : refSet.elements()) {
                    rules.add(ruleInRef.getText());
                }
                continue;
            }
            rules.add(rule.getText());
        }
        return rules;
    }

    private void copyAttributeByRules(Element sourceChartElement, Element targetChartElement, String attribute) {
        String value = sourceChartElement.attributeValue(attribute);
        if (value != null) {
            targetChartElement.addAttribute(attribute, value);
        }
    }

    private void applyConvertMerge(String rule, Element sourceChart, Element targetChart) {
        String xpath = this.getXPathForRule(rule);
        Element sourceElement = (Element)sourceChart.selectSingleNode(xpath);
        if (sourceElement == null) {
            return;
        }
        Element addPoint = DocumentHelper.makeElement((Branch)targetChart, (String)rule);
        Iterator childrenIterator = sourceElement.elementIterator();
        while (childrenIterator.hasNext()) {
            addPoint.add(((Element)childrenIterator.next()).createCopy());
        }
    }

    private void applyConvertCopy(String rule, Element sourceChart, Element targetChart) {
        String xpath = this.getXPathForRule(rule);
        Element sourceElement = (Element)sourceChart.selectSingleNode(xpath);
        if (sourceElement == null) {
            return;
        }
        Element existingChildElement = (Element)targetChart.selectSingleNode(xpath);
        if (existingChildElement != null) {
            existingChildElement.detach();
        }
        Element temp = DocumentHelper.makeElement((Branch)targetChart, (String)rule);
        Element addPoint = temp.getParent();
        temp.detach();
        addPoint.add(sourceElement.createCopy());
    }

    private void applyConvertDeepCopy(String rule, Element sourceChart, Element targetChart) {
        String xpath = this.getXPathForRule(rule);
        Element sourceElement = (Element)sourceChart.selectSingleNode(xpath);
        if (sourceElement == null) {
            Element oldElement = (Element)targetChart.selectSingleNode(xpath);
            if (sourceChart.getName().equals(targetChart.getName()) && oldElement != null) {
                oldElement.detach();
            }
            return;
        }
        Element targetElement = (Element)targetChart.selectSingleNode(xpath);
        if (targetElement == null) {
            Element temp = DocumentHelper.makeElement((Branch)targetChart, (String)rule);
            Element addPoint = temp.getParent();
            temp.detach();
            targetElement = sourceElement.createCopy();
            addPoint.add(targetElement);
        } else {
            Iterator attrIterator = sourceElement.attributeIterator();
            while (attrIterator.hasNext()) {
                Attribute attr = (Attribute)attrIterator.next();
                if (targetElement.attribute(attr.getName()) != null) continue;
                targetElement.addAttribute(attr.getName(), attr.getValue());
            }
            if (sourceChart.getName().equals(targetChart.getName())) {
                targetElement.clearContent();
            }
            for (Element child : sourceElement.elements()) {
                Element existingChild = targetElement.element(child.getName());
                if (existingChild != null) {
                    existingChild.detach();
                }
                targetElement.add(child.createCopy());
            }
        }
        String targetQuery = targetChart.attributeValue("refQuery");
        if (targetElement.attribute("refQuery") != null) {
            targetElement.addAttribute("refQuery", targetQuery);
        }
        List elementsWithRefQuery = XMLUtility.selectNodes(targetElement, V5X.selectByAttr("refQuery"));
        for (Element element : elementsWithRefQuery) {
            element.addAttribute("refQuery", targetQuery);
        }
    }

    private void convertConditionalPaletteV2(Element sourcePaletteParent, Element targetPaletteParent) {
        Element sourcePaletteElement;
        String targetPalette = ChartElements.V2ConditionalPaletteType.get(targetPaletteParent.getName());
        String sourcePalette = ChartElements.V2ConditionalPaletteType.get(sourcePaletteParent.getName());
        if (sourcePalette.equals(targetPalette)) {
            this.applyConvertCopy(targetPalette, sourcePaletteParent, targetPaletteParent);
            return;
        }
        Element targetPaletteElement = targetPaletteParent.element(targetPalette);
        if (targetPaletteElement != null) {
            targetPaletteElement.detach();
        }
        if ((sourcePaletteElement = sourcePaletteParent.element(sourcePalette)) != null) {
            targetPaletteElement = targetPaletteParent.addElement(targetPalette);
            List sourceConditions = sourcePaletteElement.elements();
            for (Element sourceCondition : sourceConditions) {
                String sourceConditionName = sourceCondition.getName();
                if (sourceConditionName.equals(ChartElements.V2AdvancedCondition.get(sourcePalette))) {
                    this.convertAdvancedConditionV2(sourceCondition, sourcePalette, targetPaletteElement);
                    continue;
                }
                if (sourceConditionName.equals(ChartElements.V2RangeCondition.get(sourcePalette))) {
                    this.convertRangeConditionV2(sourceCondition, sourcePalette, targetPaletteElement);
                    continue;
                }
                this.convertStringConditionV2(sourceCondition, sourcePalette, targetPaletteElement);
            }
        }
    }

    public void convertStringConditionV2(Element sourceCondition, String sourcePalette, Element targetPaletteElement) {
        String sourceType = ChartElements.V2PaletteType.get(sourceCondition.getParent().getParent().getName());
        Element targetCondition = targetPaletteElement.addElement(ChartElements.V2StringCondition.get(targetPaletteElement.getName()));
        this.applyConvertCopy("conditionalDataItem", sourceCondition, targetCondition);
        List valueList = V5X.selectNodes(sourceCondition, "//V5X//ANY", ChartElements.V2StringValueList.get(sourcePalette));
        for (Element value : valueList) {
            Element cases = DocumentHelper.makeElement((Branch)targetCondition, (String)ChartElements.V2StringConditionCases.get(targetPaletteElement.getName()));
            Element valueListElement = XMLUtility.addElementWithAttributes(cases, ChartElements.V2StringValueList.get(targetPaletteElement.getName()));
            Element sourcePaletteEntry = value.element(sourceType + Entry);
            this.convertPaletteEntry(sourcePaletteEntry, valueListElement, ChartElements.V2PaletteType.get(targetPaletteElement.getParent().getName()) + Entry);
            this.applyConvertCopy("v2_conditionalPaletteEntryLabel", value, valueListElement);
            this.applyConvertCopy("v2_stringValues", value, valueListElement);
            XMLUtility.copyAttribute(value, valueListElement, "selectedValues");
        }
        List criteriaList = V5X.selectNodes(sourceCondition, "//V5X//ANY", ChartElements.V2StringCriteria.get(sourcePalette));
        for (Element criteria : criteriaList) {
            Element cases = DocumentHelper.makeElement((Branch)targetCondition, (String)ChartElements.V2StringConditionCases.get(targetPaletteElement.getName()));
            Element criteriaElement = XMLUtility.addElementWithAttributes(cases, ChartElements.V2StringCriteria.get(targetPaletteElement.getName()));
            XMLUtility.copyAttribute(criteria, criteriaElement, "operator");
            Element sourceCriteriaPaletteEntry = criteria.element(sourceType + Entry);
            this.convertPaletteEntry(sourceCriteriaPaletteEntry, criteriaElement, ChartElements.V2PaletteType.get(targetPaletteElement.getParent().getName()) + Entry);
            this.applyConvertCopy("v2_conditionalPaletteEntryLabel", criteria, criteriaElement);
            this.applyConvertCopy("v2_stringValue", criteria, criteriaElement);
        }
    }

    private void convertRangeConditionV2(Element sourceCondition, String sourcePalette, Element targetPaletteElement) {
        String sourceType = ChartElements.V2PaletteType.get(sourceCondition.getParent().getParent().getName());
        Element targetCondition = XMLUtility.addElementWithAttributes(targetPaletteElement, ChartElements.V2RangeCondition.get(targetPaletteElement.getName()));
        XMLUtility.copyAttribute(sourceCondition, targetCondition, "type");
        this.applyConvertCopy("conditionalDataItem", sourceCondition, targetCondition);
        Element sourceRemaining = sourceCondition.element(ChartElements.V2RangeRemaining.get(sourceCondition.getName()));
        if (sourceRemaining != null) {
            Element targetRemaining = targetCondition.addElement(ChartElements.V2RangeRemaining.get(targetCondition.getName()));
            this.applyConvertCopy("v2_conditionalPaletteEntryLabel", sourceRemaining, targetRemaining);
            Element sourcePaletteEntry = sourceRemaining.element(sourceType + Entry);
            this.convertPaletteEntry(sourcePaletteEntry, targetRemaining, ChartElements.V2PaletteType.get(targetPaletteElement.getParent().getName()) + Entry);
        }
        List sourceCases = V5X.selectNodes(sourceCondition, ChartElements.V2RangeConditionCase.get(sourcePalette));
        Element targetCases = null;
        for (int i = 0; i < sourceCases.size(); ++i) {
            if (i == 0) {
                targetCases = targetCondition.addElement(ChartElements.V2RangeConditionCases.get(targetPaletteElement.getName()));
            }
            Element targetCase = XMLUtility.addElementWithAttributes(targetCases, ChartElements.V2RangeConditionCase.get(targetPaletteElement.getName()));
            this.applyConvertCopy("v2_conditionalPaletteEntryLabel", (Element)sourceCases.get(i), targetCase);
            Element sourceCasePaletteEntry = ((Element)sourceCases.get(i)).element(sourceType + Entry);
            this.convertPaletteEntry(sourceCasePaletteEntry, targetCase, ChartElements.V2PaletteType.get(targetPaletteElement.getParent().getName()) + Entry);
            XMLUtility.copyAttribute((Element)sourceCases.get(i), targetCase, "value");
            XMLUtility.copyAttribute((Element)sourceCases.get(i), targetCase, "inclusive");
        }
    }

    private void convertAdvancedConditionV2(Element sourceCondition, String sourcePalette, Element targetPaletteElement) {
        String sourceType = ChartElements.V2PaletteType.get(sourceCondition.getParent().getParent().getName());
        List sourceCases = V5X.selectNodes(sourceCondition, "//V5X//ANY", ChartElements.V2AdvancedConditionCase.get(sourcePalette));
        Element targetCondition = targetPaletteElement.addElement(ChartElements.V2AdvancedCondition.get(targetPaletteElement.getName()));
        for (Element sourceCase : sourceCases) {
            Element targetCases = DocumentHelper.makeElement((Branch)targetCondition, (String)ChartElements.V2AdvancedConditionCases.get(targetPaletteElement.getName()));
            Element targetCase = targetCases.addElement(ChartElements.V2AdvancedConditionCases.get(targetPaletteElement.getName()));
            this.applyConvertCopy("reportCondition", sourceCase, targetCase);
            this.applyConvertCopy("v2_conditionalPaletteEntryLabel", sourceCase, targetCase);
            Element sourcePaletteEntry = sourceCase.element(sourceType + Entry);
            this.convertPaletteEntry(sourcePaletteEntry, targetCase, ChartElements.V2PaletteType.get(targetPaletteElement.getParent().getName()) + Entry);
        }
    }

    private void removeConditionalPaletteForUnusedDataItems(Element chartElement) {
        String chartQuery = chartElement.attributeValue("refQuery");
        List conditionalDataItems = V5X.selectNodes(chartElement, "conditionalDataItem", "//V5X//ATTR", "refQuery", chartQuery);
        ArrayList<Element> conditionalPalettes = new ArrayList<Element>();
        for (Element conditionalDataItem : conditionalDataItems) {
            String measureName;
            String[] measureNames;
            String refDataItem = conditionalDataItem.attributeValue("refDataItem");
            Element chartNodeRefDataItem = V5X.selectSingleNode(chartElement, "chartNodes", "//V5X//CHILDATTR", "refDataItem", refDataItem);
            if (chartNodeRefDataItem != null) continue;
            Element chartMeasureRefDataItem = null;
            String[] stringArray = measureNames = ChartElements.measureNames.get(chartElement.getName());
            int n = stringArray.length;
            for (int i = 0; i < n && (chartMeasureRefDataItem = V5X.selectSingleNode(chartElement, measureName = stringArray[i], "//V5X//ATTR", "refDataItem", refDataItem)) == null; ++i) {
            }
            if (chartMeasureRefDataItem != null) continue;
            conditionalPalettes.add(conditionalDataItem.getParent().getParent());
            conditionalDataItem.getParent().detach();
        }
        for (Element conditionalPalette : conditionalPalettes) {
            if (conditionalPalette.elements().size() != 0 && conditionalPalette.getParent() == null) continue;
            conditionalPalette.detach();
        }
    }

    private void copyDataLabelsV2(Element sourceChart, Element targetChart) {
        if (ChartElements.V2DataLabels.get(targetChart.getName()) == null) {
            return;
        }
        Element sourceLabel = (Element)sourceChart.selectSingleNode(ChartElements.V2DataLabelsParentPath.get(sourceChart.getName()) + V5X.subselectImmediateChildren(ChartElements.V2DataLabels.get(sourceChart.getName())));
        if (sourceLabel != null) {
            List labelParents = XMLUtility.selectNodes(targetChart, ChartElements.V2DataLabelsParentPath.get(targetChart.getName()));
            for (Element labelParent : labelParents) {
                Element targetLabel = XMLUtility.addElementWithAttributes(labelParent, ChartElements.V2DataLabels.get(targetChart.getName()));
                Iterator ite = sourceLabel.attributeIterator();
                while (ite.hasNext()) {
                    Attribute attr = (Attribute)ite.next();
                    if (targetLabel.attribute(attr.getName()) == null) continue;
                    targetLabel.addAttribute(attr.getName(), attr.getValue());
                }
            }
        } else {
            List targetLabels = XMLUtility.selectNodes(targetChart, ChartElements.V2DataLabelsParentPath.get(targetChart.getName()) + V5X.subselectImmediateChildren(ChartElements.V2DataLabels.get(targetChart.getName())));
            for (Element targetLabel : targetLabels) {
                targetLabel.detach();
            }
        }
    }

    private void copySortList(Element sourceLayout, Element targetLayout) throws ActionException {
        V5DataContainer sourceContainer = V5DataContainerFactory.create(sourceLayout);
        V5DataContainer targetContainer = V5DataContainerFactory.create(targetLayout);
        Collection<Element> sortItems = this.getSortItemsToBeKept(sourceContainer, targetContainer.getV5Query());
        for (Element sortItem : sortItems) {
            String columnName = sortItem.attributeValue("refDataItem");
            Element layoutElement = sortItem.getParent().getParent();
            if (layoutElement != sourceLayout && layoutElement.attributeValue("refDataItem") != null) {
                columnName = layoutElement.attributeValue("refDataItem");
            }
            targetContainer.setActionEnv(this.actionEnv);
            targetContainer.addSortList(columnName, sortItem.attributeValue("refDataItem"), sortItem.attributeValue("sortOrder"));
        }
    }

    private void copyStyle(Element sourceLayout, Element targetLayout) {
        Element css;
        Element styles = targetLayout.element("style");
        Element stylesCopy = null;
        if (styles != null) {
            stylesCopy = styles.createCopy();
        }
        this.applyConvertCopy("style", sourceLayout, targetLayout);
        if (stylesCopy != null) {
            this.applyConvertCopy("defaultStyles", stylesCopy, targetLayout.element("style"));
        }
        if (("crosstab".equals(targetLayout.getName()) || "list".equals(targetLayout.getName())) && stylesCopy.element("CSS") != null) {
            String originalCSSValue = stylesCopy.element("CSS").attributeValue("value");
            Element css2 = DocumentHelper.makeElement((Branch)targetLayout.element("style"), (String)"CSS");
            String value = css2.attributeValue("value");
            if (value == null || value.indexOf(originalCSSValue) < 0) {
                css2.addAttribute("value", value == null ? originalCSSValue : originalCSSValue + ";" + value);
            }
        }
        if (("crosstab".equals(targetLayout.getName()) || "list".equals(targetLayout.getName())) && (css = V5X.selectSingleNode(targetLayout, "//V5X//CHILD", "style", "CSS")) != null) {
            String value = css.attributeValue("value");
            value = V5SpecHelper.stripCSSAttribute(value, "width");
            value = V5SpecHelper.stripCSSAttribute(value, "height");
            css.addAttribute("value", value);
        }
        GetInfo getInfo = new GetInfo();
        if (("crosstab".equals(sourceLayout.getName()) || "list".equals(sourceLayout.getName())) && V5RSXChart.isChart(targetLayout.getName()) && getInfo.isSingleContainerReport(this.actionEnv.getRAPReport()) && V5SpecHelper.findParentContainer(targetLayout) == null) {
            String width = this.actionEnv.getActionArg("widgetWidth");
            String height = this.actionEnv.getActionArg("widgetHeight");
            if (width + height != null && (width + height).length() > 0) {
                Element cssElement = DocumentHelper.makeElement((Branch)targetLayout.element("style"), (String)"CSS");
                String css3 = cssElement.attributeValue("value");
                String cssWidth = "width";
                String cssHeight = "height";
                if (width != null && width.length() > 0 && css3.indexOf(cssWidth) < 0) {
                    css3 = V5SpecHelper.setCSSValue(css3, cssWidth, width);
                }
                if (height != null && height.length() > 0 && css3.indexOf(cssHeight) < 0) {
                    css3 = V5SpecHelper.setCSSValue(css3, cssHeight, height);
                }
                cssElement.addAttribute("value", css3);
            }
        }
    }

    private void copyConditionalStyles(Element sourceLayout, Element targetLayout) {
        String supportedLayout = "listcrosstab";
        if (supportedLayout.indexOf(sourceLayout.getName()) < 0 || supportedLayout.indexOf(targetLayout.getName()) < 0) {
            return;
        }
        V5DataContainer sourceContainer = V5DataContainerFactory.create(sourceLayout);
        V5DataContainer targetContainer = V5DataContainerFactory.create(targetLayout);
        List<Element> elements = sourceContainer.collectNodes();
        for (Element element : elements) {
            List<Element> factCellConditionalStyles;
            V5DataContainerNode targetNode;
            V5DataContainerNode sourceNode = V5DataContainerFactory.createNode(element);
            if (sourceNode == null || (targetNode = V5DataContainerFactory.createNode(targetContainer.findItem(sourceNode.getDataItemName()))) == null) continue;
            List<Element> conditionalStyles = sourceNode.getConditionaStyles();
            if (conditionalStyles != null && conditionalStyles.size() > 0) {
                targetNode.setConditionalStyles(conditionalStyles);
            }
            if ((factCellConditionalStyles = sourceNode.getFactCellConditionalStyles()) == null || factCellConditionalStyles.size() <= 0) continue;
            targetNode.setFactCellConditionalStyles(factCellConditionalStyles);
        }
    }

    private void copyCustomizedStyle(Element sourceLayout, Element targetLayout) {
        V5DataContainer sourceContainer = V5DataContainerFactory.create(sourceLayout);
        V5DataContainer targetContainer = V5DataContainerFactory.create(targetLayout);
        if ("list".equals(sourceLayout.getName()) && "crosstab".equals(targetLayout.getName())) {
            this.copyListStyleToCrosstab(sourceContainer, targetContainer);
        } else if ("crosstab".equals(sourceLayout.getName()) && "list".equals(targetLayout.getName())) {
            this.copyCrosstabStyleToList(sourceContainer, targetContainer);
        }
    }

    private void copyCrosstabStyleToList(V5DataContainer crosstab, V5DataContainer list) {
        List<Element> sourceNodes = crosstab.collectNodes();
        for (Element sourceNodeElement : sourceNodes) {
            V5DataContainerNode sourceNode = V5DataContainerFactory.createNode(sourceNodeElement);
            String rdi = sourceNode.getDataItemName();
            V5DataContainerNode targetNode = V5DataContainerFactory.createNode(list.findItem(rdi));
            if (targetNode == null) continue;
            boolean isDefaultMeasure = "defaultMeasure".equals(sourceNodeElement.getName());
            boolean isOnColumn = false;
            boolean isInnerMost = false;
            boolean hasFactCellCSSStyle = false;
            if (!isDefaultMeasure) {
                isOnColumn = V5SpecHelper.getAncestor(sourceNodeElement, "crosstabColumns") != null;
                Element crosstabNode = V5SpecHelper.getAncestor(sourceNodeElement, "crosstabNode");
                isInnerMost = crosstabNode.element("crosstabNestedNodes") == null;
                boolean bl = hasFactCellCSSStyle = V5X.selectSingleNode(sourceNodeElement, "//V5X//CHILD", "factCell", "style", "CSS") != null;
            }
            if (isDefaultMeasure || isOnColumn && isInnerMost && hasFactCellCSSStyle) {
                this.copyCSSStyle(sourceNode, targetNode);
                continue;
            }
            Element cssElement = sourceNode.getHeaderStyle();
            if (cssElement == null) continue;
            targetNode.setFactCellStyle(cssElement.attributeValue("value"));
        }
    }

    private void copyListStyleToCrosstab(V5DataContainer list, V5DataContainer crosstab) {
        List<Element> sourceNodes = list.collectNodes();
        for (Element sourceNodeElement : sourceNodes) {
            V5DataContainerNode sourceNode = V5DataContainerFactory.createNode(sourceNodeElement);
            String rdi = sourceNode.getDataItemName();
            V5DataContainerNode targetNode = V5DataContainerFactory.createNode(crosstab.findItem(rdi));
            if (targetNode == null) continue;
            boolean isDefaultMeasure = "defaultMeasure".equals(targetNode.getNodeElement().getName());
            boolean isOnColumn = false;
            boolean isInnerMost = false;
            if (!isDefaultMeasure && crosstab.getDefaultMeasure() == null) {
                isOnColumn = V5SpecHelper.getAncestor(targetNode.getNodeElement(), "crosstabColumns") != null;
                Element crosstabNode = V5SpecHelper.getAncestor(targetNode.getNodeElement(), "crosstabNode");
                boolean bl = isInnerMost = crosstabNode.element("crosstabNestedNodes") == null;
            }
            if (isDefaultMeasure || isOnColumn && isInnerMost) {
                this.copyCSSStyle(sourceNode, targetNode);
                continue;
            }
            Element cssElement = sourceNode.getFactCellStyle();
            if (cssElement == null) continue;
            targetNode.setHeaderStyle(cssElement.attributeValue("value"));
        }
    }

    private void copyCSSStyle(V5DataContainerNode sourceNode, V5DataContainerNode targetNode) {
        Element cssElement = sourceNode.getHeaderStyle();
        if (cssElement != null) {
            targetNode.setHeaderStyle(cssElement.attributeValue("value"));
        }
        if ((cssElement = sourceNode.getFactCellStyle()) != null) {
            targetNode.setFactCellStyle(cssElement.attributeValue("value"));
        }
    }

    private Collection<Element> getSortItemsToBeKept(V5DataContainer dataContainer, V5Query query) throws ActionException {
        Collection<Element> sortItems = dataContainer.getLayoutSortItems();
        if ("list".equals(dataContainer.getContainerElement().getName())) {
            Iterator<Element> iterator = sortItems.iterator();
            while (iterator.hasNext()) {
                Element sortItem = iterator.next();
                if (!this.isSortOnNumeric(query, sortItem) || sortItem.getParent().getParent() != dataContainer.getContainerElement()) continue;
                iterator.remove();
            }
        }
        return sortItems;
    }

    private boolean isSortOnNumeric(V5Query query, Element sortItem) throws ActionException {
        Element dataItem = query.findItem(sortItem.attributeValue("refDataItem"));
        if (dataItem == null) {
            return false;
        }
        V5QueryItem queryItem = new V5QueryItem(this.actionEnv, query, dataItem);
        return queryItem.confirmIsNumeric();
    }

    private void copyTooltipsV2(Element sourceChart, Element targetChart) {
        if (ChartElements.V2Tooltips.get(sourceChart.getName()) != null && ChartElements.V2Tooltips.get(sourceChart.getName()).equals(ChartElements.V2Tooltips.get(targetChart.getName()))) {
            this.applyConvertCopy(ChartElements.V2Tooltips.get(targetChart.getName()), sourceChart, targetChart);
        } else if (ChartElements.V2Tooltips.get(sourceChart.getName()) != null && sourceChart.element(ChartElements.V2Tooltips.get(sourceChart.getName())) != null) {
            DocumentHelper.makeElement((Branch)targetChart, (String)ChartElements.V2Tooltips.get(targetChart.getName()));
        } else {
            Element tooltip = targetChart.element(ChartElements.V2Tooltips.get(targetChart.getName()));
            if (tooltip != null) {
                tooltip.detach();
            }
        }
    }

    private String getXPathForRule(String rule) {
        String[] path = rule.split("/");
        String[] xpathElements = new String[path.length + 1];
        xpathElements[0] = "//V5X//CHILD";
        System.arraycopy(path, 0, xpathElements, 1, path.length);
        return V5X.selectPath(xpathElements);
    }

    private void convertPaletteV2(Element sourcePaletteParent, Element targetPaletteParent) {
        String targetPaletteName;
        String sourcePaletteName = ChartElements.V2PaletteType.get(sourcePaletteParent.getName());
        if (sourcePaletteName.equals(targetPaletteName = ChartElements.V2PaletteType.get(targetPaletteParent.getName()))) {
            Element originalTargetPaletteElement = targetPaletteParent.element(targetPaletteName);
            if (originalTargetPaletteElement != null) {
                originalTargetPaletteElement = originalTargetPaletteElement.createCopy();
            }
            this.applyConvertCopy(sourcePaletteName, sourcePaletteParent, targetPaletteParent);
            if (originalTargetPaletteElement != null) {
                this.setMarkerShapeAttribute(originalTargetPaletteElement, targetPaletteParent.element(targetPaletteName));
            }
            return;
        }
        if ("v2_progressivePalette".equals(sourcePaletteName) || "v2_progressivePalette".equals(targetPaletteName)) {
            return;
        }
        Element sourcePalette = sourcePaletteParent.element(sourcePaletteName);
        if (sourcePalette != null) {
            Element originalTargetPaletteElement = targetPaletteParent.element(targetPaletteName);
            if (originalTargetPaletteElement != null) {
                originalTargetPaletteElement = originalTargetPaletteElement.createCopy();
            }
            targetPaletteParent.element(targetPaletteName).clearContent();
            Element targetPaletteEntriesElement = DocumentHelper.makeElement((Branch)targetPaletteParent, (String)(targetPaletteName + "/" + targetPaletteName + "Entries"));
            List sourcePaletteEntries = sourcePalette.element(sourcePaletteName + "Entries").elements();
            for (Element sourcePaletteEntry : sourcePaletteEntries) {
                this.convertPaletteEntry(sourcePaletteEntry, targetPaletteEntriesElement, targetPaletteName + Entry);
            }
            if (originalTargetPaletteElement != null) {
                this.setMarkerShapeAttribute(originalTargetPaletteElement, targetPaletteEntriesElement);
            }
        }
    }

    private void setMarkerShapeAttribute(Element sourcePaletteEntryParent, Element targetPaletteEntryParent) {
        List sourcePointPaletteEntryElements = V5X.selectNodes(sourcePaletteEntryParent, "v2_pointPaletteEntry");
        List targetPointPaletteEntryElements = V5X.selectNodes(targetPaletteEntryParent, "v2_pointPaletteEntry");
        for (int i = 0; i < sourcePointPaletteEntryElements.size() && i < targetPointPaletteEntryElements.size(); ++i) {
            Element sourcePointPaletteEntryElement = (Element)sourcePointPaletteEntryElements.get(i);
            Element targetPointPaletteEntryElement = (Element)targetPointPaletteEntryElements.get(i);
            Attribute sourceMarkerShape = sourcePointPaletteEntryElement.attribute("markerShape");
            if (sourceMarkerShape == null) {
                Attribute targetMarkerShape = targetPointPaletteEntryElement.attribute("markerShape");
                if (targetMarkerShape == null) continue;
                targetPointPaletteEntryElement.remove(targetMarkerShape);
                continue;
            }
            targetPointPaletteEntryElement.addAttribute("markerShape", sourceMarkerShape.getValue());
        }
    }

    private void convertPaletteEntry(Element sourcePaletteEntry, Element targetPalleteEntryParent, String paletteEntryName) {
        Element targetPaletteEntry = targetPalleteEntryParent.addElement(paletteEntryName);
        if (!"v2_linePaletteEntry".equals(sourcePaletteEntry.getName()) && !"v2_linePaletteEntry".equals(targetPaletteEntry.getName())) {
            Iterator ite = sourcePaletteEntry.elementIterator();
            while (ite.hasNext()) {
                targetPaletteEntry.add(((Element)ite.next()).createCopy());
            }
        } else if ("v2_linePaletteEntry".equals(paletteEntryName)) {
            if ("v2_pointPaletteEntry".equals(sourcePaletteEntry.getName())) {
                targetPaletteEntry.add(sourcePaletteEntry.createCopy());
            } else {
                Element pointEntry = targetPaletteEntry.addElement("v2_pointPaletteEntry");
                pointEntry.add(((Element)sourcePaletteEntry.elements().get(0)).createCopy());
            }
            Element lineFill = targetPaletteEntry.addElement("v2_lineFill");
            Element sourceGradient = V5X.selectSingleNode(sourcePaletteEntry, "//V5X//ANY", "v2_linearGradient", "//V5X//OR", "v2_radialRectGradient", "//V5X//OR", "v2_radialLinearGradient");
            Element solidColor = V5X.selectSingleNode(sourcePaletteEntry, "//V5X//ANY", "v2_solidColor");
            if (solidColor != null) {
                Element color = lineFill.addElement("v2_color");
                color.addAttribute("color", solidColor.attributeValue("color"));
            } else if (sourceGradient != null) {
                Element linearGradient = lineFill.addElement("v2_linearGradient");
                Iterator iterator = sourceGradient.elementIterator();
                while (iterator.hasNext()) {
                    linearGradient.add(((Element)iterator.next()).createCopy());
                }
                if (sourceGradient.getName().equals("v2_linearGradient") && linearGradient.attribute("gradientAngle") == null) {
                    linearGradient.addAttribute("gradientAngle", sourceGradient.attributeValue("gradientAngle"));
                }
            } else {
                String defaultColor = V5X.selectSingleNode(sourcePaletteEntry, "//V5X//ANY", "v2_fillEffect").attributeValue("defaultColor");
                solidColor = DocumentHelper.makeElement((Branch)lineFill, (String)"v2_color");
                solidColor.addAttribute("color", defaultColor);
            }
        } else {
            Element fillEffect = V5X.selectSingleNode(sourcePaletteEntry, "v2_pointPaletteEntry", "v2_fillEffect");
            targetPaletteEntry.add(fillEffect.createCopy());
        }
    }

    private void copyV2Matrix(Element sourceChart, Element targetChart) {
        if ("v2_pieChart".equals(targetChart.getName()) || "v2_gaugeChart".equals(targetChart.getName())) {
            ChangeDisplayTypeHelper.setMatrixElementForV2Chart(targetChart);
        } else if (sourceChart.getName().equals(targetChart.getName())) {
            this.applyConvertCopy("v2_matrix", sourceChart, targetChart);
        }
    }

    private void convertMultipleAxes(Element sourceChart, Element targetChart) {
        if (sourceChart.getName().equals(targetChart.getName())) {
            if (sourceChart.getName().equals("v2_combinationChart")) {
                this.convertMultipleAxesV2(sourceChart, targetChart);
            } else if (sourceChart.getName().equals("combinationChart")) {
                this.convertMultipleAxesV1(sourceChart, targetChart);
            }
        }
    }

    private void convertMultipleAxesV1(Element sourceChart, Element targetChart) {
        Element template = this.getAxisTemplateV1(targetChart);
        if (template == null) {
            return;
        }
        List y2AxisNodes = V5X.selectNodes(sourceChart, "bar", "//V5X//OR", "line", "//V5X//OR", "area", "//V5X//ATTR", "useNumericalAxis", "numericalAxisY2");
        for (Element y2AxisNode : y2AxisNodes) {
            List chartNodeMemberNodes = V5X.selectNodes(y2AxisNode, "chartNodeMember", "//V5X//ATTR_DEFINED", "refDataItem");
            if (chartNodeMemberNodes.size() == 0) continue;
            Element targetNewChartNodes = null;
            for (Element sourceChartNodeMember : chartNodeMemberNodes) {
                Element targetChartNodeMember = V5X.selectSingleNode(targetChart, "chartNodeMember", "//V5X//ATTR", "refDataItem", sourceChartNodeMember.attributeValue("refDataItem"));
                if (targetChartNodeMember == null) continue;
                Element targetChartNode = V5SpecHelper.getAncestor(targetChartNodeMember, "chartNode");
                if (targetNewChartNodes == null) {
                    targetNewChartNodes = DocumentHelper.createElement((QName)new QName("chartNodes", targetChartNode.getNamespace()));
                }
                targetChartNode.detach();
                targetNewChartNodes.add(targetChartNode);
            }
            if (targetNewChartNodes == null) continue;
            Element chartNodesParent = template.createCopy();
            chartNodesParent.addAttribute("useNumericalAxis", "numericalAxisY2");
            chartNodesParent.add(targetNewChartNodes);
            this.copyAxisElementAttributes(y2AxisNode, chartNodesParent);
            targetChart.element("combinationChartTypes").add(chartNodesParent);
            V5SpecHelper.removeLeafNodesByName(targetChart, "chartNodes");
        }
    }

    private Element getFirstAxisElement(Element chart) {
        if ("combinationChart".equals(chart.getName()) || "metricsChart".equals(chart.getName())) {
            return V5X.selectSingleNode(chart, "//V5X//CHILD", "combinationChartTypes", "bar", "//V5X//OR", "area", "//V5X//OR", "line");
        }
        if ("threeDCombinationChart".equals(chart.getName())) {
            return V5X.selectSingleNode(chart, "threeDCombinationChartTypes", "threeDBar", "//V5X//OR", "threeDArea", "//V5X//OR", "threeDLine");
        }
        if ("v2_combinationChart".equals(chart.getName())) {
            return V5X.selectSingleNode(chart, "//V5X//CHILD", "v2_topLeftAxis", "//V5X//ANY", "v2_combinationChartTypes", "v2_bar", "//V5X//OR", "v2_area", "//V5X//OR", "v2_line");
        }
        if ("v2_pieChart".equals(chart.getName())) {
            return V5X.selectSingleNode(chart, "//V5X//CHILD", "v2_pieSlices");
        }
        return chart;
    }

    private Element getAxisTemplateV1(Element chartElement) {
        Element template = V5X.selectSingleNode(chartElement, "//V5X//CHILD", "combinationChartTypes", "bar", "//V5X//OR", "line", "//V5X//OR", "area");
        if (template != null) {
            template = template.createCopy();
            Element chartNodes = V5X.selectSingleNode(template, "chartNodes");
            if (chartNodes != null) {
                chartNodes.detach();
            }
            return template;
        }
        return null;
    }

    private void convertMultipleAxesV2(Element sourceChart, Element targetChart) {
        Element targetTopLeftAxis = targetChart.element("v2_topLeftAxis");
        Element template = V5X.selectSingleNode(targetTopLeftAxis, "v2_bar", "//V5X//OR", "v2_line", "//V5X//OR", "v2_area");
        if (template == null) {
            return;
        }
        template.detach();
        List sourceAxes = V5X.selectNodes(sourceChart, "//V5X//CHILD", "v2_topLeftAxis", "//V5X//OR", "v2_topRightAxis", "//V5X//OR", "v2_bottomLeftAxis", "//V5X//OR", "v2_bottomRightAxis");
        for (Element sourceAxis : sourceAxes) {
            Element targetAxis = V5X.selectSingleNode(targetChart, sourceAxis.getName());
            Element chartTypes = DocumentHelper.makeElement((Branch)targetAxis, (String)"v2_combinationChartTypes");
            chartTypes.add(template.createCopy());
            this.copyComboToComboLegendEdgeV2(sourceAxis, targetAxis);
        }
    }

    private void copyComboToComboLegendEdgeV2(Element sourceEdge, Element targetEdge) {
        List sourceElements = V5X.selectNodes(sourceEdge, "v2_bar", "//V5X//OR", "v2_line", "//V5X//OR", "v2_area");
        List targetElements = V5X.selectNodes(targetEdge, "v2_bar", "//V5X//OR", "v2_line", "//V5X//OR", "v2_area");
        if (targetElements.size() < sourceElements.size()) {
            Element targetFirstElement = (Element)targetElements.get(0);
            for (int i = sourceElements.size() - targetElements.size(); i < sourceElements.size(); ++i) {
                targetFirstElement.getParent().add(targetFirstElement.createCopy());
            }
        }
        targetElements = V5X.selectNodes(targetEdge, "v2_bar", "//V5X//OR", "v2_line", "//V5X//OR", "v2_area");
        for (int i = 0; i < targetElements.size(); ++i) {
            Element chartNodes = ((Element)targetElements.get(i)).element("chartNodes");
            if (chartNodes != null) {
                chartNodes.detach();
            }
            if ((chartNodes = ((Element)sourceElements.get(i)).element("chartNodes")) != null) {
                ((Element)targetElements.get(i)).add(chartNodes.createCopy());
                this.copyComboChartTypeCommonV2((Element)sourceElements.get(i), (Element)targetElements.get(i));
            }
            this.copyAxisElementAttributes((Element)sourceElements.get(i), (Element)targetElements.get(i));
        }
    }

    private void copyComboChartTypeCommonV2(Element sourceElement, Element targetElement) {
        if (sourceElement.element("v2_trendLines") != null) {
            targetElement.add(sourceElement.element("v2_trendLines").createCopy());
        }
        this.convertPaletteV2(sourceElement, targetElement);
        this.convertConditionalPaletteV2(sourceElement, targetElement);
    }

    private void setDataItemLabelForRenamedNodes(Element sourceContainer, Element targetChart) {
        if ((sourceContainer.getName().equals("list") || sourceContainer.getName().equals("crosstab")) && V5RSXChart.isChart(targetChart.getName())) {
            V5DataContainer v5SourceContainer = V5DataContainerFactory.create(sourceContainer);
            V5DataContainer v5TargetContainer = V5DataContainerFactory.create(targetChart);
            V5Query query = v5TargetContainer.getV5Query();
            List<Element> elements = v5SourceContainer.collectNodes();
            for (Element nodeE : elements) {
                V5Variables variables;
                String renamedValue;
                Element dataItem;
                String rdi;
                V5DataContainerNode containerNode = V5DataContainerFactory.createNode(nodeE);
                if (!containerNode.isRenamed() || (rdi = containerNode.getDataItemName()) == null || (dataItem = query.findItem(rdi)) == null || (renamedValue = v5SourceContainer.getRenamedStaticValue(variables = new V5Variables(this.actionEnv.getRAPReport().getDOM().getRootElement()), rdi, this.actionEnv.getLocale())) == null) continue;
                dataItem.addAttribute("label", renamedValue);
            }
        }
    }
}

