/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.DrillLayoutNode;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.NewDrillRules;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5ListColumn;
import com.cognos.rap.actions.v5spechelpers.V5MasterDetailLinkUpdater;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Style;
import com.cognos.rap.actions.v5spechelpers.V5VizChart;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DimensionalOperations {
    BaseAction baseAction = null;
    private NewDrillRules _newDrillRules = null;
    private boolean bIsDrillOnSingleDimensionNested;
    private static boolean _bIsDrillOnIntersection;

    public DimensionalOperations(BaseAction baseAction) {
        this.setBaseAction(baseAction);
    }

    public void initializeNewDrillRules(boolean isDrillDown) {
        this._newDrillRules = new NewDrillRules(isDrillDown, this.baseAction.getRapServiceRequestManager());
    }

    public Element doDrillOnCrosstabOrChart(V5DataContainer dataContainer, Element nodeToDrillOn, SelectedCell postDrillParent, SelectedCell originalDrillUpSelectedCell, boolean bDrillUpToRoot) throws ActionException {
        if (nodeToDrillOn == null) {
            return null;
        }
        Element createdDataItem = null;
        V5Query v5query = dataContainer.getV5Query();
        String dun = DimensionalOperations.getDUN(v5query, postDrillParent);
        String hun = DimensionalOperations.getHUN(v5query, postDrillParent);
        if (this._newDrillRules != null) {
            DrillLayoutNode drilledOnLayoutNode = new DrillLayoutNode(this._newDrillRules.isDrillUp(), nodeToDrillOn, postDrillParent, v5query, dataContainer, this.baseAction.getRapServiceRequestManager(), dun, hun);
            drilledOnLayoutNode.setIsDrillOnSingleDimensionNestedNode(this.getIsDrillOnSingleDimensionNestedNode());
            this._newDrillRules.setDrilledOnLayoutNode(drilledOnLayoutNode);
        }
        if (dataContainer instanceof V5Crosstab) {
            createdDataItem = this.doDrillOnCrosstab(dataContainer, nodeToDrillOn, postDrillParent, originalDrillUpSelectedCell, bDrillUpToRoot, createdDataItem, v5query, dun, hun);
        } else if (dataContainer instanceof V5Chart) {
            createdDataItem = this.doDrillOnChart(dataContainer, nodeToDrillOn, postDrillParent, originalDrillUpSelectedCell, bDrillUpToRoot, v5query, dun, hun);
        }
        if (this._newDrillRules == null) {
            DimensionalOperations.addDrillReset(v5query.findItem(nodeToDrillOn.attributeValue("refDataItem")), createdDataItem);
        }
        return createdDataItem;
    }

    private Element doDrillOnCrosstab(V5DataContainer dataContainer, Element nodeToDrillOn, SelectedCell postDrillParent, SelectedCell originalDrillUpSelectedCell, boolean bDrillUpToRoot, Element createdDataItem, V5Query v5query, String dun, String hun) throws ActionException {
        DrillLayoutNode drillLayoutNode;
        DrillLayoutNode drillLayoutNode2 = drillLayoutNode = this._newDrillRules != null ? this._newDrillRules._drillLayoutNode : null;
        if (this.useNewRules(bDrillUpToRoot, drillLayoutNode, false)) {
            if (drillLayoutNode.isDrillable(bDrillUpToRoot, originalDrillUpSelectedCell, dataContainer)) {
                createdDataItem = this._newDrillRules.updateCrosstabLayout(bDrillUpToRoot, originalDrillUpSelectedCell);
            }
        } else {
            Element summaryElement = this.createSummaryElement(postDrillParent, v5query, dun, hun);
            Element detailElement = v5query.getItemList().addDataItemChildrenSet(summaryElement.attributeValue("name"), postDrillParent.nodeUse, hun, dun);
            DimensionalOperations.doPreUpdateLayoutOperations(dataContainer, nodeToDrillOn, postDrillParent, detailElement);
            ArrayList<DataItemRef> dataItemRefList = new ArrayList<DataItemRef>();
            dataItemRefList.add(new DataItemRef(detailElement.attributeValue("name"), false));
            dataItemRefList.add(new DataItemRef(summaryElement.attributeValue("name"), true));
            this.updateLayoutForCrosstab_BUA((V5Crosstab)dataContainer, v5query, nodeToDrillOn, dataItemRefList, postDrillParent);
            DimensionalOperations.doPostUpdateLayoutOperations(dataContainer, nodeToDrillOn, detailElement);
            createdDataItem = detailElement;
        }
        return createdDataItem;
    }

    private boolean useNewRules(boolean bDrillUpToRoot, DrillLayoutNode drillLayoutNode, boolean bIsChart) {
        return drillLayoutNode != null && (!drillLayoutNode.isSingleMemberDetail(bIsChart) || this.getIsDrillOnSingleDimensionNestedNode()) || bDrillUpToRoot;
    }

    private Element createSummaryElement(SelectedCell postDrillParent, V5Query v5query, String dun, String hun) throws ActionException {
        Element summaryElement = v5query.getItemList().addDataItemMember(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
        V5SpecHelper.setXMLAttribute(summaryElement, "RAP_DrillResetItem", "", "no");
        V5Drillability.setDrillParent(summaryElement);
        if (V5Drillability.isDrillUpDisabled(summaryElement)) {
            V5Drillability.clearDrillUpDisabled(v5query, summaryElement);
        }
        return summaryElement;
    }

    static void doPreUpdateLayoutOperations(V5DataContainer dataContainer, Element nodeToDrillOn, SelectedCell postDrillParent, Element detailElement) {
        DimensionalOperations.copySetSorting(dataContainer, nodeToDrillOn, detailElement);
        V5SpecHelper.updateRDIOfLinkedDrillItem(postDrillParent.queryName, nodeToDrillOn, detailElement.attributeValue("name"));
    }

    static void doPostUpdateLayoutOperations(V5DataContainer dataContainer, Element nodeToDrillOn, Element detailElement) {
        DimensionalOperations.copySortList(dataContainer, nodeToDrillOn, detailElement.attributeValue("name"));
    }

    private Element doDrillOnChart(V5DataContainer dataContainer, Element nodeToDrillOn, SelectedCell postDrillParent, SelectedCell originalDrillUpSelectedCell, boolean bDrillUpToRoot, V5Query v5query, String dun, String hun) throws CognosServiceRequestException, ActionException {
        DrillLayoutNode drillLayoutNode = this._newDrillRules != null ? this._newDrillRules._drillLayoutNode : null;
        Element createdDataItem = null;
        if (this.useNewRules(bDrillUpToRoot, drillLayoutNode, true)) {
            if (drillLayoutNode.isDrillable(bDrillUpToRoot, originalDrillUpSelectedCell, dataContainer)) {
                createdDataItem = this._newDrillRules.updateChartLayout(bDrillUpToRoot, originalDrillUpSelectedCell);
            }
        } else {
            Element detailDataItemElement;
            boolean bMemberHasChildren = this.baseAction.getRapServiceRequestManager().ifHasChild(dataContainer.getV5Query(), postDrillParent.nodeUse);
            if (bMemberHasChildren) {
                detailDataItemElement = v5query.getItemList().addDataItemChildrenSet(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
                DimensionalOperations.copySetSorting(dataContainer, nodeToDrillOn, detailDataItemElement);
            } else {
                detailDataItemElement = v5query.getItemList().addDataItemMember(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
                V5Drillability.setDrillDownDisabled(v5query, detailDataItemElement);
            }
            V5SpecHelper.updateRDIOfLinkedDrillItem(postDrillParent.queryName, nodeToDrillOn, detailDataItemElement.attributeValue("name"));
            if (V5Drillability.isDrillUpDisabled(detailDataItemElement)) {
                V5Drillability.clearDrillUpDisabled(v5query, detailDataItemElement);
            }
            ArrayList<DataItemRef> dataItemRefList = new ArrayList<DataItemRef>();
            dataItemRefList.add(0, new DataItemRef(detailDataItemElement.attributeValue("name"), !bMemberHasChildren));
            this.updateLayoutForChart_forBUA((V5Chart)dataContainer, v5query, nodeToDrillOn, dataItemRefList, postDrillParent);
            createdDataItem = detailDataItemElement;
            DimensionalOperations.doPostUpdateLayoutOperations(dataContainer, nodeToDrillOn, detailDataItemElement);
        }
        return createdDataItem;
    }

    private List<Element> updateLayoutForCrosstab_BUA(V5Crosstab v5Crosstab, V5Query v5Query, Element nodeToDrillOn, ArrayList<DataItemRef> dataItemRefList, SelectedCell selectedCell) throws ActionException {
        List replaceNodes = XMLUtility.selectNodes(nodeToDrillOn, "../../../*");
        Collection<Element> insertedNodes = v5Crosstab.insertObject(dataItemRefList, nodeToDrillOn, v5Query, true, true);
        List<Element> nodesToKeep = this.getInnerMostMeasureNodes(v5Query, nodeToDrillOn.getParent().getParent());
        if (nodesToKeep != null) {
            this.nestNodes(insertedNodes, nodesToKeep);
        }
        v5Query.removeFiltersUsingDataItem(nodeToDrillOn.attributeValue("refDataItem"));
        V5SpecHelper.deleteNodes(v5Crosstab, replaceNodes, true, v5Query);
        V5MasterDetailLinkUpdater.updateRefDataItemInDetailDataContainers(v5Crosstab, nodeToDrillOn.attributeValue("refDataItem"), v5Query.findItem(dataItemRefList.get(0).getRefDataItemName()));
        V5SpecHelper.removeLeafNodesByName(v5Crosstab.getContainerElement(), "crosstabNestedNodes");
        for (Element insertedNode : insertedNodes) {
            Element insertedNodeMember = V5X.selectSingleNode(insertedNode, "crosstabNodeMember");
            Element defaultStyle = V5X.selectSingleNode(insertedNodeMember, "//V5X//CHILD", "style", "defaultStyles", "defaultStyle");
            Element replacedNodeMember = this.getMatchingStyleNodeMember(replaceNodes, defaultStyle.attributeValue("refStyle"));
            Element nodeMemberToUse = replacedNodeMember != null ? replacedNodeMember : nodeToDrillOn;
            V5Style.copyStyle(nodeMemberToUse.element("style"), insertedNodeMember.element("style"));
            Element sourceFactCellStyle = V5X.selectSingleNode(nodeMemberToUse, "//V5X//CHILD", "factCell", "style");
            if (sourceFactCellStyle == null) continue;
            Element factCellStyle = DocumentHelper.makeElement((Branch)insertedNodeMember, (String)V5X.getMakeElementPath("factCell", "style"));
            V5Style.copyStyle(sourceFactCellStyle, factCellStyle);
        }
        return replaceNodes;
    }

    private Element getMatchingStyleNodeMember(List<Element> crosstabNodes, String refStyle) {
        for (Element crosstabNode : crosstabNodes) {
            Element crosstabNodeMember = V5X.selectSingleNode(crosstabNode, "//V5X//CHILD", "crosstabNodeMembers", "crosstabNodeMember");
            if (crosstabNodeMember == null) continue;
            Element defaultStyle = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "style", "defaultStyles", "defaultStyle");
            if (!refStyle.equals(defaultStyle.attributeValue("refStyle"))) continue;
            return crosstabNodeMember;
        }
        return null;
    }

    private void updateLayoutForChart_forBUA(V5Chart chart, V5Query v5Query, Element nodeToDrillOn, ArrayList<DataItemRef> dataItemRefList, SelectedCell selectedCell) throws ActionException {
        String rdiToUpdate = nodeToDrillOn.attributeValue("refDataItem");
        if (chart instanceof V5VizChart) {
            if (!V5VizChart.updateLayoutForBUADrill(nodeToDrillOn, dataItemRefList)) {
                return;
            }
            v5Query.removeFiltersUsingDataItem(nodeToDrillOn.attributeValue("refDataItem"));
        } else {
            List replaceNodes = XMLUtility.selectNodes(nodeToDrillOn, "../../../*");
            while (!"chartNode".equals(nodeToDrillOn.getName())) {
                nodeToDrillOn = nodeToDrillOn.getParent();
            }
            List<Element> insertedNodeMemberElements = chart.insertObject(dataItemRefList, nodeToDrillOn, v5Query);
            v5Query.removeFiltersUsingDataItem(nodeToDrillOn.attributeValue("refDataItem"));
            V5SpecHelper.deleteNodes(chart, replaceNodes, true, v5Query);
            for (Element insertedNodeMember : insertedNodeMemberElements) {
                V5Style.copyStyle(nodeToDrillOn.element("style"), insertedNodeMember.element("style"));
            }
        }
        List<Element> rdiRefs = chart.selectNodesInCurrentDomain("//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", rdiToUpdate);
        if (rdiRefs != null && dataItemRefList.size() > 0) {
            String newRDI = dataItemRefList.get(0).getRefDataItemName();
            for (Element rdiRef : rdiRefs) {
                rdiRef.addAttribute("refDataItem", newRDI);
            }
        }
    }

    public List<Element> getInnerMostMeasureNodes(V5Query v5Query, Element layoutNode) throws ActionException {
        List crosstabNodeMemberElements;
        Element startNode = layoutNode;
        while (startNode != null && startNode.element("crosstabNestedNodes") != null) {
            startNode = startNode.element("crosstabNestedNodes").element("crosstabNode");
        }
        if (startNode != layoutNode && this.areAllMeasureNodes(v5Query, crosstabNodeMemberElements = V5X.selectNodes(startNode.getParent(), "//V5X//CHILD", "crosstabNode", "crosstabNodeMembers", "crosstabNodeMember"))) {
            return crosstabNodeMemberElements;
        }
        return null;
    }

    public boolean areAllMeasureNodes(V5Query v5Query, List<Element> rdiNodes) throws ActionException {
        if (rdiNodes.size() == 0) {
            return false;
        }
        for (Element rdiNode : rdiNodes) {
            V5QueryItem queryItem;
            String rdi = rdiNode.attributeValue("refDataItem");
            if (rdi == null || (queryItem = new V5QueryItem(this.baseAction.getEnv(), v5Query, v5Query.findItem(rdi))).confirmIsNumeric() && queryItem.getNumericSubType() == V5QueryItem.NumericSubType.measure) continue;
            return false;
        }
        return true;
    }

    private void nestNodes(Collection<Element> parentNodes, List<Element> childNodes) {
        boolean isChart = parentNodes.iterator().next().getName().equals("chartNode");
        for (Element parentNode : parentNodes) {
            Element nestedNodes = isChart ? DocumentHelper.makeElement((Branch)parentNode, (String)"chartNestedNodes") : DocumentHelper.makeElement((Branch)parentNode, (String)"crosstabNestedNodes");
            Element nodeMembers = nestedNodes.addElement(isChart ? "chartNode" : "crosstabNode").addElement(isChart ? "chartNodeMembers" : "crosstabNodeMembers");
            for (Element child : childNodes) {
                nodeMembers.add(child.createCopy());
            }
        }
    }

    public Element doDrillingOnList(V5List v5List, V5Query v5query, Element listColumn, SelectedCell selectedCell, boolean useChildrenSet, boolean drillDown) throws ActionException {
        if (listColumn == null) {
            return null;
        }
        V5ListColumn v5ListColumn = new V5ListColumn(listColumn);
        String oldRDI = v5ListColumn.getDataItemName();
        String dun = DimensionalOperations.getDUN(v5query, selectedCell);
        String hun = DimensionalOperations.getHUN(v5query, selectedCell);
        Element dataItemElement = null;
        dataItemElement = useChildrenSet ? v5query.getItemList().addDataItemChildrenSet(selectedCell.nodeDisplay, selectedCell.nodeUse, hun, dun) : v5query.getItemList().addDataItemMember(selectedCell.nodeDisplay, selectedCell.nodeUse, hun, dun);
        dataItemElement.addAttribute("label", selectedCell.nodeDisplay);
        v5List.replaceDataItemRefOfListColumn(dataItemElement, listColumn, v5query);
        V5SpecHelper.resetCustomizedLabels((V5DataContainer)v5List, dataItemElement.attributeValue("name"), null);
        v5List.replaceRDIOfSortItem(oldRDI, dataItemElement.attributeValue("name"));
        DimensionalOperations.addDrillReset(v5query.findItem(oldRDI), dataItemElement);
        if (drillDown) {
            V5SpecHelper.setXMLAttribute(listColumn, DimensionalOperations.getNextBreadCrumbName(listColumn), oldRDI, "no");
        }
        return dataItemElement;
    }

    public static void addDrillReset(Element oldItem, Element dataItemElement) {
        if (oldItem != null) {
            String resetItem = V5SpecHelper.getXMLAttribute(oldItem, "RAP_DrillResetItem");
            if (resetItem == null) {
                resetItem = oldItem.attributeValue("name");
            }
            if (dataItemElement != null) {
                V5SpecHelper.setXMLAttribute(dataItemElement, "RAP_DrillResetItem", resetItem, "no");
            }
        }
    }

    public static String getNextBreadCrumbName(Element e) {
        int i = 0;
        while (V5SpecHelper.getXMLAttribute(e, "RAP_drillBreadCrumb" + Integer.toString(i)) != null) {
            ++i;
        }
        return "RAP_drillBreadCrumb" + Integer.toString(i);
    }

    public static String getLastBreadCrumbName(Element e) {
        int i = 0;
        while (V5SpecHelper.getXMLAttribute(e, "RAP_drillBreadCrumb" + Integer.toString(i)) != null) {
            ++i;
        }
        return i <= 0 ? null : "RAP_drillBreadCrumb" + Integer.toString(i - 1);
    }

    public Map<Integer, Collection<Element>> getHierarchyDepthsOfListColumns(V5Query v5Query, V5List v5List, List<Element> listColumns) throws ActionException {
        HashMap<Integer, Collection<Element>> map = new HashMap<Integer, Collection<Element>>();
        for (Element listColumn : listColumns) {
            int depth = this.getHierarchyDepthOfListColumn(v5List, v5Query, listColumn);
            Integer key = depth;
            ArrayList<Element> elements = (ArrayList<Element>)map.get(key);
            if (elements == null) {
                elements = new ArrayList<Element>();
                map.put(key, elements);
            }
            elements.add(listColumn);
        }
        return map;
    }

    public int getHierarchyDepthOfListColumn(V5List v5List, V5Query v5Query, Element listColumnElement) throws ActionException {
        Element dataItem = v5Query.getItemList().findItem(v5List.getRDIName(listColumnElement));
        Element exprNode = (Element)dataItem.selectSingleNode(".//*[local-name()='expression'] | .//*[local-name()='MUN'] | .//*[local-name()='LUN']");
        String expression = exprNode.getText();
        int depth = 0;
        if ("dataItemLevelSet".equals(dataItem.getName()) || "dataItemChildrenSet".equals(dataItem.getName())) {
            ++depth;
        }
        return depth += this.baseAction.getRapServiceRequestManager().getLevelDepth(v5Query, expression);
    }

    public static void setIsDrillOnIntersetion(SelectedCell selectedCell) {
        _bIsDrillOnIntersection = selectedCell.definingCells.size() >= 2 && ("".equals(selectedCell.nodeName) && "".equals(selectedCell.nodeUse) || "measure".equals(selectedCell.nodeUsage));
    }

    public static boolean isDrillOnIntersection() {
        return _bIsDrillOnIntersection;
    }

    public List<Element> getDrillableListColumnsOfSameDimension(RAPReport rapReport, V5Query query, V5List v5List, SelectedCell selectedCell) throws ActionException {
        ArrayList<Element> sameDimensionListColumnElements = new ArrayList<Element>();
        if (!this.isSelectedListColumnGrouped(v5List, selectedCell)) {
            ArrayList<SelectedCell> cells = new ArrayList<SelectedCell>();
            cells.add(selectedCell);
            cells.addAll(selectedCell.definingCells);
            for (SelectedCell cell : cells) {
                Element column;
                if ((selectedCell.nodeDimensionUniqueName == null || !selectedCell.nodeDimensionUniqueName.equals(cell.nodeDimensionUniqueName)) && (selectedCell.nodeHierarchyUniqueName == null || !selectedCell.nodeHierarchyUniqueName.equals(cell.nodeHierarchyUniqueName)) || (column = v5List.findItem(cell.nodeName)) == null) continue;
                sameDimensionListColumnElements.add(column);
            }
        } else {
            List listColumnElements = V5X.selectNodes(v5List.getContainerElement(), "//V5X//CHILD", "listColumns", "listColumn");
            for (Element listColumnElement : listColumnElements) {
                String sDun;
                Element rdiElement = V5X.selectSingleNode(listColumnElement, "//V5X//CHILD", "listColumnBody", "contents", "textItem", "dataSource", "dataItemValue", "//V5X//ATTR_DEFINED", "refDataItem");
                if (rdiElement == null || !this.ifDrillableElementFromSameDimension(rapReport, query, rdiElement, (sDun = selectedCell.nodeDimensionUniqueName) == null ? selectedCell.nodeHierarchyUniqueName : sDun)) continue;
                sameDimensionListColumnElements.add(listColumnElement);
            }
        }
        return sameDimensionListColumnElements;
    }

    private boolean isSelectedListColumnGrouped(V5List v5List, SelectedCell selectedCell) {
        Element rdiElement = (Element)v5List.getContainerElement().selectSingleNode(".//*[local-name()='listGroups']//*[@refDataItem=" + V5X.safeValue(selectedCell.nodeName) + "]");
        return rdiElement != null;
    }

    private boolean ifDrillableElementFromSameDimension(RAPReport rapReport, V5Query query, Element rdiElement, String dunOrHun) throws ActionException {
        String rdi = rdiElement.attributeValue("refDataItem");
        if (rdi == null || rdi.length() == 0) {
            rdiElement = (Element)rdiElement.selectSingleNode(".//*[@refDataItem]");
            rdi = rdiElement.attributeValue("refDataItem");
        }
        Element dataItemElement = query.getItemList().findItem(rdi);
        V5QueryItem queryItem = new V5QueryItem(this.getBaseAction().getEnv(), query, dataItemElement);
        if (queryItem.getItemType() == V5QueryItem.ItemType.numeric) {
            return false;
        }
        if (queryItem.confirmIsSetOrMember()) {
            if (queryItem.getProperties()._dun != null) {
                boolean bResult = dunOrHun.equals(queryItem.getProperties()._dun);
                if (!bResult && queryItem.getProperties()._hun != null) {
                    bResult = dunOrHun.equals(queryItem.getProperties()._hun);
                }
                return bResult;
            }
            if (queryItem.getItemType() == V5QueryItem.ItemType.member) {
                return queryItem.getQueryItemExpression().startsWith(dunOrHun);
            }
        }
        return false;
    }

    public Element getHighestNestedNodeWithSameHun(Element current, SelectedCell selectedCell, V5Query v5Query) throws ActionException {
        String highestDataItem = null;
        String hierarchyUniqueName = selectedCell.nodeHierarchyUniqueName;
        if (selectedCell.definingCells.size() > 0) {
            SelectedCell startCell = selectedCell;
            while (startCell.definingCells.size() > 0) {
                startCell = startCell.definingCells.get(0);
                if (hierarchyUniqueName != null && hierarchyUniqueName.equals(startCell.nodeHierarchyUniqueName)) {
                    highestDataItem = startCell.nodeName;
                    continue;
                }
                break;
            }
        } else if ("crosstabNodeMember".equals(current.getName()) && V5SpecHelper.getAncestor(current, "crosstabNestedNodes") != null && hierarchyUniqueName != null) {
            Element startNode = current;
            while (V5SpecHelper.getAncestor(startNode, "crosstabNestedNodes") != null) {
                String rdi;
                Element crosstabNode = V5SpecHelper.getAncestor(startNode, "crosstabNestedNodes").getParent();
                startNode = V5X.selectSingleNode(crosstabNode, "//V5X//CHILD", "crosstabNodeMembers", "crosstabNodeMember", "//V5X//ATTR_DEFINED", "refDataItem");
                String string = rdi = startNode == null ? null : startNode.attributeValue("refDataItem");
                if (rdi == null) continue;
                V5QueryItem queryItem = new V5QueryItem(this.baseAction.getEnv(), v5Query, v5Query.findItem(rdi));
                queryItem.confirmIsSetOrMember();
                if (hierarchyUniqueName.equals(queryItem.getProperties()._hun)) {
                    highestDataItem = rdi;
                    continue;
                }
                break;
            }
        } else if ("chartNodeMember".equals(current.getName()) && V5SpecHelper.getAncestor(current, "chartNestedNodes") != null && hierarchyUniqueName != null) {
            Element startNode = current;
            while (V5SpecHelper.getAncestor(startNode, "chartNestedNodes") != null) {
                Element crosstabNode = V5SpecHelper.getAncestor(startNode, "chartNestedNodes").getParent();
                startNode = V5X.selectSingleNode(crosstabNode, "//V5X//CHILD", "chartNodeMembers", "chartNodeMember", "//V5X//ATTR_DEFINED", "refDataItem");
                String rdi = startNode.attributeValue("refDataItem");
                V5QueryItem queryItem = new V5QueryItem(this.baseAction.getEnv(), v5Query, v5Query.findItem(rdi));
                queryItem.confirmIsSetOrMember();
                if (hierarchyUniqueName.equals(queryItem.getProperties()._hun)) {
                    highestDataItem = rdi;
                    continue;
                }
                break;
            }
        }
        if (highestDataItem != null && current != null) {
            if ("crosstabNodeMember".equals(current.getName())) {
                return (Element)current.selectSingleNode("ancestor::*[local-name()='crosstabNode']/*[local-name()='crosstabNodeMembers']/*[local-name()='crosstabNodeMember'][@refDataItem='" + highestDataItem + "']");
            }
            if ("chartNodeMember".equals(current.getName())) {
                return (Element)current.selectSingleNode("ancestor::*[local-name()='chartNode']/*[local-name()='chartNodeMembers']/*[local-name()='chartNodeMember'][@refDataItem='" + highestDataItem + "']");
            }
        }
        return current;
    }

    public void setIsDrillOnSingleDimensionNestedNode(V5DataContainer v5DataContainer, Element nodeToDrillOn, SelectedCell selectedCell, V5Query v5Query) throws ActionException {
        this.bIsDrillOnSingleDimensionNested = false;
        if (this._newDrillRules == null) {
            return;
        }
        String hierarchyUniqueName = selectedCell.nodeHierarchyUniqueName;
        String expectedNodeType = null;
        if (v5DataContainer instanceof V5Crosstab) {
            expectedNodeType = "crosstabNodeMember";
        } else if (v5DataContainer instanceof V5VizChart) {
            expectedNodeType = "vizCategoryDataItem";
        } else if (v5DataContainer instanceof V5Chart) {
            expectedNodeType = "chartNodeMember";
        }
        if (expectedNodeType != null && expectedNodeType.equals(nodeToDrillOn.getName()) && hierarchyUniqueName != null) {
            List<Element> nestedNodes = v5DataContainer.getNestedLocationWithSameHUN(v5Query, nodeToDrillOn, selectedCell.nodeHierarchyUniqueName);
            this.bIsDrillOnSingleDimensionNested = nestedNodes.size() > 1;
        }
    }

    public boolean getIsDrillOnSingleDimensionNestedNode() {
        return this.bIsDrillOnSingleDimensionNested;
    }

    public Element getNodeToDrillOnFromCell(V5DataContainer dataContainer, SelectedCell selectedCell) {
        Element nodeToDrillOn = null;
        ArrayList<String> rdis = new ArrayList<String>();
        rdis.add(selectedCell.nodeName);
        for (SelectedCell definingCell : selectedCell.definingCells) {
            rdis.add(0, definingCell.nodeName);
        }
        nodeToDrillOn = dataContainer.findItem((String)rdis.get(0));
        for (int i = 1; i < rdis.size() && nodeToDrillOn != null; ++i) {
            Element parent = null;
            if (nodeToDrillOn.getName().equals("crosstabNodeMember")) {
                parent = V5SpecHelper.getAncestor(nodeToDrillOn, "crosstabNode");
            } else if (nodeToDrillOn.getName().equals("chartNodeMember")) {
                parent = V5SpecHelper.getAncestor(nodeToDrillOn, "chartNode");
            }
            if (parent == null) break;
            if (parent.getName().equals("crosstabNode")) {
                nodeToDrillOn = V5X.selectSingleNode(parent, "crosstabNodeMember", "//V5X//ATTR", "refDataItem", (String)rdis.get(i));
                continue;
            }
            if (!parent.getName().equals("chartNode")) continue;
            nodeToDrillOn = V5X.selectSingleNode(parent, "chartNodeMember", "//V5X//ATTR", "refDataItem", (String)rdis.get(i));
        }
        if (nodeToDrillOn == null || !selectedCell.nodeName.equals(nodeToDrillOn.attributeValue("refDataItem"))) {
            nodeToDrillOn = dataContainer.findItem(selectedCell.nodeName);
        }
        if (nodeToDrillOn == null || !"vizCategoryDataItem".equals(nodeToDrillOn.getName()) && !"crosstabNodeMember".equals(nodeToDrillOn.getName()) && !"chartNodeMember".equals(nodeToDrillOn.getName())) {
            return null;
        }
        return nodeToDrillOn;
    }

    public Element createDrillUpCellToEdge(V5DataContainer dataContainer, SelectedCell selectedCell) throws ActionException {
        Element nodeToDrill = this.getNodeToDrillOnFromCell(dataContainer, selectedCell);
        if (nodeToDrill == null) {
            String targetHUN = selectedCell.nodeHierarchyUniqueName;
            List<Element> nodes = dataContainer.collectEdgeNodes();
            for (Element node : nodes) {
                String rdi = node.attributeValue("refDataItem");
                if (rdi == null) continue;
                V5QueryItem item = new V5QueryItem(this.baseAction.getEnv(), dataContainer.getV5Query(), dataContainer.getV5Query().findItem(rdi));
                if (item.getProperties()._hun == null || !item.getProperties()._hun.equals(selectedCell.nodeHierarchyUniqueName)) continue;
                item.confirmIsSet();
                return node;
            }
        }
        return nodeToDrill;
    }

    public Element doDrillUp(V5DataContainer dataContainer, Element nodeToDrillOn, MemberInfo ancestorInfo, SelectedCell selectedCell, boolean bDrillToRoot) throws ActionException {
        if (nodeToDrillOn == null) {
            return null;
        }
        if (!(DrillLayoutNode.hasBreadCrumb(nodeToDrillOn) || ancestorInfo != null && ancestorInfo.isValid())) {
            V5Drillability.setDrillUpDisabled(dataContainer.getV5Query(), selectedCell.nodeName);
            return null;
        }
        V5Query v5query = dataContainer.getV5Query();
        Element dataItem = v5query.findItem(selectedCell.nodeName);
        if (dataItem != null && V5Drillability.isDrillDownDisabled(dataItem)) {
            V5Drillability.clearDrillDownDisabled(v5query, dataItem);
        }
        String mun = ancestorInfo.getMUN();
        String memberCaption = ancestorInfo.getMemberCaption();
        selectedCell.nodeDimensionUniqueName = DimensionalOperations.getDUN(v5query, selectedCell);
        selectedCell.nodeHierarchyUniqueName = DimensionalOperations.getHUN(v5query, selectedCell);
        SelectedCell postDrillParent = DimensionalOperations.createSelectedCell(memberCaption, mun, selectedCell);
        Element createdDataItem = this.doDrillOnCrosstabOrChart(dataContainer, nodeToDrillOn, postDrillParent, selectedCell, bDrillToRoot);
        return createdDataItem;
    }

    public static String getDUN(V5Query query, SelectedCell selectedCell) {
        if (selectedCell.nodeDimensionUniqueName != null && selectedCell.nodeDimensionUniqueName.length() > 0) {
            return selectedCell.nodeDimensionUniqueName;
        }
        String dun = null;
        Element refDataItem = query.findItem(selectedCell.nodeName);
        if (refDataItem != null && (dun = V5QueryItem.getDun(refDataItem)) == null && selectedCell.nodeHierarchyUniqueName != null) {
            return V5SpecHelper.getDUN(selectedCell.nodeHierarchyUniqueName);
        }
        return dun;
    }

    public static String getHUN(V5Query query, SelectedCell selectedCell) {
        if (selectedCell.nodeHierarchyUniqueName != null && selectedCell.nodeHierarchyUniqueName.length() > 0) {
            return selectedCell.nodeHierarchyUniqueName;
        }
        Element refDataItem = query.getItemList().findItem(selectedCell.nodeName);
        if (refDataItem == null) {
            return null;
        }
        return V5Query.getExtendedDataItemProperty(refDataItem, "HUN");
    }

    public static boolean isDrillableMember(SelectedCell cell) {
        return "memberUniqueName".equals(cell.nodeType) && "nonMeasure".equals(cell.nodeUsage) && !cell.nodeUse.startsWith("calc_uuid:") && !cell.nodeUse.startsWith("uuid:");
    }

    public static List<SelectedCell> buildSelectedCellsToDrill(SelectedCell selectedCell, String userSelectedItem, V5DataContainer dataContainer) {
        ArrayList<SelectedCell> cellsToDrill = new ArrayList<SelectedCell>();
        if (userSelectedItem != null) {
            SelectedCell searchResult = DimensionalOperations.findSelectedCell(selectedCell, userSelectedItem);
            if (searchResult != null) {
                cellsToDrill.add(searchResult);
            }
            return cellsToDrill;
        }
        if (dataContainer instanceof V5VizChart) {
            List<Element> edgeNodes = ((V5VizChart)dataContainer).collectInnerMostEdgeNodes();
            HashSet<SelectedCell> cellsToDrillSet = new HashSet<SelectedCell>();
            for (Element edgeNode : edgeNodes) {
                String refDataItem = edgeNode.attributeValue("refDataItem");
                SelectedCell searchResult = DimensionalOperations.findSelectedCell(selectedCell, refDataItem);
                if (searchResult == null) continue;
                cellsToDrillSet.add(searchResult);
            }
            return new ArrayList<SelectedCell>(cellsToDrillSet);
        }
        DimensionalOperations.setIsDrillOnIntersetion(selectedCell);
        if (DimensionalOperations.isDrillOnIntersection()) {
            if (dataContainer != null) {
                Element dataContainerElem = dataContainer.getContainerElement();
                Element tempElement = null;
                for (SelectedCell cell : selectedCell.definingCells) {
                    tempElement = V5X.selectSingleNode(dataContainerElem, "masterDetailLink", "masterContext", "dataItemContext", "//V5X//ATTR", "refDataItem", cell.nodeName);
                    if (tempElement != null) continue;
                    cellsToDrill.add(cell);
                }
            } else {
                cellsToDrill.addAll(selectedCell.definingCells);
            }
        } else {
            cellsToDrill.add(selectedCell);
        }
        return cellsToDrill;
    }

    private static SelectedCell findSelectedCell(SelectedCell cell, String searchName) {
        if (searchName.equals(cell.nodeName)) {
            return cell;
        }
        if (cell.definingCells != null) {
            for (SelectedCell definingCell : cell.definingCells) {
                SelectedCell result = DimensionalOperations.findSelectedCell(definingCell, searchName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public int getAncestorDistance(V5Query v5Query, SelectedCell selectedCell) throws ActionException {
        Element onSummary = this.baseAction.getActionArguments().getActionArgs().element("onSummary");
        if (onSummary != null) {
            for (Element dataItem : onSummary.elements()) {
                if (dataItem.getText() == null || !dataItem.getText().equals(selectedCell.nodeName)) continue;
                return 1;
            }
        }
        return this.getAncestorDistance(v5Query, selectedCell.nodeName, selectedCell.nodeUse);
    }

    public int getAncestorDistance(V5Query v5Query, Element dataItem) throws ActionException {
        Element exprNode = (Element)dataItem.selectSingleNode(".//*[local-name()='MUN'] | .//*[local-name()='expression']");
        return this.getAncestorDistance(v5Query, dataItem.attributeValue("name"), exprNode.getText());
    }

    private int getAncestorDistance(V5Query v5Query, String rdi, String expression) throws ActionException {
        Element dataItem = v5Query.findItem(rdi);
        V5QueryItem queryItem = new V5QueryItem(this.getBaseAction().getEnv(), v5Query, dataItem);
        if (dataItem.getName().equals("dataItem") || queryItem.confirmIsSet()) {
            return 2;
        }
        return DimensionalOperations.getAncestorDistance(expression);
    }

    private static int getAncestorDistance(String expression) {
        int distance = 1;
        if (expression.startsWith("children(")) {
            distance = 2;
        }
        return distance;
    }

    public static SelectedCell createSelectedCell(String caption, String expression, SelectedCell baseCell) {
        SelectedCell newSelectedCell = new SelectedCell();
        newSelectedCell.queryName = baseCell.queryName;
        newSelectedCell.nodeDisplay = caption;
        newSelectedCell.nodeName = caption;
        newSelectedCell.nodeUse = expression;
        newSelectedCell.nodeDimensionUniqueName = baseCell.nodeDimensionUniqueName;
        newSelectedCell.nodeHierarchyUniqueName = baseCell.nodeHierarchyUniqueName;
        return newSelectedCell;
    }

    public void setBaseAction(BaseAction baseAction) {
        this.baseAction = baseAction;
    }

    public BaseAction getBaseAction() {
        return this.baseAction;
    }

    public Element getOuterMostCrosstabNodeInChartMatrixByDimension(V5Crosstab v5Crosstab, String dun) throws ActionException {
        Element crosstabEdgeRoot;
        V5Query v5Query = new V5Query(v5Crosstab.getContainerElement(), v5Crosstab.getRefQuery());
        Element crosstabNodeMemberFromSameDimension = this.getCrosstabNodeMemberByDun(v5Query, crosstabEdgeRoot = (Element)v5Crosstab.getContainerElement().selectSingleNode(V5X.select("crosstabColumns")), dun);
        if (crosstabNodeMemberFromSameDimension == null) {
            crosstabEdgeRoot = (Element)v5Crosstab.getContainerElement().selectSingleNode(V5X.select("crosstabRows"));
            crosstabNodeMemberFromSameDimension = this.getCrosstabNodeMemberByDun(v5Query, crosstabEdgeRoot, dun);
        }
        return crosstabNodeMemberFromSameDimension;
    }

    private Element getCrosstabNodeMemberByDun(V5Query v5Query, Element crosstabEdgeRoot, String dun) throws ActionException {
        if (crosstabEdgeRoot == null) {
            return null;
        }
        List crosstabNodeElements = XMLUtility.selectNodes(crosstabEdgeRoot, V5X.select("crosstabNode"));
        for (Element crosstabNodeElement : crosstabNodeElements) {
            Element crosstabNodeMemberElement = V5X.selectSingleNode(crosstabNodeElement, "//V5X//CHILD", "crosstabNodeMembers", "//V5X//CHILD", "crosstabNodeMember");
            if (!this.ifDrillableElementFromSameDimension(this.baseAction.getRAPReport(), v5Query, crosstabNodeMemberElement, dun)) continue;
            return crosstabNodeMemberElement;
        }
        for (Element crosstabNodeElement : crosstabNodeElements) {
            Element crosstabNestedNodesElement = (Element)crosstabNodeElement.selectSingleNode(V5X.select("crosstabNestedNodes"));
            Element crosstabNodeMemberFromSameDimension = this.getCrosstabNodeMemberByDun(v5Query, crosstabNestedNodesElement, dun);
            if (crosstabNodeMemberFromSameDimension == null) continue;
            return crosstabNodeMemberFromSameDimension;
        }
        return null;
    }

    private static void copySetSorting(V5DataContainer dataContainer, Element nodeToDrillOn, Element targetDataItem) {
        boolean copied;
        Element sourceDataItem;
        Element nodeMember;
        if (!V5QueryItem.isHighLevelSetType(targetDataItem)) {
            return;
        }
        Element edgeRoot = nodeToDrillOn.getParent().getParent().getParent();
        List<Element> nodeMemberElements = dataContainer.collectEdgeNodes();
        String targetHUN = V5Query.getExtendedDataItemProperty(targetDataItem, "HUN");
        if (targetHUN == null) {
            return;
        }
        Iterator<Element> iterator = nodeMemberElements.iterator();
        while (!(!iterator.hasNext() || V5SpecHelper.findParentContainer(nodeMember = iterator.next()) == dataContainer.getContainerElement() && (sourceDataItem = dataContainer.getV5Query().findItem(nodeMember.attributeValue("refDataItem"))) != null && sourceDataItem != targetDataItem && targetHUN.equals(V5Query.getExtendedDataItemProperty(sourceDataItem, "HUN")) && (copied = DimensionalOperations.copySetSorting(sourceDataItem, targetDataItem)))) {
        }
    }

    private static boolean copySetSorting(Element sourceDataItem, Element targetDataItem) {
        if (sourceDataItem == null || sourceDataItem == targetDataItem || !V5QueryItem.isHighLevelSetType(targetDataItem)) {
            return false;
        }
        Element sourceSetSorting = sourceDataItem.element("setSorting");
        if (sourceSetSorting != null) {
            Element setSorting = targetDataItem.element("setSorting");
            if (setSorting != null) {
                setSorting.detach();
            }
            targetDataItem.add(sourceSetSorting.createCopy());
            return true;
        }
        return false;
    }

    private static void copySortList(V5DataContainer dataContainer, Element oldNode, String newDataItemName) {
        if (oldNode.element("sortList") == null) {
            return;
        }
        Element newLayoutNode = dataContainer.findItem(newDataItemName);
        if (newLayoutNode == null || oldNode == newLayoutNode) {
            return;
        }
        newLayoutNode.add(oldNode.element("sortList").createCopy());
        String oldRDI = oldNode.attributeValue("refDataItem");
        dataContainer.replaceRDIOfSortItem(oldRDI, newDataItemName);
    }

    public static class DataItemRef {
        private String refDataItemName;
        private boolean drillParent;

        public DataItemRef(String refDataItemName, boolean drillParent) {
            this.refDataItemName = refDataItemName;
            this.drillParent = drillParent;
        }

        public String getRefDataItemName() {
            return this.refDataItemName;
        }

        public boolean isDrillParent() {
            return this.drillParent;
        }
    }
}

