/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.NewDrillRules;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5VizChart;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

class DrillLayoutNode {
    private Element _drillLayoutNodeElement = null;
    private Element _queryItem = null;
    private boolean _bIsDrillParent;
    private boolean _bIsIsolated;
    private boolean _bIsDataItemMember;
    private Element _relatedDetailLayoutNode = null;
    private boolean _bDrillUp;
    private SelectedCell _postDrillParent;
    private V5Query _v5query;
    private List<SelectedCell> _definingCellsWithSameHUN = null;
    private RapServiceRequestManager _rapServiceManager = null;
    private V5DataContainer _v5DataContainer = null;
    private boolean _bIsDrillOnSingleDimensionNested;
    private String _hun = null;
    private String _dun = null;
    private boolean _bIsDataItemDimensionalEdgeSummary;
    private String _originalRDI = null;
    private String _queryItemName;

    public DrillLayoutNode(boolean bDrillUp, Element nodeToDrillOn, SelectedCell postDrillParent, V5Query v5query, V5DataContainer v5DataContainer, RapServiceRequestManager rapServiceManager, String dun, String hun) {
        this._postDrillParent = postDrillParent;
        this._drillLayoutNodeElement = nodeToDrillOn;
        this._bDrillUp = bDrillUp;
        this._v5query = v5query;
        this._rapServiceManager = rapServiceManager;
        this._hun = hun;
        this._dun = dun;
        this._v5DataContainer = v5DataContainer;
        this._originalRDI = nodeToDrillOn.attributeValue("refDataItem");
        this.setQueryItem(bDrillUp, postDrillParent, v5query);
        this.setIsDrillParent();
        this.setIsDataItemMember();
        this.setIsIsolated();
        this.setIsDataItemDimensionalEdgeSummary();
    }

    private void setQueryItem(boolean bDrillUp, SelectedCell postDrillParent, V5Query v5query) {
        this._queryItem = bDrillUp ? v5query.findItem(this._drillLayoutNodeElement.attributeValue("refDataItem")) : v5query.findItem(postDrillParent.nodeName);
        this._queryItemName = this._queryItem.attributeValue("name");
    }

    private void setIsIsolated() {
        String drillIsolated = V5SpecHelper.getXMLAttribute(this._queryItem, "RAP_drillIsolated", false);
        this._bIsIsolated = this.isDataItemMember() && drillIsolated != null && drillIsolated.equals("true");
    }

    private void setIsDrillParent() {
        this._bIsDrillParent = V5Query.isRSDrillParent(this._queryItem);
    }

    private void setIsDataItemMember() {
        this._bIsDataItemMember = this._queryItem.getName().equals("dataItemMember");
    }

    private void setIsDataItemDimensionalEdgeSummary() {
        this._bIsDataItemDimensionalEdgeSummary = this._queryItem.getName().equals("dataItemDimensionalEdgeSummary");
    }

    private Element getRelatedItemSet(String sDrilledOnMUN) {
        Iterator<String> it = NewDrillRules._DataItemSetType.iterator();
        while (it.hasNext()) {
            Element relatedQueryItem = this._v5query.getItem(it.next(), sDrilledOnMUN);
            if (relatedQueryItem == null) continue;
            return relatedQueryItem;
        }
        return null;
    }

    private boolean nestedLocationsContainRootMember(SelectedCell originalDrillUpSelectedCell, V5DataContainer dataContainer) throws CognosServiceRequestException, ActionException {
        if (!this._bDrillUp || !this._bIsDrillOnSingleDimensionNested) {
            return false;
        }
        String mun = null;
        List<SelectedCell> definingCells = this.getDefiningCellsFromSameHierarchy(originalDrillUpSelectedCell);
        int numberOfDefiningCells = definingCells.size();
        if (numberOfDefiningCells > 0) {
            SelectedCell ancestor = definingCells.get(numberOfDefiningCells - 1);
            mun = ancestor.nodeUse;
        }
        if (mun == null) {
            return false;
        }
        MemberInfo ancestorParent = this._rapServiceManager.getAncestorInfo(dataContainer.getV5Query(), mun, 1);
        return ancestorParent == null || !ancestorParent.isValid();
    }

    public Element getRelatedSummaryLayoutNodeForCrosstab(Element layoutNode, String queryItemName) {
        if (this.isDrillDownOnIsolatedNode()) {
            return null;
        }
        Element crosstabNode = V5SpecHelper.getAncestor(layoutNode, "crosstabNode");
        if (crosstabNode == null) {
            return null;
        }
        List potentialSummaryNodes = XMLUtility.selectNodes(crosstabNode, V5X.selectPrecedingSibling("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember") + "|" + V5X.selectFollowingSibling("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember"));
        Element relatedSummaryLayoutNode = null;
        for (Element potentialSummaryNode : potentialSummaryNodes) {
            Element potentialSummaryItem = this._v5query.findItem(potentialSummaryNode.attributeValue("refDataItem"));
            if (potentialSummaryItem == null) continue;
            String potentialSummaryHUN = V5Query.getExtendedDataItemProperty(potentialSummaryItem, "HUN");
            if ((potentialSummaryHUN != null && potentialSummaryHUN.equals(this._postDrillParent.nodeHierarchyUniqueName) || "dataItemEdgeSummary".equals(potentialSummaryItem.getName())) && NewDrillRules._DataItemSummaryType.contains(potentialSummaryItem.getName())) {
                relatedSummaryLayoutNode = potentialSummaryNode;
                break;
            }
            String potentialAggregateRDI = V5QueryItem.getKnownAggregateRDI(potentialSummaryItem);
            if (potentialAggregateRDI == null || !potentialAggregateRDI.equals(queryItemName)) continue;
            relatedSummaryLayoutNode = potentialSummaryNode;
            V5QueryItem.upgradeIfKnownAggregateItem(potentialSummaryItem, this._hun, this._dun);
            break;
        }
        return relatedSummaryLayoutNode;
    }

    public List<Element> getRelatedSummaryLayoutNodeForChart(Element layoutNode, String itemName) {
        ArrayList<Element> relatedSummaryNodes = new ArrayList<Element>();
        if (this.isDrillDownOnIsolatedNode()) {
            return null;
        }
        if ("v2_combinationChart".equals(this.getV5Container().getContainerElement().getName())) {
            List combinationChartTypes = V5X.selectNodes(this.getV5Container().getContainerElement(), "v2_combinationChartTypes");
            if (combinationChartTypes != null && combinationChartTypes.size() > 0) {
                for (Element combinationChartType : combinationChartTypes) {
                    Element chartSummary;
                    List potentialSummaryNodes = V5X.selectNodes(combinationChartType, "chartNodeMembers", "chartNodeMember", "//V5X//EXCEPT_ATTR", "refDataItem", layoutNode.attributeValue("refDataItem"));
                    if (potentialSummaryNodes == null || (chartSummary = this.findChartSummaryLayoutNode(itemName, potentialSummaryNodes)) == null) continue;
                    relatedSummaryNodes.add(chartSummary);
                }
            }
        } else {
            List<Element> potentialSummaryNodes = this.getV5Container().findPotentialChartSummaryNodes(layoutNode, itemName);
            if (potentialSummaryNodes == null) {
                return null;
            }
            Element chartSummary = this.findChartSummaryLayoutNode(itemName, potentialSummaryNodes);
            if (chartSummary != null) {
                relatedSummaryNodes.add(chartSummary);
            }
        }
        return relatedSummaryNodes;
    }

    private Element findChartSummaryLayoutNode(String layoutNodeRDI, List<Element> potentialSummaryNodes) {
        Element relatedSummaryLayoutNode = null;
        for (Element potentialSummaryNode : potentialSummaryNodes) {
            Element potentialSummaryItem = this._v5query.findItem(potentialSummaryNode.attributeValue("refDataItem"));
            if (potentialSummaryItem == null) continue;
            String potentialSummaryHUN = V5Query.getExtendedDataItemProperty(potentialSummaryItem, "HUN");
            if (potentialSummaryHUN != null && potentialSummaryHUN.equals(this._postDrillParent.nodeHierarchyUniqueName) && NewDrillRules._DataItemSummaryType.contains(potentialSummaryItem.getName())) {
                relatedSummaryLayoutNode = potentialSummaryNode;
                break;
            }
            String potentialAggregateRDI = V5QueryItem.getKnownAggregateRDI(potentialSummaryItem);
            if (potentialAggregateRDI == null || !potentialAggregateRDI.equals(layoutNodeRDI)) continue;
            relatedSummaryLayoutNode = potentialSummaryNode;
            V5QueryItem.upgradeIfKnownAggregateItem(potentialSummaryItem, this._hun, this._dun);
            break;
        }
        return relatedSummaryLayoutNode;
    }

    public Element getRelatedDetailLayoutNodeForCrosstab() throws CognosServiceRequestException, ActionException {
        if (this._relatedDetailLayoutNode != null) {
            return this._relatedDetailLayoutNode;
        }
        String drilledOnMUN = V5Query.getExtendedDataItemProperty(this._queryItem, "MUN");
        Element relatedQueryItemSet = this.getRelatedItemSet(drilledOnMUN);
        Element crosstabNode = V5SpecHelper.getAncestor(this._drillLayoutNodeElement, "crosstabNode");
        if (relatedQueryItemSet != null) {
            Element startNode = crosstabNode.getParent();
            Element relatedLayoutNode = V5X.selectSingleNode(startNode, "//V5X//CHILD", "crosstabNode", "crosstabNodeMembers", "crosstabNodeMember", "//V5X//ATTR", "refDataItem", relatedQueryItemSet.attributeValue("name"));
            if (relatedLayoutNode != null) {
                this._relatedDetailLayoutNode = relatedLayoutNode;
                return relatedLayoutNode;
            }
        }
        List siblings = XMLUtility.selectNodes(crosstabNode, V5X.selectPrecedingSibling("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember") + "|" + V5X.selectFollowingSibling("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember"));
        this.findRelatedDataItemMember(drilledOnMUN, siblings);
        return this._relatedDetailLayoutNode;
    }

    private void findRelatedDataItemMember(String drilledOnMUN, List<Element> siblingNodes) throws CognosServiceRequestException, ActionException {
        for (Element sibling : siblingNodes) {
            MemberInfo parentInfo;
            String siblingHUN;
            Element siblingQueryItem = this._v5query.findItem(sibling.attributeValue("refDataItem"));
            if (siblingQueryItem == null || (siblingHUN = V5Query.getExtendedDataItemProperty(siblingQueryItem, "HUN")) == null || !siblingHUN.equals(this._postDrillParent.nodeHierarchyUniqueName) || !siblingQueryItem.getName().equals("dataItemMember") || !(parentInfo = this._rapServiceManager.getAncestorInfo(this._v5query, V5Query.getExtendedDataItemProperty(siblingQueryItem, "MUN"), 1)).isValid() || !drilledOnMUN.equals(parentInfo.getMUN())) continue;
            this._relatedDetailLayoutNode = sibling;
            break;
        }
    }

    public Element getQueryItem() {
        return this._queryItem;
    }

    public boolean isDataItemDimensionalEdgeSummary() {
        return this._bIsDataItemDimensionalEdgeSummary;
    }

    public boolean isSummary() {
        if (this._bIsDataItemDimensionalEdgeSummary) {
            return true;
        }
        if (this._bIsDrillParent) {
            if (this._v5DataContainer instanceof V5Crosstab) {
                return this.getRelatedSummaryLayoutNodeForCrosstab(this._drillLayoutNodeElement, this._queryItemName) == null;
            }
            List<Element> summaryNodes = this.getRelatedSummaryLayoutNodeForChart(this._drillLayoutNodeElement, this._queryItemName);
            return summaryNodes == null || summaryNodes.size() > 0;
        }
        return false;
    }

    public boolean isIsolated() {
        return this._bIsIsolated;
    }

    public boolean isDataItemMember() {
        return this._bIsDataItemMember;
    }

    boolean isSingleMemberDetail(boolean bIsChart) {
        return this.isDataItemMember() && !this.isIsolated() && !this.isSummary() && this.hasSiblings(bIsChart);
    }

    private boolean isDrillDownOnDrillParent() {
        return !this._bDrillUp && this._bIsDrillParent;
    }

    public boolean isDrillable(boolean bDrillToRoot, SelectedCell originalDrillUpSelectedCell, V5DataContainer dataContainer) throws CognosServiceRequestException, ActionException {
        return bDrillToRoot && !this.isDrillOnSingleDimensionNestedNode() || !this.isDrillDownOnIsolatedNode() && !this.isDrillDownOnDrillParent() && !this.isPreserveDrillBehaviour() && (!DimensionalOperations.isDrillOnIntersection() || !this.isDataItemDimensionalEdgeSummary()) && !this.nestedLocationsContainRootMember(originalDrillUpSelectedCell, dataContainer);
    }

    private boolean isPreserveDrillBehaviour() {
        return V5X.selectSingleNode(this.getLayoutNodeElement().getDocument().getRootElement(), "//V5X//CHILD", "drillBehavior", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.getV5Query().getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", this._originalRDI, this._bDrillUp ? "drillUpBehavior" : "drillDownBehavior", "drillSimpleType", "//V5X//ATTR", "type", "preserve") != null;
    }

    private boolean isDrillDownOnIsolatedNode() {
        return !this._bDrillUp && this.isIsolated() && this._postDrillParent.nodeName.equals(this._drillLayoutNodeElement.attributeValue("refDataItem"));
    }

    public List<SelectedCell> getDefiningCellsFromSameHierarchy(SelectedCell selectedCell) {
        if (this._definingCellsWithSameHUN != null) {
            return this._definingCellsWithSameHUN;
        }
        this._definingCellsWithSameHUN = new ArrayList<SelectedCell>();
        int noOfDefiningCells = selectedCell.definingCells.size();
        String hierarchyUniqueName = selectedCell.nodeHierarchyUniqueName;
        for (int i = 0; i < noOfDefiningCells; ++i) {
            SelectedCell selectedCellDefiningCell = selectedCell.definingCells.get(i);
            if (selectedCellDefiningCell.nodeHierarchyUniqueName.equals(hierarchyUniqueName)) {
                this._definingCellsWithSameHUN.add(selectedCellDefiningCell);
            }
            SelectedCell newDefiningCell = selectedCell.definingCells.get(i);
            while (newDefiningCell.definingCells.size() > 0) {
                newDefiningCell = newDefiningCell.definingCells.get(0);
                if (!hierarchyUniqueName.equals(newDefiningCell.nodeHierarchyUniqueName)) continue;
                this._definingCellsWithSameHUN.add(newDefiningCell);
            }
        }
        return this._definingCellsWithSameHUN;
    }

    public void setIsDrillOnSingleDimensionNestedNode(boolean bIsDrillOnSingleDimensionNested) {
        this._bIsDrillOnSingleDimensionNested = bIsDrillOnSingleDimensionNested;
    }

    public boolean isDrillOnSingleDimensionNestedNode() {
        return this._bIsDrillOnSingleDimensionNested;
    }

    public String getDUN() {
        return this._dun;
    }

    public String getHUN() {
        return this._hun;
    }

    public V5Query getV5Query() {
        return this._v5query;
    }

    public V5DataContainer getV5Container() {
        return this._v5DataContainer;
    }

    public SelectedCell getPostDrillParent() {
        return this._postDrillParent;
    }

    public Element getLayoutNodeElement() {
        return this._drillLayoutNodeElement;
    }

    public String getOriginalRDI() {
        return this._originalRDI;
    }

    public static boolean hasBreadCrumb(Element layoutNode) {
        return V5SpecHelper.getXMLAttribute(layoutNode, "RAP_drillBreadCrumb", true) != null;
    }

    public boolean hasSiblings(boolean bIsChart) {
        List siblings = null;
        if (bIsChart) {
            if (this._v5DataContainer instanceof V5VizChart) {
                if ("vizCategoryDataItem".equals(this._drillLayoutNodeElement.getName())) {
                    siblings = XMLUtility.selectNodes(this._drillLayoutNodeElement, V5X.selectPrecedingSibling("vizCategoryDataItem") + "|" + V5X.selectFollowingSibling("vizCategoryDataItem"));
                }
            } else {
                Element chartNode = V5SpecHelper.getAncestor(this._drillLayoutNodeElement, "chartNode");
                if (chartNode == null) {
                    return false;
                }
                siblings = this.getSiblings(chartNode, "chartNode", "chartNodeMember");
            }
        } else {
            Element crosstabNode = V5SpecHelper.getAncestor(this._drillLayoutNodeElement, "crosstabNode");
            if (crosstabNode == null) {
                return false;
            }
            siblings = this.getSiblings(crosstabNode, "crosstabNode", "crosstabNodeMember");
        }
        return siblings != null && siblings.size() > 0;
    }

    private List<Element> getSiblings(Element node, String nodeType, String nodeMemberType) {
        List siblings = XMLUtility.selectNodes(node, V5X.selectPrecedingSibling(nodeType) + "|" + V5X.selectFollowingSibling(nodeType));
        if (siblings == null || siblings.size() == 0) {
            siblings = XMLUtility.selectNodes(this._drillLayoutNodeElement, V5X.selectPrecedingSibling(nodeMemberType) + "|" + V5X.selectFollowingSibling(nodeMemberType));
        }
        return siblings;
    }
}

