/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.CSSHelper;
import com.cognos.rap.actions.v5spechelpers.IV5PageAdornment;
import com.cognos.rap.actions.v5spechelpers.V5TableHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPMessageManager;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.cognos.i18n.util.Bidi;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class InfoBarAdornment
implements IV5PageAdornment {
    protected Element m_parameterValues = null;
    private static final String _infoBar = "infoBar";
    private static final String _space = " ";
    private static final String _sort = "sort";
    private static final String _in_range = "in_range";
    private static final String _type = "type";
    private static final String _values = "values";
    private static final String _min = "min";
    private static final String _max = "max";
    private static final String _ReportInfo = "ReportInfo";
    private static final String _ParameterValues = "ParameterValues";
    private static final String _container = "container";
    private static final String _item = "item";
    private static final String _label = "label";
    private static final String _labels = "labels";
    private static final String _itemLabel = "itemLabel";
    private static final String _notIn = "notIn";
    private static final String _range = "range";
    private static final String _notRange = "notRange";
    private static final String _lessThan = "lessThan";
    private static final String _lessThanEqual = "lessThanEqual";
    private static final String _greaterThan = "greaterThan";
    private static final String _greaterThanEqual = "greaterThanEqual";
    private static final String _in = "in";
    private static final String _valuesOf = "valuesOf";
    private static final String _byItems = "byItems";
    private static final String _order = "order";
    private static final String _name = "name";
    private static final String _value = "value";
    private static final String _controlType = "controlType";
    private static final String _checkbox = "checkbox";
    protected static final String _filter = "filter";
    protected static final String _sliders = "sliders";
    protected static final String _lockedFilters = "lockedFilters";
    protected static final String _pvs = "pvs";
    protected static final String _itemSeparator = " - ";
    protected static final String _staticText = "staticText";
    private static final String _filterIconPath = "../rv/images/action_filter.png";
    private static final String _sortIconPath = "../rv/images/action_sort.png";
    private static final String _sortIconPathRtl = "../rv/images/action_sort_rtl.png";
    private static final String _promptImage = "../rv/images/action_filter.png";
    private static final String _sliderFilterImage = "../rv/images/infobar_slider.gif";
    private static final String _selectValueFilterImage = "../rv/images/infobar_select.gif";
    private static final String _adhocFilterImage = "../rv/images/action_filter.png";
    private boolean _forAnnotationInfoBar = false;
    private JSONArray m_reportInfoContainers;
    private static final String Style_detailHeaderItem = CSSHelper.concat("font-weight:bold", "color: #808080");
    private HashSet<String> sliderAutoParameterNames = new HashSet();

    @Override
    public boolean canAdd(Element actionArguments) throws ActionException {
        this.setReportInfoContainers(actionArguments);
        if (this.m_reportInfoContainers == null) {
            return false;
        }
        String addInfoBar = actionArguments.attributeValue(_infoBar);
        return "true".equals(addInfoBar);
    }

    @Override
    public void add(Document v5Report, Element actionArguments, String locale) throws ActionException {
        for (JSONObject reportInfoItem : this.m_reportInfoContainers) {
            boolean isSingleton;
            String displayTypeId = (String)reportInfoItem.get((Object)"displayTypeId");
            boolean bl = isSingleton = "singleton".equals(displayTypeId);
            if (isSingleton && !reportInfoItem.containsKey((Object)_sliders) && !reportInfoItem.containsKey((Object)_filter)) continue;
            this.buildParameterValuesSpec(actionArguments);
            if (!reportInfoItem.containsKey((Object)_sliders) && !reportInfoItem.containsKey((Object)_sort) && !reportInfoItem.containsKey((Object)_filter) && !reportInfoItem.containsKey((Object)_lockedFilters) && !this.hasNonSliderParameterValueItems()) continue;
            String layoutContainer = (String)reportInfoItem.get((Object)_container);
            Element layoutsElement = V5X.selectSingleNode(v5Report.getRootElement(), "//V5X//CHILD", "layouts");
            Element layoutItem = V5X.selectSingleNode(layoutsElement, "//V5X//CHILDATTR", _name, layoutContainer);
            if (layoutItem == null) continue;
            Element layoutItemParent = layoutItem.getParent();
            List layoutItemSiblings = layoutItemParent.elements();
            int index = layoutItemSiblings.indexOf(layoutItem);
            if ("layoutComponentOverride".equals(layoutItemParent.getName())) {
                Element block = DocumentHelper.createElement((QName)new QName("block", layoutItemParent.getNamespace()));
                layoutItemSiblings.add(index, block);
                Element blockContents = block.addElement("contents");
                this.renderInfoBarDetails(blockContents, reportInfoItem, locale);
                layoutItem.detach();
                blockContents.add(layoutItem);
                continue;
            }
            Element table = this.renderInfoBarDetails(v5Report.getRootElement(), reportInfoItem, locale);
            table.detach();
            layoutItemSiblings.add(index, table);
            table.add(layoutItemParent.getNamespace());
        }
    }

    protected Iterator getParameterValuesIterator() {
        return this.m_parameterValues.elementIterator();
    }

    private void buildParameterValuesSpec(Element actionArguments) {
        Document paramterValuesDocument;
        Element parameterValuesXmlSpec;
        if (this.m_parameterValues == null && (parameterValuesXmlSpec = actionArguments.element(_ParameterValues)) != null && (paramterValuesDocument = XMLUtility.createXMLDocument(parameterValuesXmlSpec.getText())) != null && paramterValuesDocument.getRootElement() != null) {
            this.m_parameterValues = paramterValuesDocument.getRootElement();
        }
        if (this.m_parameterValues == null) {
            this.m_parameterValues = DocumentHelper.createElement((String)_pvs);
        }
    }

    private Element renderInfoBarDetails(Element rootNode, JSONObject reportInfoItem, String locale) {
        Element table = V5TableHelper.addTable(rootNode, "");
        this.addFilteredItemsDetails(table, reportInfoItem, locale);
        this.addSortDetails(table, reportInfoItem, locale);
        return table;
    }

    private void addFilteredItemsDetails(Element parent, JSONObject reportInfoItem, String locale) {
        if (reportInfoItem.containsKey((Object)_sliders) || reportInfoItem.containsKey((Object)_filter) || reportInfoItem.containsKey((Object)_lockedFilters) || this.hasNonSliderParameterValueItems()) {
            Element tr = V5TableHelper.addRow(parent, "");
            Element td = V5TableHelper.addColumn(tr, "");
            Element table = V5TableHelper.addTable(td, "border: none");
            V5TableHelper.addXMLAttribute(table, "cellpadding", "0px");
            V5TableHelper.addXMLAttribute(table, "cellspacing", "0");
            tr = V5TableHelper.addRow(table, "");
            td = V5TableHelper.addColumn(tr, "vertical-align:top");
            V5TableHelper.addImage(td, "../rv/images/action_filter.png", "");
            td = V5TableHelper.addColumn(tr, "vertical-align:top");
            table = V5TableHelper.addTable(td, "");
            tr = V5TableHelper.addRow(table, "");
            td = V5TableHelper.addColumn(tr, "white-space:nowrap");
            V5TableHelper.addText(td, RAPMessageManager.convert("IDS_JS_FILTER_CONDITIONS", locale), Style_detailHeaderItem);
            this.cacheSliderAutoParameterNames(reportInfoItem, locale);
            this.processParameterValueItems(table, locale);
            this.processLockedFilterItems(table, reportInfoItem);
            this.processSliderItems(table, reportInfoItem, locale);
            this.processFilterItems(table, reportInfoItem, locale);
        }
    }

    protected void processLockedFilterItems(Element parent, JSONObject reportInfoItem) {
        JSONArray lockedFilters = (JSONArray)reportInfoItem.get((Object)_lockedFilters);
        if (lockedFilters != null) {
            for (JSONObject lockedFilter : lockedFilters) {
                String staticText = (String)lockedFilter.get((Object)_staticText);
                if (staticText == null) continue;
                Element tr = V5TableHelper.addRow(parent, "");
                Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
                V5TableHelper.addText(td, staticText, "");
            }
        }
    }

    protected void processParameterValueItems(Element parent, String locale) {
        Iterator parameterValueIterator = this.getParameterValuesIterator();
        while (parameterValueIterator.hasNext()) {
            Element parameterValueNode = (Element)parameterValueIterator.next();
            Element name = parameterValueNode.element(_name);
            if (this.sliderAutoParameterNames.contains(name.getText()) || name.getText().startsWith("BusinessInsight.")) continue;
            Element tr = V5TableHelper.addRow(parent, "");
            Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
            Element value = parameterValueNode.element(_value);
            if (this._forAnnotationInfoBar) {
                String valuesInString = value.getText();
                String nameInString = name.getText() + RAPMessageManager.convert("IDS_JS_COLON", locale) + _space;
                this.addNameValueWithIcon(tr, td, "../rv/images/action_filter.png", nameInString, valuesInString);
                continue;
            }
            String text = name.getText() + RAPMessageManager.convert("IDS_JS_COLON", locale) + _space + value.getText();
            V5TableHelper.addText(td, text, "");
        }
    }

    protected boolean hasNonSliderParameterValueItems() {
        Iterator parameterValueIterator = this.getParameterValuesIterator();
        while (parameterValueIterator.hasNext()) {
            Element parameterValueNode = (Element)parameterValueIterator.next();
            Element name = parameterValueNode.element(_name);
            if (this.sliderAutoParameterNames.contains(name.getText()) || name.getText().startsWith("BusinessInsight.")) continue;
            return true;
        }
        return false;
    }

    private void cacheSliderAutoParameterNames(JSONObject reportInfoItem, String locale) {
        JSONArray sliders = (JSONArray)reportInfoItem.get((Object)_sliders);
        if (sliders != null) {
            for (int i = 0; i < sliders.size(); ++i) {
                JSONObject sliderItem = (JSONObject)sliders.get(i);
                this.sliderAutoParameterNames.add("BusinessInsight." + (String)sliderItem.get((Object)_name));
            }
        }
    }

    protected void processSliderItems(Element parent, JSONObject reportInfoItem, String locale) {
        JSONArray sliders = (JSONArray)reportInfoItem.get((Object)_sliders);
        if (sliders != null) {
            Iterator iterator = sliders.iterator();
            while (iterator.hasNext()) {
                Element tr = V5TableHelper.addRow(parent, "");
                Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
                JSONObject sliderItem = (JSONObject)iterator.next();
                String filterText = "";
                String name = (String)(sliderItem.get((Object)_label) != null ? sliderItem.get((Object)_label) : sliderItem.get((Object)_name)) + RAPMessageManager.convert("IDS_JS_COLON", locale) + _space;
                JSONArray values = (JSONArray)sliderItem.get((Object)_values);
                String valuesInString = null;
                if (values != null) {
                    valuesInString = this.processFilterOperatorItems(values, locale);
                } else {
                    String type = (String)sliderItem.get((Object)_type);
                    if (type != null && type.equals(_in_range)) {
                        String maximum;
                        String minimum = (String)sliderItem.get((Object)_min);
                        valuesInString = minimum.equals(maximum = (String)sliderItem.get((Object)_max)) ? _space + minimum : RAPMessageManager.convert("IDS_JS_INFOBAR_BETWEEN_TEXT", locale, new Object[]{minimum, maximum});
                    }
                }
                if (this._forAnnotationInfoBar) {
                    String controlType = (String)sliderItem.get((Object)_controlType);
                    String imagePath = _checkbox.equals(controlType) ? _selectValueFilterImage : _sliderFilterImage;
                    this.addNameValueWithIcon(tr, td, imagePath, name, valuesInString);
                    continue;
                }
                filterText = name + valuesInString;
                V5TableHelper.addText(td, filterText, "");
            }
        }
    }

    protected void processFilterItems(Element parent, JSONObject reportInfoItem, String locale) {
        JSONArray filters = (JSONArray)reportInfoItem.get((Object)_filter);
        if (filters != null) {
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                Element tr = V5TableHelper.addRow(parent, "");
                Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
                JSONObject filterItem = (JSONObject)iterator.next();
                String filterItemText = (String)filterItem.get((Object)_itemLabel);
                if (filterItemText == null) {
                    filterItemText = (String)filterItem.get((Object)_item);
                }
                if (this._forAnnotationInfoBar) {
                    String valuesInString = this.processFilterOperator(filterItem, locale);
                    this.addNameValueWithIcon(tr, td, "../rv/images/action_filter.png", filterItemText, valuesInString);
                    continue;
                }
                String filterText = filterItemText + this.processFilterOperator(filterItem, locale);
                V5TableHelper.addText(td, filterText, "");
            }
        }
    }

    private String processFilterOperator(JSONObject filterItem, String locale) {
        StringBuilder filterOperatorText = new StringBuilder("");
        if (filterItem.containsKey((Object)_in)) {
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_INFOBAR_INCLUDE_TEXT", locale, new Object[]{this.processFilterOperatorItems((JSONArray)filterItem.get((Object)_in), locale)}));
        } else if (filterItem.containsKey((Object)_notIn)) {
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_INFOBAR_EXCLUDE_TEXT", locale, new Object[]{this.processFilterOperatorItems((JSONArray)filterItem.get((Object)_notIn), locale)}));
        } else if (filterItem.containsKey((Object)_range) || filterItem.containsKey((Object)_notRange)) {
            String operatorText = filterItem.containsKey((Object)_range) ? "IDS_JS_INFOBAR_BETWEEN_TEXT" : "IDS_JS_INFOBAR_NOT_BETWEEN_TEXT";
            JSONArray array = filterItem.containsKey((Object)_range) ? (JSONArray)filterItem.get((Object)_range) : (JSONArray)filterItem.get((Object)_notRange);
            for (int index = 0; index < array.size(); ++index) {
                JSONObject range = (JSONObject)array.get(index);
                String fromValue = (String)range.get((Object)"from");
                String toValue = (String)range.get((Object)"to");
                filterOperatorText.append(_space).append(RAPMessageManager.convert(operatorText, locale, new Object[]{fromValue, toValue}));
            }
        } else if (filterItem.containsKey((Object)_lessThan)) {
            String lessThanValue = (String)filterItem.get((Object)_lessThan);
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_FILTER_LESS_THAN", locale)).append(_space).append(lessThanValue);
        } else if (filterItem.containsKey((Object)_lessThanEqual)) {
            String lessThanValue = (String)filterItem.get((Object)_lessThanEqual);
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_FILTER_LESS_THAN_EQUAL", locale)).append(_space).append(lessThanValue);
        } else if (filterItem.containsKey((Object)_greaterThan)) {
            String greaterThanValue = (String)filterItem.get((Object)_greaterThan);
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_FILTER_GREATER_THAN", locale)).append(_space).append(greaterThanValue);
        } else if (filterItem.containsKey((Object)_greaterThanEqual)) {
            String greaterThanValue = (String)filterItem.get((Object)_greaterThanEqual);
            filterOperatorText.append(_space).append(RAPMessageManager.convert("IDS_JS_FILTER_GREATER_THAN_EQUAL", locale)).append(_space).append(greaterThanValue);
        }
        return filterOperatorText.toString();
    }

    private String processFilterOperatorItems(JSONArray filterOperatorItems, String locale) {
        String filterOperatorItemsText = "";
        int size = filterOperatorItems.size();
        for (int index = 0; index < size; ++index) {
            if (index != 0) {
                if (size != 2) {
                    filterOperatorItemsText = filterOperatorItemsText + RAPMessageManager.convert("IDS_JS_COMMA", locale);
                }
                filterOperatorItemsText = filterOperatorItemsText + _space;
                if (index + 1 == size) {
                    filterOperatorItemsText = filterOperatorItemsText + RAPMessageManager.convert("IDS_JS_INFOBAR_AND_TEXT", locale) + _space;
                }
            }
            if ((filterOperatorItemsText = filterOperatorItemsText + (String)filterOperatorItems.get(index)).length() <= 100) continue;
            filterOperatorItemsText = filterOperatorItemsText.substring(0, 100);
            filterOperatorItemsText = filterOperatorItemsText + RAPMessageManager.convert("IDS_JS_ELIPSES", locale);
            break;
        }
        return filterOperatorItemsText;
    }

    private void addSortDetails(Element parent, JSONObject reportInfoItem, String locale) {
        if (reportInfoItem.containsKey((Object)_sort)) {
            Element tr = V5TableHelper.addRow(parent, "");
            Element td = V5TableHelper.addColumn(tr, "");
            Element table = V5TableHelper.addTable(td, "border: none");
            V5TableHelper.addXMLAttribute(table, "cellpadding", "0px");
            V5TableHelper.addXMLAttribute(table, "cellspacing", "0");
            tr = V5TableHelper.addRow(table, "");
            td = V5TableHelper.addColumn(tr, "vertical-align:top");
            if (Bidi.isLocaleRTL((String)locale)) {
                V5TableHelper.addImage(td, _sortIconPathRtl, "");
            } else {
                V5TableHelper.addImage(td, _sortIconPath, "");
            }
            td = V5TableHelper.addColumn(tr, "vertical-align:top");
            table = V5TableHelper.addTable(td, "");
            tr = V5TableHelper.addRow(table, "");
            td = V5TableHelper.addColumn(tr, "white-space:nowrap");
            V5TableHelper.addText(td, RAPMessageManager.convert("IDS_JS_SORTING_CONDITIONS", locale), Style_detailHeaderItem);
            this.buildSortDetailsLabel(table, reportInfoItem, locale);
        }
    }

    private void buildSortDetailsLabel(Element parent, JSONObject reportInfoItem, String locale) {
        if (reportInfoItem.containsKey((Object)_sort)) {
            JSONArray sorts = (JSONArray)reportInfoItem.get((Object)_sort);
            for (JSONObject sortInfo : sorts) {
                String sortInfoLabels = null;
                if (sortInfo.containsKey((Object)_labels)) {
                    sortInfoLabels = (String)sortInfo.get((Object)_labels);
                }
                Object sortInfoValues = null;
                if (sortInfo.containsKey((Object)_valuesOf)) {
                    sortInfoValues = sortInfo.get((Object)_valuesOf);
                }
                String sortOrder = (String)sortInfo.get((Object)_order);
                if (sortInfoLabels != null || sortInfoValues instanceof String) {
                    if (sortInfo.containsKey((Object)_itemLabel)) {
                        sortInfoLabels = (String)sortInfo.get((Object)_itemLabel);
                    }
                    StringBuilder itemLabel = new StringBuilder();
                    itemLabel.append(sortInfoLabels != null ? sortInfoLabels : (String)sortInfoValues);
                    itemLabel.append(" : ");
                    JSONArray sortedByItems = (JSONArray)sortInfo.get((Object)_byItems);
                    if (sortedByItems != null) {
                        for (int byItemsIdx = 0; byItemsIdx < sortedByItems.size(); ++byItemsIdx) {
                            if (byItemsIdx > 0) {
                                itemLabel.append(_itemSeparator);
                            }
                            JSONObject sortedByItem = (JSONObject)sortedByItems.get(byItemsIdx);
                            itemLabel.append(sortedByItem.get((Object)_item));
                            itemLabel.append(", ");
                            if ("ascending".equals(sortedByItem.get((Object)_order))) {
                                itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_ASCENDING_ORDER", locale));
                                continue;
                            }
                            itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_DESCENDING_ORDER", locale));
                        }
                    } else {
                        if (sortInfoValues instanceof String) {
                            itemLabel.append(RAPMessageManager.convert("IDS_JS_SORTED_BY_VALUE", locale));
                        } else {
                            itemLabel.append(RAPMessageManager.convert("IDS_JS_SORTED_BY_LABEL", locale));
                        }
                        itemLabel.append(", ");
                        if ("ascending".equals(sortOrder)) {
                            itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_ASCENDING_ORDER", locale));
                        } else {
                            itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_DESCENDING_ORDER", locale));
                        }
                    }
                    Element tr = V5TableHelper.addRow(parent, "");
                    Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
                    V5TableHelper.addText(td, itemLabel.toString(), "");
                    continue;
                }
                if (!(sortInfoValues instanceof JSONArray)) continue;
                JSONArray sortValuesArray = (JSONArray)sortInfoValues;
                Iterator sortValuesIterator = sortValuesArray.iterator();
                String existingitemLabel = (String)sortInfo.get((Object)_itemLabel);
                StringBuilder itemLabel = new StringBuilder();
                if (existingitemLabel == null || existingitemLabel.length() == 0) {
                    while (sortValuesIterator.hasNext()) {
                        JSONObject sortItem = (JSONObject)sortValuesIterator.next();
                        itemLabel.append(_itemSeparator);
                        itemLabel.append(sortItem.get((Object)_item));
                    }
                    if (itemLabel.length() > 0) {
                        itemLabel.delete(0, 3);
                    }
                } else {
                    itemLabel.append(existingitemLabel);
                }
                itemLabel.append(" : ");
                itemLabel.append(RAPMessageManager.convert("IDS_JS_SORTED_BY_VALUE", locale));
                itemLabel.append(", ");
                if ("ascending".equals(sortOrder)) {
                    itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_ASCENDING_ORDER", locale));
                } else {
                    itemLabel.append(RAPMessageManager.convert("IDS_JS_SORT_DESCENDING_ORDER", locale));
                }
                Element tr = V5TableHelper.addRow(parent, "");
                Element td = V5TableHelper.addColumn(tr, "white-space:nowrap");
                V5TableHelper.addText(td, itemLabel.toString(), "");
            }
        }
    }

    public void forAnnotationInfoBar(boolean flag) {
        this._forAnnotationInfoBar = flag;
    }

    private void addNameValueWithIcon(Element tr, Element td, String image, String name, String value) {
        V5TableHelper.addImage(td, image, "margin:0px;vertical-align:middle");
        Element newTd = V5TableHelper.addColumn(tr, "white-space:nowrap");
        V5TableHelper.addText(newTd, name, "font-weight:bold;font-size:10pt;color:#666666;");
        V5TableHelper.addText(newTd, value, "font-size:10pt;color:#666666;");
    }

    private void setReportInfoContainers(Element actionArguments) throws ActionException {
        Element reportInfoNode = actionArguments.element(_ReportInfo);
        if (reportInfoNode == null) {
            return;
        }
        String reportInfoArgument = reportInfoNode.getText();
        try {
            JSONObject reportInfoObject = (JSONObject)JSON.parse((String)reportInfoArgument);
            this.m_reportInfoContainers = (JSONArray)reportInfoObject.get((Object)"containers");
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }
}

