/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DiscreteValue;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.RAPMessageManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MeasureFacetHelper {
    private Element _measureOnEdgeNodeParent = null;
    private Element _defaultMeasureLayoutNode = null;
    private Element _referenceMeasureLayoutNodeMember = null;
    private Element _referenceMeasureDataItem = null;
    private HashMap<String, Element> _oldMeasureLayoutNodes = new HashMap();
    private boolean _newMeasuresAddedToLayout = false;
    Renderer _renderer = null;
    ActionEnv _env = null;

    public MeasureFacetHelper(ActionEnv env) {
        this._env = env;
    }

    public boolean initialize(String dimensionName, V5DataContainer container) {
        this._newMeasuresAddedToLayout = false;
        List<Element> containerNodes = container.collectNodes();
        V5Query containerQuery = container.getV5Query();
        if (!this.canApplyMeasureFacet(container, dimensionName)) {
            return false;
        }
        this._renderer = new Renderer(this._env, container);
        for (Element containerNodeMember : containerNodes) {
            String refDataItem = containerNodeMember.attributeValue("refDataItem");
            if (refDataItem == null || this.initializeMeasureOnEdge(container, containerNodeMember, refDataItem)) continue;
            this.initializeDefaultMeasure(container, containerQuery, containerNodeMember, refDataItem);
        }
        return true;
    }

    public boolean canApplyMeasureFacet(V5DataContainer container, String dimensionName) {
        Element anyMeasure = V5X.selectSingleNode(container.getV5Query().getQueryElement(), "//V5X//CHILD", "selection", "dataItemMeasure", "//V5X//OR", "dataItemCalculatedMeasure");
        return anyMeasure != null && dimensionName.equals(V5QueryItem.getDimensionName(anyMeasure));
    }

    public boolean isMeasureOnEdgeType() {
        return this._referenceMeasureLayoutNodeMember != null && this._referenceMeasureDataItem != null;
    }

    private boolean initializeMeasureOnEdge(V5DataContainer container, Element containerNodeMember, String refDataItem) {
        if ("crosstabNodeMember".equals(containerNodeMember.getName()) || "chartNodeMember".equals(containerNodeMember.getName())) {
            Element relatedQueryItem = container.getV5Query().findItem(refDataItem);
            if (V5QueryItem.isHighLevelMeasure(relatedQueryItem)) {
                Element oldMeasure;
                Element nodeParent;
                this._renderer.initializeFromLayout(container, containerNodeMember, "Render as trends_EdgeMeasure", "metricTrend", refDataItem);
                this._renderer.initializeFromLayout(container, containerNodeMember, "Render as traffic light_EdgeMeasure", "trafficLight", refDataItem);
                boolean isCrosstab = "crosstab".equals(container.getType());
                Element node = V5SpecHelper.getAncestor(containerNodeMember, isCrosstab ? "crosstabNode" : "chartNode");
                Element element = nodeParent = node == null ? null : node.getParent();
                if (this._measureOnEdgeNodeParent == null) {
                    this._measureOnEdgeNodeParent = nodeParent;
                } else if (nodeParent != this._measureOnEdgeNodeParent) {
                    return true;
                }
                if (this._referenceMeasureDataItem == null) {
                    this._referenceMeasureLayoutNodeMember = containerNodeMember;
                    this._referenceMeasureDataItem = relatedQueryItem;
                }
                if ((oldMeasure = container.getV5Query().findItem(refDataItem)) != null) {
                    DynamicDataFilter.removeFilterTags(oldMeasure);
                }
                this._oldMeasureLayoutNodes.put(refDataItem, node);
            }
            return true;
        }
        return false;
    }

    public Element addUpdateMeasureOnEdge(V5DataContainer container, DiscreteValue value) {
        if (value.getMun() == null || value.getMun().length() == 0) {
            return null;
        }
        String facetMeasureName = value.getCaption();
        Element measureDataItem = container.getV5Query().findItem(facetMeasureName);
        if (!this._newMeasuresAddedToLayout) {
            for (Element oldMeasureLayoutNode : this._oldMeasureLayoutNodes.values()) {
                oldMeasureLayoutNode.detach();
            }
        }
        if (measureDataItem != null && this._oldMeasureLayoutNodes.get(facetMeasureName) != null) {
            this._measureOnEdgeNodeParent.add(this._oldMeasureLayoutNodes.get(facetMeasureName));
        } else {
            measureDataItem = this.addNewMeasureOnEdge(container, value);
        }
        this._newMeasuresAddedToLayout = true;
        return measureDataItem;
    }

    private Element addNewMeasureOnEdge(V5DataContainer container, DiscreteValue value) {
        Element cnms;
        Element cn;
        Element cnm = null;
        Element textItem = null;
        String rdi = value.getCaption();
        if (container instanceof V5Crosstab) {
            cn = this._measureOnEdgeNodeParent.addElement("crosstabNode");
            cnms = cn.addElement("crosstabNodeMembers");
            cnm = cnms.addElement("crosstabNodeMember");
            textItem = cnm.addElement("contents").addElement("textItem");
            cnm.addAttribute("refDataItem", rdi);
            cnm.addAttribute("edgeLocation", ((V5Crosstab)container).nextFreeEdge());
        } else {
            cn = this._measureOnEdgeNodeParent.addElement("chartNode");
            cnms = cn.addElement("chartNodeMembers");
            cnm = cnms.addElement("chartNodeMember");
            textItem = cnm.addElement("chartContents").addElement("chartTextItem");
            cnm.addAttribute("refDataItem", rdi);
        }
        Element origStyle = this._referenceMeasureLayoutNodeMember.element("style");
        if (origStyle != null) {
            Element style = this._referenceMeasureLayoutNodeMember.element("style").createCopy();
            cnm.add(style);
        }
        textItem.addElement("dataSource").addElement("memberCaption");
        Element newMeasure = this.addUpdateDataItemMeasure(container, value);
        Renderer renderer = new Renderer(this._env, container);
        renderer.render(cnm, rdi);
        return newMeasure;
    }

    public boolean isDefaultMeasureType() {
        return this._defaultMeasureLayoutNode != null && this._referenceMeasureLayoutNodeMember == null && this._referenceMeasureDataItem != null;
    }

    private boolean initializeDefaultMeasure(V5DataContainer container, V5Query containerQuery, Element containerNode, String refDataItem) {
        if (!"crosstabNodeMember".equals(containerNode.getName()) && !"chartNodeMember".equals(containerNode.getName())) {
            Element relatedQueryItem = containerQuery.findItem(refDataItem);
            if (V5QueryItem.isHighLevelMeasure(relatedQueryItem)) {
                this._renderer.initializeFromLayout(container, container._container, "Render as trends", "metricTrend", refDataItem);
                this._renderer.initializeFromLayout(container, container._container, "Render as traffic light", "trafficLight", refDataItem);
                this._defaultMeasureLayoutNode = containerNode;
                this._referenceMeasureDataItem = relatedQueryItem;
                if (relatedQueryItem != null) {
                    DynamicDataFilter.removeFilterTags(relatedQueryItem);
                }
            }
            return true;
        }
        return false;
    }

    public Element addUpdateDefaultMeasure(V5DataContainer container, DiscreteValue value) {
        if (this._defaultMeasureLayoutNode != null) {
            Element measureDataItem = this.addUpdateDataItemMeasure(container, value);
            this._defaultMeasureLayoutNode.addAttribute("refDataItem", measureDataItem.attributeValue("name"));
            this._newMeasuresAddedToLayout = true;
            Renderer renderer = new Renderer(this._env, container);
            renderer.renderAsDefaultMeasure(measureDataItem.attributeValue("name"));
            return measureDataItem;
        }
        return null;
    }

    public boolean getNewMeasuresAddedToLayout() {
        return this._newMeasuresAddedToLayout;
    }

    private Element addUpdateDataItemMeasure(V5DataContainer container, DiscreteValue value) {
        Element newMeasure = container.getV5Query().findItem(value.getCaption());
        if (newMeasure == null) {
            newMeasure = container.getV5Query().getItemList().addDataItemMeasure(value.getCaption(), value.getMun(), V5QueryItem.getDun(this._referenceMeasureDataItem));
        }
        return newMeasure;
    }

    public List<DiscreteValue> loadMeasuresAsDiscreteValues(V5Query v5Query, String sModelPath, String measureDimensionName) throws CognosServiceRequestException {
        JSONArray measures = v5Query.requestMeasures(sModelPath, measureDimensionName, true);
        ArrayList<DiscreteValue> returnValues = new ArrayList<DiscreteValue>();
        if (measures != null) {
            for (int i = 0; i < measures.size(); ++i) {
                JSONObject measure = (JSONObject)measures.get(i);
                returnValues.add(new DiscreteValue((String)measure.get((Object)"name"), "", (String)measure.get((Object)"_ref")));
            }
        }
        return returnValues;
    }

    public DiscreteValue loadMeasureAsDiscreteValue(V5Query v5Query, String sModelPath, String measureDimensionName, String measureName) throws CognosServiceRequestException {
        Element existingItem = v5Query.findItem(measureName);
        if (existingItem != null) {
            if ("dataItemMeasure".equals(existingItem.getName()) || "dataItemCalculatedMeasure".equals(existingItem.getName())) {
                String measureMUN = V5X.selectSingleNode(existingItem, "//V5X//CHILD", "dmMember", "MUN").getText();
                return new DiscreteValue(measureName, "", measureMUN);
            }
            return null;
        }
        JSONObject measure = v5Query.requestMeasure(sModelPath, measureDimensionName, measureName);
        return measure == null ? null : new DiscreteValue((String)measure.get((Object)"name"), "", (String)measure.get((Object)"_ref"));
    }

    public static boolean isMeasureFacetDimension(String dimensionName, Document reportToModify) {
        List measures = V5X.selectNodes(reportToModify, "//V5X//CHILD", "queries", "query", "selection", "dataItemMeasure", "//V5X//OR", "dataItemCalculatedMeasure");
        for (Element measure : measures) {
            if (!dimensionName.equals(V5QueryItem.getDimensionName(measure))) continue;
            return true;
        }
        return false;
    }

    class Renderer {
        private V5DataContainer _container = null;
        private ActionEnv _env = null;
        private static final String _rendererType_metricTrend = "metricTrend";
        private static final String _rendererType_trafficLight = "trafficLight";
        private static final String _trendsVariableDefaultMeasure = "Render as trends";
        private static final String _trafficLightVariableDefaultMeasure = "Render as traffic light";
        private static final String _trendsVariableName = "Render as trends_EdgeMeasure";
        private static final String _trafficLightVariableName = "Render as traffic light_EdgeMeasure";

        public Renderer(ActionEnv env, V5DataContainer container) {
            this._container = container;
            this._env = env;
        }

        private String getRendererXMLAttributeName(V5DataContainer container, String rdi) {
            return ("Renderer_" + container.getRefQuery() + "_" + rdi).replace("\"", "&quot;");
        }

        private String getRendererXMLAttribute(V5DataContainer container, String rdi) {
            return V5SpecHelper.getXMLAttribute(container.getContainerElement().getDocument(), this.getRendererXMLAttributeName(container, rdi));
        }

        private void setRendererXMLAttribute(V5DataContainer container, String rdi, String value) {
            V5SpecHelper.setXMLAttribute(container.getContainerElement().getDocument(), this.getRendererXMLAttributeName(container, rdi), value);
        }

        protected void initializeFromLayout(V5DataContainer container, Element containerNode, String rendererName, String rendererType, String refDataItem) {
            List<Element> conditionalRenderList;
            if (this.getRendererXMLAttribute(container, refDataItem) == null && (conditionalRenderList = V5DataContainer.selectNodes(container.getContainerElement(), containerNode, "factCell", "//V5X//OR", "crosstabFactCell", "conditionalRender")) != null && conditionalRenderList.size() > 0) {
                for (Element conditionalRender : conditionalRenderList) {
                    if (!conditionalRender.attributeValue("refVariable").contains(rendererName)) continue;
                    this.setRendererXMLAttribute(container, refDataItem, rendererType);
                }
            }
        }

        protected void render(Element cnm, String rdi) {
            String renderer = this.getRendererXMLAttribute(this._container, rdi);
            if (renderer != null) {
                Element conditionRoot = DocumentHelper.makeElement((Branch)cnm, (String)"factCell");
                this.renderConditionals(conditionRoot, conditionRoot, renderer, false);
            }
        }

        private void renderConditionals(Element conditionRoot, Element textRoot, String renderer, boolean defaultMeasure) {
            Element CSS2;
            Element textRootContents;
            String locale = this._env.getLocale();
            String variableName = this.getVariableName(renderer, defaultMeasure);
            Element conditionRootContents = DocumentHelper.makeElement((Branch)conditionRoot, (String)"contents");
            Element element = textRootContents = conditionRoot == textRoot ? conditionRootContents : DocumentHelper.makeElement((Branch)textRoot, (String)"contents");
            if (_rendererType_metricTrend.equals(renderer)) {
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_metric_trend_down.gif", RAPMessageManager.convert("RAP_TREND_GETTING_WORSE", locale), variableName, "red");
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_metric_trend_even.gif", RAPMessageManager.convert("RAP_TREND_NOCHANGE", locale), variableName, "yellow");
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_metric_trend_up.gif", RAPMessageManager.convert("RAP_TREND_GETTING_BETTER", locale), variableName, "green");
                this.addConditionalCellValueText(textRootContents, variableName, "text");
                CSS2 = conditionRoot.addElement("style").addElement("CSS");
                CSS2.addAttribute("value", "text-align:center");
                this.addRenderVariable(variableName, false);
                if (defaultMeasure) {
                    this.addBlockConditionalRender(conditionRoot, variableName);
                }
            }
            if (_rendererType_trafficLight.equals(renderer)) {
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_poor_traffic.gif", RAPMessageManager.convert("RAP_TRAFFICLIGHT_POOR", locale), variableName, "red");
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_average_traffic.gif", RAPMessageManager.convert("RAP_TRAFFICLIGHT_AVERAGE", locale), variableName, "yellow");
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_excellent_traffic.gif", RAPMessageManager.convert("RAP_TRAFFICLIGHT_EXCELLENT", locale), variableName, "green");
                this.addConditionalImage(conditionRootContents, "../icd/feeds/images/icon_metrics_not_live.gif", RAPMessageManager.convert("RAP_TRAFFICLIGHT_MISSING", locale), variableName, "missing");
                this.addConditionalCellValueText(textRootContents, variableName, "text");
                CSS2 = conditionRoot.addElement("style").addElement("CSS");
                CSS2.addAttribute("value", "text-align:center");
                this.addRenderVariable(variableName, true);
                if (defaultMeasure) {
                    this.addBlockConditionalRender(conditionRoot, variableName);
                }
            }
        }

        protected void renderAsDefaultMeasure(String rdi) {
            this.removeActiveDefaultMeasureRenderer();
            String renderer = this.getRendererXMLAttribute(this._container, rdi);
            if (renderer != null) {
                Element factCell = DocumentHelper.makeElement((Branch)this._container.getContainerElement(), (String)"crosstabFactCell");
                Element imageBlock = DocumentHelper.makeElement((Branch)factCell, (String)"contents/block");
                this.renderConditionals(imageBlock, factCell, renderer, true);
            }
        }

        private void removeActiveDefaultMeasureRenderer() {
            List conditionalRenderBlocks = V5X.selectNodes(this._container.getContainerElement(), "//V5X//CHILD", "crosstabFactCell", "contents", "block", "conditionalRender");
            if (conditionalRenderBlocks == null) {
                return;
            }
            for (Element conditionalRenderBlock : conditionalRenderBlocks) {
                String conditionalBlockVariableName = conditionalRenderBlock.attributeValue("refVariable");
                if (!conditionalBlockVariableName.equals(_trendsVariableDefaultMeasure) && !conditionalBlockVariableName.equals(_trafficLightVariableDefaultMeasure)) continue;
                Element conditionalRenderText = V5X.selectSingleNode(conditionalRenderBlock.getParent().getParent(), "//V5X//CHILD", "textItem", "conditionalRender", "//V5X//ATTR", "refVariable", conditionalBlockVariableName);
                if (conditionalRenderText != null) {
                    conditionalRenderText.detach();
                }
                conditionalRenderBlock.getParent().detach();
                break;
            }
        }

        private void addBlockConditionalRender(Element imageBlock, String rendererName) {
            Element conditionalRender = imageBlock.addElement("conditionalRender");
            conditionalRender.addAttribute("refVariable", rendererName);
            this.addRenderFor(conditionalRender, "red");
            this.addRenderFor(conditionalRender, "yellow");
            this.addRenderFor(conditionalRender, "green");
            this.addRenderFor(conditionalRender, "missing");
            this.addRenderFor(conditionalRender, "text");
        }

        private void addRenderFor(Element conditionalRender, String refVariableValue) {
            Element renderFor = conditionalRender.addElement("renderFor");
            renderFor.addAttribute("refVariableValue", refVariableValue);
        }

        private String getVariableName(String renderer, boolean defaultMeasure) {
            if (defaultMeasure) {
                return _rendererType_metricTrend.equals(renderer) ? _trendsVariableDefaultMeasure : _trafficLightVariableDefaultMeasure;
            }
            return _rendererType_metricTrend.equals(renderer) ? _trendsVariableName : _trafficLightVariableName;
        }

        private void addRenderVariable(String renderVariableName, boolean renderMissingAsImage) {
            V5Variables variables = new V5Variables(this._container.getContainerElement().getDocument().getRootElement());
            String[] variableValues = new String[]{"red", "green", "yellow", "missing", "text"};
            String textAndMissingCases = renderMissingAsImage ? "if (ReportOutput()='CSV' or ReportOutput()='XML') then ('text') else if (cellValue() is missing) then ('missing') else " : "if (ReportOutput()='CSV' or ReportOutput()='XML' or cellValue() is missing) then ('text') else ";
            variables.addStringVariable(renderVariableName, textAndMissingCases + "if (cellValue() <= -0.5) then ('red') else " + "if (cellValue() > 0.5) then ('green') else ('yellow')", variableValues);
        }

        private void addConditionalImage(Element contents, String url, String altText, String refVariable, String refVariableValue) {
            Element image = contents.addElement("image");
            Element imageURL = image.addElement("dataSource").addElement("staticValue");
            imageURL.setText(url);
            Element imageAltText = image.addElement("alternateText").addElement("defaultText");
            imageAltText.setText(altText);
            Element imageConditionalRender = image.addElement("conditionalRender");
            imageConditionalRender.addAttribute("refVariable", refVariable);
            Element renderFor = imageConditionalRender.addElement("renderFor");
            renderFor.addAttribute("refVariableValue", refVariableValue);
        }

        private void addConditionalCellValueText(Element contents, String refVariable, String refVariableValue) {
            Element textItem = DocumentHelper.makeElement((Branch)contents, (String)"textItem");
            DocumentHelper.makeElement((Branch)textItem, (String)"dataSource/cellValue");
            Element textConditionalRender = textItem.addElement("conditionalRender");
            textConditionalRender.addAttribute("refVariable", refVariable);
            Element renderFor = textConditionalRender.addElement("renderFor");
            renderFor.addAttribute("refVariableValue", refVariableValue);
        }
    }
}

