/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5X;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class MemberSetsAndDrillBehaviors {
    private Document _report = null;
    private HashMap<String, Element> _memberSetToDrillUpBehavior = new HashMap();
    private HashMap<String, Element> _memberSetToDrillDownBehavior = new HashMap();

    public MemberSetsAndDrillBehaviors(Document report) {
        this._report = report;
    }

    public void initialize() {
        List memberSets = V5X.selectNodes(this._report.getRootElement(), "queries", "memberSet");
        for (Element memberSet : memberSets) {
            this._memberSetToDrillUpBehavior.put(memberSet.attributeValue("refDataItem"), null);
            this._memberSetToDrillDownBehavior.put(memberSet.attributeValue("refDataItem"), null);
        }
        List drillBehaviors = V5X.selectNodes(this._report.getRootElement(), "drillBehavior", "drillDataItemBehavior");
        for (Element drillBehavior : drillBehaviors) {
            this.initializeBehavior(drillBehavior, this._memberSetToDrillUpBehavior, "drillUpBehavior");
            this.initializeBehavior(drillBehavior, this._memberSetToDrillDownBehavior, "drillDownBehavior");
        }
    }

    private void initializeBehavior(Element drillBehavior, HashMap<String, Element> behaviorMap, String behaviorType) {
        String behaviourRdi = drillBehavior.attributeValue("refDataItem");
        if (behaviorMap.containsKey(drillBehavior.attributeValue("refDataItem"))) {
            Element behaviorSimpleType = V5X.selectSingleNode(drillBehavior, behaviorType, "drillSimpleType");
            if (behaviorSimpleType != null) {
                behaviorMap.put(behaviourRdi, behaviorSimpleType);
            } else {
                Element drillChangeBehavior = V5X.selectSingleNode(drillBehavior, behaviorType, "drillChange");
                behaviorMap.put(behaviourRdi, drillChangeBehavior);
            }
        }
    }

    public boolean hasMemberSet(String rdi) {
        return this._memberSetToDrillDownBehavior.containsKey(rdi) || this._memberSetToDrillUpBehavior.containsKey(rdi);
    }

    public String findBehaviorTypeForSet(String rdi) {
        Element drillDownBehavior = this._memberSetToDrillDownBehavior.get(rdi);
        if (drillDownBehavior != null) {
            if ("drillSimpleType".equals(drillDownBehavior.getName())) {
                return drillDownBehavior.attributeValue("type");
            }
            if ("drillChange".equals(drillDownBehavior.getName())) {
                return "drillChange";
            }
        }
        return null;
    }

    public String findUpBehaviorTypeForSet(String rdi) {
        Element drillUpBehavior = this._memberSetToDrillUpBehavior.get(rdi);
        if (drillUpBehavior != null) {
            if ("drillSimpleType".equals(drillUpBehavior.getName())) {
                return drillUpBehavior.attributeValue("type");
            }
            if ("drillChange".equals(drillUpBehavior.getName())) {
                return "drillChange";
            }
        }
        return null;
    }
}

