/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.DrillLayoutNode;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.RapServiceRequestManager;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class NewDrillRules {
    HashMap<String, Boolean> _rdiToIsSummaryMap = new HashMap();
    HashMap<String, Element> _rdiToNewQueryItemMap = new HashMap();
    public static HashSet<String> _DataItemSetType = new HashSet();
    public static HashSet<String> _DataItemSummaryType;
    DrillLayoutNode _drillLayoutNode;
    private boolean isDrillDown = false;
    private RapServiceRequestManager rapServiceManager;

    public NewDrillRules(boolean isDrillDown, RapServiceRequestManager rapServiceRequestManager) {
        this.isDrillDown = isDrillDown;
        this.rapServiceManager = rapServiceRequestManager;
    }

    public void setDrilledOnLayoutNode(DrillLayoutNode drilledOnLayoutNodeInfo) {
        this._drillLayoutNode = drilledOnLayoutNodeInfo;
    }

    boolean isDrillUp() {
        return !this.isDrillDown;
    }

    protected Element updateChartLayout(boolean bDrillUpToRoot, SelectedCell originalDrillUpSelectedCell) throws ActionException {
        DrillLayoutNode drillLayoutNode = this._drillLayoutNode;
        V5Query v5Query = drillLayoutNode.getV5Query();
        V5DataContainer v5DataContainer = drillLayoutNode.getV5Container();
        SelectedCell postDrillParent = drillLayoutNode.getPostDrillParent();
        Element layoutNodeToDrillOn = drillLayoutNode.getLayoutNodeElement();
        String hun = drillLayoutNode.getHUN();
        String dun = drillLayoutNode.getDUN();
        Element newDetailDataItem = null;
        boolean isDrillOnSingleDimensionNestedNode = drillLayoutNode.isDrillOnSingleDimensionNestedNode();
        if (this.isDrillUp() && isDrillOnSingleDimensionNestedNode) {
            newDetailDataItem = this.collectRelatedNodesForSingleDimensionNestingOnDrillUp(v5DataContainer, layoutNodeToDrillOn, originalDrillUpSelectedCell, v5Query, postDrillParent, bDrillUpToRoot);
        } else {
            if (isDrillOnSingleDimensionNestedNode) {
                this.collectRelatedNodesForSingleDimensionNestingOnDrillDown(v5DataContainer, postDrillParent, v5Query, layoutNodeToDrillOn);
            }
            List<Element> relatedSummaryNodes = drillLayoutNode.getRelatedSummaryLayoutNodeForChart(drillLayoutNode.getLayoutNodeElement(), drillLayoutNode.getQueryItem().attributeValue("name"));
            newDetailDataItem = this.createDetailElement(v5Query, postDrillParent, hun, dun, bDrillUpToRoot);
            DimensionalOperations.doPreUpdateLayoutOperations(v5DataContainer, layoutNodeToDrillOn, postDrillParent, newDetailDataItem);
            newDetailDataItem = this.addRDIToNewQueryItemMap(v5Query, layoutNodeToDrillOn, newDetailDataItem);
            if (!bDrillUpToRoot && relatedSummaryNodes != null && relatedSummaryNodes.size() > 0) {
                Element newSummaryDataItem = this.createNewSummaryDataItem(v5Query, newDetailDataItem, drillLayoutNode.getQueryItem(), postDrillParent);
                for (Element relatedSummaryNode : relatedSummaryNodes) {
                    this.collectRelatedSummaryInfo(v5DataContainer, v5Query, relatedSummaryNode, newSummaryDataItem, newDetailDataItem);
                }
            }
        }
        this.updateRDIs(v5Query, v5DataContainer);
        return newDetailDataItem;
    }

    protected Element updateCrosstabLayout(boolean bDrillUpToRoot, SelectedCell originalDrillUpSelectedCell) throws ActionException {
        DrillLayoutNode drillLayoutNode = this._drillLayoutNode;
        V5Query v5Query = drillLayoutNode.getV5Query();
        V5DataContainer v5DataContainer = drillLayoutNode.getV5Container();
        SelectedCell postDrillParent = drillLayoutNode.getPostDrillParent();
        Element layoutNodeToDrillOn = drillLayoutNode.getLayoutNodeElement();
        String hun = drillLayoutNode.getHUN();
        String dun = drillLayoutNode.getDUN();
        if (drillLayoutNode.isSummary()) {
            Element relatedDetailDataItem = null;
            Element relatedDetailLayoutNode = drillLayoutNode.getRelatedDetailLayoutNodeForCrosstab();
            if (relatedDetailLayoutNode != null) {
                relatedDetailDataItem = this.createDetailElement(v5Query, postDrillParent, hun, dun, bDrillUpToRoot);
                this.addRDIToNewQueryItemMap(v5Query, relatedDetailLayoutNode, relatedDetailDataItem);
            }
            if (drillLayoutNode.isDrillOnSingleDimensionNestedNode()) {
                this.collectRelatedNodesForSingleDimensionNestingOnDrillUp(v5DataContainer, layoutNodeToDrillOn, originalDrillUpSelectedCell, v5Query, postDrillParent, bDrillUpToRoot);
            } else {
                Element newSummaryDataItem = this.createSummaryElement(v5Query, postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
                this.addRDIToNewQueryItemMap(v5Query, layoutNodeToDrillOn, newSummaryDataItem);
            }
            this.updateRDIs(v5Query, v5DataContainer);
            return relatedDetailDataItem;
        }
        Element newDetailDataItem = null;
        boolean isDrillOnSingleDimensionNestedNode = drillLayoutNode.isDrillOnSingleDimensionNestedNode();
        if (this.isDrillUp() && isDrillOnSingleDimensionNestedNode) {
            newDetailDataItem = this.collectRelatedNodesForSingleDimensionNestingOnDrillUp(v5DataContainer, layoutNodeToDrillOn, originalDrillUpSelectedCell, v5Query, postDrillParent, bDrillUpToRoot);
        } else {
            Element relatedSummaryNode = drillLayoutNode.getRelatedSummaryLayoutNodeForCrosstab(layoutNodeToDrillOn, drillLayoutNode.getQueryItem().attributeValue("name"));
            if (isDrillOnSingleDimensionNestedNode) {
                this.collectRelatedNodesForSingleDimensionNestingOnDrillDown(v5DataContainer, postDrillParent, v5Query, layoutNodeToDrillOn);
            }
            newDetailDataItem = this.createDetailElement(v5Query, postDrillParent, hun, dun, bDrillUpToRoot);
            DimensionalOperations.doPreUpdateLayoutOperations(v5DataContainer, layoutNodeToDrillOn, postDrillParent, newDetailDataItem);
            this.addRDIToNewQueryItemMap(v5Query, layoutNodeToDrillOn, newDetailDataItem);
            if (!bDrillUpToRoot && relatedSummaryNode != null) {
                Element newSummaryDataItem = this.createNewSummaryDataItem(v5Query, newDetailDataItem, drillLayoutNode.getQueryItem(), postDrillParent);
                this.collectRelatedSummaryInfo(v5DataContainer, v5Query, relatedSummaryNode, newSummaryDataItem, newDetailDataItem);
            }
        }
        this.updateRDIs(v5Query, v5DataContainer);
        return newDetailDataItem;
    }

    private void updateRDIs(V5Query v5Query, V5DataContainer v5DataContainer) {
        Iterator<Map.Entry<String, Object>> mapIterator = this._rdiToNewQueryItemMap.entrySet().iterator();
        HashMap<String, List<Element>> rdiToNodesToUpdateMap = new HashMap<String, List<Element>>();
        while (mapIterator.hasNext()) {
            List<Element> layoutNodes;
            Map.Entry<String, Element> pairs = mapIterator.next();
            String string = pairs.getKey();
            Element newQueryItem = pairs.getValue();
            if (v5DataContainer instanceof V5Chart) {
                layoutNodes = v5DataContainer.selectNodesInCurrentDomain("//V5X//ANYCHILD", "//V5X//EXCEPT_TAG", "propertyItem", "//V5X//ATTR", "refDataItem", string);
                rdiToNodesToUpdateMap.put(string, layoutNodes);
                continue;
            }
            layoutNodes = v5DataContainer.selectNodesInCurrentDomain("//V5X//ANYCHILD", "//V5X//EXCEPT_TAG", "propertyItem", "//V5X//OR", "dataItemLabel", "//V5X//ATTR", "refDataItem", string);
            rdiToNodesToUpdateMap.put(string, layoutNodes);
        }
        HashMap<String, String> oldRDIToNewRDIMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : rdiToNodesToUpdateMap.entrySet()) {
            String rdi = entry.getKey();
            List nodesToUpdate = (List)entry.getValue();
            for (Element layoutNodeToUpdate : nodesToUpdate) {
                if (this._rdiToIsSummaryMap.containsKey(rdi)) {
                    String newSummaryRDI = this.updateSummaryNode(v5DataContainer, v5Query, layoutNodeToUpdate, this._rdiToNewQueryItemMap.get(rdi));
                    if (newSummaryRDI == null) continue;
                    oldRDIToNewRDIMap.put(rdi, newSummaryRDI);
                    continue;
                }
                String newNonSummaryRDI = this.updateNonSummaryNode(v5DataContainer, v5Query, layoutNodeToUpdate, this._rdiToNewQueryItemMap.get(rdi));
                oldRDIToNewRDIMap.put(rdi, newNonSummaryRDI);
            }
        }
        for (Map.Entry<String, Object> entry : oldRDIToNewRDIMap.entrySet()) {
            String originalRDIToUpdate = entry.getKey();
            String newRDI = (String)entry.getValue();
            this.updateNamedConditionalStyles(v5DataContainer, originalRDIToUpdate, newRDI);
            this.updateMasterDetailLinks(v5DataContainer, v5Query, originalRDIToUpdate, newRDI);
        }
    }

    private Element createDetailElement(V5Query v5Query, SelectedCell postDrillParent, String hun, String dun, boolean bDrillUpToRoot) throws ActionException {
        Element newDataItem;
        if (bDrillUpToRoot) {
            newDataItem = v5Query.getItemList().addDataItemRootMembers(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
            if (V5Drillability.isDrillUpDisabled(newDataItem)) {
                V5Drillability.clearDrillUpDisabled(v5Query, newDataItem);
            }
        } else if (bDrillUpToRoot || this.rapServiceManager.ifHasChild(v5Query, postDrillParent.nodeUse)) {
            newDataItem = v5Query.getItemList().addDataItemChildrenSet(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
        } else {
            newDataItem = v5Query.getItemList().addDataItemMember(postDrillParent.nodeDisplay, postDrillParent.nodeUse, hun, dun);
            V5Drillability.setDrillDownDisabled(v5Query, newDataItem);
            V5Drillability.setIsIsolated(newDataItem);
        }
        return newDataItem;
    }

    private Element createSummaryElement(V5Query v5Query, String itemName, String itemMUN, String hun, String dun) throws ActionException {
        Element summaryElement = v5Query.getItemList().addDataItemMember(itemName, itemMUN, hun, dun);
        V5Drillability.setDrillParent(summaryElement);
        if (V5Drillability.isDrillUpDisabled(summaryElement)) {
            V5Drillability.clearDrillUpDisabled(v5Query, summaryElement);
        }
        return summaryElement;
    }

    private void collectRelatedSummaryInfo(V5DataContainer v5DataContainer, V5Query v5Query, Element summaryLayoutNodeToUpdate, Element newSummaryDataItem, Element detailDataItem) throws ActionException {
        if (summaryLayoutNodeToUpdate == null) {
            return;
        }
        if (this._rdiToNewQueryItemMap.containsKey(summaryLayoutNodeToUpdate.attributeValue("refDataItem"))) {
            return;
        }
        String summaryRDI = summaryLayoutNodeToUpdate.attributeValue("refDataItem");
        Element currentSummaryQueryItem = v5Query.getItemList().findItem(summaryLayoutNodeToUpdate.attributeValue("refDataItem"));
        if (this.isEdgeSummary(currentSummaryQueryItem)) {
            Element summaryDataItem = "false".equals(currentSummaryQueryItem.attributeValue("useSetAggregation")) ? detailDataItem : (newSummaryDataItem == null ? detailDataItem : newSummaryDataItem);
            this.addRDIToNewQueryItemMap(v5Query, summaryLayoutNodeToUpdate, summaryDataItem);
            this._rdiToIsSummaryMap.put(summaryRDI, true);
            return;
        }
        this.addRDIToNewQueryItemMap(v5Query, summaryLayoutNodeToUpdate, newSummaryDataItem);
        this._rdiToIsSummaryMap.put(summaryRDI, true);
    }

    private String updateSummaryNode(V5DataContainer v5DataContainer, V5Query v5Query, Element summaryLayoutNodeToUpdate, Element newSummaryDataItem) {
        Element currentSummaryQueryItem = v5Query.getItemList().findItem(summaryLayoutNodeToUpdate.attributeValue("refDataItem"));
        if (this.isEdgeSummary(currentSummaryQueryItem)) {
            this.updateDataItemDimensionalEdgeSummaryInfo(v5Query, summaryLayoutNodeToUpdate, currentSummaryQueryItem, newSummaryDataItem.attributeValue("name"));
            return null;
        }
        if (newSummaryDataItem == null) {
            this.addBreadcrumbAttribute(summaryLayoutNodeToUpdate);
            return null;
        }
        return this.updateNonSummaryNode(v5DataContainer, v5Query, summaryLayoutNodeToUpdate, newSummaryDataItem);
    }

    private boolean isEdgeSummary(Element queryItem) {
        return queryItem.getName().equals("dataItemDimensionalEdgeSummary") || queryItem.getName().equals("dataItemEdgeSummary");
    }

    private Element createNewSummaryDataItem(V5Query v5Query, Element newDetailDataItem, Element oldDetailDataItem, SelectedCell postDrillParent) throws ActionException {
        Element newSummaryDataItem = null;
        if (postDrillParent != null) {
            MemberInfo parentInfo;
            if (newDetailDataItem.getName().equals("dataItemChildrenSet")) {
                newSummaryDataItem = this.createSummaryElement(v5Query, postDrillParent.nodeDisplay, postDrillParent.nodeUse, postDrillParent.nodeHierarchyUniqueName, postDrillParent.nodeDimensionUniqueName);
            }
            if (newDetailDataItem.getName().equals("dataItemMember") && oldDetailDataItem.getName().equals("dataItemMemberSet") && (parentInfo = this.getRapServiceManager().getAncestorInfo(v5Query, postDrillParent.nodeUse, 1)).isValid()) {
                newSummaryDataItem = this.createSummaryElement(v5Query, parentInfo.getMemberCaption(), parentInfo.getMUN(), postDrillParent.nodeHierarchyUniqueName, postDrillParent.nodeDimensionUniqueName);
            }
        }
        return newSummaryDataItem;
    }

    private Element addRDIToNewQueryItemMap(V5Query v5Query, Element chartOrXtabNodeMember, Element newQueryItem) {
        String originalRDIToUpdate = chartOrXtabNodeMember.attributeValue("refDataItem");
        if (!this._rdiToNewQueryItemMap.containsKey(originalRDIToUpdate)) {
            Element breadcrumbQueryItem;
            if (this.isDrillUp() && (breadcrumbQueryItem = this.getQueryItemForBreadcrumb(v5Query, chartOrXtabNodeMember)) != null) {
                newQueryItem = breadcrumbQueryItem;
            }
            this._rdiToNewQueryItemMap.put(chartOrXtabNodeMember.attributeValue("refDataItem"), newQueryItem);
        }
        return newQueryItem;
    }

    private String updateNonSummaryNode(V5DataContainer v5DataContainer, V5Query v5Query, Element layoutNodeToUpdate, Element newDataItem) {
        String originalRDIToUpdate = layoutNodeToUpdate.attributeValue("refDataItem");
        String newDataItemName = newDataItem.attributeValue("name");
        this.updateLayoutReference(v5Query, layoutNodeToUpdate, newDataItemName);
        String newRDI = layoutNodeToUpdate.attributeValue("refDataItem");
        newDataItem = v5Query.findItem(newRDI);
        if (this.isDrillDown) {
            DimensionalOperations.addDrillReset(v5Query.findItem(originalRDIToUpdate), newDataItem);
        }
        this.addToPropertyListIfNeeded(v5DataContainer, layoutNodeToUpdate, originalRDIToUpdate);
        return newRDI;
    }

    private void addToPropertyListIfNeeded(V5DataContainer v5DataContainer, Element layoutNodeToUpdate, String originalRDIToUpdate) {
        if (!"crosstabNodeMember".equals(layoutNodeToUpdate.getName()) && !"chartNodeMember".equals(layoutNodeToUpdate.getName())) {
            return;
        }
        Element propertyList = V5X.selectSingleNode(layoutNodeToUpdate, "//V5X//CHILD", "propertyList");
        if (propertyList != null) {
            if (V5X.selectSingleNode(propertyList, "//V5X//CHILD", "propertyItem", "//V5X//ATTR", "refDataItem", originalRDIToUpdate) == null) {
                propertyList.addElement("propertyItem").addAttribute("refDataItem", originalRDIToUpdate);
            }
        } else if (v5DataContainer.selectSingleNode("reportCondition", "//V5X//OR", "reportExpression") != null || v5DataContainer.selectSingleNode("//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refVariable", "//V5X//EXCEPT_ANCESTOR", "noDataHandler") != null) {
            layoutNodeToUpdate.addElement("propertyList").addElement("propertyItem").addAttribute("refDataItem", originalRDIToUpdate);
        }
    }

    private void updateMasterDetailLinks(V5DataContainer v5DataContainer, V5Query v5Query, String originalRDIToUpdate, String newRDI) {
        if (!(v5DataContainer instanceof V5Crosstab)) {
            return;
        }
        if (v5DataContainer.getDefaultMeasure() != null) {
            return;
        }
        List masterDetailLinksList = V5X.selectNodes(v5DataContainer.getContainerElement(), "//V5X//CHILD", "crosstabFactCell", "contents", "//V5X//ANYCHILD", "masterDetailLinks");
        if (masterDetailLinksList == null || masterDetailLinksList.size() == 0) {
            return;
        }
        for (Element masterDetailLinks : masterDetailLinksList) {
            V5DataContainer childContainer;
            V5Query v5QueryChild;
            Element masterDetailLinkDataItemContext = V5X.selectSingleNode(masterDetailLinks, "dataItemContext", "//V5X//ATTR", "refDataItem", originalRDIToUpdate);
            if (masterDetailLinkDataItemContext == null || (v5QueryChild = (childContainer = V5DataContainerFactory.create(masterDetailLinks.getParent())).getV5Query()).getQueryName().equals(v5Query.getQueryName())) continue;
            List layoutNodesToUpdate = V5X.selectNodes(childContainer.getContainerElement(), "//V5X//CHILDATTR", "refDataItem", originalRDIToUpdate);
            for (Element layoutNodeToUpdate : layoutNodesToUpdate) {
                Element dataItem = v5Query.findItem(newRDI);
                v5QueryChild.getItemList().addDataItem(dataItem.createCopy());
                layoutNodeToUpdate.addAttribute("refDataItem", newRDI);
            }
        }
    }

    private void updateDataItemDimensionalEdgeSummaryInfo(V5Query v5Query, Element layoutNodeToUpdate, Element currentSummaryDataItem, String newRDI) {
        String originalRDI = currentSummaryDataItem.attributeValue("refDataItem");
        if (this.isDrillUp()) {
            String breadCrumb = this.getLastBreadCrumb(v5Query, layoutNodeToUpdate);
            if (breadCrumb != null) {
                V5SpecHelper.removeXMLAttribute(layoutNodeToUpdate, breadCrumb);
            }
        } else if (this.isDrillDown && (layoutNodeToUpdate.getName().equals("chartNodeMember") || layoutNodeToUpdate.getName().equals("crosstabNodeMember"))) {
            V5SpecHelper.setXMLAttribute(layoutNodeToUpdate, DimensionalOperations.getNextBreadCrumbName(layoutNodeToUpdate), originalRDI, "no");
        }
        currentSummaryDataItem.addAttribute("refDataItem", newRDI);
    }

    private String getLastBreadCrumb(V5Query v5Query, Element layoutNodeToUpdate) {
        String drillUpItemName;
        String breadCrumbName = DimensionalOperations.getLastBreadCrumbName(layoutNodeToUpdate);
        if (breadCrumbName != null && (drillUpItemName = V5SpecHelper.getXMLAttribute(layoutNodeToUpdate, breadCrumbName)) != null && v5Query.findItem(drillUpItemName) != null) {
            V5SpecHelper.removeXMLAttribute(layoutNodeToUpdate, breadCrumbName);
            return drillUpItemName;
        }
        return null;
    }

    private void updateLayoutReference(V5Query v5Query, Element rdiToUpdate, String newDataItemName) {
        String breadCrumbName;
        if (this.isDrillUp() && (breadCrumbName = this.getLastBreadCrumb(v5Query, rdiToUpdate)) != null) {
            V5SpecHelper.removeXMLAttribute(rdiToUpdate, breadCrumbName);
        }
        if (this.isDrillDown && (rdiToUpdate.getName().equals("chartNodeMember") || rdiToUpdate.getName().equals("crosstabNodeMember") || rdiToUpdate.getName().equals("vizCategoryDataItem"))) {
            this.addBreadcrumbAttribute(rdiToUpdate);
        }
        rdiToUpdate.addAttribute("refDataItem", newDataItemName);
    }

    private void updateNamedConditionalStyles(V5DataContainer v5DataContainer, String originalRDIToUpdate, String newRDI) {
        Document doc = v5DataContainer.getContainerElement().getDocument();
        List conditionalDataItems = V5X.selectNodes(doc, "//V5X//SUBSELECT", "//V5X//CHILD", "report", "namedConditionalStyles", "//V5X//ANYCHILD", "//V5X//CHILDATTR", "refDataItem", originalRDIToUpdate);
        if (conditionalDataItems == null || conditionalDataItems.size() == 0) {
            return;
        }
        for (Element conditionalDataItem : conditionalDataItems) {
            conditionalDataItem.addAttribute("refDataItem", newRDI);
        }
    }

    private void addBreadcrumbAttribute(Element rdiToUpdate) {
        String oldRDI = rdiToUpdate.attributeValue("refDataItem");
        V5SpecHelper.setXMLAttribute(rdiToUpdate, DimensionalOperations.getNextBreadCrumbName(rdiToUpdate), oldRDI, "no");
    }

    public Element getQueryItemForBreadcrumb(V5Query v5Query, Element rdiNodeToUpdate) {
        String drillUpItemName;
        Element dataItemElement = null;
        if (rdiNodeToUpdate == null) {
            return null;
        }
        String breadCrumbName = DimensionalOperations.getLastBreadCrumbName(rdiNodeToUpdate);
        if (breadCrumbName != null && (drillUpItemName = V5SpecHelper.getXMLAttribute(rdiNodeToUpdate, breadCrumbName)) != null && v5Query.findItem(drillUpItemName) != null) {
            dataItemElement = v5Query.findItem(drillUpItemName);
        }
        return dataItemElement;
    }

    private void collectRelatedNodesForSingleDimensionNestingOnDrillDown(V5DataContainer container, SelectedCell postDrillParent, V5Query v5Query, Element nodeToDrillOn) throws ActionException {
        List<Element> nestedNodesInSameHierarchy = container.getNestedLocationWithSameHUN(v5Query, nodeToDrillOn, postDrillParent.nodeHierarchyUniqueName);
        if (nestedNodesInSameHierarchy == null || nestedNodesInSameHierarchy.size() == 0) {
            return;
        }
        int ancestorLevels = nestedNodesInSameHierarchy.size() - 1;
        List<MemberInfo> ancestorsInfo = this.getRapServiceManager().getAncestorsInfo(v5Query, postDrillParent.nodeUse, 1, ancestorLevels);
        boolean bSelectedMemberHasChildren = this.rapServiceManager.ifHasChild(v5Query, postDrillParent.nodeUse);
        for (int ancestorLevel = 0; ancestorLevel < ancestorLevels; ++ancestorLevel) {
            Element relatedSummaryNode;
            Element nodeToBeUpdated = nestedNodesInSameHierarchy.get(ancestorLevel + 1);
            Element oldDetailDataItem = v5Query.findItem(nodeToBeUpdated.attributeValue("refDataItem"));
            String itemName = oldDetailDataItem.attributeValue("name");
            Element element = relatedSummaryNode = container instanceof V5Crosstab ? this._drillLayoutNode.getRelatedSummaryLayoutNodeForCrosstab(nodeToBeUpdated, itemName) : null;
            if (bSelectedMemberHasChildren) {
                Element newDataItem;
                if (ancestorLevel == 0) {
                    newDataItem = v5Query.getItemList().addDataItemMember(postDrillParent.nodeDisplay, postDrillParent.nodeUse, postDrillParent.nodeHierarchyUniqueName, postDrillParent.nodeDimensionUniqueName);
                } else {
                    MemberInfo ancestorInfo = ancestorsInfo.get(ancestorLevel - 1);
                    newDataItem = v5Query.getItemList().addDataItemMember(ancestorInfo.getMemberCaption(), ancestorInfo.getMUN(), postDrillParent.nodeHierarchyUniqueName, postDrillParent.nodeDimensionUniqueName);
                }
                String newDataItemLabel = ancestorsInfo.get(ancestorLevel).getMemberCaption();
                newDataItem.addAttribute("label", newDataItemLabel);
                this.addRDIToNewQueryItemMap(v5Query, nodeToBeUpdated, newDataItem);
                if (relatedSummaryNode == null) continue;
                this.collectRelatedSummaryInfo(container, v5Query, relatedSummaryNode, null, newDataItem);
                continue;
            }
            this.addBreadcrumbAttribute(nodeToBeUpdated);
            if (relatedSummaryNode == null) continue;
            V5SpecHelper.setXMLAttribute(relatedSummaryNode, DimensionalOperations.getNextBreadCrumbName(relatedSummaryNode), itemName, "no");
        }
    }

    private Element collectRelatedNodesForSingleDimensionNestingOnDrillUp(V5DataContainer v5DataContainer, Element drilledOnLayoutNode, SelectedCell cellToDrillUp, V5Query v5Query, SelectedCell postDrillParent, boolean bDrillUpToRoot) throws ActionException {
        boolean bUpdateDetailNodes = false;
        List<Element> nestedNodesInSameHierarchy = v5DataContainer.getNestedLocationWithSameHUN(v5Query, drilledOnLayoutNode, cellToDrillUp.nodeHierarchyUniqueName);
        int noOfNestedLevels = nestedNodesInSameHierarchy.size();
        if (noOfNestedLevels < 2) {
            return null;
        }
        int ancestorLevels = noOfNestedLevels - 1;
        List<SelectedCell> definingCells = this._drillLayoutNode.getDefiningCellsFromSameHierarchy(cellToDrillUp);
        int iDefiningCellsSize = definingCells.size();
        int startAncestorLevel = ancestorLevels == iDefiningCellsSize && !bDrillUpToRoot ? 2 : 1;
        List<MemberInfo> ancestorsInfo = this.getRapServiceManager().getAncestorsInfo(v5Query, cellToDrillUp.nodeUse, startAncestorLevel, noOfNestedLevels);
        MemberInfo detailMemberInfo = ancestorsInfo.get(0);
        Element detailNode = nestedNodesInSameHierarchy.get(0);
        Element newDetailDataItem = this.getQueryItemForDrilledOnNode(v5DataContainer, drilledOnLayoutNode, cellToDrillUp, v5Query, detailNode, detailMemberInfo);
        this.addRDIToNewQueryItemMap(v5Query, detailNode, newDetailDataItem);
        Element oldDetailQueryItem = v5Query.findItem(nestedNodesInSameHierarchy.get(0).attributeValue("refDataItem"));
        String oldDetailQueryItemName = oldDetailQueryItem.attributeValue("name");
        Element relatedSummaryNode = this._drillLayoutNode.getRelatedSummaryLayoutNodeForCrosstab(nestedNodesInSameHierarchy.get(0), oldDetailQueryItemName);
        Element newSummaryDataItem = this.createNewSummaryDataItem(v5Query, newDetailDataItem, oldDetailQueryItem, postDrillParent);
        this.collectRelatedSummaryInfo(v5DataContainer, v5Query, relatedSummaryNode, newSummaryDataItem, newDetailDataItem);
        for (int ancestorLevel = 0; ancestorLevel < ancestorLevels; ++ancestorLevel) {
            MemberInfo ancestorInfo = ancestorsInfo.get(ancestorLevel);
            Element newDataItem = v5Query.getItemList().addDataItemMember(ancestorInfo.getMemberCaption(), ancestorInfo.getMUN(), cellToDrillUp.nodeHierarchyUniqueName, cellToDrillUp.nodeDimensionUniqueName);
            String newDataItemLabel = ancestorsInfo.get(ancestorLevel + 1).getMemberCaption();
            newDataItem.addAttribute("label", newDataItemLabel);
            Element nodeToBeUpdated = nestedNodesInSameHierarchy.get(ancestorLevel + 1);
            String queryItemName = v5Query.findItem(nodeToBeUpdated.attributeValue("refDataItem")).attributeValue("name");
            Element relatedSummaryNodeForAncestor = v5DataContainer instanceof V5Crosstab ? this._drillLayoutNode.getRelatedSummaryLayoutNodeForCrosstab(nodeToBeUpdated, queryItemName) : null;
            this.addRDIToNewQueryItemMap(v5Query, nodeToBeUpdated, newDataItem);
            if (relatedSummaryNodeForAncestor == null) continue;
            this.collectRelatedSummaryInfo(v5DataContainer, v5Query, relatedSummaryNodeForAncestor, null, newDataItem);
        }
        return newDetailDataItem;
    }

    private Element getQueryItemForDrilledOnNode(V5DataContainer v5DataContainer, Element layoutNodeToDrillOn, SelectedCell cellToDrillUp, V5Query v5Query, Element detailNode, MemberInfo detailMemberInfo) throws ActionException {
        Element newQueryItem = null;
        if (v5DataContainer instanceof V5Crosstab && this._drillLayoutNode.isSummary()) {
            newQueryItem = this.createSummaryElement(v5Query, detailMemberInfo.getMemberCaption(), detailMemberInfo.getMUN(), cellToDrillUp.nodeHierarchyUniqueName, cellToDrillUp.nodeDimensionUniqueName);
        } else {
            newQueryItem = v5Query.getItemList().addDataItemChildrenSet(detailMemberInfo.getMemberCaption(), detailMemberInfo.getMUN(), cellToDrillUp.nodeHierarchyUniqueName, cellToDrillUp.nodeDimensionUniqueName);
            DimensionalOperations.doPreUpdateLayoutOperations(v5DataContainer, layoutNodeToDrillOn, cellToDrillUp, newQueryItem);
        }
        return newQueryItem;
    }

    private RapServiceRequestManager getRapServiceManager() {
        return this.rapServiceManager;
    }

    static {
        _DataItemSetType.add("dataItemLevelSet");
        _DataItemSetType.add("dataItemChildrenSet");
        _DataItemSetType.add("dataItemMemberSet");
        _DataItemSummaryType = new HashSet();
        _DataItemSummaryType.add("dataItemMember");
        _DataItemSummaryType.add("dataItemDimensionalEdgeSummary");
        _DataItemSummaryType.add("dataItemEdgeSummary");
    }
}

