/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.JSONUtility;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import org.dom4j.Element;

public class QueryItemProperties {
    public static final String version = "version";
    public static final String currentVersion = "1";
    public static final String usageFact = "2";
    public static final String munTag = "m";
    public static final String hunTag = "h";
    public static final String dunTag = "d";
    public static final String rdiTag = "r";
    public static final String modelItemTag = "i";
    public static final String usageTag = "usage";
    public static final String dtypeTag = "dtype";
    public static final String useValueTag = "u";
    private static final String itemTag = "item";
    private static final String numericTag = "numeric";
    private static final String dateTimeTag = "dateTime";
    private static final String mCaptionTag = "mCaption";
    private static final String hCaptionTag = "hCaption";
    private static final String dCaptionTag = "dCaption";
    private static final String dimensionalTag = "dimensional";
    private static final String setTag = "set";
    private static final String TEMPORARY_FLAG = "temporary";
    private String _itemName = null;
    private Boolean _numeric = null;
    private Boolean _dateTime = null;
    private String _mun = null;
    public String _hun = null;
    public String _dun = null;
    private String _usage = null;
    private String _modelItem = null;
    public Dimensionality _dimensionality = Dimensionality.unknown;
    private String _memberCaption = null;
    private String _hierarchyCaption = null;
    private String _dimensionCaption = null;

    public void initialize(Element highLevelDataItem) {
        Element dmMember;
        Element dmHierarchy;
        Element dmDimension = highLevelDataItem.element("dmDimension");
        if (dmDimension != null) {
            this._dun = dmDimension.elementText("DUN");
            this._dimensionCaption = dmDimension.elementText("itemCaption");
        }
        if ((dmHierarchy = highLevelDataItem.element("dmHierarchy")) != null) {
            this._modelItem = this._hun = dmHierarchy.elementText("HUN");
            this._hierarchyCaption = dmHierarchy.elementText("itemCaption");
        }
        if ((dmMember = highLevelDataItem.element("dmMember")) != null) {
            this._mun = dmMember.elementText("MUN");
            this._memberCaption = dmMember.elementText("itemCaption");
        }
    }

    public Dimensionality getDimensionality() {
        if (this._dimensionality != Dimensionality.basicValue && this._dimensionality == Dimensionality.unknown && (this._mun != null || this._hun != null && this._dun != null)) {
            this._dimensionality = Dimensionality.dimensional;
        }
        return this._dimensionality;
    }

    public void setBasicValue() {
        this._dimensionality = Dimensionality.basicValue;
    }

    public void setMemberCaption(String memberCaption) {
        this._memberCaption = memberCaption;
    }

    public String getMemberCaption() {
        return this._memberCaption;
    }

    public void setHierarchyCaption(String hierarchyCaption) {
        this._hierarchyCaption = hierarchyCaption;
    }

    public String getModelItem() {
        return this._modelItem;
    }

    public void setModelItem(String modelItem) {
        this._modelItem = modelItem;
    }

    public void setItemName(String itemName) {
        this._itemName = itemName;
    }

    public String getItemName() {
        return this._itemName;
    }

    public void setMun(String mun) {
        this._mun = mun;
    }

    public String getMun() {
        return this._mun;
    }

    public void setUsage(String usage) {
        this._usage = usage;
    }

    public String getUsage() {
        return this._usage;
    }

    public void setNumeric(boolean flag) {
        this._numeric = new Boolean(flag);
    }

    public void setDateTime(boolean flag) {
        this._dateTime = new Boolean(flag);
    }

    public String getHierarchyCaption() {
        if (this._hierarchyCaption != null) {
            return this._hierarchyCaption;
        }
        return this._itemName;
    }

    public void setDimensionCaption(String dimensionCaption) {
        this._dimensionCaption = dimensionCaption;
    }

    public String getDimensionCaption() {
        if (this._dimensionCaption != null) {
            return this._dimensionCaption;
        }
        if (this._hierarchyCaption != null) {
            return this._hierarchyCaption;
        }
        return this._itemName;
    }

    private String getMdTableValue(JSONObject ctxEntry, String ctxTag, JSONObject mdTable, String mdTag) {
        JSONObject mdTableEntry;
        Long mdTableKey;
        if (ctxEntry != null && (mdTableKey = (Long)ctxEntry.get((Object)ctxTag)) != null && (mdTableEntry = (JSONObject)mdTable.get((Object)mdTableKey.toString())) != null) {
            return mdTableEntry.get((Object)mdTag).toString();
        }
        return null;
    }

    public boolean initializeFromJSONContextTables(Element contextData, Element metaData) throws ActionException {
        if (contextData != null && metaData != null) {
            String ctx = contextData.elementText("Block");
            String md = metaData.elementText("Block");
            return this.initializeFromJSONContextTables(ctx, md);
        }
        return false;
    }

    public boolean initializeFromJSONContextTables(String ctx, String md) throws ActionException {
        JSONObject jsonCtx;
        if (ctx != null && md != null && (jsonCtx = JSONUtility.parse(ctx)).size() > 0) {
            JSONObject firstCtxEntry = (JSONObject)jsonCtx.get((Object)currentVersion);
            JSONObject jsonMd = JSONUtility.parse(md);
            this._itemName = this.getMdTableValue(firstCtxEntry, rdiTag, jsonMd, rdiTag);
            this._hun = this.getMdTableValue(firstCtxEntry, hunTag, jsonMd, hunTag);
            this._dun = this.getMdTableValue(firstCtxEntry, dunTag, jsonMd, dunTag);
            this._usage = this.getMdTableValue(firstCtxEntry, rdiTag, jsonMd, usageTag);
            this._mun = this.getMdTableValue(firstCtxEntry, munTag, jsonMd, munTag);
            this._modelItem = this.getMdTableValue(firstCtxEntry, modelItemTag, jsonMd, modelItemTag);
            if (this._modelItem == null && this._mun != null && this._hun != null) {
                this._modelItem = this._hun;
            }
            return true;
        }
        return false;
    }

    public boolean loadJSONXMLAttribute(Element parentDataItemOrSubtype) throws ActionException {
        try {
            JSONObject json;
            String buxQueryItemProperties = V5SpecHelper.getXMLAttribute(parentDataItemOrSubtype, "BUX_QueryItemProperties");
            if (buxQueryItemProperties != null && (json = (JSONObject)JSON.parse((String)buxQueryItemProperties)) != null) {
                if (json.get((Object)version) == null || !currentVersion.equals(json.get((Object)version))) {
                    return false;
                }
                this._itemName = (String)json.get((Object)itemTag);
                this._numeric = (Boolean)json.get((Object)numericTag);
                this._dateTime = (Boolean)json.get((Object)dateTimeTag);
                this._usage = (String)json.get((Object)usageTag);
                Boolean dimensional = (Boolean)json.get((Object)dimensionalTag);
                if (dimensional != null) {
                    if (dimensional.booleanValue()) {
                        this._dimensionality = Dimensionality.dimensional;
                        if (json.get((Object)setTag) != null) {
                            this._dimensionality = Dimensionality.set;
                        }
                        this._mun = (String)json.get((Object)munTag);
                        this._hun = (String)json.get((Object)hunTag);
                        this._dun = (String)json.get((Object)dunTag);
                        this._memberCaption = (String)json.get((Object)mCaptionTag);
                        this._hierarchyCaption = (String)json.get((Object)hCaptionTag);
                        this._dimensionCaption = (String)json.get((Object)dCaptionTag);
                    } else {
                        this._dimensionality = Dimensionality.basicValue;
                    }
                }
                this._modelItem = (String)json.get((Object)modelItemTag);
                return true;
            }
        }
        catch (Exception e) {
            throw new ActionException("load properties", e);
        }
        return false;
    }

    public void saveJSONXMLAttribute(Element parentDataItemOrSubtype, boolean temporary) {
        JSONObject jsonProps = new JSONObject();
        jsonProps.put((Object)version, (Object)currentVersion);
        jsonProps.put((Object)itemTag, (Object)parentDataItemOrSubtype.attributeValue("name"));
        if (this._numeric != null) {
            jsonProps.put((Object)numericTag, (Object)this._numeric);
        }
        if (this._dateTime != null) {
            jsonProps.put((Object)dateTimeTag, (Object)this._dateTime);
        }
        if (usageFact.equals(this._usage) || this._numeric != null && this._numeric.booleanValue() && this._usage != null) {
            jsonProps.put((Object)usageTag, (Object)this._usage);
        }
        if (this._modelItem != null) {
            jsonProps.put((Object)modelItemTag, (Object)this._modelItem);
        }
        if (this.getDimensionality() == Dimensionality.dimensional || this.getDimensionality() == Dimensionality.set) {
            jsonProps.put((Object)dimensionalTag, (Object)Boolean.TRUE);
            if (this.getDimensionality() == Dimensionality.set) {
                jsonProps.put((Object)setTag, (Object)Boolean.TRUE);
            }
            if (this._mun != null) {
                jsonProps.put((Object)munTag, (Object)this._mun);
            }
            if (this._hun != null) {
                jsonProps.put((Object)hunTag, (Object)this._hun);
            }
            if (this._dun != null) {
                jsonProps.put((Object)dunTag, (Object)this._dun);
            }
            if (this._memberCaption != null) {
                jsonProps.put((Object)mCaptionTag, (Object)this._memberCaption);
            }
            if (this._hierarchyCaption != null) {
                jsonProps.put((Object)hCaptionTag, (Object)this._hierarchyCaption);
            }
            if (this._dimensionCaption != null) {
                jsonProps.put((Object)dCaptionTag, (Object)this._dimensionCaption);
            }
        } else if (this._dimensionality == Dimensionality.basicValue) {
            jsonProps.put((Object)dimensionalTag, (Object)Boolean.FALSE);
        }
        if (temporary) {
            jsonProps.put((Object)TEMPORARY_FLAG, (Object)new Boolean(temporary).toString());
        } else {
            jsonProps.remove((Object)TEMPORARY_FLAG);
        }
        V5SpecHelper.setXMLAttribute(parentDataItemOrSubtype, "BUX_QueryItemProperties", jsonProps.toString(), "no");
    }

    public boolean isUsageFact() {
        return this._usage != null && this._usage.equals(usageFact);
    }

    public boolean isUsageData() {
        return this._usage.equals("0") || this._usage.equals(currentVersion);
    }

    public boolean isUsageCalculationOrAggregate() {
        return this._usage.equals("3");
    }

    public boolean hasUsage() {
        return this._usage != null;
    }

    public boolean isConfirmedNumeric() {
        return this.isUsageFact() || this._numeric != null && this._numeric == true;
    }

    public boolean isConfirmedSet() {
        return this._dimensionality != null && this._dimensionality == Dimensionality.set;
    }

    public boolean isConfirmedBasicValue() {
        return this._dimensionality != null && this._dimensionality == Dimensionality.basicValue;
    }

    public boolean isConfirmedNonNumeric() {
        return this._numeric != null && this._numeric == false || this.isConfirmedSet() || this.isConfirmedDateTime();
    }

    public boolean isConfirmedDateTime() {
        return this._dateTime != null && this._dateTime == true;
    }

    public static enum Dimensionality {
        unknown,
        dimensional,
        set,
        basicValue;

    }
}

