/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.CCLDbTypesInfo;
import com.cognos.rap.actions.ItemLabel;
import com.cognos.rap.actions.v5requestcreators.V5LocalizedNamesRequest;
import com.cognos.rap.actions.v5spechelpers.QueryItemProperties;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class QueryItemPropertyManager {
    protected ActionEnv _env = null;
    private V5Query _query = null;
    private ClientContextData _clientContextData = new ClientContextData();

    public QueryItemPropertyManager(ActionEnv env, V5Query query) {
        this._env = env;
        this._query = query;
    }

    public void apply(boolean temporary) throws ActionException {
        String queryName = this._query.getQueryName();
        List dataItems = V5X.selectNodes(this._query.getQueryElement(), "//V5X//CHILD", "selection", "dataItem");
        if (this._clientContextData.initializeClientContextSummary()) {
            for (Element dataItem : dataItems) {
                String rdiName = dataItem.attributeValue("name");
                ContextSummaryRecord contextSummaryRecord = this.getContextSummaryRecord(queryName, rdiName);
                if (contextSummaryRecord == null) continue;
                QueryItemProperties props = new QueryItemProperties();
                props.loadJSONXMLAttribute(dataItem);
                props.setItemName(rdiName);
                props.setUsage(contextSummaryRecord.getUsage());
                props.setModelItem(contextSummaryRecord.getModelItem());
                if (!"2".equals(props.getUsage())) {
                    props._hun = contextSummaryRecord.getHun();
                    props._dun = contextSummaryRecord.getDun();
                    int munCount = contextSummaryRecord.getMunCount();
                    if (munCount > 1) {
                        props._dimensionality = contextSummaryRecord.canDrillDown() ? QueryItemProperties.Dimensionality.set : QueryItemProperties.Dimensionality.dimensional;
                    } else if (munCount == 1) {
                        props._dimensionality = QueryItemProperties.Dimensionality.dimensional;
                    } else if (props._hun == null) {
                        props._dimensionality = QueryItemProperties.Dimensionality.basicValue;
                    }
                    if (contextSummaryRecord.getModelItem() != null) {
                        props.setNumeric(false);
                    } else if (contextSummaryRecord.isNumericDType()) {
                        props.setNumeric(true);
                    }
                    if ((props._dimensionality == QueryItemProperties.Dimensionality.basicValue || props._dimensionality == QueryItemProperties.Dimensionality.unknown) && (contextSummaryRecord.isDateTime() || contextSummaryRecord.hasDateTimeValues())) {
                        props.setDateTime(true);
                    }
                }
                props.saveJSONXMLAttribute(dataItem, temporary);
            }
        }
    }

    public void localizeItemLabels(List<ItemLabel> itemLabelsToTranslate) throws ActionException {
        if (itemLabelsToTranslate.size() == 0 || this._query == null || this._query.getQueryElement() == null) {
            return;
        }
        Document report = this._query.getQueryElement().getDocument();
        if (V5SpecHelper.compareLocales(this._env.getLocale(), report.getRootElement().attributeValue("expressionLocale"), true)) {
            return;
        }
        HashSet<String> processedItems = new HashSet<String>();
        for (Element query : V5Query.getQueryNodes(report.getRootElement())) {
            V5Query v5Query = new V5Query(query, query.attributeValue("name"));
            if (processedItems.size() == itemLabelsToTranslate.size()) {
                return;
            }
            V5LocalizedNamesRequest localizedNamesRequest = new V5LocalizedNamesRequest(this._env, v5Query);
            for (ItemLabel itemLabel : itemLabelsToTranslate) {
                if (processedItems.contains(itemLabel.getName()) || itemLabel.labelIsCustomized()) continue;
                localizedNamesRequest.addItem(itemLabel.getName());
            }
            if (!localizedNamesRequest.hasItems() || !localizedNamesRequest.execute(this._env.getRapServiceRequestManager())) continue;
            for (ItemLabel label : itemLabelsToTranslate) {
                String translatedLabel = localizedNamesRequest.getResults().get(label.getName());
                if (translatedLabel == null) continue;
                label.setLabel(translatedLabel);
                processedItems.add(label.getName());
            }
        }
    }

    public ContextSummaryRecord getContextSummaryRecord(String queryName, String rdiName) {
        if (this._clientContextData._contextSummaryMap != null) {
            return this._clientContextData._contextSummaryMap.get(queryName + "." + rdiName);
        }
        return null;
    }

    public class ContextSummaryRecord {
        private JSONObject _mdEntry = null;
        protected ArrayList<JSONObject> _cdEntries = new ArrayList();
        private JSONObject _mdTable = null;

        protected ContextSummaryRecord(JSONObject mdTable, String mdKey) {
            this._mdTable = mdTable;
            this._mdEntry = (JSONObject)this._mdTable.get((Object)mdKey);
        }

        protected void addCDEntry(JSONObject cdEntry) {
            this._cdEntries.add(cdEntry);
        }

        public boolean isNumericDType() {
            Long dtype = (Long)this._mdEntry.get((Object)"dtype");
            if (dtype == null) {
                return false;
            }
            return CCLDbTypesInfo.isKnownNumericType(dtype.intValue());
        }

        public String getUsage() {
            return this._mdEntry.get((Object)"usage").toString();
        }

        public boolean isDateTime() {
            Long dtype = (Long)this._mdEntry.get((Object)"dtype");
            if (dtype == null) {
                return false;
            }
            return CCLDbTypesInfo.isDateTimeType(dtype.intValue());
        }

        public String getHun() {
            return this.getCDPropValueFromMDTable("h");
        }

        public String getDun() {
            return this.getCDPropValueFromMDTable("d");
        }

        public String getFirstMun() {
            return this.getCDPropValueFromMDTable("m");
        }

        public String getModelItem() {
            return this.getCDPropValueFromMDTable("i");
        }

        public boolean canDrillDown() {
            Long drill = (Long)this._mdEntry.get((Object)"drill");
            return drill != null && (drill.byteValue() == 2 || drill.byteValue() == 3);
        }

        public String getCDPropValue(String propertyTag) {
            String propertyKey = null;
            for (JSONObject cdEntry : this._cdEntries) {
                if (cdEntry.get((Object)propertyTag) == null) continue;
                propertyKey = cdEntry.get((Object)propertyTag).toString();
            }
            return propertyKey;
        }

        public ArrayList<String> getCDValues(String usageTag, String rdiTag) {
            ArrayList<String> usageTags = new ArrayList<String>();
            for (JSONObject cdEntry : this._cdEntries) {
                if (cdEntry.get((Object)"r") == null || cdEntry.get((Object)"u") == null || cdEntry.get((Object)"r").toString().compareToIgnoreCase(rdiTag) != 0) continue;
                usageTags.add(cdEntry.get((Object)"u").toString());
            }
            return usageTags;
        }

        private String getCDPropValueFromMDTable(String propertyTag) {
            for (JSONObject cdEntry : this._cdEntries) {
                if (cdEntry.get((Object)propertyTag) == null) continue;
                String propertyKey = cdEntry.get((Object)propertyTag).toString();
                JSONObject mdTableEntry = (JSONObject)this._mdTable.get((Object)propertyKey);
                return (String)mdTableEntry.get((Object)propertyTag);
            }
            return null;
        }

        public int getMunCount() {
            int munCount = 0;
            for (JSONObject cdEntry : this._cdEntries) {
                if (cdEntry.get((Object)"m") == null) continue;
                ++munCount;
            }
            return munCount;
        }

        public boolean hasDateTimeValues() {
            for (JSONObject cdEntry : this._cdEntries) {
                String useValue = (String)cdEntry.get((Object)"u");
                if (useValue == null || !CCLDbTypesInfo.isDateTimeFormat(useValue)) continue;
                return true;
            }
            return false;
        }
    }

    class ClientContextData {
        protected JSONObject _mdTable = null;
        private JSONObject _cdTable = null;
        protected HashMap<String, ContextSummaryRecord> _contextSummaryMap = null;
        private HashMap<String, String> _metadataTableKeyToNameKeyMap = new HashMap();

        ClientContextData() {
        }

        private void addContextSummaryRecord(String mdKey) {
            String nameKey = this._metadataTableKeyToNameKeyMap.get(mdKey);
            if (this._contextSummaryMap == null) {
                this._contextSummaryMap = new HashMap();
            }
            ContextSummaryRecord contextSummaryRecord = new ContextSummaryRecord(this._mdTable, mdKey);
            this._contextSummaryMap.put(nameKey, contextSummaryRecord);
        }

        private void addContextSummaryValue(String mdKey, JSONObject cdEntry) {
            ContextSummaryRecord contextSummaryRecord;
            String nameKey = this._metadataTableKeyToNameKeyMap.get(mdKey);
            if (this._contextSummaryMap == null) {
                this._contextSummaryMap = new HashMap();
            }
            if ((contextSummaryRecord = this._contextSummaryMap.get(nameKey)) != null) {
                contextSummaryRecord.addCDEntry(cdEntry);
            }
        }

        private boolean loadClientContextDataFromActionArguments() {
            String mdString = QueryItemPropertyManager.this._env.getActionArg("md");
            String cdString = QueryItemPropertyManager.this._env.getActionArg("cd");
            Object md = null;
            Object cd = null;
            if (mdString == null || cdString == null) {
                return false;
            }
            try {
                this._mdTable = this.removeEntriesOfNone2UsageByItemName(JSONObject.parse((String)mdString));
                this._cdTable = JSONObject.parse((String)cdString);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        private JSONObject removeEntriesOfNone2UsageByItemName(JSONObject mdJSON) {
            HashMap rValueEntryKeyMap = new HashMap();
            HashMap rValueUsageMap = new HashMap();
            for (Object key : mdJSON.keySet()) {
                Object usageValue;
                Object rValue = ((JSONObject)mdJSON.get(key)).get((Object)"r");
                if (rValue == null) continue;
                ArrayList keyList = (ArrayList)rValueEntryKeyMap.get(rValue);
                if (keyList == null) {
                    keyList = new ArrayList();
                    rValueEntryKeyMap.put(rValue, keyList);
                }
                keyList.add(key);
                HashSet<Object> usageSet = (HashSet<Object>)rValueUsageMap.get(rValue);
                if (usageSet == null) {
                    usageSet = new HashSet<Object>();
                    rValueUsageMap.put(rValue, usageSet);
                }
                if ((usageValue = ((JSONObject)mdJSON.get(key)).get((Object)"usage")) == null) {
                    usageValue = "null";
                }
                usageSet.add(usageValue);
            }
            for (Object rValue : rValueUsageMap.keySet()) {
                if (((Set)rValueUsageMap.get(rValue)).size() <= 1) continue;
                for (Object key : (List)rValueEntryKeyMap.get(rValue)) {
                    Object usageValue = ((JSONObject)mdJSON.get(key)).get((Object)"usage");
                    if (usageValue.toString().equals("2")) continue;
                    mdJSON.remove(key);
                }
            }
            return mdJSON;
        }

        public boolean initializeClientContextSummary() {
            if (this.loadClientContextDataFromActionArguments()) {
                for (Map.Entry mdEntry : this._mdTable.entrySet()) {
                    String rName = (String)((JSONObject)mdEntry.getValue()).get((Object)"r");
                    if (rName == null) continue;
                    String qKey = ((JSONObject)mdEntry.getValue()).get((Object)"q").toString();
                    JSONObject qEntry = (JSONObject)this._mdTable.get((Object)qKey);
                    String qName = null;
                    if (qEntry != null) {
                        qName = (String)qEntry.get((Object)"q");
                    }
                    this._metadataTableKeyToNameKeyMap.put(((String)mdEntry.getKey()).toString(), qName + "." + rName);
                    this.addContextSummaryRecord(((String)mdEntry.getKey()).toString());
                }
                for (JSONObject cdEntry : this._cdTable.values()) {
                    String rKey = cdEntry.get((Object)"r").toString();
                    this.addContextSummaryValue(rKey, cdEntry);
                }
                return true;
            }
            return false;
        }
    }
}

