/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.mahelpers.MAMemberChildInfoRequest;
import com.cognos.rap.actions.mahelpers.MAMemberParentInfoRequest;
import com.cognos.rap.actions.v5requestcreators.V5LevelDepthRequest;
import com.cognos.rap.actions.v5requestcreators.V5MemberInfoRequest;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.controller.IReportActionController;
import com.cognos.rap.controller.ReportActionState;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class RapServiceRequestManager {
    private IReportActionController rapController = null;
    private ActionEnv actionEnv = null;
    private String _cachedListSeparator = null;
    private JSONObject actionOptions = null;
    public static int BUCKET_SIZE = 5;

    public ActionEnv getActionEnv() {
        return this.actionEnv;
    }

    public RapServiceRequestManager(IReportActionController controller) {
        this.rapController = controller;
    }

    public RapServiceRequestManager(IReportActionController controller, ActionEnv env) {
        this.rapController = controller;
        this.actionEnv = env;
    }

    public RapServiceRequestManager(IReportActionController controller, ActionEnv env, JSONObject actionOptions) {
        this(controller, env);
        this.actionOptions = actionOptions;
    }

    private String getListSeparator(Element anyReportElement) {
        if (this._cachedListSeparator == null) {
            this._cachedListSeparator = V5SpecHelper.getListSeparator(anyReportElement.getDocument());
            this._cachedListSeparator = this._cachedListSeparator != null ? this._cachedListSeparator : ",";
        }
        return this._cachedListSeparator;
    }

    public Element executeQuery(Element reportSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        return this.executeQuery(reportSpec.asXML(), options);
    }

    public Element executeQuery(Document reportSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        return this.executeQuery(reportSpec.getRootElement(), options);
    }

    public Element executeQuery(Element reportSpec) throws CognosServiceRequestException {
        return this.executeQuery(reportSpec, null);
    }

    public Element executeQuery(Document reportSpec) throws CognosServiceRequestException {
        return this.executeQuery(reportSpec, null);
    }

    private CognosServiceResponse _executeMAQuery(String metadataSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        if (this.rapController == null || this.rapController.getCognosServiceInterface() == null) {
            throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
        }
        CognosServiceResponse response = this.rapController.getCognosServiceInterface().runMetadataSpecification(metadataSpec, options);
        return response;
    }

    public Element executeMAQuery(String metadataSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        CognosServiceResponse response = this._executeMAQuery(metadataSpec, options);
        return response.getDOMValue();
    }

    public ArrayList<Element> executeMAQuerySet(String metadataSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        CognosServiceResponse response = this._executeMAQuery(metadataSpec, options);
        return response.getDOMValues();
    }

    public Element executeQuery(String reportSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        if (this.rapController == null || this.rapController.getCognosServiceInterface() == null) {
            throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
        }
        CognosServiceResponse response = this.rapController.getCognosServiceInterface().runReportSpecification(reportSpec, options);
        return response != null ? response.getDOMValue() : null;
    }

    public CognosServiceResponse runReportSpecification(String reportSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        if (this.rapController == null || this.rapController.getCognosServiceInterface() == null) {
            throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
        }
        CognosServiceResponse response = this.rapController.getCognosServiceInterface().runReportSpecification(reportSpec, options);
        return response;
    }

    public CognosServiceResponse runGetParametersSpecification(String reportSpec, CognosServiceOptions options) throws CognosServiceRequestException {
        if (this.rapController == null || this.rapController.getCognosServiceInterface() == null) {
            throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
        }
        CognosServiceResponse response = this.rapController.getCognosServiceInterface().runGetParametersSpecification(reportSpec, options);
        return response;
    }

    public Element executeQuery(String reportSpec) throws CognosServiceRequestException {
        return this.executeQuery(reportSpec, null);
    }

    public MemberInfo getAncestorInfo(V5Query originalQuery, String mun, int level) throws CognosServiceRequestException, ActionException {
        V5Query query = this.createQueryWithoutFilters(originalQuery);
        String listSeparator = this.getListSeparator(originalQuery.getQueryElement());
        if (mun.startsWith("children(")) {
            mun = "item(" + mun + listSeparator + "0)";
        }
        MemberInfo memberInfo = null;
        memberInfo = this.rapController.getReportActionState().getAncestorInfoFromState(mun, level);
        if (memberInfo == null) {
            if (this.rapController.getCognosServiceInterface() == null) {
                throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
            }
            String maGetParent = "false";
            if (this.actionOptions != null) {
                maGetParent = (String)this.actionOptions.get((Object)"useMAGetParentRequest");
            }
            memberInfo = "true".equals(maGetParent) ? this.executeMAParentInfoRequest(level, mun) : this.executeMemberInfoRequest(query, V5LevelDepthRequest.getAncestorExpression(mun, level, listSeparator));
            this.rapController.getReportActionState().addAncestorInfoToState(mun, level, memberInfo);
        }
        return memberInfo;
    }

    public List<MemberInfo> getAncestorsInfo(V5Query originalQuery, String mun, int startDepthLevel, int noOfLevels) throws CognosServiceRequestException, ActionException {
        V5Query query = this.createQueryWithoutFilters(originalQuery);
        String listSeparator = this.getListSeparator(originalQuery.getQueryElement());
        if (mun.startsWith("children(")) {
            mun = "item(" + mun + listSeparator + "0)";
        }
        if (this.rapController.getCognosServiceInterface() == null) {
            throw new CognosServiceRequestException("Could not find an object implementing CognosServiceInterface set on the controller");
        }
        String expression = "set(";
        for (int i = 0; i < noOfLevels; ++i) {
            if (i != 0) {
                expression = expression + listSeparator;
            }
            expression = expression + V5LevelDepthRequest.getAncestorExpression(mun, i + startDepthLevel, listSeparator);
        }
        List<MemberInfo> memberInfos = this.executeMemberInfosRequest(query, expression = expression + ")");
        if (memberInfos == null) {
            return null;
        }
        int noOfMemberInfos = memberInfos.size();
        if (noOfMemberInfos < noOfLevels) {
            for (int ancestorLevel = 0; ancestorLevel < noOfLevels - noOfMemberInfos; ++ancestorLevel) {
                MemberInfo rootMemberInfo = memberInfos.get(noOfMemberInfos - 1);
                MemberInfo memberInfo = new MemberInfo(rootMemberInfo.getMUN(), rootMemberInfo.getMemberCaption());
                memberInfos.add(memberInfo);
            }
        }
        return memberInfos;
    }

    private V5Query createQueryWithoutFilters(V5Query originalQuery) {
        Element summaryFilters;
        V5Query query = new V5Query(((Document)originalQuery.getQueryElement().getDocument().clone()).getRootElement(), originalQuery.getQueryName());
        Element detailFilters = query.getQueryElement().element("detailFilters");
        if (detailFilters != null) {
            detailFilters.detach();
        }
        if ((summaryFilters = query.getQueryElement().element("summaryFilters")) != null) {
            summaryFilters.detach();
        }
        return query;
    }

    public MemberInfo getChildInfo(V5Query query, String mun) throws CognosServiceRequestException, ActionException {
        String expression = "item(children(" + mun + ")" + this.getListSeparator(query.getQueryElement()) + "0)";
        String maGetChild = "false";
        if (this.actionOptions != null) {
            maGetChild = (String)this.actionOptions.get((Object)"useMAGetChildRequest");
        }
        if ("true".equals(maGetChild)) {
            return this.executeMAChildInfoRequest(mun);
        }
        return this.executeMemberInfoRequest(query, expression);
    }

    public MemberInfo getMemberInfo(V5Query query, String mun) throws CognosServiceRequestException, ActionException {
        String expression = "item(" + mun + this.getListSeparator(query.getQueryElement()) + "0)";
        return this.executeMemberInfoRequest(query, expression);
    }

    public boolean ifHasChild(V5Query query, String mun) throws CognosServiceRequestException, ActionException {
        ReportActionState reportActionState = this.rapController.getReportActionState();
        Element cachedChild = reportActionState.getChildInfoFromCache(mun);
        if (cachedChild == null) {
            MemberInfo memberInfo = this.getChildInfo(query, mun);
            reportActionState.addChildInfoToState(mun, memberInfo);
            return memberInfo.isValid();
        }
        return Boolean.parseBoolean(cachedChild.attributeValue("hasChild"));
    }

    public int getLevelDepth(V5Query query, String expression) throws CognosServiceRequestException, ActionException {
        String queryExpression = "item(" + expression + this.getListSeparator(query.getQueryElement()) + " 0)";
        int depth = 0;
        int parentCount = 0;
        do {
            V5LevelDepthRequest depthRequest = new V5LevelDepthRequest(query, queryExpression, BUCKET_SIZE);
            depthRequest.create();
            Element result = this.executeQuery(depthRequest.getDocument(), null);
            Element rowElement = (Element)result.selectSingleNode(".//*[local-name()='row']");
            if (rowElement == null) break;
            List values = rowElement.elements();
            parentCount = 0;
            for (Element value : values) {
                parentCount += Integer.parseInt(value.getText());
            }
            depth += parentCount;
            if (parentCount != BUCKET_SIZE) continue;
            MemberInfo memberInfo = this.getAncestorInfo(query, queryExpression, BUCKET_SIZE);
            if (memberInfo == null || !memberInfo.isValid()) break;
            queryExpression = memberInfo.getMUN();
        } while (parentCount >= BUCKET_SIZE);
        return depth;
    }

    protected MemberInfo executeMemberInfoRequest(V5Query query, String expression) throws CognosServiceRequestException, ActionException {
        if (this.actionEnv != null) {
            this.actionEnv.addEventTiming("executeMemberInfoRequest: " + expression, "2");
        }
        V5MemberInfoRequest memberInfoRequest = new V5MemberInfoRequest(query, expression);
        memberInfoRequest.create();
        Element result = this.executeQuery(memberInfoRequest.getDocument(), null);
        return this.parseMemberInfoRequestResponse(result);
    }

    protected MemberInfo executeMAChildInfoRequest(String mun) throws CognosServiceRequestException, ActionException {
        MAMemberChildInfoRequest maMemberInfoRequest = new MAMemberChildInfoRequest(this, mun);
        return maMemberInfoRequest.requestMemberInfo();
    }

    protected MemberInfo executeMAParentInfoRequest(int level, String mun) throws CognosServiceRequestException, ActionException {
        MAMemberParentInfoRequest maMemberInfoRequest = new MAMemberParentInfoRequest(this, level, mun);
        return maMemberInfoRequest.requestMemberInfo();
    }

    protected List<MemberInfo> executeMemberInfosRequest(V5Query query, String expression) throws CognosServiceRequestException, ActionException {
        V5MemberInfoRequest memberInfoRequest = new V5MemberInfoRequest(query, expression);
        memberInfoRequest.create();
        Element result = this.executeQuery(memberInfoRequest.getDocument(), null);
        if (result == null) {
            return null;
        }
        List rowElements = XMLUtility.selectNodes(result, ".//*[local-name()='row']");
        if (rowElements == null || rowElements.size() == 0) {
            return null;
        }
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        for (Element rowElement : rowElements) {
            List valueList = rowElement.elements();
            MemberInfo memberInfo = new MemberInfo(((Element)valueList.get(0)).getText(), ((Element)valueList.get(1)).getText());
            memberInfos.add(memberInfo);
        }
        return memberInfos;
    }

    private MemberInfo parseMemberInfoRequestResponse(Element result) {
        if (result == null) {
            return new MemberInfo("", "");
        }
        Element rowElement = (Element)result.selectSingleNode(".//*[local-name()='row']");
        if (rowElement == null) {
            return new MemberInfo("", "");
        }
        List valueList = rowElement.elements();
        MemberInfo memberInfo = new MemberInfo(((Element)valueList.get(0)).getText(), ((Element)valueList.get(1)).getText());
        return memberInfo;
    }
}

