/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.V5;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.utility.XMLUtility;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class V1ToV2PaletteMigrationHelper {
    private static final String ENTRIES = "Entries";
    private static final String ENTTRY = "Entry";
    private static final String XPATH_SPLITTER = "/";
    private static final String FILL_COLOR = "fillColor";
    private static final String SOLID_COLOR = "solidColor";
    private static final String PATTERN = "pattern";
    private static final String V2_PREFIX = "v2_";
    private static final String EMPTY_STRING = "";

    public static void migratePalette(Element sourceChart, Element targetChart) {
        Element eleSrcPalette;
        String srcChartName = sourceChart.getName();
        String tgtChartName = targetChart.getName();
        if (!srcChartName.equals("progressiveChart") && !tgtChartName.equals("progressiveChart") && (eleSrcPalette = V5X.selectSingleNode(sourceChart, "chartPalette", "//V5X//CHILD")) != null) {
            List srcPaletteEntries = XMLUtility.selectNodes(V5X.selectSingleNode(sourceChart, "chartPalette"), "child::*");
            List tgtPaletteParentList = XMLUtility.selectNodes(targetChart, ChartElements.V2PaletteParentPath.get(tgtChartName));
            String tgtPaletteParentNS = null;
            for (Element tgtPaletteParent : tgtPaletteParentList) {
                tgtPaletteParentNS = tgtPaletteParent.getNamespaceURI();
                String tgtPaletteName = ChartElements.V2PaletteType.get(tgtPaletteParent.getName());
                tgtPaletteParent.element(tgtPaletteName).clearContent();
                Element eleTgtPaletteEntries = DocumentHelper.makeElement((Branch)tgtPaletteParent, (String)(tgtPaletteName + XPATH_SPLITTER + tgtPaletteName + ENTRIES));
                for (Element srcPaletteEntry : srcPaletteEntries) {
                    Element tgtPaletteEntry = new DocumentFactory().createElement("v2_solidPaletteEntry", tgtPaletteParentNS);
                    Element tgtPaletteFillEffect = tgtPaletteEntry.addElement("v2_fillEffect", tgtPaletteParentNS);
                    V1ToV2PaletteMigrationHelper.migrateFillEffect(srcPaletteEntry, tgtPaletteFillEffect, false);
                    Element eleTgtPaletteEntry_clone = (Element)tgtPaletteEntry.clone();
                    if (eleTgtPaletteEntries.getName() != "v2_solidPaletteEntries") {
                        V1ToV2PaletteMigrationHelper.convertPaletteEntry(eleTgtPaletteEntry_clone, eleTgtPaletteEntries, tgtPaletteName + ENTTRY);
                        continue;
                    }
                    eleTgtPaletteEntries.add(eleTgtPaletteEntry_clone);
                }
                if (!srcPaletteEntries.isEmpty()) continue;
            }
        }
        sourceChart.element("chartPalette").detach();
    }

    private static void convertPaletteEntry(Element eleSrcPaletteEntry, Element eleTgtPaletteEntryParent, String tgtPaletteEntryName) {
        Element eleTgtPaletteEntry = eleTgtPaletteEntryParent.addElement(tgtPaletteEntryName);
        if (!eleSrcPaletteEntry.getName().equals("v2_linePaletteEntry") && !eleTgtPaletteEntry.getName().equals("v2_linePaletteEntry")) {
            eleTgtPaletteEntry.add((Element)eleSrcPaletteEntry.selectSingleNode("*").clone());
        } else if (tgtPaletteEntryName.equals("v2_linePaletteEntry")) {
            if (eleSrcPaletteEntry.getName().equals("v2_pointPaletteEntry")) {
                eleTgtPaletteEntry.add((Element)eleSrcPaletteEntry.clone());
            } else {
                Element elePointEntry = eleTgtPaletteEntry.addElement("v2_pointPaletteEntry");
                Node containedNode = eleSrcPaletteEntry.selectSingleNode("*");
                if (containedNode != null) {
                    elePointEntry.add((Element)containedNode.clone());
                }
            }
            Element eleLineFill = eleTgtPaletteEntry.addElement("v2_lineFill");
            Element eleSrcGradient = V5X.selectSingleNode(eleSrcPaletteEntry, "v2_linearGradient", "//V5X//OR", "v2_radialRectGradient", "//V5X//OR", "v2_radialLinearGradient");
            Element eleSolidColor = V5X.selectSingleNode(eleSrcPaletteEntry, "v2_solidColor");
            Element eleDefaultColor = V5X.selectSingleNode(eleSrcPaletteEntry, "//V5X//CHILD", "v2_fillEffect", "//V5X//ATTR_DEFINED", "defaultColor");
            String defaultColor = EMPTY_STRING;
            if (eleDefaultColor != null) {
                defaultColor = eleDefaultColor.getText();
            }
            if (eleSolidColor != null) {
                Element v_nColor = eleLineFill.addElement("v2_color");
                v_nColor.addAttribute("color", eleSolidColor.attributeValue("color"));
            } else if (eleSrcGradient != null) {
                Element eleLinearGradient = eleLineFill.addElement("v2_linearGradient");
                List nodes = XMLUtility.selectNodes(eleSrcGradient, "*");
                for (Element ele : nodes) {
                    eleLinearGradient.add((Element)ele.clone());
                }
                Element eleImportedGradient = (Element)eleSrcGradient.clone();
                if (eleImportedGradient.getName().equals("v2_linearGradient")) {
                    eleLinearGradient.addAttribute("gradientAngle", eleImportedGradient.attributeValue("gradientAngle"));
                }
            } else {
                Element eleSolidColor1 = eleLineFill.addElement("v2_color");
                eleSolidColor1.addAttribute("color", defaultColor);
            }
        } else {
            Element v_nFillEffect = (Element)eleSrcPaletteEntry.selectSingleNode("v2_pointPaletteEntry" + XPATH_SPLITTER + "v2_fillEffect");
            if (v_nFillEffect != null) {
                eleTgtPaletteEntry.add((Element)v_nFillEffect.clone());
            }
        }
    }

    public static void migrateFillEffect(Element eleSrcPalette, Element eleFillEffect, boolean isLegendChart) {
        String chartNamePrefix = isLegendChart ? EMPTY_STRING : V2_PREFIX;
        String colorEleName = isLegendChart ? FILL_COLOR : SOLID_COLOR;
        String defaultColor = EMPTY_STRING;
        String eleSrcPaletteEntryName = eleSrcPalette.getName();
        if (eleSrcPaletteEntryName.equals("chartColor")) {
            Element eleColor = eleFillEffect.addElement(chartNamePrefix + colorEleName);
            eleColor.addAttribute("color", eleSrcPalette.attributeValue("value"));
            defaultColor = eleSrcPalette.attributeValue("value");
        } else if (eleSrcPaletteEntryName.equals("chartGradient")) {
            Element eleGradient = eleFillEffect.addElement(chartNamePrefix + "linearGradient");
            Element eleFirstColor = eleGradient.addElement(chartNamePrefix + "gradientColor");
            eleFirstColor.addAttribute("gradientColor", eleSrcPalette.attributeValue("fromColor"));
            eleFirstColor.addAttribute("colorPosition", "0");
            Element eleSecondColor = eleGradient.addElement(chartNamePrefix + "gradientColor");
            eleSecondColor.addAttribute("gradientColor", eleSrcPalette.attributeValue("toColor"));
            eleSecondColor.addAttribute("colorPosition", "100");
            eleGradient.addAttribute("gradientAngle", V1ToV2PaletteMigrationHelper.getV1GradientAngle_From_V2PaletteGradientDirection(eleSrcPalette.attributeValue("direction")));
            defaultColor = eleSrcPalette.attributeValue("fromColor");
        } else if (eleSrcPaletteEntryName.equals("chartPattern")) {
            Element elePattern = eleFillEffect.addElement(chartNamePrefix + PATTERN);
            elePattern.addAttribute("foregroundColor", eleSrcPalette.attributeValue("foregroundColor"));
            elePattern.addAttribute("backgroundColor", eleSrcPalette.attributeValue("backgroundColor"));
            elePattern.addAttribute("patternType", eleSrcPalette.attributeValue("patternType"));
            defaultColor = eleSrcPalette.attributeValue("foregroundColor");
        }
        if (!isLegendChart) {
            eleFillEffect.attributeValue("defaultColor", defaultColor);
        }
    }

    private static String getV1GradientAngle_From_V2PaletteGradientDirection(String direction) {
        String result;
        if (direction != null && (result = V5.Attr.directionAngleMap.get(direction)) != null) {
            return result;
        }
        return "180";
    }
}

