/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeRulesProcessor;
import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.SwapRowsAndColumnsHelper;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5RSXChart;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.NameSpaceSetter;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Visitor;

public class V5Chart
extends V5RSXChart {
    private ActionEnv actionEnv = null;
    protected List<Element> _layoutItems = null;
    private List<Element> _nestedLocationWithSameHUN = null;

    public V5Chart(Element chartDataContainer) {
        this._container = chartDataContainer;
        this._typeID = V5DataContainer.containerTypeID.chart;
    }

    @Override
    public Element getChartElement() {
        return this._container;
    }

    public static boolean isV1Chart(Element chartElement) {
        return chartElement.getName().endsWith("Chart") && !chartElement.getName().contains("v2_");
    }

    public static boolean isV2Chart(Element chartElement) {
        return chartElement.getName().startsWith("v2_");
    }

    public boolean isMicroChart() {
        if ("v2_bulletChart".equals(this._container.getName())) {
            return false;
        }
        if ("winLossChart".equals(this._container.getName())) {
            return true;
        }
        if ("combinationChart".equals(this._container.getName()) || "v2_combinationChart".equals(this._container.getName())) {
            String value = V5SpecHelper.getXMLAttribute(this._container, "beganAsMicroChart");
            if (value != null && value.equals("true")) {
                return true;
            }
            if (V5Chart.isV2Chart(this._container) ? V5X.selectSingleNode(this._container, "v2_legend") == null && V5X.selectSingleNode(this._container, "v2_commonAxis", "//V5X//CHILD", "v2_ordinalAxis").elements().isEmpty() : V5Chart.isV1Chart(this._container) && V5X.selectSingleNode(this._container, "legend") == null && V5X.selectSingleNode(this._container, "ordinalAxis", "//V5X//CHILD", "axisTitle") == null) {
                return true;
            }
        }
        return false;
    }

    public void setChartPalette(Element v5ChartPalette) {
        Element existingPalette = null;
        if (V5Chart.isV1Chart(this._container)) {
            existingPalette = this._container.element("chartPalette");
            if (existingPalette != null) {
                existingPalette.detach();
            }
            if (v5ChartPalette != null) {
                Element cloneV5Palette = (Element)v5ChartPalette.clone();
                NameSpaceSetter nameSpaceSetter = new NameSpaceSetter(this._container.getNamespace());
                cloneV5Palette.accept((Visitor)nameSpaceSetter);
                this._container.add(cloneV5Palette);
            }
        } else if (v5ChartPalette != null) {
            List paletteItemsElements = XMLUtility.selectNodes(v5ChartPalette, "./*");
            String paletteParentPath = ChartElements.V2PaletteParentPath.get(this._container.getName());
            if (paletteParentPath == null) {
                return;
            }
            List paletteParents = XMLUtility.selectNodes(this._container, paletteParentPath);
            for (Element paletteParent : paletteParents) {
                String paletteEntriesName;
                String paletteName;
                Element oldPaletteElement = paletteParent.element(paletteName = ChartElements.V2PaletteType.get(paletteParent.getName()));
                if (oldPaletteElement != null) {
                    oldPaletteElement.detach();
                }
                if ((paletteEntriesName = ChartElements.V2PaletteEntriesName.get(paletteName)) == null) continue;
                Element paletteEntriesElement = paletteParent.addElement(paletteName).addElement(paletteEntriesName);
                this.copyPaletteAttributes(oldPaletteElement, paletteParent.element(paletteName));
                this.applyV2Palettes(paletteItemsElements, paletteEntriesElement, ChartElements.V2PaletteEntryName.get(paletteName), oldPaletteElement);
            }
        }
    }

    public void applyV2Palettes(List<Element> paletteItemsElements, Element v2_paletteEntriesElement, String v2_paletteEntryName, Element oldPaletteElement) {
        List markerShapeAttrbutes = null;
        int markerShapeIndex = 0;
        for (int i = 0; i < paletteItemsElements.size(); ++i) {
            Element v2_pointPaletteEntry;
            Element paletteItem = paletteItemsElements.get(i);
            Element v2_paletteEntryElement = v2_paletteEntriesElement.addElement(v2_paletteEntryName);
            Element v2_fillEfect = null;
            Element v2_lineFill = null;
            if ("v2_linePaletteEntry".equals(v2_paletteEntryName)) {
                v2_lineFill = v2_paletteEntryElement.addElement("v2_lineFill");
                v2_fillEfect = v2_paletteEntryElement.addElement("v2_pointPaletteEntry").addElement("v2_fillEffect");
            } else {
                v2_fillEfect = v2_paletteEntryElement.addElement("v2_fillEffect");
            }
            Object object = "v2_linePaletteEntry".equals(v2_paletteEntryName) ? v2_paletteEntryElement.element("v2_pointPaletteEntry") : (v2_pointPaletteEntry = "v2_pointPaletteEntry".equals(v2_paletteEntryName) ? v2_paletteEntryElement : null);
            if (v2_pointPaletteEntry != null) {
                if (markerShapeAttrbutes == null && oldPaletteElement != null) {
                    markerShapeAttrbutes = V5X.selectNodes(oldPaletteElement, "v2_pointPaletteEntry", "//V5X//ATTR_DEFINED", "markerShape");
                }
                if (markerShapeAttrbutes != null && markerShapeIndex < markerShapeAttrbutes.size()) {
                    v2_pointPaletteEntry.addAttribute("markerShape", ((Element)markerShapeAttrbutes.get(markerShapeIndex++)).attributeValue("markerShape"));
                }
            }
            if ("chartColor".equals(paletteItem.getName())) {
                if (v2_lineFill != null) {
                    v2_lineFill.addElement("v2_color").addAttribute("color", paletteItem.attributeValue("value"));
                    v2_lineFill.addAttribute("defaultColor", paletteItem.attributeValue("value"));
                }
                v2_fillEfect.addAttribute("defaultColor", paletteItem.attributeValue("value"));
                Element v2_solidColorElement = v2_fillEfect.addElement("v2_solidColor");
                v2_solidColorElement.addAttribute("color", paletteItem.attributeValue("value"));
                continue;
            }
            if ("chartGradient".equals(paletteItem.getName())) {
                Element v2_gradientColorTo;
                Element v2_gradientColorFrom;
                Element v2_linearGradientElement;
                if (v2_lineFill != null) {
                    v2_lineFill.addAttribute("defaultColor", paletteItem.attributeValue("fromColor"));
                    v2_linearGradientElement = v2_lineFill.addElement("v2_linearGradient");
                    v2_linearGradientElement.addAttribute("gradientAngle", "90");
                    v2_gradientColorFrom = v2_linearGradientElement.addElement("v2_gradientColor");
                    v2_gradientColorFrom.addAttribute("gradientColor", paletteItem.attributeValue("fromColor"));
                    v2_gradientColorTo = v2_linearGradientElement.addElement("v2_gradientColor");
                    v2_gradientColorTo.addAttribute("gradientColor", paletteItem.attributeValue("toColor"));
                    v2_gradientColorTo.addAttribute("colorPosition", paletteItem.attributeValue("colorPosition", "100"));
                }
                v2_fillEfect.addAttribute("defaultColor", paletteItem.attributeValue("fromColor"));
                v2_linearGradientElement = v2_fillEfect.addElement("v2_linearGradient");
                v2_linearGradientElement.addAttribute("gradientAngle", "270");
                v2_gradientColorFrom = v2_linearGradientElement.addElement("v2_gradientColor");
                v2_gradientColorFrom.addAttribute("gradientColor", paletteItem.attributeValue("fromColor"));
                v2_gradientColorTo = v2_linearGradientElement.addElement("v2_gradientColor");
                v2_gradientColorTo.addAttribute("gradientColor", paletteItem.attributeValue("toColor"));
                v2_gradientColorTo.addAttribute("colorPosition", paletteItem.attributeValue("colorPosition", "100"));
                continue;
            }
            if (!"chartPattern".equals(paletteItem.getName())) continue;
            Element v2_patternElement = v2_fillEfect.addElement("v2_pattern");
            v2_patternElement.addAttribute("foregroundColor", paletteItem.attributeValue("foregroundColor"));
            v2_patternElement.addAttribute("backgroundColor", paletteItem.attributeValue("backgroundColor"));
            v2_patternElement.addAttribute("patternType", paletteItem.attributeValue("patternType"));
            v2_fillEfect.addAttribute("defaultColor", paletteItem.attributeValue("foregroundColor"));
            if (v2_lineFill == null) continue;
            v2_lineFill.addAttribute("defaultColor", paletteItem.attributeValue("foregroundColor"));
            v2_lineFill.addElement("v2_color").addAttribute("color", paletteItem.attributeValue("foregroundColor"));
        }
    }

    private void copyPaletteAttributes(Element oldPaletteElement, Element newPaletteElement) {
        if (oldPaletteElement == null || newPaletteElement == null) {
            return;
        }
        for (Attribute attribute : oldPaletteElement.attributes()) {
            newPaletteElement.add((Attribute)attribute.clone());
        }
    }

    @Override
    public Element getDefaultMeasure() {
        String nodeName = this.getNodeNameOfDefaultChartMeasure();
        return this._container.element(nodeName);
    }

    @Override
    public void addSortList(String columnName, String sortOrder) {
        this.addSortList(columnName, columnName, sortOrder);
    }

    @Override
    public void addSortList(String columnName, String sortedDataItem, String sortOrder) {
        Element nodeMember = this.findItem(columnName);
        if (nodeMember != null) {
            Element sortList = nodeMember.element("sortList");
            if (sortList != null) {
                sortList.detach();
            }
            sortList = DocumentHelper.makeElement((Branch)nodeMember, (String)"sortList");
            V5SpecHelper.addSortItem(sortList, sortedDataItem, sortOrder);
        }
    }

    @Override
    public Element findAxis(String refDataItem) {
        String legendName = ChartElements.legendEdgeName.get(this._container.getName());
        String seriesName = ChartElements.ordinalAxis.get(this._container.getName());
        if (legendName == null || seriesName == null) {
            return null;
        }
        Element chartNodeMember = V5X.selectSingleNode(this._container, "chartNodeMember", "//V5X//ATTR", "refDataItem", refDataItem);
        if (chartNodeMember == null) {
            return null;
        }
        Element axisRoot = V5SpecHelper.getAncestor(chartNodeMember, legendName);
        if (axisRoot == null) {
            axisRoot = V5SpecHelper.getAncestor(chartNodeMember, seriesName);
        }
        return axisRoot;
    }

    @Override
    public Element findOppositeAxis(String refDataItem) {
        Element thisAxis = this.findAxis(refDataItem);
        String legendName = ChartElements.legendEdgeName.get(this._container.getName());
        String seriesName = ChartElements.ordinalAxis.get(this._container.getName());
        if (legendName == null || seriesName == null) {
            return null;
        }
        if (thisAxis != null) {
            if (legendName.equals(thisAxis.getName())) {
                return V5X.selectSingleNode(this.getContainerElement(), seriesName);
            }
            return V5X.selectSingleNode(this.getContainerElement(), legendName);
        }
        return null;
    }

    @Override
    public List<Element> axisNodeMembers(Element axis) {
        return V5X.selectNodes(axis, "chartNodeMember");
    }

    @Override
    public List<Element> collectNodes() {
        if (this._layoutItems == null) {
            this._layoutItems = V5X.selectNodes(this._container, "chartNodeMember");
            List<Element> measureItems = V5Chart.collectMeasureElements(this._container);
            if (measureItems != null) {
                if (this._layoutItems == null) {
                    this._layoutItems = new ArrayList<Element>();
                }
                this._layoutItems.addAll(measureItems);
            }
        }
        return this._layoutItems;
    }

    @Override
    public List<Element> collectEdgeNodes() {
        return XMLUtility.selectNodes(this._container, ".//*[local-name()='chartNodeMember']");
    }

    @Override
    public Element findItem(String refDataItem) {
        Element layoutItem = V5X.selectSingleNode(this._container, "chartNodeMember", "//V5X//ATTR", "refDataItem", refDataItem);
        if (layoutItem == null) {
            List<Element> measureItems = V5Chart.collectMeasureElements(this._container);
            if (measureItems != null) {
                for (Element measureItem : measureItems) {
                    if (!refDataItem.equals(measureItem.attributeValue("refDataItem"))) continue;
                    return measureItem;
                }
            }
            if ("mapChart".equals(this._container.getName())) {
                layoutItem = this.selectSingleNode("//V5X//CHILD", "regionLayer", "//V5X//OR", "pointLayer", "//V5X//CHILDATTR", "refDataItem", refDataItem);
            }
        }
        return layoutItem;
    }

    @Override
    public Element findItemLabelByRDI(String dataItemName) {
        Element nodeMember = V5X.selectSingleNode(this._container, "//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", dataItemName);
        if (nodeMember != null) {
            return V5X.selectSingleNode(nodeMember, "chartContents", "//V5X//CHILD", "chartTextItem");
        }
        return null;
    }

    @Override
    public Element findItemLabel(Element chartMemberOrMeasure) {
        return V5X.selectSingleNode(chartMemberOrMeasure, "chartContents", "//V5X//CHILD", "chartTextItem");
    }

    @Override
    public boolean isLeafNode(Element thisNodeMember) {
        return thisNodeMember.getParent() != null && thisNodeMember.getParent().getParent() != null && thisNodeMember.getParent().getParent().element("chartNestedNodes") == null;
    }

    @Override
    public Element changeDisplayType(ActionEnv env) throws ActionException {
        this.actionEnv = env;
        if ("mapChart".equals(this.getContainerElement().getName())) {
            return null;
        }
        V5Query query = new V5Query();
        query.focusQuery(env.getRAPReport().getDOM().getRootElement(), this.getRefQuery());
        ChangeDisplayTypeHelper.TargetDisplayType targetType = ChangeDisplayTypeHelper.getTargetDisplayType(env.getActionArguments());
        Element newDataContainerElement = null;
        Element originalChart = this.getContainerElement().createCopy();
        if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.crosstab) {
            newDataContainerElement = this.convertToCrosstab();
        } else if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.chart || targetType == ChangeDisplayTypeHelper.TargetDisplayType.list) {
            Element crosstabElement = this.convertToCrosstab();
            V5Crosstab v5Crosstab = new V5Crosstab(crosstabElement);
            newDataContainerElement = v5Crosstab.changeDisplayType(env);
        }
        if (newDataContainerElement != null) {
            ChangeDisplayTypeRulesProcessor rulesProcessor = new ChangeDisplayTypeRulesProcessor(this.actionEnv);
            rulesProcessor.applyChartConversionRules(originalChart, newDataContainerElement);
            ChangeDisplayTypeHelper.stripConversionRulesNodes(newDataContainerElement);
            ChangeDisplayTypeHelper.setDataContainerName(newDataContainerElement, this._container.attributeValue("name"), env.getActionArguments());
            return newDataContainerElement;
        }
        return super.changeDisplayType(env);
    }

    @Override
    public Collection<Element> getLayoutSortItems() {
        return V5X.selectNodes(this.getContainerElement(), "chartNodeMember", "//V5X//CHILD", "sortList", "//V5X//CHILD", "sortItem");
    }

    @Override
    public void removeSortList(String columnName) throws ActionException {
        Element sortList;
        Element nodeMember = this.findItem(columnName);
        if (nodeMember != null && (sortList = nodeMember.element("sortList")) != null) {
            sortList.detach();
        }
    }

    public void setDefaultMeasure(String rdi) {
        if (rdi == null || rdi.length() == 0) {
            return;
        }
        String nodeName = this.getNodeNameOfDefaultChartMeasure();
        Element measureNode = DocumentHelper.makeElement((Branch)this._container, (String)nodeName);
        measureNode.addAttribute("refDataItem", rdi);
    }

    public void setDataFormatStyleOnDefaultMeasure(Element dataFormat) {
        if (dataFormat == null) {
            return;
        }
        String nodeName = this.getNodeNameOfDefaultChartMeasure();
        Element defaultMeasureElement = V5X.selectSingleNode(this._container, "//V5X//CHILD", nodeName);
        if (defaultMeasureElement != null) {
            Element defaultMeasureStyle = DocumentHelper.makeElement((Branch)defaultMeasureElement, (String)"style");
            defaultMeasureStyle.add(dataFormat);
        }
    }

    private String getNodeNameOfDefaultChartMeasure() {
        String nodeName = V5Chart.isV2Chart(this._container) ? "v2_defaultChartMeasure" : "defaultChartMeasure";
        return nodeName;
    }

    public void removeDefaultMeasure() {
        String nodeName = this.getNodeNameOfDefaultChartMeasure();
        Element measureNode = this._container.element(nodeName);
        if (measureNode != null) {
            measureNode.detach();
        }
    }

    public Element getDefaultMeasureDataFormat() {
        String nodeName = this.getNodeNameOfDefaultChartMeasure();
        return V5X.selectSingleNode(this._container, "//V5X//CHILD", nodeName, "style", "dataFormat");
    }

    private Element convertToCrosstab() throws ActionException {
        Element crosstabElement = ChangeDisplayTypeHelper.getNewChartElement("crosstab", this.getContainerElement().getNamespace());
        V5Crosstab v5Crosstab = new V5Crosstab(crosstabElement);
        crosstabElement.addAttribute("refQuery", this.getContainerElement().attributeValue("refQuery"));
        Element crosstabRows = (Element)crosstabElement.selectSingleNode(V5X.select("crosstabRows"));
        String seriesName = ChartElements.legendEdgeName.get(this.getChartElement().getName());
        this.mergeAxes();
        Element seriesElement = (Element)this.getContainerElement().selectSingleNode(V5X.select(seriesName));
        if (seriesElement != null) {
            V5Chart.populateCrosstabEdgeFromChartEdge(v5Crosstab, seriesElement, crosstabRows);
        }
        Element crosstabColumns = (Element)crosstabElement.selectSingleNode(V5X.select("crosstabColumns"));
        String categoryName = ChartElements.ordinalAxis.get(this.getContainerElement().getName());
        Element categoryElement = (Element)this.getContainerElement().selectSingleNode(V5X.select(categoryName));
        if (categoryElement != null) {
            V5Chart.populateCrosstabEdgeFromChartEdge(v5Crosstab, categoryElement, crosstabColumns);
        }
        XMLUtility.cloneChildNode(crosstabElement, this.getContainerElement(), "masterDetailLinks");
        this.copySuppressionFromChart(crosstabElement);
        XMLUtility.cloneChildNode(crosstabElement, this.getContainerElement(), "noDataHandler");
        ArrayList<Element> chartElements = new ArrayList<Element>();
        chartElements.add(this.getContainerElement());
        Collection<String> measures = V5Chart.collectMeasures(chartElements);
        if (measures.size() == 1) {
            Element dataFormat = this.getDefaultMeasureDataFormat();
            if (dataFormat != null) {
                dataFormat = (Element)dataFormat.clone();
            }
            v5Crosstab.setDefaultMeasureForCrosstab(measures.iterator().next(), dataFormat);
        } else if (measures.size() > 1) {
            Element crosstabEdgeRoot = this.getCrosstabEdgeToAddMeasures(v5Crosstab.getContainerElement());
            for (String measure : measures) {
                v5Crosstab.insertCrosstabNodeOfRDI(measure, null, crosstabEdgeRoot);
            }
        }
        Element parent = this.getContainerElement().getParent();
        int chartIndex = parent.indexOf((Node)this.getContainerElement());
        parent.content().add(chartIndex, crosstabElement);
        this.getContainerElement().detach();
        V5SpecHelper.removeLeafNodesByName(crosstabElement, "crosstabColumns");
        V5SpecHelper.removeLeafNodesByName(crosstabElement, "crosstabRows");
        return crosstabElement;
    }

    private void mergeAxes() {
        if (this.getChartElement().getName().equals("v2_combinationChart")) {
            Element topLeftAxis = V5X.selectSingleNode(this.getChartElement(), "v2_topLeftAxis");
            Element chartNodesParent = V5X.selectSingleNode(topLeftAxis, "v2_line", "//V5X//OR", "v2_bar", "//V5X//OR", "v2_area");
            if (chartNodesParent == null) {
                return;
            }
            Element chartNodesTopLeftAxis = DocumentHelper.makeElement((Branch)chartNodesParent, (String)"chartNodes");
            List extraAxes = V5X.selectNodes(this.getChartElement(), "v2_topRightAxis", "//V5X//OR", "v2_bottomLeftAxis", "//V5X//OR", "v2_bottomRightAxis");
            for (Element extraAxis : extraAxes) {
                Element chartNodes = V5X.selectSingleNode(extraAxis, "chartNodes");
                if (chartNodes == null) continue;
                for (Element chartNode : chartNodes.elements()) {
                    chartNodesTopLeftAxis.add(chartNode.createCopy());
                }
            }
            if (chartNodesTopLeftAxis.elements().size() == 0) {
                chartNodesTopLeftAxis.detach();
            }
        }
    }

    private Element getInsertionPointInCrosstab(Element crosstabElement, boolean isColumn) {
        String edgeElementName = isColumn ? "crosstabColumns" : "crosstabRows";
        Element crosstabEdgeElement = (Element)crosstabElement.selectSingleNode(V5X.select(edgeElementName));
        if (crosstabEdgeElement == null) {
            crosstabEdgeElement = crosstabElement.addElement(edgeElementName);
        }
        if (crosstabEdgeElement.element("crosstabNode") != null) {
            Element crosstabNestedNodes = V5SpecHelper.getInnerMostNestedCrosstabNodes(crosstabEdgeElement);
            Element nodeToAppend = crosstabNestedNodes == null ? crosstabEdgeElement : crosstabNestedNodes;
            return DocumentHelper.makeElement((Branch)nodeToAppend, (String)"crosstabNode/crosstabNestedNodes");
        }
        return crosstabEdgeElement;
    }

    public static void populateCrosstabEdgeFromChartEdge(V5Crosstab v5Crosstab, Element chartRoot, Element crosstabRoot) {
        ArrayList chartNodeElements = new ArrayList();
        if ("chartNestedNodes".equals(chartRoot.getName())) {
            chartNodeElements.addAll(chartRoot.elements("chartNode"));
        } else {
            List chartNodesElements = V5X.selectNodes(chartRoot, "chartNodes");
            for (Element chartNodes : chartNodesElements) {
                chartNodeElements.addAll(chartNodes.elements("chartNode"));
            }
        }
        for (Element chartNode : chartNodeElements) {
            Element chartNestedNodes;
            List chartNodeMemberElments = V5X.selectNodes(chartNode, "//V5X//CHILD", "chartNodeMembers", "chartNodeMember");
            Element crosstabNode = null;
            if (chartNodeMemberElments.size() > 0) {
                crosstabNode = V5Chart.createCrosstabNodeFromChartNode(v5Crosstab, chartNodeMemberElments, crosstabRoot);
            }
            if ((chartNestedNodes = chartNode.element("chartNestedNodes")) == null) continue;
            Element crosstabNestedNodes = DocumentHelper.makeElement((Branch)crosstabNode, (String)"crosstabNestedNodes");
            V5Chart.populateCrosstabEdgeFromChartEdge(v5Crosstab, chartNestedNodes, crosstabNestedNodes);
            if (crosstabNestedNodes.elements().size() != 0) continue;
            crosstabNestedNodes.detach();
        }
    }

    private static Collection<String> collectMeasures(List<Element> chartElements) {
        ArrayList<String> measureElements = new ArrayList<String>();
        for (Element originalChartElement : chartElements) {
            Element chartElement = (Element)originalChartElement.clone();
            String[] measures = ChartElements.measureNames.get(chartElement.getName());
            for (int i = 0; i < measures.length; ++i) {
                Element measureElement = (Element)chartElement.selectSingleNode(V5X.select(measures[i]));
                if (measureElement == null) continue;
                measureElements.add(measureElement.attributeValue("refDataItem"));
                measureElement.detach();
            }
        }
        return measureElements;
    }

    public static List<Element> collectMeasureElements(Element chartElement) {
        String[] measures = ChartElements.measureNames.get(chartElement.getName());
        if (measures != null) {
            StringBuilder xPath = new StringBuilder(".//*[local-name()='").append(measures[0]);
            for (int i = 1; i < measures.length; ++i) {
                xPath.append("' or local-name()='").append(measures[i]);
            }
            xPath.append("']");
            return XMLUtility.selectNodes(chartElement, xPath.toString());
        }
        return null;
    }

    public List<Element> collectMeasureElements(ActionEnv env) throws ActionException {
        this.actionEnv = env;
        ArrayList<Element> measures = new ArrayList<Element>();
        List chartNodeMemberElements = V5X.selectNodes(this._container, "chartNodeMember");
        for (Element chartNodeMember : chartNodeMemberElements) {
            String rdi = chartNodeMember.attributeValue("refDataItem");
            if (rdi == null) continue;
            Element dataItem = this.getV5Query().findItem(rdi);
            V5QueryItem queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), dataItem);
            if (!queryItem.confirmIsNumeric()) continue;
            measures.add(chartNodeMember);
        }
        measures.addAll(V5Chart.collectMeasureElements(this._container));
        return measures;
    }

    private static Element createCrosstabNodeFromChartNode(V5Crosstab v5Crosstab, List<Element> chartNodeMemberElments, Element crosstabRoot) {
        Element crosstabNode = crosstabRoot.addElement("crosstabNode");
        Element crosstabNodeMembers = crosstabNode.addElement("crosstabNodeMembers");
        for (Element chartNodeMember : chartNodeMemberElments) {
            V5Chart.createCrosstabNodeMemberFromChartNodeMember(v5Crosstab, chartNodeMember, crosstabNodeMembers);
        }
        return crosstabNode;
    }

    private static void createCrosstabNodeMemberFromChartNodeMember(V5Crosstab v5Crosstab, Element chartNodeMember, Element crosstabNodeMembers) {
        Element indentationElement;
        Element xmlAttributes;
        Element crosstabNodeMember = crosstabNodeMembers.addElement("crosstabNodeMember");
        crosstabNodeMember.addAttribute("refDataItem", chartNodeMember.attributeValue("refDataItem"));
        crosstabNodeMember.addAttribute("edgeLocation", v5Crosstab.nextFreeEdge());
        List chartTextItems = V5X.selectNodes(chartNodeMember, "//V5X//CHILD", "chartContents", "chartTextItem");
        Element contents = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"contents");
        for (Element chartTextItem : chartTextItems) {
            contents.add(chartTextItem.createCopy(new QName("textItem", chartNodeMember.getNamespace())));
        }
        XMLUtility.cloneChildNode(crosstabNodeMember, chartNodeMember, "sortList");
        XMLUtility.cloneChildNode(crosstabNodeMember, chartNodeMember, "propertyList");
        Element style = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"style");
        Element defaultStyle = DocumentHelper.makeElement((Branch)style, (String)"defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "ml");
        Element dataFormatOfChartNodeMember = V5X.selectSingleNode(chartNodeMember, "//V5X//CHILD", "style", "dataFormat");
        if (dataFormatOfChartNodeMember != null) {
            style = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)V5X.getMakeElementPath("factCell", "style"));
            style.add((Element)dataFormatOfChartNodeMember.clone());
        }
        if ((xmlAttributes = chartNodeMember.element("XMLAttributes")) != null) {
            crosstabNodeMember.add(xmlAttributes.createCopy());
        }
        if ((indentationElement = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "indentation")) == null) {
            indentationElement = crosstabNodeMember.addElement("indentation");
            indentationElement.addAttribute("type", "relative");
            indentationElement.addAttribute("indentationLength", "20");
        }
    }

    private void copySuppressionFromChart(Element crosstabElement) {
        Element chartSuppress = this.getContainerElement().element("chartSuppress");
        if (chartSuppress == null) {
            return;
        }
        Element crosstabSuppress = (Element)chartSuppress.clone();
        crosstabSuppress.setQName(new QName("crosstabSuppress", crosstabElement.getNamespace()));
        crosstabElement.add(crosstabSuppress);
        String type = crosstabSuppress.attributeValue("type");
        if ("categoriesAndSeries".equals(type)) {
            type = "rowsAndColumns";
        } else if ("series".equals(type)) {
            type = "rows";
        } else if ("categories".equals(type)) {
            type = "columns";
        }
        crosstabSuppress.addAttribute("type", type);
    }

    private Element getCrosstabEdgeToAddMeasures(Element crosstab) {
        Element columns = V5X.selectSingleNode(crosstab, "crosstabColumns");
        if (V5X.selectSingleNode(columns, "crosstabNode") == null) {
            return columns;
        }
        Element rows = V5X.selectSingleNode(crosstab, "crosstabRows");
        if (V5X.selectSingleNode(rows, "crosstabNode") == null) {
            return rows;
        }
        return this.getInsertionPointInCrosstab(crosstab, true);
    }

    public void swapEdges() {
        Element nOrdinalEdge;
        String chartName = this._container.getName();
        if (chartName.equals("combinationChart") || chartName.equals("threeDCombinationChart") || chartName.equals("metricsChart")) {
            Element eOrdinalNodes = V5X.selectSingleNode(this._container, "//V5X//CHILD", "commonClusters", "chartNodes");
            List elComboPieces = XMLUtility.selectNodes(this._container, "*[local-name()='combinationChartTypes' or local-name()='threeDCombinationChartTypes']/*");
            Element eComboPiece = (Element)this._container.selectSingleNode("*[local-name()='combinationChartTypes' or local-name()='threeDCombinationChartTypes']/*");
            int noOfComboPieces = elComboPieces.size();
            if (noOfComboPieces > 0) {
                if (eOrdinalNodes != null) {
                    eOrdinalNodes.detach();
                }
                Element ordinalEdge = DocumentHelper.makeElement((Branch)this._container, (String)"commonClusters/chartNodes");
                for (Element piece : elComboPieces) {
                    List chartNodeList = V5X.selectNodes(piece, "//V5X//CHILD", "chartNodes", "chartNode");
                    for (Element eChartNode : chartNodeList) {
                        ordinalEdge.add(eChartNode.detach());
                    }
                    piece.detach();
                }
            }
            Element eLegendEdge = DocumentHelper.makeElement((Branch)this._container, (String)(chartName.equals("metricsChart") ? "combinationChartTypes" : chartName + "Types"));
            if (eOrdinalNodes != null) {
                if (eComboPiece != null) {
                    eComboPiece.remove(eComboPiece.element("chartNodes"));
                    eComboPiece = (Element)eComboPiece.clone();
                    eLegendEdge.add(eComboPiece);
                } else {
                    eComboPiece = eLegendEdge.addElement(chartName.equals("combinationChart") ? "bar" : "threeDBar");
                }
                if (eOrdinalNodes.getParent() != null) {
                    eOrdinalNodes.detach();
                }
                eComboPiece.add(eOrdinalNodes);
            } else if (elComboPieces.size() > 0) {
                eLegendEdge.add(V5SpecHelper.shallowCopy(eComboPiece));
            }
            String leafChartNodesXPath = "./*[local-name()='commonClusters']/*[local-name()='chartNodes' and not(*)]";
            Node leafChartNodes = this._container.selectSingleNode(leafChartNodesXPath);
            if (leafChartNodes != null) {
                leafChartNodes.getParent().detach();
            }
            V5SpecHelper.removeLeafNodesByName(this._container, chartName + "Types");
        } else if (chartName.equals("v2_combinationChart")) {
            Element nOrdinalNodes = V5X.selectSingleNode(this._container, ChartElements.ordinalAxis.get(chartName), "//V5X//CHILD", "chartNodes");
            List nlComboPieces = V5X.selectNodes(this._container, "v2_combinationChartTypes", "//V5X//CHILD", "//V5X//ANYCHILD");
            Element nComboPiece = V5X.selectSingleNode(this._container, "v2_combinationChartTypes", "//V5X//CHILD", "//V5X//ANYCHILD");
            List nComboPieceNodes = V5X.selectNodes(this._container, "v2_combinationChartTypes", "//V5X//CHILD", "//V5X//ANYCHILD", "chartNodes", "chartNode");
            ArrayList<Element> aComboNodes = new ArrayList<Element>();
            for (Element eComboPieceNode : nComboPieceNodes) {
                aComboNodes.add((Element)eComboPieceNode.clone());
            }
            if (nOrdinalNodes != null) {
                Object nChartNodes;
                if (nOrdinalNodes.getParent() != null) {
                    nOrdinalNodes.detach();
                }
                if ((nChartNodes = V5X.selectNodes(nOrdinalNodes, "//V5X//CHILD", "chartNode")).size() == nlComboPieces.size()) {
                    for (int i = 0; i < nChartNodes.size(); ++i) {
                        Element nChartNodeElement = (Element)nChartNodes.get(i);
                        Element nComboPieceElement = (Element)nlComboPieces.get(i);
                        Element chartNodes2 = DocumentHelper.makeElement((Branch)nComboPieceElement, (String)"chartNodes");
                        nChartNodeElement.detach();
                        chartNodes2.add(nChartNodeElement);
                    }
                } else {
                    String removeNodes_XPath = V5X.selectImmediateChildren("chartNodes");
                    V5SpecHelper.removeNodes(nComboPiece, removeNodes_XPath);
                    nComboPiece.add(nOrdinalNodes);
                }
            }
            for (Element eComboPieceNode : nComboPieceNodes) {
                eComboPieceNode.detach();
            }
            if (nlComboPieces.size() > 0) {
                nOrdinalEdge = DocumentHelper.makeElement((Branch)this._container, (String)ChartElements.ordinalAxis.get(chartName));
                V5SpecHelper.removeNodes(nOrdinalEdge, V5X.selectImmediateChildren("chartNodes"));
                Element nNewOrdinalNodes = nOrdinalEdge.addElement("chartNodes");
                for (Element comboNode : aComboNodes) {
                    nNewOrdinalNodes.add(comboNode);
                }
            }
            String xPath = V5X.selectImmediateChildren(ChartElements.ordinalAxis.get(chartName)) + "/*[local-name()='" + "chartNodes" + "' and not(*)]";
            V5SpecHelper.removeNodes(this._container, xPath);
            xPath = V5X.selectPath("//V5X//ANYCHILD", "v2_combinationChartTypes", "//V5X//ANYCHILD", "chartNodes") + "[not(*)]";
            V5SpecHelper.removeNodes(this._container, xPath);
            xPath = V5X.selectPath("//V5X//ANYCHILD", "v2_combinationChartTypes") + "[not(*)]";
            V5SpecHelper.removeNodes(this._container, xPath);
        } else if ("v2_gaugeChart".equals(chartName)) {
            List nlLegendNodes = V5X.selectNodes(this._container, ChartElements.legendEdgeName.get(chartName), "//V5X//CHILD", "chartNodes");
            Element nGaugeOrdinalNode = V5X.selectSingleNode(this._container, ChartElements.ordinalAxis.get(chartName), "//V5X//CHILD", "chartNodes");
            if (nlLegendNodes.size() > 0) {
                Element nOrdinalEdge2 = DocumentHelper.makeElement((Branch)this._container, (String)ChartElements.ordinalAxis.get(chartName));
                for (Element eLegendNode : nlLegendNodes) {
                    nOrdinalEdge2.add(eLegendNode.detach());
                }
            }
            if (nGaugeOrdinalNode != null) {
                Element nGaugeNeedle = V5X.selectSingleNode(this._container, ChartElements.legendEdgeName.get(chartName));
                nGaugeNeedle.add(nGaugeOrdinalNode.detach());
            }
        } else if ("v2_paretoChart".equals(chartName)) {
            Element eParetoNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", "v2_paretoBars", "//V5X//CHILD", "chartNodes");
            Element eAxisNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", "v2_commonAxis", "//V5X//CHILD", "chartNodes");
            if (eParetoNode != null && eAxisNode != null) {
                Element eAxisEdge = DocumentHelper.makeElement((Branch)this._container, (String)"v2_commonAxis");
                eAxisEdge.add(eParetoNode.detach());
                Element eParetoEdge = DocumentHelper.makeElement((Branch)this._container, (String)"v2_paretoBars");
                eParetoEdge.add(eAxisNode.detach());
            }
        } else {
            Element eOrdinalChild;
            Element eLegendChild;
            String sOrdinalAxis = ChartElements.ordinalAxis.get(chartName);
            String sLegendEdgeName = ChartElements.legendEdgeName.get(chartName);
            Element eLegendNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", sLegendEdgeName);
            Element eLegendChartNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", sLegendEdgeName, "//V5X//CHILD", "chartNodes");
            Element eOrdinalNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", sOrdinalAxis);
            Element eOrdinalChartNode = V5X.selectSingleNode(this._container, "//V5X//CHILD", sOrdinalAxis, "//V5X//CHILD", "chartNodes");
            if (eLegendChartNode != null) {
                Element eOrdinalEdge = DocumentHelper.makeElement((Branch)this._container, (String)sOrdinalAxis);
                eOrdinalEdge.add(eLegendChartNode.detach());
            }
            if (eOrdinalChartNode != null) {
                Element eLegendEdge = DocumentHelper.makeElement((Branch)this._container, (String)sLegendEdgeName);
                eLegendEdge.add(eOrdinalChartNode.detach());
            }
            if (eLegendNode != null && (eLegendChild = V5X.selectSingleNode(eLegendNode, "//V5X//ANYCHILD")) == null) {
                eLegendNode.detach();
            }
            if (eOrdinalNode != null && (eOrdinalChild = V5X.selectSingleNode(eOrdinalNode, "//V5X//ANYCHILD")) == null) {
                eOrdinalNode.detach();
            }
        }
        Element eMatrixColumns = V5X.selectSingleNode(this._container, "v2_matrix", "//V5X//CHILD", "v2_matrixColumns");
        Element eMatrixRows = V5X.selectSingleNode(this._container, "v2_matrix", "//V5X//CHILD", "v2_matrixRows");
        boolean bSeriesMatrix = ChartElements.seriesEdgeIsMatrix.contains(chartName);
        boolean bOrdinalMatrix = ChartElements.ordinalEdgeIsMatrix.contains(chartName);
        if (eMatrixColumns != null || eMatrixRows != null) {
            boolean bSwapMatrix = true;
            if (bSeriesMatrix && !bOrdinalMatrix || !bSeriesMatrix && bOrdinalMatrix) {
                bSwapMatrix = false;
            }
            if (bSwapMatrix) {
                if (eMatrixColumns != null) {
                    this.swapMatrixEdges(eMatrixColumns, "v2_matrixRows", "v2_matrixColumnLabels", "v2_matrixRowLabels");
                }
                if (eMatrixRows != null) {
                    this.swapMatrixEdges(eMatrixRows, "v2_matrixColumns", "v2_matrixRowLabels", "v2_matrixColumnLabels");
                }
            }
        }
        if (bSeriesMatrix && !bOrdinalMatrix || !bSeriesMatrix && bOrdinalMatrix) {
            Element nSeriesEdge = V5X.selectSingleNode(this._container, ChartElements.legendEdgeName.get(chartName), "//V5X//ANY", "chartNodes");
            nOrdinalEdge = V5X.selectSingleNode(this._container, ChartElements.ordinalAxis.get(chartName), "//V5X//ANY", "chartNodes");
            if (eMatrixColumns == null && bOrdinalMatrix && nOrdinalEdge != null) {
                this.processV2CategoryAndV2Matrix(this._container);
            }
            if (eMatrixRows == null && bSeriesMatrix && nSeriesEdge != null) {
                this.processV2SeriesAndV2Matrix(this._container);
            }
            this.fixMatrixLevels(this._container);
        }
        SwapRowsAndColumnsHelper.puffChart(this._container);
    }

    private void processV2CategoryAndV2Matrix(Element eChartNode) {
        Element nMatrixColumns = DocumentHelper.makeElement((Branch)eChartNode, (String)"v2_matrix/v2_matrixColumns");
        nMatrixColumns.addAttribute("matrixLevels", "1");
        this.addMatrixLabels(nMatrixColumns.getParent(), "v2_matrixColumns", "v2_matrixColumnLabels");
        this.createV2AxisTitle(nMatrixColumns);
    }

    private void processV2SeriesAndV2Matrix(Element nChart) {
        Element nMatrixRows = DocumentHelper.makeElement((Branch)nChart, (String)"v2_matrix/v2_matrixRows");
        nMatrixRows.addAttribute("matrixLevels", "1");
        this.addMatrixLabels(nMatrixRows.getParent(), "v2_matrixRows", "v2_matrixRowLabels");
        this.createV2AxisTitle(nMatrixRows);
    }

    private Element createV2AxisTitle(Element chartNode) {
        Element nTitle = DocumentHelper.makeElement((Branch)chartNode, (String)"v2_axisTitle");
        this.setClass(nTitle, "at");
        if (!ChartElements.singleEdgeMatrixCharts.contains(chartNode.getName())) {
            chartNode = V5SpecHelper.getAncestor(chartNode, ChartElements.singleEdgeMatrixCharts);
        }
        nTitle.addAttribute("refQuery", chartNode.attributeValue("refQuery"));
        Element nChartTextContents = nTitle.addElement("v2_chartTextContents");
        nChartTextContents.addElement("v2_automaticText");
        return nTitle;
    }

    private void addMatrixLabels(Element nMatrix, String sParent, String sLabels) {
        Element nParent = DocumentHelper.makeElement((Branch)nMatrix, (String)sParent);
        Element nLabels = DocumentHelper.makeElement((Branch)nParent, (String)sLabels);
        this.setClass(nLabels, "al");
    }

    private void setClass(Element elem, String sClass) {
        Element nStyle = DocumentHelper.makeElement((Branch)elem, (String)"style");
        Element nDefaultStyles = DocumentHelper.makeElement((Branch)nStyle, (String)"defaultStyles");
        V5SpecHelper.removeNodes(nDefaultStyles, "*");
        Element nDefaultStyle = nDefaultStyles.addElement("defaultStyle");
        nDefaultStyle.addAttribute("refStyle", sClass);
    }

    private void fixMatrixLevels(Element nChartNode) {
        if (!ChartElements.singleEdgeMatrixCharts.contains(nChartNode.getName())) {
            return;
        }
        if ("v2_bulletChart".equals(nChartNode.getName())) {
            this.adjustBulletMatrixLevels(this._container);
        } else {
            Element nMatrixColumns;
            Element nMatrixRows = V5X.selectSingleNode(this._container, "//V5X//CHILD", "v2_matrix", "v2_matrixRows");
            if (nMatrixRows != null) {
                Element nSeriesEdge = V5X.selectSingleNode(this._container, ChartElements.legendEdgeName.get(nChartNode.getName()), "chartNodes");
                if (nSeriesEdge == null) {
                    V5SpecHelper.removeNode(this._container, "./*[local-name()='v2_matrix']/*[local-name()='v2_matrixRows']");
                } else {
                    int iMatrixLevels;
                    String sMaxRowLevel = this.getMaxSeriesLevels(this._container);
                    int iMaxRowLevel = sMaxRowLevel == null ? -1 : Integer.parseInt(sMaxRowLevel);
                    String sMatrixLevels = nMatrixRows.attributeValue("matrixLevels");
                    int n = iMatrixLevels = sMatrixLevels == null ? -1 : Integer.parseInt(sMatrixLevels);
                    if (iMatrixLevels > iMaxRowLevel) {
                        nMatrixRows.addAttribute("matrixLevels", sMaxRowLevel);
                    }
                }
            }
            if ((nMatrixColumns = V5X.selectSingleNode(this._container, "//V5X//CHILD", "v2_matrix", "v2_matrixColumns")) != null) {
                Element nCategoryEdge = V5X.selectSingleNode(this._container, ChartElements.ordinalAxis.get(nChartNode.getName()), "//V5X//CHILD", "chartNodes");
                if (nCategoryEdge == null) {
                    V5SpecHelper.removeNode(this._container, "./*[local-name()='v2_matrix']/*[local-name()='v2_matrixColumns']");
                } else {
                    int matrixLevels;
                    String sMaxColumnLevel = this.getMaxCategoryLevels(this._container);
                    int iMaxColumnLevel = sMaxColumnLevel == null ? -1 : Integer.parseInt(sMaxColumnLevel);
                    String sMatrixLevels = nMatrixColumns.attributeValue("matrixLevels");
                    int n = matrixLevels = sMatrixLevels == null ? -1 : Integer.parseInt(sMatrixLevels);
                    if (matrixLevels > iMaxColumnLevel) {
                        nMatrixColumns.addAttribute("matrixLevels", sMaxColumnLevel);
                    }
                }
            }
            V5SpecHelper.removeLeafNodesByName(this._container, "v2_matrix");
        }
    }

    private void adjustBulletMatrixLevels(Element nChartNode) {
        if ("v2_bulletChart".equals(nChartNode.getName())) {
            Element nMatrixColumns;
            Element nMatrixRows = V5X.selectSingleNode(nChartNode, "//V5X//CHILD", "v2_matrix", "v2_matrixRows");
            if (nMatrixRows != null) {
                Element nSeriesEdge = V5X.selectSingleNode(nChartNode, ChartElements.legendEdgeName.get(nChartNode.getName()), "//V5X//CHILD", "chartNodes");
                if (nSeriesEdge == null) {
                    String v2_matrixRows = V5X.selectPath("//V5X//CHILD", "v2_matrix", "v2_matrixRows");
                    V5SpecHelper.removeNode(this._container, v2_matrixRows);
                } else {
                    nMatrixRows.addAttribute("matrixLevels", this.getMaxSeriesLevels(nChartNode));
                }
            }
            if ((nMatrixColumns = V5X.selectSingleNode(nChartNode, "//V5X//CHILD", "v2_matrix", "v2_matrixColumns")) != null) {
                Element nCategoryEdge = V5X.selectSingleNode(this._container, ChartElements.ordinalAxis.get(nChartNode.getName()), "//V5X//CHILD", "chartNodes");
                if (nCategoryEdge == null) {
                    String v2_MatrixColumns = V5X.selectPath("//V5X//CHILD", "v2_matrix", "v2_matrixColumns");
                    V5SpecHelper.removeNode(this._container, v2_MatrixColumns);
                } else {
                    nMatrixColumns.addAttribute("matrixLevels", this.getMaxCategoryLevels(nChartNode));
                }
            }
        }
    }

    private String getMaxCategoryLevels(Element _container1) {
        List nRootNodes = V5X.selectNodes(_container1, ChartElements.ordinalAxis.get(this._container.getName()));
        return this.getMaxMatrixLevels(nRootNodes);
    }

    private String getMaxSeriesLevels(Element _container1) {
        List nRootNodes = V5X.selectNodes(_container1, ChartElements.legendEdgeName.get(this._container.getName()));
        return this.getMaxMatrixLevels(nRootNodes);
    }

    private String getMaxMatrixLevels(List<Element> rootNodes) {
        int nDefault;
        int nMaxLevels = nDefault = 99999;
        ArrayList<Integer> aLevels = new ArrayList<Integer>();
        for (Element node : rootNodes) {
            List nlChartNodes = XMLUtility.selectNodes(node, ".//*[local-name()='chartNode' ][ not(*[local-name()='chartNestedNodes']/*)]/*[local-name()='chartNodeMembers']/*");
            for (Element chartNode : nlChartNodes) {
                int iCount = V5SpecHelper.getAncestors(chartNode, "chartNestedNodes").size();
                aLevels.add(new Integer(iCount));
            }
            if (aLevels.isEmpty()) continue;
            Collections.sort(aLevels);
            Integer i = (Integer)aLevels.get(0);
            nMaxLevels = Math.min(i + 1, nMaxLevels);
        }
        if (nMaxLevels == nDefault) {
            nMaxLevels = 1;
        }
        Integer result = new Integer(nMaxLevels);
        return result.toString();
    }

    private void swapMatrixEdges(Element eCurrentEdge, String sNewEdge, String currentEdgeLabels, String newEdgeLabels) {
        Element eCurrentEdgeLabels;
        Element eMatrix = V5X.selectSingleNode(this._container, "v2_matrix");
        Element eNewEdge = eMatrix.addElement(sNewEdge);
        V5SpecHelper.copyAttributes(eNewEdge, eCurrentEdge);
        Element eCurrentEdgeTitle = V5X.selectSingleNode(eCurrentEdge, "//V5X//CHILD", "v2_axisTitle");
        if (eCurrentEdgeTitle != null) {
            eNewEdge.add(eCurrentEdgeTitle.detach());
        }
        if ((eCurrentEdgeLabels = V5X.selectSingleNode(eCurrentEdge, "//V5X//CHILD", currentEdgeLabels)) != null) {
            Element eNewEdgeLabels = eNewEdge.addElement(newEdgeLabels);
            V5SpecHelper.copyAttributes(eNewEdgeLabels, eCurrentEdgeLabels);
            Element eStyle = V5X.selectSingleNode(eCurrentEdgeLabels, "//V5X//CHILD", "style");
            if (eStyle != null) {
                eNewEdgeLabels.add(eStyle.detach());
            }
        }
        eCurrentEdge.detach();
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element chartNodeMember, String startNodeHUN) throws ActionException {
        Element parentNodeMember;
        if (this._nestedLocationWithSameHUN != null) {
            return this._nestedLocationWithSameHUN;
        }
        this._nestedLocationWithSameHUN = new ArrayList<Element>();
        Element chartNode = V5SpecHelper.getAncestor(chartNodeMember, "chartNode");
        Element chartNestedNodeOrAxis = (Element)chartNode.selectSingleNode(V5X.select("chartNestedNodes") + "[not(" + V5X.select("chartNestedNodes") + ")]");
        if (chartNestedNodeOrAxis != null) {
            Element detailChartNode = V5X.selectSingleNode(chartNestedNodeOrAxis, "//V5X//CHILD", "chartNode", "chartNodeMembers", "chartNodeMember");
            if (detailChartNode != null && this.hasSameHUN(v5Query, detailChartNode, startNodeHUN)) {
                this._nestedLocationWithSameHUN.add(detailChartNode);
            }
        } else {
            this._nestedLocationWithSameHUN.add(chartNodeMember);
            chartNestedNodeOrAxis = V5SpecHelper.getAncestor(chartNodeMember, "chartNode").getParent();
        }
        while ("chartNestedNodes".equals(chartNestedNodeOrAxis.getName()) && (parentNodeMember = V5X.selectSingleNode(chartNestedNodeOrAxis.getParent(), "//V5X//CHILD", "chartNodeMembers", "chartNodeMember")) != null) {
            if (!this.hasSameHUN(v5Query, parentNodeMember, startNodeHUN)) {
                chartNestedNodeOrAxis = V5SpecHelper.getAncestor(parentNodeMember, "chartNode").getParent();
                continue;
            }
            this._nestedLocationWithSameHUN.add(parentNodeMember);
            chartNestedNodeOrAxis = V5SpecHelper.getAncestor(parentNodeMember, "chartNode").getParent();
        }
        return this._nestedLocationWithSameHUN;
    }

    private boolean hasSameHUN(V5Query v5Query, Element chartNode, String sHUN) {
        V5QueryItem queryItem = new V5QueryItem(this.getActionEnv(), v5Query, v5Query.findItem(chartNode.attributeValue("refDataItem")));
        return sHUN.equals(queryItem.getProperties()._hun);
    }

    @Override
    public List<Element> findPotentialChartSummaryNodes(Element layoutNode, String itemName) {
        Element chartNode = V5SpecHelper.getAncestor(layoutNode, "chartNode");
        if (chartNode == null) {
            return null;
        }
        return V5X.selectNodes(chartNode, "//V5X//CHILD", "chartNodeMembers", "chartNodeMember", "//V5X//EXCEPT_ATTR", "refDataItem", itemName);
    }
}

