/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.DynamicDataFilterResetter;
import com.cognos.rap.actions.DynamicDiscreteValuesFilter;
import com.cognos.rap.actions.FilterableItemsInfo;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class V5ContextSlicer {
    public static List<Element> findContextSlicers(Element documentOrQuery) {
        List contextSlicers = "query".equals(documentOrQuery.getName()) ? V5X.selectNodes(documentOrQuery, "//V5X//CHILD", "slicer", "contextSlice") : V5X.selectNodes(documentOrQuery, "//V5X//CHILD", "queries", "query", "slicer", "contextSlice");
        return contextSlicers == null ? new ArrayList() : contextSlicers;
    }

    public static List<Element> findDynamicContextSlicers(Element documentOrQuery) {
        ArrayList<Element> dynamicContextSlicers = new ArrayList<Element>();
        List<Element> contextSlicers = V5ContextSlicer.findContextSlicers(documentOrQuery);
        for (Element contextSlicer : contextSlicers) {
            if (!SliderInfo.exists(contextSlicer)) continue;
            dynamicContextSlicers.add(contextSlicer);
        }
        return dynamicContextSlicers;
    }

    public static Element findDynamicContextSlicer(Element docOrQuery, String clientID) {
        for (Element dynamicSlicer : V5ContextSlicer.findDynamicContextSlicers(docOrQuery)) {
            if (!clientID.equals(SliderInfo.getClientId(dynamicSlicer))) continue;
            return dynamicSlicer;
        }
        return null;
    }

    public static Element findSlicerForDynamicFiltering(V5Query query, DynamicDataFilter dynamicDataFilter) {
        List<Element> contextSlicers = V5ContextSlicer.findContextSlicers(query.getQueryElement());
        for (Element contextSlicer : contextSlicers) {
            if (!SliderInfo.exists(contextSlicer) || !dynamicDataFilter.getClientId().equals(SliderInfo.getClientId(contextSlicer))) continue;
            return contextSlicer;
        }
        for (Element contextSlicer : contextSlicers) {
            String HUN;
            if (V5ContextSlicer.isContextSlicerName(contextSlicer, dynamicDataFilter.getRDIName())) {
                return contextSlicer;
            }
            if (!dynamicDataFilter.isFacet() || !(HUN = V5ContextSlicer.getContextSlicerHUN(contextSlicer)).endsWith(".[" + dynamicDataFilter.getRDIName() + "]")) continue;
            return contextSlicer;
        }
        return null;
    }

    public static String getContextSlicerName(Element contextSlice) {
        if ("contextSlice".equals(contextSlice.getName())) {
            Element contextLUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmLevel", "LUN");
            if (contextLUN == null) {
                Element contextHUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmHierarchy", "HUN");
                return contextHUN == null ? "" : contextHUN.getParent().elementText("itemCaption");
            }
            return contextLUN.getParent().elementText("itemCaption");
        }
        return "";
    }

    public static String getContextSlicerHUN(Element contextSlice) {
        if ("contextSlice".equals(contextSlice.getName())) {
            Element contextHUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmHierarchy", "HUN");
            return contextHUN == null ? "" : contextHUN.getText();
        }
        return "";
    }

    public static String getContextSlicerLUN(Element contextSlice) {
        if ("contextSlice".equals(contextSlice.getName())) {
            Element contextLUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmLevel", "LUN");
            return contextLUN == null ? "" : contextLUN.getText();
        }
        return "";
    }

    public static boolean isContextSlicerName(Element contextSlice, String rdi) {
        String captionHUN;
        String captionLUN;
        Element contextLUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmLevel", "LUN");
        if (contextLUN != null && (captionLUN = contextLUN.getParent().elementText("itemCaption")) != null && captionLUN.equals(rdi)) {
            return true;
        }
        Element contextHUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmHierarchy", "HUN");
        return contextHUN != null && (captionHUN = contextHUN.getParent().elementText("itemCaption")) != null && captionHUN.equals(rdi);
    }

    public static List<Element> getMembers(Element contextSlicer) {
        List slicerMembers = V5X.selectNodes(contextSlicer, "//V5X//CHILD", "contextSliceDefinition", "dmMembers", "dmMember");
        return slicerMembers == null ? new ArrayList() : slicerMembers;
    }

    public static void updateDynamicSlicerIfApplicable(V5Query query, DynamicDiscreteValuesFilter dynamicDataFilter) {
        Element contextSlicer = V5ContextSlicer.findSlicerForDynamicFiltering(query, dynamicDataFilter);
        if (contextSlicer == null && dynamicDataFilter.isFacet()) {
            contextSlicer = V5ContextSlicer.restoreFacet(query.getQueryElement(), dynamicDataFilter.getClientId());
        }
        if (contextSlicer != null || SliderInfo.exists(contextSlicer)) {
            dynamicDataFilter.generateV5Slicer(contextSlicer);
        }
    }

    public static void updateDynamicContextSlicer(Element contextSlicer, String controlType, String clientID, List<DynamicDiscreteValuesFilter.ParmValue> parmValues) {
        if (parmValues.size() == 0 || parmValues.size() == 1 && parmValues.get(0).getUseValueAttribute() == null) {
            return;
        }
        SliderInfo.saveInitial(contextSlicer, false);
        Element contextSliceDefinition = contextSlicer.element("contextSliceDefinition");
        if (contextSliceDefinition != null) {
            String firstMun = V5X.selectSingleNode(contextSlicer, "dmMember").elementText("MUN");
            contextSliceDefinition.detach();
            contextSliceDefinition = contextSlicer.addElement("contextSliceDefinition");
            if (parmValues.size() > 0) {
                Element dmMembers = contextSliceDefinition.addElement("dmMembers");
                for (DynamicDiscreteValuesFilter.ParmValue choice : parmValues) {
                    Element dmMember = dmMembers.addElement("dmMember");
                    Element MUN = dmMember.addElement("MUN");
                    MUN.setText(V5ContextSlicer.getV5Mun(controlType, firstMun, choice.getUseValueAttribute()));
                    Element itemCaption = dmMember.addElement("itemCaption");
                    itemCaption.setText(choice.getDisplayValueAttribute());
                }
            }
        }
        SliderInfo.saveCurrent(contextSlicer);
        SliderInfo.saveDescriptor(contextSlicer, SliderInfo.getControlTypeId(controlType), clientID);
    }

    private static String getV5Mun(String controlType, String firstMun, String useValue) {
        String[] v5MunLHRH;
        if ("facet".equals(controlType) && firstMun.indexOf("]->:[TM].[") > 0 && useValue.matches("^\\[[^\\]]*\\]\\.\\[[^\\]]*\\]$") && (v5MunLHRH = firstMun.split("\\.\\[@MEMBER\\]")).length == 2) {
            String[] tm1MunLHRH = useValue.split("\\].\\[");
            String v5Mun = v5MunLHRH[0] + ".[@MEMBER].[" + tm1MunLHRH[1];
            return v5Mun;
        }
        return useValue;
    }

    public static boolean removeDynamicContextSlicer(Element query, String sliderClientId) {
        return V5ContextSlicer.removeDynamicContextSlicer(V5ContextSlicer.findDynamicContextSlicer(query, sliderClientId));
    }

    public static boolean removeDynamicContextSlicer(Element contextSlicer) {
        Element initialContextSlicer;
        if (contextSlicer != null && (initialContextSlicer = SliderInfo.loadInitial(contextSlicer)) != null) {
            SliderInfo.removeSliderInfo(contextSlicer);
            Element parent = contextSlicer.getParent();
            contextSlicer.detach();
            parent.add(initialContextSlicer);
            return true;
        }
        return false;
    }

    public static boolean resetFacet(V5Query query, DynamicDataFilterResetter facet) {
        Element contextSlicer = V5ContextSlicer.findDynamicContextSlicer(query.getQueryElement(), facet.getClientId());
        if (contextSlicer != null) {
            if (SliderInfo.exists(contextSlicer)) {
                SliderInfo.saveFacet(contextSlicer, facet.getClientId());
                SliderInfo.removeSliderInfo(contextSlicer);
                if (contextSlicer.getParent().elements().size() == 1) {
                    contextSlicer.getParent().detach();
                }
                contextSlicer.detach();
                return true;
            }
        } else {
            contextSlicer = V5ContextSlicer.findSlicerForDynamicFiltering(query, facet);
            if (contextSlicer != null) {
                SliderInfo.saveFacet(contextSlicer, facet.getClientId());
                if (contextSlicer.getParent().elements().size() == 1) {
                    contextSlicer.getParent().detach();
                }
                contextSlicer.detach();
                return true;
            }
        }
        return false;
    }

    public static Element restoreFacet(Element targetQuery, String clientId) {
        Element contextSlice;
        Element targetSlicers = targetQuery.element("slicer");
        if (targetSlicers == null) {
            targetSlicers = targetQuery.addElement("slicer");
        }
        if ((contextSlice = SliderInfo.restoreFacet(targetSlicers, targetQuery.attributeValue("name"), clientId)) == null && targetSlicers.elements().size() == 0) {
            targetSlicers.detach();
        }
        return contextSlice;
    }

    public static void addFilterableItemForSliders(ActionEnv env, FilterableItemsInfo filterableItems, Element contextSlice, String label) {
        String name = V5ContextSlicer.getContextSlicerName(contextSlice);
        if (name != null) {
            FilterableItemsInfo.FilterableItemInfo filterableItemInfo = filterableItems.add(name, label, false, true);
        }
    }

    protected static String getQueryName(Element contextSlicer) {
        return contextSlicer.getParent().getParent().attributeValue("name");
    }

    public static class SliderInfo {
        public static final String RAP_slicerDefinition = "RAP_slicerDefintion.";
        public static final String RAP_savedFacet = "RAP_savedFacet.";
        public static final String _initial = "initial.";
        public static final String _current = "";
        public static final String _descriptor = "descriptor.";
        private static final char controlTypeID_slider = '0';
        private static final char controlTypeID_checkbox = '1';
        private static final char controlTypeID_facet = '2';

        private static String getContextSlicerXMLAttributeName(Element contextSlicer, String subType) {
            String key = V5ContextSlicer.getContextSlicerLUN(contextSlicer);
            if (key.length() == 0) {
                key = V5ContextSlicer.getContextSlicerHUN(contextSlicer);
            }
            return XMLUtility.encodeXMLAttribute(RAP_slicerDefinition + subType + V5ContextSlicer.getQueryName(contextSlicer) + "." + key);
        }

        private static String getSavedFacetXMLAttributeName(String queryName, String clientId) {
            return XMLUtility.encodeXMLAttribute(RAP_savedFacet + XTSExt.web64encode((String)(queryName + "." + clientId), (boolean)true));
        }

        public static boolean exists(Element contextSlicer) {
            return contextSlicer != null && contextSlicer.getDocument() != null && V5SpecHelper.getXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _current)) != null;
        }

        public static void saveInitial(Element contextSlicer, boolean replaceExisting) {
            if (replaceExisting || !SliderInfo.exists(contextSlicer)) {
                V5SpecHelper.setXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _initial), XTSExt.web64encode((String)contextSlicer.asXML(), (boolean)true), "no");
            }
        }

        public static void saveCurrent(Element contextSlicer) {
            V5SpecHelper.setXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _current), XTSExt.web64encode((String)contextSlicer.asXML(), (boolean)true), "no");
        }

        public static void saveDescriptor(Element contextSlicer, char controlType, String clientId) {
            V5SpecHelper.setXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _descriptor), controlType + clientId, "no");
        }

        public static Element loadInfo(Element contextSlicer, String sliderInfoAttrName) {
            String contextSlicerInfo = V5SpecHelper.getXMLAttribute(contextSlicer.getDocument().getRootElement(), sliderInfoAttrName);
            if (contextSlicerInfo == null) {
                return contextSlicer;
            }
            try {
                return SliderInfo.matchNamespaces(contextSlicer, DocumentHelper.parseText((String)XTSExt.web64decode((String)contextSlicerInfo, (boolean)true)).getRootElement());
            }
            catch (Exception exception) {
                return contextSlicer;
            }
        }

        private static Element matchNamespaces(Element contextSlicer, Element returnValue) {
            List tree = XMLUtility.selectNodes(returnValue, ".//*");
            if (tree != null && tree.size() > 0) {
                for (Element treeNode : tree) {
                    treeNode.remove(treeNode.getNamespace());
                    treeNode.setQName(DocumentHelper.createQName((String)treeNode.getName(), (Namespace)contextSlicer.getNamespace()));
                }
            }
            returnValue.remove(returnValue.getNamespace());
            returnValue.setQName(DocumentHelper.createQName((String)returnValue.getName(), (Namespace)contextSlicer.getNamespace()));
            return returnValue;
        }

        public static Element loadInitial(Element contextSlicer) {
            return SliderInfo.loadInfo(contextSlicer, SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _initial));
        }

        protected static void removeSliderInfo(Element contextSlicer) {
            V5SpecHelper.removeXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _initial));
            V5SpecHelper.removeXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _current));
            V5SpecHelper.removeXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _descriptor));
        }

        private static String getDescriptor(Element contextSlicer) {
            return V5SpecHelper.getXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _descriptor));
        }

        protected static void saveFacet(Element contextSlicer, String clientId) {
            V5SpecHelper.setXMLAttribute(contextSlicer.getDocument().getRootElement(), SliderInfo.getSavedFacetXMLAttributeName(V5ContextSlicer.getQueryName(contextSlicer), clientId), XTSExt.web64encode((String)contextSlicer.asXML(), (boolean)true), "no");
        }

        protected static Element restoreFacet(Element targetSlicerRoot, String queryName, String clientId) {
            Element facetContent = SliderInfo.loadInfo(targetSlicerRoot, SliderInfo.getSavedFacetXMLAttributeName(queryName, clientId));
            if (facetContent != null) {
                targetSlicerRoot.add(facetContent);
                V5SpecHelper.removeXMLAttribute(targetSlicerRoot.getDocument().getRootElement(), SliderInfo.getSavedFacetXMLAttributeName(queryName, clientId));
            }
            return facetContent;
        }

        public static List<String> getResetFacetIDs(Element query) {
            ArrayList<String> results = new ArrayList<String>();
            List xmlAttributes = V5X.selectNodes(query.getDocument().getRootElement(), "//V5X//CHILD", "XMLAttributes", "XMLAttribute");
            if (xmlAttributes != null) {
                String search = RAP_savedFacet + query.attributeValue("name") + ".";
                for (Element xmlAttribute : xmlAttributes) {
                    String savedFacetKey;
                    String savedName = xmlAttribute.attributeValue("name");
                    if (!savedName.startsWith(RAP_savedFacet) || !(savedFacetKey = RAP_savedFacet + XTSExt.web64decode((String)savedName.substring(RAP_savedFacet.length()), (boolean)true)).startsWith(search)) continue;
                    results.add(savedFacetKey.substring(search.length()));
                }
            }
            return results;
        }

        public static String getClientId(Element contextSlicer) {
            String descriptor = SliderInfo.getDescriptor(contextSlicer);
            return descriptor == null ? null : descriptor.substring(1);
        }

        public static String getControlType(Element contextSlicer) {
            String descriptor = SliderInfo.getDescriptor(contextSlicer);
            return descriptor == null ? null : SliderInfo.getControlTypeString(descriptor.charAt(0));
        }

        protected static char getControlTypeId(String controlType) {
            if ("slider".equals(controlType)) {
                return '0';
            }
            if ("facet".equals(controlType)) {
                return '2';
            }
            return '1';
        }

        private static String getControlTypeString(char controlTypeId) {
            switch (controlTypeId) {
                case '0': {
                    return "slider";
                }
                case '2': {
                    return "facet";
                }
            }
            return "checkbox";
        }

        public static void refresh(Document report) {
            HashSet<String> rapSlicerDefinitionXMLAttributes = new HashSet<String>();
            for (Element contextSlicer : V5ContextSlicer.findContextSlicers(report.getRootElement())) {
                Element xmlAttribute = V5X.selectSingleNode(report, "//V5X//CHILD", "XMLAttributes", "XMLAttribute", "//V5X//ATTR", "name", SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _current));
                if (xmlAttribute == null) continue;
                String currentContextSlicerInfo = XTSExt.web64encode((String)contextSlicer.asXML(), (boolean)true);
                if (!currentContextSlicerInfo.equals(xmlAttribute.attributeValue("value"))) {
                    SliderInfo.saveCurrent(contextSlicer);
                    SliderInfo.saveInitial(contextSlicer, true);
                }
                rapSlicerDefinitionXMLAttributes.add(SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _current));
                rapSlicerDefinitionXMLAttributes.add(SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _initial));
                rapSlicerDefinitionXMLAttributes.add(SliderInfo.getContextSlicerXMLAttributeName(contextSlicer, _descriptor));
            }
            List xmlAttributes = V5X.selectNodes(report, "//V5X//CHILD", "XMLAttributes", "XMLAttribute");
            if (xmlAttributes != null) {
                for (Element xmlAttribute : xmlAttributes) {
                    if (!xmlAttribute.attributeValue("name").startsWith(RAP_slicerDefinition) || rapSlicerDefinitionXMLAttributes.contains(xmlAttribute.attributeValue("name"))) continue;
                    xmlAttribute.detach();
                }
            }
        }
    }
}

